using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;
using System.Drawing;

namespace SCFiler2 {
	public class SCFiler2System {
		static private SCFiler2System instance = new SCFiler2System();
		static public SCFiler2System Instance {
			get { return instance;}
		}
		private SCFiler2System() {
			Option.load();
		}

		public class OptionClass {
			public class KeyCommandOption {
				public bool ChangeDriveByNumKey = false;
				public void save() {
					OptionUtil.save("KeyAssign2", this);
				}
				public void load() {
					OptionUtil.load("KeyAssign2", this);
				}
			}
			public KeyCommandOption KeyCommand = new KeyCommandOption();

			public class ColorOption {
				public Color ActiveViewTitleBack = new Color();
				public Color ActiveViewTitleText = new Color();
				public Color InactiveViewTitleBack = new Color();
				public Color InactiveViewTitleText = new Color();
				public ColorOption() {
					//l̐ݒ
					ActiveViewTitleBack = System.Drawing.Color.Aqua;
					ActiveViewTitleText = System.Drawing.Color.Black;
					InactiveViewTitleBack = System.Drawing.Color.Azure;
					InactiveViewTitleText = System.Drawing.Color.Black;

				}
				public void save() {
					OptionUtil.save("Color", this);
				}
				public void load() {
					OptionUtil.load("Color", this);
				}
			}
			public ColorOption Color = new ColorOption();

			public void save() {
				KeyCommand.save();
				Color.save();
			}
			public void load() {
				KeyCommand.load();
				Color.load();
			}
		}
		public OptionClass Option = new OptionClass();
	}
}
