using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Util;

namespace SCFiler2.Action {
	/// <summary>
	/// ͂ꂽL[Action̊֌WǗBVOgB
	/// </summary>
	public class KeyCommandManager {
		static KeyCommandManager instance = new KeyCommandManager();
		private System.Collections.Hashtable valid_keys = new System.Collections.Hashtable();
			
		static public KeyCommandManager Instance {
			get { return instance; }
		}

		private KeyCommandManager() {
			registValidKeys();
		}

		private class Command {
			public string command_string;
			public Action action;
			public Command(Action action, string command) {
				this.action = action;
				this.command_string = command;
			}
		}
		private List<Command> command_list = new List<Command>();

		/// <summary>
		/// L[R}h蓖ĂĂAction擾
		/// </summary>
		/// <param name="key_command">ΏۃL[R}h</param>
		/// <returns>łɎgpĂA蓖ĂĂActionBgĂȂnull</returns>
		public Action getAssignedAction(string key_command) {
			foreach (Command com in command_list) {
				if (com.command_string == key_command) {
					return com.action;
				}
			}
			return null;
		}

		/// <summary>
		/// ActionɊ蓖ĂĂL[R}hɑΉ镶擾
		/// </summary>
		/// <param name="action">ׂΏۂAction</param>
		/// <returns>Ή镶Bo^ĂȂ""Ԃ</returns>
		public string getAssignedKeyCommand(Action action) {
			foreach (Command com in command_list) {
				if (com.action == action) {
					return com.command_string;
				}
			}
			return "";
		}

		/// <summary>
		/// ANVɃL[蓖ĂBłɃANVɃL[蓖ĂĂƂ͏㏑
		/// </summary>
		/// <param name="action">蓖đΏۂAction</param>
		/// <param name="key_command">ActionɊ蓖ĂL[</param>
		public void registAction(Action action, string key_command) {
			foreach (Command com in command_list) {
				if (com.action == action) {
					com.command_string = key_command;
					return;
				}
			}
			Command new_com = new Command(action, key_command);
			command_list.Add(new_com);
		}

		/// <summary>
		/// L[蓖Đݒǂݍ
		/// </summary>
		public void load() {
			SettingFile file = SettingFile.Instance;

			foreach (Action action in Action.All_Action) {
				string str = file.load("KeyAssign", action.DisplayString);
				if (str != "Nothing") {
					registAction(action, str);
				}
			}
		}

		/// <summary>
		/// L[蓖Đݒۑ
		/// </summary>
		public void save() {
			SettingFile file = SettingFile.Instance;

			foreach (Action action in Action.All_Action) {
				string str = getAssignedKeyCommand(action);
				if (str == "") {
					file.save("KeyAssign", action.DisplayString, null);
				} else {
					file.save("KeyAssign", action.DisplayString, str);
				}
			}
		}

		/// <summary>
		/// R}ho^\ǂ𒲂ׂ
		/// </summary>
		/// <param name="control"></param>
		/// <param name="alt"></param>
		/// <param name="shift"></param>
		/// <param name="key"></param>
		/// <returns>o^\ȃL[trueԂ</returns>
		public bool IsValidCommand(bool control, bool alt, bool shift, Keys key) {
			if (valid_keys.Contains(key)) {
				return true;
			} else {
				return false;
			}
		}


		/// <summary>
		/// L[ꂽƂActions
		/// </summary>
		/// <param name="control">ControlĂ邩ǂ</param>
		/// <param name="alt">AltĂ邩ǂ</param>
		/// <param name="shift">shiftĂ邩ǂ</param>
		/// <param name="key">ꂽL[</param>
		/// <returns>strue, L[ɑΉActionȂĎsłȂfalseԂ</returns>
		public bool executeAction(bool control, bool alt, bool shift, Keys key) {
			string str = getCommandString(control, alt, shift, key);
			if (str == "") {
				return false;
			}
			Action action = getAssignedAction(str);
			if (action == null) {
				return false;
			}
			action.execute();
			return true;
		}

		/// <summary>
		/// ꂽL[Ή镶ɕϊ
		/// </summary>
		/// <param name="control">ControlĂ邩ǂ</param>
		/// <param name="alt">AltĂ邩ǂ</param>
		/// <param name="shift">shiftĂ邩ǂ</param>
		/// <param name="key">ꂽL[</param>
		/// <returns>L[ɑΉ镶BLł͂Ȃꍇ""Ԃ</returns>
		public string getCommandString(bool control, bool alt, bool shift, Keys key) {
			if (!valid_keys.Contains(key)) {
				return "";
			}
			string command_str = "";
			if (control) {
				command_str += "Ctrl-";
			}
			if (alt) {
				command_str += "Alt-";
			}
			if (shift) {
				command_str += "Shift-";
			}
			command_str += valid_keys[key];
			return command_str;
		}


		#region LL[o^ƑΉ̒`
		/// <summary>
		/// LȃL[̓o^ƁAɑΉ镶`BiToStringƂ˂ɂłȂƂ̂Łj
		/// </summary>
		private void registValidKeys() {
		    valid_keys.Add(Keys.Enter, "Enter");
		    valid_keys.Add(Keys.Escape, "Escape");
		    valid_keys.Add(Keys.Space, "Space");
			valid_keys.Add(Keys.Back, "Back");
		    valid_keys.Add(Keys.Delete, "Del");
		    valid_keys.Add(Keys.Oem5, "\\");
		    valid_keys.Add(Keys.Left,"Left");
		    valid_keys.Add(Keys.Right,"Right");
		    valid_keys.Add(Keys.F1, "F1");
		    valid_keys.Add(Keys.F2, "F2");
		    valid_keys.Add(Keys.F3, "F3");
		    valid_keys.Add(Keys.F4, "F4");
		    valid_keys.Add(Keys.F5, "F5");
		    valid_keys.Add(Keys.F6, "F6");
		    valid_keys.Add(Keys.F7, "F7");
		    valid_keys.Add(Keys.F8, "F8");
		    valid_keys.Add(Keys.F9, "F9");
		    valid_keys.Add(Keys.F10, "F10");
		    valid_keys.Add(Keys.F11, "F11");
		    valid_keys.Add(Keys.F12, "F12");
		    valid_keys.Add(Keys.A, "A");
		    valid_keys.Add(Keys.B, "B");
		    valid_keys.Add(Keys.C, "C");
		    valid_keys.Add(Keys.D, "D");
		    valid_keys.Add(Keys.E, "E");
		    valid_keys.Add(Keys.F, "F");
		    valid_keys.Add(Keys.G, "G");
		    valid_keys.Add(Keys.H, "H");
		    valid_keys.Add(Keys.I, "I");
		    valid_keys.Add(Keys.J, "J");
		    valid_keys.Add(Keys.K, "K");
		    valid_keys.Add(Keys.L, "L");
		    valid_keys.Add(Keys.M, "M");
		    valid_keys.Add(Keys.N, "N");
		    valid_keys.Add(Keys.O, "O");
		    valid_keys.Add(Keys.P, "P");
		    valid_keys.Add(Keys.Q, "Q");
		    valid_keys.Add(Keys.R, "R");
		    valid_keys.Add(Keys.S, "S");
		    valid_keys.Add(Keys.T, "T");
		    valid_keys.Add(Keys.U, "U");
		    valid_keys.Add(Keys.V, "V");
		    valid_keys.Add(Keys.W, "W");
		    valid_keys.Add(Keys.X, "X");
		    valid_keys.Add(Keys.Y, "Y");
		    valid_keys.Add(Keys.Z, "Z");
		}
		#endregion

	}
}
