﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SCFiler2.FileSystem {
	public class JumpFolder {
		Folder folder = null;
		string title = null;

		public string Title {
			get { return title; }
		}
		public Folder Folder {
			get { return folder; }
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="jumpfolder_title">ジャンプフォルダにつけるタイトル</param>
		/// <param name="folder_path">ジャンプフォルダに設定するフォルダのパス</param>
		public JumpFolder(string jumpfolder_title, string folder_path) {
			title = jumpfolder_title;
			folder = new Folder(folder_path);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="jumpfolder_title">ジャンプフォルダにつけるタイトル</param>
		/// <param name="folder">ジャンプフォルダに設定するフォルダ</param>
		public JumpFolder(string jumpfolder_title, Folder folder) {
			title = jumpfolder_title;
			this.folder = folder;
		}
	}
}
