using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;
using SCFiler2.Action;

namespace SCFiler2 {
	public partial class HistoryView : UserControl {
		HistoryManager manager = null;

		public HistoryView() {
			InitializeComponent();
		}

		/// <summary>
		/// r[őIĂACeԂ
		/// </summary>
		public FilerItem SelectedItem {
			get {
				return (FilerItem)item_list.FocusedItem.Tag;
			}
		}

		public void initialise(HistoryManager history_manager, string title) {
			manager = history_manager;
			view_title_panel.Text = title;
		}

		public void update() {
			item_list.Items.Clear();
			foreach (FilerItem item in manager.ItemList) {
				ListViewItem list_item = new ListViewItem(item.Info.Name);
				list_item.Tag = item;
				item_list.Items.Add(list_item);
			}
		}

		private void HistoryView_Enter(object sender, EventArgs e) {
			MainForm.Instance.notifyHistoryViewFocused(this);
			title_panel.BackColor = SystemColors.ActiveCaption;
		}

		private void HistoryView_Leave(object sender, EventArgs e) {
			title_panel.BackColor = SystemColors.InactiveCaption;
			MainForm.Instance.printToStatusbar("");
		}

		private void item_list_KeyDown(object sender, KeyEventArgs e) {
			KeyCommandManager.Instance.executeAction(e.Control, e.Alt, e.Shift, e.KeyCode);
		}

		private void item_list_DoubleClick(object sender, EventArgs e) {
			Action.Action.ExecuteFocusedItem.execute();
		}

		private void item_list_SelectedIndexChanged(object sender, EventArgs e) {
			if (item_list.SelectedItems.Count > 0) {
				FilerItem item = (FilerItem)item_list.SelectedItems[0].Tag;
				MainForm.Instance.printToStatusbar(item.Info.FullName);
			} else {
				MainForm.Instance.printToStatusbar("");
			}
		}
	}
}
