using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using SCFiler2.FileSystem;
using SCFiler2.Action;

namespace SCFiler2 {
	public partial class FileView : UserControl {
		private string current_path = @"c:\";
		private FileViewComparer sorter = new FileViewComparer(0);
		private string item_name = "";

		public FileView() {
			InitializeComponent();
			setPath(current_path); //TODO Ƃ肠ŏ̓[g\邱ƂɂƂBƂŏC
			list_view.ListViewItemSorter = sorter;
		}

		/// <summary>
		/// JnMainFormĂ΂
		/// </summary>
		/// <param name="item_name"></param>
		public void initialize(string item_name) {
			this.item_name = item_name;
			load();
		}

		/// <summary>
		/// IMainFormĂ΂
		/// </summary>
		public void terminate() {
		}

		/// <summary>
		/// IĂFilerItemList^ŕԂB
		/// </summary>
		public List<FilerItem> SelectedFilerItems {
			get {
				List<FilerItem> list = new List<FilerItem>();
				foreach (ListViewItem item in list_view.SelectedItems) {
					list.Add((FilerItem)item.Tag);
				}
				return list;
			}
		}

		/// <summary>
		/// FilerViewɕ\ĂpXԂ
		/// </summary>
		public string CurrentPath {
			get { return current_path; }
		}

		/// <summary>
		/// r[̃pXXV܂B
		/// </summary>
		/// <param name="full_name">Vɐݒ肷tH_̃tpX</param>
		public void setPath(string full_name) {
			current_path = full_name;
			drawView();
			current_path_label.Text = current_path;
			//ACe΁Aԏ̂̂ɑIĂԂɂ
			if (list_view.Items.Count > 0) {
				list_view.Items[0].Selected = true;
				list_view.Items[0].Focused = true;
			}
		}

		/// <summary>
		/// r[̓ẽ݂pXɏ]čŐVɂ܂B
		/// </summary>
		public void drawView() {
			//
			list_view.Clear();

			//̏
			list_view.Columns.Add("O", 250);
			list_view.Columns.Add("gq", 50);
			list_view.Columns.Add("TCY", 80, HorizontalAlignment.Right);
			list_view.Columns.Add("XV", 130);

			//tH_̕\
			string[] folders = System.IO.Directory.GetDirectories(current_path);
			foreach (string folder in folders) {
				FilerItem filer_item = new Folder(folder);
				ListViewItem item = new ListViewItem(filer_item.NameWithoutExtension);//O
				item.SubItems.Add("<dir>");//gq
				item.SubItems.Add(filer_item.SizeDisplayString);//TCY
				item.SubItems.Add(filer_item.Info.LastWriteTime.ToString());//XV
				item.Tag = filer_item;
				list_view.Items.Add(item);
			}

			//t@C̕\
			string[] files = System.IO.Directory.GetFiles(current_path);
			foreach (string file in files) {
				FilerItem filer_item = new File(file);
				ListViewItem item = new ListViewItem(filer_item.NameWithoutExtension);//O
				item.SubItems.Add(filer_item.Info.Extension);//gq
				item.SubItems.Add(filer_item.SizeDisplayString);//TCY
				item.SubItems.Add(filer_item.Info.LastWriteTime.ToString());//XV
				item.Tag = filer_item;
				list_view.Items.Add(item);
			}

			list_view.Sort();
		}

		private void file_list_view_KeyDown(object sender, KeyEventArgs e) {
			KeyCommandManager.Instance.executeAction(e.Control, e.Alt, e.Shift, e.KeyCode);
		}

		private void FileView_Enter(object sender, EventArgs e) {
			MainForm main_form = MainForm.Instance;
			main_form.notifyFileViewFocused(this);

			folder_info_panel.BackColor = SystemColors.ActiveCaption;
		}

		private void FileView_Leave(object sender, EventArgs e) {
			folder_info_panel.BackColor = SystemColors.InactiveCaption;
		}

		private void list_view_DoubleClick(object sender, EventArgs e) {
			Action.Action.ExecuteFocusedItem.execute();
		}

		private void save() {
		}

		private void load() {
		}

	}
}
