using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Action;

namespace SCFiler2 {
	public partial class MainForm : Form {
		static private MainForm instance = null;

		#region r[ւ̃ANZX֘A
		public enum EFocusedViewType {
			FileView,
			HistoryView,
			Other
		}
		private EFocusedViewType focused_view = EFocusedViewType.Other;
		public EFocusedViewType FocusedViewType {
			get { return focused_view; }
			set { focused_view = value; }
		}
		private FileView last_focused_fileview = null;

		/// <summary>
		/// ݃tH[JXĂFileViewAɃtH[JXȂꍇ͍ŌɂقԂ
		/// Focusedł͂ȂLastFocusedɂĂ̂́A_CAOɃtH[JXƂɂg悤ɁB
		/// </summary>
		public FileView getLastFocusedFileView() {
			return last_focused_fileview;
		}

		/// <summary>
		/// tH[JXړƂMainFormɒʒm
		/// </summary>
		/// <param name="focused_view">VFocusFileView</param>
		public void setLastFocusedFileView(FileView focused_view) {
			last_focused_fileview = focused_view;
		}

		/// <summary>
		/// QFileVieŵŗ^ꂽFileView̔΂FileViewԂ
		/// </summary>
		/// <param name="file_view"></param>
		/// <returns>Ɣ΂FileView</returns>
		public FileView getAnotherFileView(FileView file_view) {
			if (file_view == left_file_listview) {
				return right_file_listview;
			} else {
				return left_file_listview;
			}
		}
		#endregion r[ւ̃ANZX֘A


		public MainForm() {
			instance = this;

			InitializeComponent();

			//TODO łŃL[o^Ă
			KeyCommandManager keycommand_manager = KeyCommandManager.Instance;
			keycommand_manager.registAction(keycommand_manager.getCommandString(false, false, false, Keys.Escape), new ExitApplication());
			keycommand_manager.registAction(keycommand_manager.getCommandString(false, false, false, Keys.Enter), new ExecuteFocusedItem());
			keycommand_manager.registAction(keycommand_manager.getCommandString(false, false, false, Keys.Delete), new moveToRecycle());
			keycommand_manager.registAction(keycommand_manager.getCommandString(false, false, false, Keys.Back), new MoveToParentFolder());
			keycommand_manager.registAction(keycommand_manager.getCommandString(true, false, false, Keys.C), new CopyToAnotherFileVIew());
			keycommand_manager.registAction(keycommand_manager.getCommandString(true, false, false, Keys.M), new moveToAnotherFileView());
		}

		/// <summary>
		/// MainForm̃CX^Xn
		/// </summary>
		static public MainForm Instance {
			get { return instance; }
		}

		private void MainForm_KeyDown(object sender, KeyEventArgs e) {
			KeyCommandManager.Instance.executeAction(e.Control, e.Alt, e.Shift, e.KeyCode);
		}
	}
}