using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace SCFiler2 {
	public partial class FileView : UserControl {
		private string current_path = @"c:\";

		public FileView() {
			InitializeComponent();
			setPath(current_path); //TODO Ƃ肠ŏ̓[g\邱ƂɂƂBƂŏC
		}

		/// <summary>
		/// r[̃pXXV܂B
		/// </summary>
		/// <param name="full_name">Vɐݒ肷tH_̃tpX</param>
		private void setPath(string full_name) {
			current_path = full_name;
			drawView();
		}

		/// <summary>
		/// r[̓ẽ݂pXɏ]čŐVɂ܂B
		/// </summary>
		private void drawView() {
			//
			list_view.Clear();

			//̏
			list_view.Columns.Add("O", 300);

			//tH_̕\
			string[] folders = System.IO.Directory.GetDirectories(current_path);
			foreach (string folder in folders) {
				string[] strs = folder.Split('\\'); 
				string folder_name = strs[strs.Length -1]; //\pɃtpXtH_o
				ListViewItem item = new ListViewItem(folder_name);
				item.Tag = folder; //Tagɂ̓tpX
				list_view.Items.Add(item);
			}

			//t@C̕\
			string[] files = System.IO.Directory.GetFiles(current_path);
			foreach (string file in files) {
				string file_name = System.IO.Path.GetFileName(file);
				ListViewItem item = new ListViewItem(file_name);
				item.Tag = file;
				list_view.Items.Add(item);
			}

		}

		private void file_list_view_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyCode == Keys.Enter) {
				ListViewItem item = list_view.FocusedItem;
				string item_name = (string)item.Tag; //TagFullPath擾

				if (System.IO.Directory.Exists(item_name)) {
					//tH_炻̃tH_̒Ɉړ
					setPath(item_name);
				} else if (System.IO.File.Exists(item_name)) {
					//t@CAs
					Process.Start(item_name);
				}
			} else if (e.KeyCode == Keys.Back) {
				//etH_Ɉړ
				System.IO.DirectoryInfo info = System.IO.Directory.GetParent(current_path);//etH_擾
				setPath(info.FullName);
			}
		}
	}
}
