#pragma once

#include <list>

namespace chocolat{namespace container{

/** This linked list contains data temporarily.
 *  last in first out.
 */
template<typename T>
class WorkList
{
	std::list<T> m_list;
public:
	typedef T value_type;
	typedef typename std::list<T>::iterator iterator;
	/** by default, it behaves like stack.*/
	void push(T value)
	{
		m_list.push_front(value);
	}
	T pop()
	{
		unsigned value = m_list.front();
		m_list.pop_front();
		return value;
	}
	/** for last in last out, this method is used to delay pop.*/
	void push_back(T value)
	{
		m_list.push_back(value);
	}
	bool empty()const
	{
		return m_list.empty();
	}
	T size()const
	{
		return m_list.size();
	}
	/** remove the value*/
	void remove(T value)
	{
		m_list.remove(value);
	}
	/** erase the position */
	iterator erase(iterator ite) 
	{
		return m_list.erase(ite);
	}
	iterator begin()
	{
		return m_list.begin();
	}
	iterator end()
	{
		return m_list.end();
	}
	/** query it has the value */
	bool found(T value)const
	{
		for (auto i=m_list.begin(); i!=m_list.end(); ++i) {
			if (value == *i) {
				return true;
			}
		}
		return false;
	}
};

}}
