#pragma once
#include "opcode_info.hpp"

/** this object represents register, memory, immediate value.  */
class Operand
{
public:
	enum Type{
		NONE=0,
		REGISTER,
		MEMORY,
		IMMEDIATE,
		INDEX,
	};
	Operand::Type type;
	opcode::AddressingMode reg;
	unsigned value;
	
	Operand()
			:type(NONE),reg(opcode::AM_NONE),value(0)
	{
	}
	void setup(opcode::AddressingMode target,
			   opcode::AddressingMode instruction, unsigned parameter);
};
/** This utility provide operation info.*/
class OperationInfoServer
{
public:
	const opcode::OperationInfo* getInfoOf(opcode::Operation type)const;
};
