package com.sanpudo.formula;

/**
 * 例外で使用されるメッセージを定義したクラス。
 * 
 * @author Sanpudo.
 */
public class Messages {
	/** コンストラクタ(ダミー)。 */
	protected Messages() {
	}

	/** 式が存在していない。 */
	public static final String NULL_INPUT = "Null input";
	/** 値が期待される場所に演算子,右括弧などが見つかった。 */
	public static final String VALUE_EXPECT = "Value expected";

	/** 値または区切り文字が期待される場所に演算子,右括弧などが見つかった。 */
	public static final String NEXT_VALUE_EXPECT = "Next value expected";

	/** 演算子が期待される場所に値や左括弧が見つかった。 */
	public static final String OPERATOR_EXPECT = "Operator expected";

	/** 右括弧に対応する左括弧が存在しない。 */
	public static final String NO_CORR_PAREN = "No corresponding left parenthesis";

	/** 左括弧に対応する右括弧が存在しない。 */
	public static final String PAREN_INCOMPLETE = "Incomplete parenthesis";

	/** 演算子の第2パラメータが存在しない。 */
	public static final String OPERATOR_INCOMPELETE = "Incomplete operator";

	/** 未定義の定数名を指定した。 */
	public static final String UNDKNOWN_CONST = "Unknown constant";

	/** 未定義の関数名を指定した。 */
	public static final String UNDKNOWN_FUNC = "Unknown Function";

	/** システム定数と同じ名前のユーザ定数を登録しようとした。 */
	public static final String CONST_NAME_COMFLICT = "Name conflicts to pre-defined constants";

	/** システム定義済み関数と同じ名前のユーザ関数を登録しようとした。 */
	public static final String FUNC_NAME_COMFLICT = "Name conflicts to pre-defined function";

	/** 関数の引数の数が不正。 */
	public static final String INVALID_ARG_NO = "Invalid argment number";

	/** 不正な位置の区切り文字。 */
	public static final String INVALID_DELIM = "Invalid delimitter";

	/** 右括弧が必要。 */
	public static final String RPAR_EXPECT = "Right parenthesis expected";

	/** doubleを返す関数が実装されていない。 */
	public static final String UNSUPPORT_DOUBLE = "Unsupported function (double)";

	/** BigDecimalを返す関数が実装されていない。 */
	public static final String UNSUPPORT_DECIMAL = "Unsupported function (BigDecimal)";

	/** doubleとBigDecimalの関数実装の引数個数が異なる。 */
	public static final String ARG_NO_CONFLICT = "Different number of args between double and BigDecimal";

	/** 引数の個数が異なる同名の関数を登録しようとした。 */
	public static final String SAME_NAME_USED = "Same name function is duplicate defined";

	/** 関数名として正しくない名前を登録しようとした。 */
	public static final String INVALID_FUNC_NAME = "Invalid function name";

	/** 定数名として正しくない名前を登録しようとした。 */
	public static final String INVALID_CONST_NAME = "Invalid constant name";

	/** UNNECESSARYを端数処理として登録しようとした。 */
	public static final String INVALID_ROUNDING = "Unnecassary is not alllowed as rouding";

	/** BigDecimalのべき乗計算で、整数以外または大きすぎる整数をべき数に指定した。 */
	public static final String INVALID_POW = "Invalid pow calculation";

	/** round/up/downの第2パラメータに整数以外を指定した。 */
	public static final String INVALID_ROUND = "2nd param of round/up/down should be integer";

	/** ユーザ関数が、FormulaEvaluator以外の例外を返した。 */
	public static final String UNKOWN_EXCEPTION = "User function threw unknown Exception";

	/** 指定したクラスが存在しないか、インスタンスが作成できない。 */
	public static final String CLASS_LOADING_ERROR = "Class loading / creating instance failed";

	/** 指定したクラスがFunctionImplementationを実装していない */
	public static final String CLASS_INCOMPATIBLE = "Class incompatible to user function";

	/** ライブラリ内部の不具合。 */
	public static final String INTERNAL_ERROR = "Library internal error";
}
