package com.sanpudo.formula;

/**
 * 数式評価時の例外。
 * 
 * @author Sanpudo.
 */
public class FormulaEvaluatorException extends Exception {
	private static final long serialVersionUID = 1L;
	/** 入力された式。 */
	String input;
	/** エラー発生箇所。式の先頭は0、次の文字は1、以下同様。 */
	int errorLocation;

	/** メッセージを伴ったコンストラクタ。 */
	FormulaEvaluatorException(String msg, String input, int errorLocation) {
		super(msg);
		this.input = input;
		this.errorLocation = errorLocation;
	}

	/** メッセージと原因を伴ったコンストラクタ。 */
	FormulaEvaluatorException(String msg, Throwable throwable, String input,
			int errorLocation) {
		super(msg, throwable);
		this.input = input;
		this.errorLocation = errorLocation;
	}

	/** 入力された式を返す。 
	 * @return 入力された式
	 * */
	public String getInput() {
		return input;
	}

	/** 式中のエラー発生箇所を返す。式の先頭は0、次の文字は1、以下同様。
	 * @return 式中のエラー発生箇所
	 *  */
	public int getErrorLocation() {
		return errorLocation;

	}

	/**
	 * 例外発生時に推奨されるエラーメッセージ(複数行)を返す。メッセージは
	 * 入力、エラー箇所、エラー原因を視覚的に表現したもので以下のようなイメージである。
	 * 
	 * <pre>
	 * 	    No corresponding left parenthesis
	 * 	    ((1+2)+5))
	 * 	             &circ;
	 * </pre>
	 * @return 例外発生時に推奨されるエラーメッセージ(複数行)。
	 */
	public String recommendedMessage() {
		String s = this.getMessage();
		s += "\n" + input + "\n";
		for (int i = 0; i < getErrorLocation(); i++) {
			s += " ";
		}
		s += "^";
		return s;
	}

}
