package com.sanpudo.formula;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

/**
 * デモ。
 * 
 * @author Sanpudo.
 */
public class Demo extends JFrame implements ActionListener, KeyListener {

	private static final long serialVersionUID = 1L;

	// Evaluator
	private FormulaEvaluator fe;

	// Menu
	private JMenuItem exitMenu;
	private JMenuItem[] sampleItems;
	private String[] samples = { "1+2-3*4/5+6-7*8/9", "max(5.0,-5.0)",
			"log(E)", "sqrt(sin(0.5)^2+cos(0.5)^2)", "round(1/3,5)" };

	// Window items
	private JTextField formula;
	private JLabel result;
	private JButton evalButton;
	private ButtonGroup modeGroup;
	private JRadioButton dValue;
	private JRadioButton bdValue;
	private JComboBox scale;
	private JButton quitButton;

	// Action Listener
	public void actionPerformed(ActionEvent e) {
		try {
			Object source = e.getSource();
			formula.setForeground(Color.BLACK);
			// Quit
			if ((source == quitButton) || (source == exitMenu)) {
				System.exit(0);

				// Evaluate
			} else if (source == evalButton) {
				if (modeGroup.isSelected(dValue.getModel())) {
					double d = fe.dEvaluate(formula.getText());
					result.setText(Double.toString(d));
				} else {
					BigDecimal bd = fe.bdEvaluate(formula.getText());
					result.setText(bd.toString());
				}
			} else if (source == dValue) {
				scale.setEnabled(false);
			} else if (source == bdValue) {
				scale.setEnabled(true);
			} else if (source == scale) {
				fe.setScale(scale.getSelectedIndex());
			} else {
				for (int i = 0; i < sampleItems.length; i++) {
					if (source == sampleItems[i]) {
						formula.setText(sampleItems[i].getText());
						break;
					}
				}
			}
			// Error
		} catch (FormulaEvaluatorException ex) {
			result.setText(ex.getMessage());
			formula.setCaretPosition(ex.errorLocation);
			formula.setForeground(Color.RED);
			formula.requestFocus();
		}

	}

	// KeyListener
	public void keyPressed(KeyEvent e) {
		formula.setForeground(Color.BLACK);

	}

	public void keyReleased(KeyEvent e) {

	}

	public void keyTyped(KeyEvent e) {
	}

	/** コンストラクタ。 */
	Demo() {
		fe = new FormulaEvaluator();
		this.setLayout(new GridLayout(4, 1));

		// Menu
		JMenuBar menuBar = new JMenuBar();
		this.setJMenuBar(menuBar);
		JMenu fileMenu = new JMenu("File");
		menuBar.add(fileMenu);
		exitMenu = new JMenuItem("Exit");
		exitMenu.addActionListener(this);
		fileMenu.add(exitMenu);

		// Samples
		JMenu sampleMenu = new JMenu("Sample");
		menuBar.add(sampleMenu);
		sampleItems = new JMenuItem[samples.length];
		for (int i = 0; i < samples.length; i++) {
			sampleItems[i] = new JMenuItem(samples[i]);
			sampleItems[i].addActionListener(this);
			sampleMenu.add(sampleItems[i]);
		}

		// Formula
		JPanel formulaPanel = new JPanel();
		formulaPanel.setLayout(new FlowLayout(FlowLayout.LEFT));

		// Formula
		formulaPanel.add(new JLabel("Formula:"));
		formula = new JTextField(30);
		formula.setText("1+2*3");
		formula.addKeyListener(this);
		formulaPanel.add(formula);
		this.getContentPane().add(formulaPanel);

		// Result
		JPanel resultPanel = new JPanel();
		resultPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		resultPanel.add(new JLabel("Result:"));
		result = new JLabel("                              ");
		resultPanel.add(result);
		this.getContentPane().add(resultPanel);

		// Mode selection
		JPanel modePanel = new JPanel();
		modePanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		modePanel.add(new JLabel("Mode:"));
		modeGroup = new ButtonGroup();

		// double
		dValue = new JRadioButton("double");
		modeGroup.add(dValue);
		modePanel.add(dValue);
		dValue.addActionListener(this);

		// BigDecimal
		bdValue = new JRadioButton("BigDecimal");
		modeGroup.add(bdValue);
		modePanel.add(bdValue);
		bdValue.addActionListener(this);
		modeGroup.setSelected(dValue.getModel(), true);

		// scale
		modePanel.add(new JLabel("Scale:"));
		scale = new JComboBox();
		for (int i = 0; i < 16; i++) {
			scale.addItem(new Integer(i));
		}
		scale.setSelectedIndex(fe.getScale());
		scale.setEnabled(false);
		scale.addActionListener(this);
		modePanel.add(scale);
		this.getContentPane().add(modePanel);

		// Button
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout());

		// Evaluate
		evalButton = new JButton("Evaluate");
		evalButton.addActionListener(this);
		this.getRootPane().setDefaultButton(evalButton);
		buttonPanel.add(evalButton);

		// Quit
		quitButton = new JButton("Quit");
		quitButton.addActionListener(this);
		buttonPanel.add(quitButton);

		this.getContentPane().add(buttonPanel);

		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setTitle("Sanpudo Formula Evaluator Demo");
		this.pack();
		Rectangle screen = this.getGraphicsConfiguration().getBounds();
		this.setLocation(
				screen.x + screen.width / 2 - this.getSize().width / 2,
				screen.y + screen.height / 2 - this.getSize().height / 2);

	}

	/**
	 * メイン
	 */
	public static void main(String[] args) {
		Demo demo = new Demo();
		demo.setVisible(true);

	}

}
