package com.sanpudo.formula;

import java.math.BigDecimal;
import java.util.regex.Pattern;

/**
 * 定数。
 * 
 * @author Sanpudo.
 */
class Constant extends Value {

	String name;
	Environments environments;

	static final String regex = "[a-zA-Z]\\w*";
	static final String regexParam = "([a-zA-Z]\\w*)|(\\$\\d)";
	static Pattern pattern;
	static Pattern patternParam;

	static {
		pattern = Pattern.compile(regex);
		patternParam = Pattern.compile(regexParam);
	}

	/** コンストラクタ。 */
	Constant(String formula, int location, String name,
			Environments environments) {
		super(formula, location);
		this.name = name;
		this.environments = environments;
	}

	/** token文字列を返す。 */
	String strToken() {
		return name;
	}

	/** 定数の名前として正しいとき、trueを返す。 */
	static boolean isValidName(String name, boolean allowParam) {
		if (allowParam) {
			return patternParam.matcher(name).matches();
		} else {
			return pattern.matcher(name).matches();
		}
	}

	/** doubleの評価値を返す。 */
	double value() throws FormulaEvaluatorException {
		try {
			if (environments.userDefine.containsKey(name)) {
				return Double.parseDouble(environments.userDefine.get(name));
			} else if (Environments.predefine.containsKey(name)) {
				return Double.parseDouble(Environments.predefine.get(name));
			} else {
				throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR,
						strToken(), location);
			}
		} catch (NumberFormatException e) {
			throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR, e,
					strToken(), location);
		}
	}

	/** BigDecimalの評価値を返す。 */
	BigDecimal value(Rounding rounding) throws FormulaEvaluatorException {
		try {
			if (environments.userDefine.containsKey(name)) {
				return rounding.everyRound(new BigDecimal(
						environments.userDefine.get(name)));
			} else if (Environments.predefine.containsKey(name)) {
				return rounding.everyRound(new BigDecimal(
						Environments.predefine.get(name)));
			} else {
				throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR,
						strToken(), location);
			}
		} catch (Exception e) {
			throw new FormulaEvaluatorException(Messages.INTERNAL_ERROR, e,
					strToken(), location);
		}

	}

}
