/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.FunctionAdaptor;
import com.sanpudo.formula.FunctionEvalException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class SystemFunctions
extends FunctionAdaptor {
    SystemFunctions() {
    }

    public double abs(double d) {
        return Math.abs(d);
    }

    public BigDecimal abs(BigDecimal bd) {
        return bd.abs();
    }

    public double cbrt(double d) {
        return Math.cbrt(d);
    }

    public double ceil(double d) {
        return Math.ceil(d);
    }

    public double cos(double d) {
        return Math.cos(d);
    }

    public double exp(double d) {
        return Math.exp(d);
    }

    public double floor(double d) {
        return Math.floor(d);
    }

    public double log(double d) {
        return Math.log(d);
    }

    public double log10(double d) {
        return Math.log10(d);
    }

    public BigDecimal max(BigDecimal bd1, BigDecimal bd2) {
        return bd1.max(bd2);
    }

    public double max(double d1, double d2) {
        return Math.max(d1, d2);
    }

    public BigDecimal min(BigDecimal bd1, BigDecimal bd2) {
        return bd1.min(bd2);
    }

    public double min(double d1, double d2) {
        return Math.min(d1, d2);
    }

    public BigDecimal pow(BigDecimal bd1, BigDecimal bd2) throws FunctionEvalException {
        try {
            return bd1.pow(bd2.intValueExact());
        }
        catch (ArithmeticException e) {
            throw new FunctionEvalException("Invalid pow calculation", e);
        }
    }

    public double pow(double d1, double d2) {
        return Math.pow(d1, d2);
    }

    public double rint(double d) {
        return Math.rint(d);
    }

    public double sin(double d) {
        return Math.sin(d);
    }

    public double sqrt(double d) {
        return Math.sqrt(d);
    }

    public double tan(double d) {
        return Math.tan(d);
    }

    public BigDecimal round(BigDecimal bd, BigDecimal scale) throws FunctionEvalException {
        return this.setScale(bd, scale, RoundingMode.HALF_UP);
    }

    public BigDecimal down(BigDecimal bd, BigDecimal scale) throws FunctionEvalException {
        return this.setScale(bd, scale, RoundingMode.DOWN);
    }

    public BigDecimal up(BigDecimal bd, BigDecimal scale) throws FunctionEvalException {
        return this.setScale(bd, scale, RoundingMode.UP);
    }

    private BigDecimal setScale(BigDecimal bd, BigDecimal scale, RoundingMode rMode) throws FunctionEvalException {
        try {
            return bd.setScale(scale.intValueExact(), rMode);
        }
        catch (ArithmeticException e) {
            throw new FunctionEvalException("2nd param of round/up/down should be integer", e);
        }
    }
}

