/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.Environments;
import com.sanpudo.formula.FormulaEvaluator;
import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.FunctionEvalException;
import com.sanpudo.formula.FunctionImplementation;
import com.sanpudo.formula.Lex;
import com.sanpudo.formula.Parser;
import java.math.BigDecimal;

class FunctionInterpreter
implements FunctionImplementation {
    private String funcName;
    private int numberOfArgs;
    private String formula;
    private Environments environments;

    FunctionInterpreter(String funcName, int numberOfArgs, String formula, Environments environments) throws FormulaEvaluatorException {
        this.funcName = funcName;
        this.numberOfArgs = numberOfArgs;
        this.formula = formula;
        this.environments = environments.clone();
        FunctionInterpreter.checkFormula(funcName, numberOfArgs, formula, this.environments);
    }

    static void checkFormula(String funcName, int numberOfArgs, String formula, Environments environments) throws FormulaEvaluatorException {
        if (!Lex.isValidFuncName(funcName)) {
            throw new FormulaEvaluatorException("Invalid function name", funcName, 0);
        }
        if (Environments.systemFunctions.supports(funcName)) {
            throw new FormulaEvaluatorException("Name conflicts to pre-defined function", funcName, 0);
        }
        int i = 0;
        while (i < numberOfArgs) {
            environments.defineUserConstant("$" + Integer.toString(i), "0", true, false);
            ++i;
        }
        new Parser(formula).parse(new Lex(environments).analyze(formula, true));
    }

    public boolean supports(String name) {
        return this.funcName.equals(name);
    }

    public String[] names() {
        String[] ns = new String[]{this.funcName};
        return ns;
    }

    public int numberOfArgs(String name) {
        return this.numberOfArgs;
    }

    public double value(String name, double[] args) throws FunctionEvalException {
        try {
            int i = 0;
            while (i < this.numberOfArgs) {
                this.environments.defineUserConstant("$" + Integer.toString(i), Double.toString(args[i]), true, false);
                ++i;
            }
            FormulaEvaluator formulaEvaluator = new FormulaEvaluator(this.environments);
            return formulaEvaluator.dEvaluateParam(this.formula);
        }
        catch (FormulaEvaluatorException e) {
            throw new FunctionEvalException(e.getMessage(), e);
        }
    }

    public BigDecimal value(String name, BigDecimal[] args) throws FunctionEvalException {
        try {
            int i = 0;
            while (i < this.numberOfArgs) {
                this.environments.defineUserConstant("$" + Integer.toString(i), args[i].toString(), true, false);
                ++i;
            }
            FormulaEvaluator formulaEvaluator = new FormulaEvaluator(this.environments);
            return formulaEvaluator.bdEvaluateParam(this.formula);
        }
        catch (FormulaEvaluatorException e) {
            throw new FunctionEvalException(e.getMessage(), e);
        }
    }
}

