/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.FunctionEvalException;
import com.sanpudo.formula.FunctionException;
import com.sanpudo.formula.FunctionImplementation;
import com.sanpudo.formula.Lex;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Hashtable;

public class FunctionAdaptor
implements FunctionImplementation {
    private Hashtable<String, Integer> argNums;
    private Hashtable<String, Method> dMethods;
    private Hashtable<String, Method> bdMethods;

    protected FunctionAdaptor() {
        this.setCompatibleMethods();
    }

    public double value(String name, double[] args) throws FunctionEvalException {
        if (this.dMethods.containsKey(name)) {
            Object[] arg = new Double[args.length];
            int i = 0;
            while (i < arg.length) {
                arg[i] = new Double(args[i]);
                ++i;
            }
            try {
                Double d = (Double)this.dMethods.get(name).invoke((Object)this, arg);
                return d;
            }
            catch (IllegalAccessException e) {
                throw new FunctionException(e.getMessage(), name);
            }
            catch (IllegalArgumentException e) {
                throw new FunctionException(e.getMessage(), name);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof FunctionEvalException) {
                    throw (FunctionEvalException)e.getCause();
                }
                throw new FunctionException("User function threw unknown Exception", e.getMessage());
            }
        }
        throw new FunctionEvalException("Unsupported function (double)");
    }

    public BigDecimal value(String name, BigDecimal[] args) throws FunctionEvalException {
        if (this.bdMethods.containsKey(name)) {
            try {
                Object[] arg = args;
                return (BigDecimal)this.bdMethods.get(name).invoke((Object)this, arg);
            }
            catch (IllegalAccessException e) {
                throw new FunctionException(e.getMessage(), name);
            }
            catch (IllegalArgumentException e) {
                throw new FunctionException(e.getMessage(), name);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof FunctionEvalException) {
                    throw (FunctionEvalException)e.getCause();
                }
                throw new FunctionException("User function threw unknown Exception", e.getMessage());
            }
        }
        throw new FunctionEvalException("Unsupported function (BigDecimal)");
    }

    public String[] names() {
        return this.argNums.keySet().toArray(new String[this.argNums.size()]);
    }

    public int numberOfArgs(String name) {
        return this.argNums.get(name);
    }

    public boolean supports(String name) {
        return this.argNums.containsKey(name);
    }

    private void setCompatibleMethods() {
        String name;
        int j;
        Class<?>[] argClasses;
        this.argNums = new Hashtable();
        this.dMethods = new Hashtable();
        this.bdMethods = new Hashtable();
        Method[] methods = this.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (Lex.isValidFuncName(methods[i].getName()) && methods[i].getReturnType().getName().equals("double")) {
                argClasses = methods[i].getParameterTypes();
                j = 0;
                while (j < argClasses.length) {
                    if (!argClasses[j].getName().equals("double")) break;
                    ++j;
                }
                if (j >= argClasses.length) {
                    name = methods[i].getName();
                    if (this.dMethods.containsKey(name)) {
                        throw new FunctionException("Same name function is duplicate defined", name);
                    }
                    this.argNums.put(name, argClasses.length);
                    this.dMethods.put(name, methods[i]);
                }
            }
            ++i;
        }
        i = 0;
        while (i < methods.length) {
            if (Lex.isValidFuncName(methods[i].getName()) && methods[i].getReturnType().getName().equals("java.math.BigDecimal")) {
                argClasses = methods[i].getParameterTypes();
                j = 0;
                while (j < argClasses.length) {
                    if (!argClasses[j].getName().equals("java.math.BigDecimal")) break;
                    ++j;
                }
                if (j >= argClasses.length) {
                    name = methods[i].getName();
                    if (this.bdMethods.containsKey(name)) {
                        throw new FunctionException("Same name function is duplicate defined", name);
                    }
                    if (this.argNums.containsKey(name) && this.argNums.get(name) != argClasses.length) {
                        throw new FunctionException("Different number of args between double and BigDecimal", name);
                    }
                    this.argNums.put(methods[i].getName(), argClasses.length);
                    this.bdMethods.put(name, methods[i]);
                }
            }
            ++i;
        }
    }
}

