/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.Container;
import com.sanpudo.formula.Environments;
import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.FunctionEvalException;
import com.sanpudo.formula.FunctionException;
import com.sanpudo.formula.FunctionImplementation;
import com.sanpudo.formula.Rounding;
import com.sanpudo.formula.Token;
import java.math.BigDecimal;
import java.util.Vector;

public class Function
extends Container {
    String name;
    int numberOfArgs;
    Vector<Token> args;
    Environments environments;
    static final String regex = "[a-zA-Z]\\w*\\(";

    Function(String formula, int location, String name, int numberOfArgs, Environments environments) {
        super(formula, location);
        this.name = name;
        this.numberOfArgs = numberOfArgs;
        this.environments = environments;
        this.args = new Vector();
    }

    double value() throws FormulaEvaluatorException {
        double[] dArgs = new double[this.args.size()];
        int i = 0;
        while (i < dArgs.length) {
            dArgs[i] = this.args.get(i).value();
            ++i;
        }
        try {
            if (Environments.systemFunctions.supports(this.name)) {
                return Environments.systemFunctions.value(this.name, dArgs);
            }
            for (FunctionImplementation fun : this.environments.userFunctions) {
                if (!fun.supports(this.name)) continue;
                return fun.value(this.name, dArgs);
            }
        }
        catch (FunctionEvalException e) {
            throw new FormulaEvaluatorException(e.getMessage(), e.getCause(), this.formula, this.location);
        }
        catch (FunctionException e) {
            throw new FormulaEvaluatorException(e.getMessage(), e.getFunctionName(), this.location);
        }
        throw new FormulaEvaluatorException("Library internal error", this.name, -1);
    }

    BigDecimal value(Rounding rounding) throws FormulaEvaluatorException {
        BigDecimal[] bdArgs = new BigDecimal[this.args.size()];
        int i = 0;
        while (i < bdArgs.length) {
            bdArgs[i] = this.args.get(i).value(rounding);
            ++i;
        }
        try {
            if (Environments.systemFunctions.supports(this.name)) {
                return Environments.systemFunctions.value(this.name, bdArgs);
            }
            for (FunctionImplementation fun : this.environments.userFunctions) {
                if (!fun.supports(this.name)) continue;
                return rounding.everyRound(fun.value(this.name, bdArgs));
            }
        }
        catch (FunctionEvalException e) {
            throw new FormulaEvaluatorException(e.getMessage(), e.getCause(), this.formula, this.location);
        }
        catch (FunctionException e) {
            throw new FormulaEvaluatorException(e.getMessage(), e.getFunctionName(), this.location);
        }
        throw new FormulaEvaluatorException("Library internal error", this.name, -1);
    }

    String imcompleteMessage() {
        if (this.isOpen()) {
            return "Incomplete parenthesis";
        }
        if (this.args.size() != this.numberOfArgs) {
            return "Invalid argment number";
        }
        return null;
    }

    boolean isComplete() {
        return !this.isOpen() && this.args.size() == this.numberOfArgs;
    }

    String normalized() {
        String s = "";
        for (Token arg : this.args) {
            if (!s.equals("")) {
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + arg.normalized();
        }
        return String.valueOf(this.name) + "(" + s + ")";
    }

    String strToken() {
        return String.valueOf(this.name) + "(";
    }

    boolean filled() {
        return this.args.size() >= this.numberOfArgs;
    }

    void bind(Token token) {
        this.args.add(token);
        token.parent = this;
    }

    void reBind(Token token) {
        this.args.remove(this.args.size() - 1);
        this.bind(token);
    }
}

