/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.FormulaEvaluatorException;
import com.sanpudo.formula.Rounding;
import com.sanpudo.formula.Value;
import java.math.BigDecimal;

class DirectValue
extends Value {
    String value;
    static final String regex = "(-?\\d+(\\.\\d*)?)|(-?\\.\\d+)";

    DirectValue(String formula, int location, String value) {
        super(formula, location);
        this.value = value;
    }

    String strToken() {
        return this.value;
    }

    double value() throws FormulaEvaluatorException {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            throw new FormulaEvaluatorException("Library internal error", this.strToken(), this.location);
        }
    }

    BigDecimal value(Rounding rounding) throws FormulaEvaluatorException {
        try {
            return rounding.everyRound(new BigDecimal(this.value).setScale(rounding.scale, rounding.rMode));
        }
        catch (Exception e) {
            throw new FormulaEvaluatorException("Library internal error", this.strToken(), this.location);
        }
    }
}

