/*
 * Decompiled with CFR 0.152.
 */
package com.sanpudo.formula;

import com.sanpudo.formula.FormulaEvaluator;
import com.sanpudo.formula.FormulaEvaluatorException;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Demo
extends JFrame
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private FormulaEvaluator fe;
    private JMenuItem exitMenu;
    private JMenuItem[] sampleItems;
    private String[] samples = new String[]{"1+2-3*4/5+6-7*8/9", "max(5.0,-5.0)", "log(E)", "sqrt(sin(0.5)^2+cos(0.5)^2)", "round(1/3,5)"};
    private JTextField formula;
    private JLabel result;
    private JButton evalButton;
    private ButtonGroup modeGroup;
    private JRadioButton dValue;
    private JRadioButton bdValue;
    private JComboBox scale;
    private JButton quitButton;

    public void actionPerformed(ActionEvent e) {
        block11: {
            try {
                Object source = e.getSource();
                this.formula.setForeground(Color.BLACK);
                if (source == this.quitButton || source == this.exitMenu) {
                    System.exit(0);
                    break block11;
                }
                if (source == this.evalButton) {
                    if (this.modeGroup.isSelected(this.dValue.getModel())) {
                        double d = this.fe.dEvaluate(this.formula.getText());
                        this.result.setText(Double.toString(d));
                    } else {
                        BigDecimal bd = this.fe.bdEvaluate(this.formula.getText());
                        this.result.setText(bd.toString());
                    }
                    break block11;
                }
                if (source == this.dValue) {
                    this.scale.setEnabled(false);
                    break block11;
                }
                if (source == this.bdValue) {
                    this.scale.setEnabled(true);
                    break block11;
                }
                if (source == this.scale) {
                    this.fe.setScale(this.scale.getSelectedIndex());
                    break block11;
                }
                int i = 0;
                while (i < this.sampleItems.length) {
                    if (source == this.sampleItems[i]) {
                        this.formula.setText(this.sampleItems[i].getText());
                        break;
                    }
                    ++i;
                }
            }
            catch (FormulaEvaluatorException ex) {
                this.result.setText(ex.getMessage());
                this.formula.setCaretPosition(ex.errorLocation);
                this.formula.setForeground(Color.RED);
                this.formula.requestFocus();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        this.formula.setForeground(Color.BLACK);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    Demo() {
        this.fe = new FormulaEvaluator();
        this.setLayout(new GridLayout(4, 1));
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        this.exitMenu = new JMenuItem("Exit");
        this.exitMenu.addActionListener(this);
        fileMenu.add(this.exitMenu);
        JMenu sampleMenu = new JMenu("Sample");
        menuBar.add(sampleMenu);
        this.sampleItems = new JMenuItem[this.samples.length];
        int i = 0;
        while (i < this.samples.length) {
            this.sampleItems[i] = new JMenuItem(this.samples[i]);
            this.sampleItems[i].addActionListener(this);
            sampleMenu.add(this.sampleItems[i]);
            ++i;
        }
        JPanel formulaPanel = new JPanel();
        formulaPanel.setLayout(new FlowLayout(0));
        formulaPanel.add(new JLabel("Formula:"));
        this.formula = new JTextField(30);
        this.formula.setText("1+2*3");
        this.formula.addKeyListener(this);
        formulaPanel.add(this.formula);
        this.getContentPane().add(formulaPanel);
        JPanel resultPanel = new JPanel();
        resultPanel.setLayout(new FlowLayout(0));
        resultPanel.add(new JLabel("Result:"));
        this.result = new JLabel("                              ");
        resultPanel.add(this.result);
        this.getContentPane().add(resultPanel);
        JPanel modePanel = new JPanel();
        modePanel.setLayout(new FlowLayout(0));
        modePanel.add(new JLabel("Mode:"));
        this.modeGroup = new ButtonGroup();
        this.dValue = new JRadioButton("double");
        this.modeGroup.add(this.dValue);
        modePanel.add(this.dValue);
        this.dValue.addActionListener(this);
        this.bdValue = new JRadioButton("BigDecimal");
        this.modeGroup.add(this.bdValue);
        modePanel.add(this.bdValue);
        this.bdValue.addActionListener(this);
        this.modeGroup.setSelected(this.dValue.getModel(), true);
        modePanel.add(new JLabel("Scale:"));
        this.scale = new JComboBox();
        int i2 = 0;
        while (i2 < 16) {
            this.scale.addItem(new Integer(i2));
            ++i2;
        }
        this.scale.setSelectedIndex(this.fe.getScale());
        this.scale.setEnabled(false);
        this.scale.addActionListener(this);
        modePanel.add(this.scale);
        this.getContentPane().add(modePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.evalButton = new JButton("Evaluate");
        this.evalButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.evalButton);
        buttonPanel.add(this.evalButton);
        this.quitButton = new JButton("Quit");
        this.quitButton.addActionListener(this);
        buttonPanel.add(this.quitButton);
        this.getContentPane().add(buttonPanel);
        this.setDefaultCloseOperation(2);
        this.setTitle("Sanpudo Formula Evaluator Demo");
        this.pack();
        Rectangle screen = this.getGraphicsConfiguration().getBounds();
        this.setLocation(screen.x + screen.width / 2 - this.getSize().width / 2, screen.y + screen.height / 2 - this.getSize().height / 2);
    }

    public static void main(String[] args) {
        Demo demo = new Demo();
        demo.setVisible(true);
    }
}

