/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

public class Earth {
    private double e2;
    private double a;
    private double b;
    private double f;
    private static final double radius = 6371229.0;

    Earth(double a, double b) {
        this.a = a;
        this.b = b;
        this.e2 = 1.0 - b * b / (a * a);
        this.f = 1.0 - b / a;
    }

    Earth(double a, double f, boolean fake) {
        this.a = a;
        this.f = f;
        this.b = a * (1.0 - f);
        this.e2 = 1.0 - this.b * this.b / (a * a);
    }

    public double getEccentricity() {
        return Math.sqrt(this.e2);
    }

    public double getFlattening() {
        return this.f;
    }

    public double getMajor() {
        return this.a;
    }

    public double getMinor() {
        return this.b;
    }

    public static double getRadius() {
        return 6371229.0;
    }
}

