/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.Controller;
import thredds.filesystem.DateExtractorFromFilename;
import thredds.filesystem.MCollection;
import thredds.filesystem.MFile;
import thredds.filesystem.MFileFilter;
import thredds.filesystem.RegExpMatchOnName;
import thredds.filesystem.WildcardMatchOnPath;
import ucar.nc2.ncml.DatasetScanner;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetScanner2 {
    protected static Logger logger = LoggerFactory.getLogger(DatasetScanner.class);
    private static Controller controller;
    private MCollection mc;
    private boolean wantSubdirs = true;
    private long olderThan_msecs;
    private boolean debugScan = false;

    static void setController(Controller _controller) {
        controller = _controller;
    }

    DatasetScanner2(String dirName, String suffix, String regexpPatternString, String subdirsS, String olderS, String dateFormatString) {
        MFileFilter filter = null;
        if (null != regexpPatternString) {
            filter = new RegExpMatchOnName(regexpPatternString);
        } else if (suffix != null) {
            filter = new WildcardMatchOnPath("*" + suffix);
        }
        DateExtractorFromFilename dateExtractor = dateFormatString == null ? null : new DateExtractorFromFilename(dateFormatString);
        this.mc = new MCollection(dirName, dirName, filter, dateExtractor);
        if (subdirsS != null && subdirsS.equalsIgnoreCase("false")) {
            this.wantSubdirs = false;
        }
        if (olderS != null) {
            try {
                TimeUnit tu = new TimeUnit(olderS);
                this.olderThan_msecs = (long)(1000.0 * tu.getValueInSeconds());
            }
            catch (Exception e) {
                logger.error("Invalid time unit for olderThan = {}", (Object)olderS);
            }
        }
    }

    public List<MFile> scanDirectory(CancelTask cancelTask) throws IOException {
        ArrayList<MFile> result = new ArrayList<MFile>();
        this.scanDirectory(this.mc, new Date().getTime(), result, cancelTask);
        return result;
    }

    private void scanDirectory(MCollection mc, long now, List<MFile> result, CancelTask cancelTask) throws IOException {
        Iterator<MFile> iter = controller.getInventory(mc);
        while (iter.hasNext()) {
            MFile child = iter.next();
            if (child.isDirectory()) {
                if (this.wantSubdirs) {
                    this.scanDirectory(mc.subdir(child), now, result, cancelTask);
                }
            } else {
                long lastModifiedMsecs;
                if (this.olderThan_msecs > 0L && now - (lastModifiedMsecs = child.getLastModified()) < this.olderThan_msecs) continue;
                result.add(child);
                if (this.debugScan) {
                    System.out.println(" accept " + child);
                }
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }
}

