/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thredds.crawlabledataset.CrawlableDataset;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.fmrc.ForecastModelRunInventory;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationExisting;
import ucar.nc2.ncml.AggregationFmrc;
import ucar.nc2.ncml.AggregationOuterDimension;
import ucar.nc2.ncml.DatasetScanner;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateFromString;
import ucar.nc2.util.CancelTask;

public class AggregationFmrcSingle
extends AggregationFmrc {
    private Calendar cal;
    private Map<Date, List<DatasetFmrcSingle>> runHash = new HashMap<Date, List<DatasetFmrcSingle>>();
    private List<Date> runs;
    private CoordinateAxis1D timeAxis = null;
    private int max_times = 0;
    private boolean debug = false;
    private String runMatcher;
    private String forecastMatcher;
    private String offsetMatcher;

    public AggregationFmrcSingle(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.forecastModelRunSingleCollection, recheckS);
        this.cal = new GregorianCalendar();
        this.cal.clear();
    }

    public void addDirectoryScanFmrc(String dirName, String suffix, String regexpPatternString, String subdirs, String olderThan, String runMatcher, String forecastMatcher, String offsetMatcher) throws IOException {
        this.runMatcher = runMatcher;
        this.forecastMatcher = forecastMatcher;
        this.offsetMatcher = offsetMatcher;
        this.isDate = true;
        DatasetScanner d = new DatasetScanner(null, dirName, suffix, regexpPatternString, subdirs, olderThan);
        this.datasetManager.addDirectoryScan(d);
    }

    protected void closeDatasets() throws IOException {
        for (Aggregation.Dataset ds : this.datasets) {
            OpenDataset ods = (OpenDataset)ds;
            if (ods.openFile == null) continue;
            ods.openFile.close();
        }
    }

    public void getDetailInfo(Formatter f) {
        super.getDetailInfo(f);
        if (this.runMatcher != null) {
            f.format("  runMatcher=%s%n", this.runMatcher);
        }
        if (this.forecastMatcher != null) {
            f.format("  forecastMatcher=%s%n", this.forecastMatcher);
        }
        if (this.offsetMatcher != null) {
            f.format("  offsetMatcher=%s%n", this.offsetMatcher);
        }
    }

    protected void makeDatasets(CancelTask cancelTask) throws IOException {
        this.runHash = new HashMap<Date, List<DatasetFmrcSingle>>();
        Aggregation.Dataset typDataset = null;
        for (CrawlableDataset cd : this.datasetManager.getFiles()) {
            List<DatasetFmrcSingle> runDatasets;
            DatasetFmrcSingle ds = new DatasetFmrcSingle(cd);
            if (typDataset == null) {
                typDataset = ds;
            }
            if ((runDatasets = this.runHash.get(ds.runDate)) == null) {
                runDatasets = new ArrayList<DatasetFmrcSingle>();
                this.runHash.put(ds.runDate, runDatasets);
            }
            runDatasets.add(ds);
            if (!this.debug) continue;
            System.out.println("  adding " + cd.getPath() + " forecast date= " + ds.coordValue + "(" + ds.coordValueDate + ")" + " run date= " + this.dateFormatter.toDateTimeStringISO(ds.runDate));
        }
        NetcdfFile typFile = typDataset.acquireFile(cancelTask);
        NetcdfDataset typDS = NetcdfDataset.wrap(typFile, null);
        GridDataset typGds = new GridDataset(typDS);
        for (GridDatatype grid : typGds.getGrids()) {
            GridCoordSystem gcc = grid.getCoordinateSystem();
            this.timeAxis = gcc.getTimeAxis1D();
            if (null == this.timeAxis) continue;
            break;
        }
        if (this.timeAxis == null) {
            throw new IllegalStateException("No time variable");
        }
        this.datasets = new ArrayList();
        for (Aggregation.Dataset dataset : this.explicitDatasets) {
            dataset.enhance = fmrcEnhanceMode;
            this.datasets.add(dataset);
        }
        this.max_times = 0;
        this.runs = new ArrayList<Date>(this.runHash.keySet());
        Collections.sort(this.runs);
        for (Date runDate : this.runs) {
            String runDateS = this.dateFormatter.toDateTimeStringISO(runDate);
            List<DatasetFmrcSingle> runDatasets = this.runHash.get(runDate);
            this.max_times = Math.max(this.max_times, runDatasets.size());
            Collections.sort(runDatasets);
            NetcdfDataset ncd = new NetcdfDataset();
            ncd.setLocation("Run" + runDateS);
            DateFormatter format = new DateFormatter();
            if (this.debug) {
                System.out.println("Run" + format.toDateTimeString(runDate));
            }
            AggregationExisting agg = new AggregationExisting(ncd, this.timeAxis.getName(), null);
            for (DatasetFmrcSingle dataset : runDatasets) {
                agg.addDataset(dataset);
                if (!this.debug) continue;
                System.out.println("  adding Forecast " + format.toDateTimeString(((AggregationOuterDimension.DatasetOuterDimension)dataset).coordValueDate) + " " + dataset.getLocation());
            }
            ncd.setAggregation(agg);
            agg.finish(cancelTask);
            ncd.finish();
            this.datasets.add(new OpenDataset(ncd, runDate, runDateS));
        }
        typGds.close();
    }

    private Date addHour(Date d, double hour) {
        this.cal.setTime(d);
        int ihour = (int)hour;
        int imin = (int)(hour - (double)ihour) * 60;
        this.cal.add(11, ihour);
        this.cal.add(12, imin);
        return this.cal.getTime();
    }

    protected void makeTimeCoordinate(ucar.nc2.dt.GridDataset gds, CancelTask cancelTask) throws IOException {
        String innerDimName = this.timeAxis.getName();
        Dimension innerDim = new Dimension(innerDimName, this.max_times);
        this.ncDataset.removeDimension(null, innerDimName);
        this.ncDataset.addDimension(null, innerDim);
        int[] shape = new int[]{this.runs.size(), this.max_times};
        Array timeCoordVals = Array.factory(DataType.DOUBLE, shape);
        MAMath.setDouble(timeCoordVals, Double.NaN);
        Index ima = timeCoordVals.getIndex();
        Date baseDate = null;
        for (int i = 0; i < this.runs.size(); ++i) {
            Date runDate = this.runs.get(i);
            if (baseDate == null) {
                baseDate = runDate;
            }
            List<DatasetFmrcSingle> runDatasets = this.runHash.get(runDate);
            for (int j = 0; j < runDatasets.size(); ++j) {
                DatasetFmrcSingle dataset = runDatasets.get(j);
                double offset = ForecastModelRunInventory.getOffsetInHours(baseDate, dataset.coordValueDate);
                timeCoordVals.setDouble(ima.set(i, j), offset);
            }
        }
        String dims = this.dimName + " " + innerDimName;
        String units = "hours since " + this.dateFormatter.toDateTimeStringISO(baseDate);
        String desc = "calculated forecast date from AggregationFmrcSingle processing";
        VariableDS vagg = new VariableDS(this.ncDataset, null, null, innerDimName, DataType.DOUBLE, dims, units, desc);
        vagg.setCachedData(timeCoordVals, false);
        DatasetConstructor.transferVariableAttributes(this.timeAxis, vagg);
        vagg.addAttribute(new Attribute("units", units));
        vagg.addAttribute(new Attribute("long_name", desc));
        vagg.addAttribute(new Attribute("missing_value", Double.NaN));
        this.ncDataset.addCoordinateAxis(vagg);
        if (this.debug) {
            System.out.println("FmrcAggregation: promoted timeCoord " + innerDimName);
        }
    }

    protected void readTimeCoordinates(VariableDS timeAxis, CancelTask cancelTask) throws IOException {
        String dimName = timeAxis.getName();
        Dimension timeDim = this.ncDataset.findDimension(dimName);
        timeDim.setLength(this.max_times);
        List<Variable> vars = this.ncDataset.getVariables();
        for (Variable v : vars) {
            if (v.findDimensionIndex(dimName) < 0) continue;
            v.resetDimensions();
            v.setCachedData(null, false);
        }
        int[] shape = new int[]{this.runs.size(), this.max_times};
        Array timeCoordVals = Array.factory(DataType.DOUBLE, shape);
        MAMath.setDouble(timeCoordVals, Double.NaN);
        Index ima = timeCoordVals.getIndex();
        Date baseDate = null;
        for (int i = 0; i < this.runs.size(); ++i) {
            Date runDate = this.runs.get(i);
            if (baseDate == null) {
                baseDate = runDate;
            }
            List<DatasetFmrcSingle> runDatasets = this.runHash.get(runDate);
            for (int j = 0; j < runDatasets.size(); ++j) {
                AggregationOuterDimension.DatasetOuterDimension dataset = runDatasets.get(j);
                double offset = ForecastModelRunInventory.getOffsetInHours(baseDate, dataset.coordValueDate);
                timeCoordVals.setDouble(ima.set(i, j), offset);
            }
        }
        timeAxis.setCachedData(timeCoordVals, true);
        String units = "hours since " + this.dateFormatter.toDateTimeStringISO(baseDate);
        timeAxis.addAttribute(new Attribute("units", units));
    }

    public class OpenDataset
    extends AggregationOuterDimension.DatasetOuterDimension {
        private NetcdfFile openFile;

        protected OpenDataset(NetcdfFile openFile, Date coordValueDate, String coordValue) {
            super((AggregationOuterDimension)AggregationFmrcSingle.this, openFile.getLocation());
            this.openFile = openFile;
            this.ncoord = 1;
            this.coordValueDate = coordValueDate;
            this.coordValue = coordValue;
        }

        public NetcdfFile acquireFile(CancelTask cancelTask) throws IOException {
            return this.openFile;
        }

        protected void close(NetcdfFile ncfile) throws IOException {
            if (ncfile == null) {
                return;
            }
            this.cacheVariables(ncfile);
        }
    }

    public class DatasetFmrcSingle
    extends AggregationOuterDimension.DatasetOuterDimension {
        Date runDate;
        Double offset;

        DatasetFmrcSingle(CrawlableDataset cd) {
            super((AggregationOuterDimension)AggregationFmrcSingle.this, cd.getPath());
            this.cacheLocation = this.location;
            this.enhance = AggregationFmrc.fmrcEnhanceMode;
            this.ncoord = 1;
            if (AggregationFmrcSingle.this.runMatcher != null) {
                this.runDate = DateFromString.getDateUsingDemarkatedMatch(this.location, AggregationFmrcSingle.this.runMatcher, '#');
                if (null == this.runDate) {
                    Aggregation.logger.error("Cant extract rundate from =" + this.location + " using format " + AggregationFmrcSingle.this.runMatcher);
                }
            }
            if (AggregationFmrcSingle.this.forecastMatcher != null) {
                this.coordValueDate = DateFromString.getDateUsingDemarkatedMatch(this.location, AggregationFmrcSingle.this.forecastMatcher, '#');
                if (null == this.coordValueDate) {
                    Aggregation.logger.error("Cant extract forecast date from =" + this.location + " using format " + AggregationFmrcSingle.this.forecastMatcher);
                } else {
                    this.coordValue = AggregationFmrcSingle.this.dateFormatter.toDateTimeStringISO(this.coordValueDate);
                }
            }
            if (AggregationFmrcSingle.this.offsetMatcher != null) {
                this.offset = DateFromString.getHourUsingDemarkatedMatch(this.location, AggregationFmrcSingle.this.offsetMatcher, '#');
                if (null == this.offset) {
                    Aggregation.logger.error("Cant extract forecast offset from =" + this.location + " using format " + AggregationFmrcSingle.this.offsetMatcher);
                }
                this.coordValueDate = AggregationFmrcSingle.this.addHour(this.runDate, this.offset);
                this.coordValue = AggregationFmrcSingle.this.dateFormatter.toDateTimeStringISO(this.coordValueDate);
            }
        }
    }
}

