/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.uamiv;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class UAMIVServiceProvider
extends AbstractIOServiceProvider {
    private static final String AVERAGE = "A   V   E   R   A   G   E               ";
    private static final String EMISSIONS = "E   M   I   S   S   I   O   N   S       ";
    private static final String AIRQUALITY = "A   I   R   Q   U   A   L   I   T   Y   ";
    private static final String INSTANT = "I   N   S   T   A   N   T               ";
    private static final String HEIGHT = "HEIGHT";
    private static final String PBL = "PBL";
    private static final String TEMP = "TEMP";
    private static final String PRESS = "PRESS";
    private static final String WINDX = "WINDX";
    private static final String WINDY = "WINDY";
    private static final String VERTDIFF = "Kv";
    private static final String SPEED = "SPEED";
    private static final String CLDOD = "CLD OPDEP";
    private static final String CLDWATER = "CLD WATER";
    private static final String PRECIP = "PCP WATER";
    private static final String RAIN = "RAIN";
    private RandomAccessFile raf;
    private NetcdfFile ncfile;
    private String[] species_names;
    private long data_start;
    private int n2dvals;
    private int n3dvals;
    private int spc_2D_block;
    private int spc_3D_block;
    private int data_block;
    private int date_block;
    private int nspec;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            raf.order(0);
            raf.seek(0L);
            raf.skipBytes(4);
            byte[] b = new byte[40];
            raf.read(b);
            String test = new String(b);
            return test.equals(EMISSIONS) || test.equals(AVERAGE) || test.equals(AIRQUALITY) || test.equals(INSTANT);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public String getFileTypeId() {
        return "UAMIV";
    }

    public String getFileTypeDescription() {
        return "CAMx UAM-IV formatted files";
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        int nspec;
        this.raf = raf;
        this.ncfile = ncfile;
        raf.order(0);
        raf.seek(0L);
        raf.skipBytes(4);
        String name = raf.readString(40);
        String note = raf.readString(240);
        raf.skipBytes(4);
        this.nspec = nspec = raf.readInt();
        int bdate = raf.readInt();
        float btime = raf.readFloat();
        int edate = raf.readInt();
        float etime = raf.readFloat();
        int btimei = (int)btime;
        if (bdate < 70000) {
            edate += 2000000;
            bdate += 2000000;
        } else {
            edate += 1900000;
            bdate += 1900000;
        }
        raf.skipBytes(4);
        raf.skipBytes(4);
        raf.skipBytes(8);
        int iutm = raf.readInt();
        float xorg = raf.readFloat();
        float yorg = raf.readFloat();
        float delx = raf.readFloat();
        float dely = raf.readFloat();
        int nx = raf.readInt();
        int ny = raf.readInt();
        int nz = raf.readInt();
        raf.skipBytes(20);
        raf.skipBytes(4);
        raf.skipBytes(4);
        raf.skipBytes(8);
        int nx2 = raf.readInt();
        int ny2 = raf.readInt();
        raf.skipBytes(8);
        nz = Math.max(nz, 1);
        int count = 0;
        String[] spc_names = new String[nspec];
        while (count < nspec) {
            String spc = raf.readString(40);
            spc_names[count++] = spc.replace(" ", "");
        }
        this.species_names = spc_names;
        raf.skipBytes(4);
        this.data_start = raf.getFilePointer();
        int data_length_float_equivalents = ((int)raf.length() - (int)this.data_start) / 4;
        this.n2dvals = nx * ny;
        this.n3dvals = nx * ny * nz;
        this.spc_2D_block = nx * ny + 10 + 2 + 1;
        this.spc_3D_block = this.spc_2D_block * nz;
        this.data_block = this.spc_3D_block * nspec + 6;
        int ntimes = data_length_float_equivalents / this.data_block;
        ncfile.addDimension(null, new Dimension("TSTEP", ntimes, true));
        ncfile.addDimension(null, new Dimension("LAY", nz, true));
        ncfile.addDimension(null, new Dimension("ROW", ny, true));
        ncfile.addDimension(null, new Dimension("COL", nx, true));
        ncfile.sync();
        count = 0;
        while (count < nspec) {
            String spc = spc_names[count++];
            Variable temp = ncfile.addVariable(null, spc, DataType.FLOAT, "TSTEP LAY ROW COL");
            if (spc.equals(WINDX) || spc.equals(WINDY) || spc.equals(SPEED)) {
                temp.addAttribute(new Attribute("units", "m/s"));
            } else if (spc.equals(VERTDIFF)) {
                temp.addAttribute(new Attribute("units", "m**2/s"));
            } else if (spc.equals(TEMP)) {
                temp.addAttribute(new Attribute("units", "K"));
            } else if (spc.equals(PRESS)) {
                temp.addAttribute(new Attribute("units", "hPa"));
            } else if (spc.equals(HEIGHT) || spc.equals(PBL)) {
                temp.addAttribute(new Attribute("units", "m"));
            } else if (spc.equals(CLDWATER) || spc.equals(PRECIP) || spc.equals(RAIN)) {
                temp.addAttribute(new Attribute("units", "g/m**3"));
            } else if (spc.equals(CLDOD)) {
                temp.addAttribute(new Attribute("units", "none"));
            } else if (spc.startsWith("SOA") || spc.equals("PSO4") || spc.equals("PNO3") || spc.equals("PNH4") || spc.equals("PH2O") || spc.equals("SOPA") || spc.equals("SOPB") || spc.equals("NA") || spc.equals("PCL") || spc.equals("POA") || spc.equals("PEC") || spc.equals("FPRM") || spc.equals("FCRS") || spc.equals("CPRM") || spc.equals("CCRS")) {
                temp.addAttribute(new Attribute("units", "ug/m**3"));
            } else {
                temp.addAttribute(new Attribute("units", "ppm"));
            }
            temp.addAttribute(new Attribute("long_name", spc));
            temp.addAttribute(new Attribute("var_desc", spc));
        }
        double[] sigma = new double[nz + 1];
        count = 0;
        while (count < nz + 1) {
            sigma[count++] = count;
        }
        int[] size = new int[]{nz + 1};
        Array sigma_arr = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), size, (Object)sigma);
        ncfile.addAttribute(null, new Attribute("VGLVLS", sigma_arr));
        ncfile.addAttribute(null, new Attribute("SDATE", new Integer(bdate)));
        ncfile.addAttribute(null, new Attribute("STIME", new Integer(btimei)));
        ncfile.addAttribute(null, new Attribute("TSTEP", new Integer(10000)));
        ncfile.addAttribute(null, new Attribute("NSTEPS", new Integer(ntimes)));
        ncfile.addAttribute(null, new Attribute("NLAYS", new Integer(nz)));
        ncfile.addAttribute(null, new Attribute("NROWS", new Integer(ny)));
        ncfile.addAttribute(null, new Attribute("NCOLS", new Integer(nx)));
        ncfile.addAttribute(null, new Attribute("XORIG", new Double(xorg)));
        ncfile.addAttribute(null, new Attribute("YORIG", new Double(yorg)));
        ncfile.addAttribute(null, new Attribute("XCELL", new Double(delx)));
        ncfile.addAttribute(null, new Attribute("YCELL", new Double(dely)));
        ncfile.addAttribute(null, new Attribute("GDTYP", new Integer(2)));
        ncfile.addAttribute(null, new Attribute("P_ALP", new Double(30.0)));
        ncfile.addAttribute(null, new Attribute("P_BET", new Double(60.0)));
        ncfile.addAttribute(null, new Attribute("XCENT", new Double(-100.0)));
        ncfile.addAttribute(null, new Attribute("YCENT", new Double(40.0)));
    }

    public Array readData(Variable v2, Section wantSection) throws IOException, InvalidRangeException {
        this.raf.order(0);
        int size = (int)v2.getSize();
        float[] arr = new float[size];
        this.raf.seek(this.data_start);
        int pad1 = this.raf.readInt();
        this.raf.skipBytes(16);
        int pad2 = this.raf.readInt();
        if (pad1 != pad2) {
            throw new IOException("Asymmetric fortran buffer values: 1");
        }
        int spcid = -1;
        String spc = "";
        while (spc != v2.getShortName()) {
            spc = this.species_names[++spcid];
        }
        this.raf.skipBytes(this.spc_3D_block * spcid * 4);
        int count = 0;
        while (count < size) {
            int ione;
            if (count == 0) {
                pad1 = this.raf.readInt();
                ione = this.raf.readInt();
                spc = this.raf.readString(40);
            }
            if (count != 0 && count % this.n2dvals == 0) {
                pad2 = this.raf.readInt();
                if (pad1 != pad2) {
                    throw new IOException("Asymmetric fortran buffer values: 2");
                }
                if (count % this.n3dvals == 0) {
                    this.raf.skipBytes((this.data_block - this.spc_3D_block) * 4);
                }
                pad1 = this.raf.readInt();
                ione = this.raf.readInt();
                spc = this.raf.readString(40);
            }
            try {
                arr[count++] = this.raf.readFloat();
            }
            catch (ArrayIndexOutOfBoundsException io) {
                throw new IOException(io.getMessage());
            }
        }
        Array data = Array.factory(DataType.FLOAT.getPrimitiveClassType(), v2.getShape(), (Object)arr);
        return data.sectionNoReduce(wantSection.getRanges());
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

