/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.StringTokenizer;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.StructurePseudo;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.JoinArray;
import ucar.nc2.ft.point.standard.JoinMuiltdimStructure;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class GempakCdm
extends TableConfigurerImpl {
    private final String Convention = "GEMPAK/CDM";

    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        boolean ok = false;
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        if (conv.equals("GEMPAK/CDM")) {
            ok = true;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equals("GEMPAK/CDM")) continue;
            ok = true;
        }
        if (!ok) {
            return false;
        }
        String ftypeS = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        CF.FeatureType ftype = ftypeS == null ? CF.FeatureType.point : CF.FeatureType.valueOf(ftypeS);
        return ftype == CF.FeatureType.stationTimeSeries;
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        String ftypeS = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        CF.FeatureType ftype = ftypeS == null ? CF.FeatureType.point : CF.FeatureType.valueOf(ftypeS);
        switch (ftype) {
            case point: {
                return null;
            }
            case stationTimeSeries: {
                if (wantFeatureType == FeatureType.POINT) {
                    return this.getStationAsPointConfig(ds, errlog);
                }
                return this.getStationConfig(ds, errlog);
            }
        }
        throw new IllegalStateException("unimplemented feature ftype= " + (Object)((Object)ftype));
    }

    protected TableConfig getStationConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        boolean needFinish = false;
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Latitude coordinate", new Object[0]);
            return null;
        }
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (lon == null) {
            errlog.format("Must have a Longitude coordinate", new Object[0]);
            return null;
        }
        if (lat.getRank() != lon.getRank()) {
            errlog.format("Lat and Lon coordinate must have same rank", new Object[0]);
            return null;
        }
        boolean stnIsScalar = lat.getRank() == 0;
        boolean stnIsSingle = lat.getRank() == 1 && lat.getSize() == 1L;
        Dimension stationDim = null;
        if (!stnIsScalar) {
            if (lat.getDimension(0) != lon.getDimension(0)) {
                errlog.format("Lat and Lon coordinate must have same size", new Object[0]);
                return null;
            }
            stationDim = lat.getDimension(0);
        }
        boolean hasStruct = Evaluator.hasRecordStructure(ds);
        Table.Type stationTableType = stnIsScalar ? Table.Type.Top : Table.Type.Structure;
        TableConfig stnTable = new TableConfig(stationTableType, "station");
        stnTable.featureType = FeatureType.STATION;
        stnTable.isPsuedoStructure = !hasStruct;
        stnTable.dim = stationDim;
        stnTable.lat = lat.getName();
        stnTable.lon = lon.getName();
        CoordinateAxis alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        if (alt != null) {
            stnTable.stnAlt = alt.getName();
        }
        stnTable.stnId = Evaluator.getVariableWithAttribute(ds, "standard_name", "station_id");
        if (stnTable.stnId == null) {
            errlog.format("Must have a Station id variable with standard name station_id", new Object[0]);
            return null;
        }
        Variable stnId = ds.findVariable(stnTable.stnId);
        if (!stnIsScalar && !stnId.getDimension(0).equals(stationDim)) {
            errlog.format("Station id outer dimension must match latitude/longitude dimension", new Object[0]);
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate", new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(time.getRank() - 1);
        Table.Type obsTableType = null;
        Structure multidimStruct = null;
        if (obsTableType == null && (multidimStruct = Evaluator.getStructureWithDimensions(ds, stationDim, obsDim)) != null) {
            obsTableType = Table.Type.MultiDimStructure;
        }
        if (obsTableType == null && time.getRank() == 2) {
            obsTableType = Table.Type.MultiDimInner;
        }
        if (obsTableType == null) {
            errlog.format("Cannot figure out Station/obs table structure", new Object[0]);
            return null;
        }
        TableConfig obs = new TableConfig(obsTableType, obsDim.getName());
        obs.dim = obsDim;
        obs.time = time.getName();
        stnTable.addChild(obs);
        if (obsTableType == Table.Type.MultiDimStructure) {
            obs.structName = multidimStruct.getName();
            obs.isPsuedoStructure = false;
            if (multidimStruct.findVariable(time.getShortName()) == null) {
                obs.addJoin(new JoinArray(time, JoinArray.Type.raw, 0));
            }
        }
        if (obsTableType == Table.Type.MultiDimInner) {
            obs.dim = obsDim;
        }
        if (needFinish) {
            ds.finish();
        }
        return stnTable;
    }

    protected TableConfig getStationAsPointConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        boolean needFinish = false;
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("Must have a Latitude coordinate", new Object[0]);
            return null;
        }
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (lon == null) {
            errlog.format("Must have a Longitude coordinate", new Object[0]);
            return null;
        }
        if (lat.getRank() != lon.getRank()) {
            errlog.format("Lat and Lon coordinate must have same rank", new Object[0]);
            return null;
        }
        boolean stnIsScalar = lat.getRank() == 0;
        boolean stnIsSingle = lat.getRank() == 1 && lat.getSize() == 1L;
        Dimension stationDim = null;
        if (!stnIsScalar) {
            if (lat.getDimension(0) != lon.getDimension(0)) {
                errlog.format("Lat and Lon coordinate must have same size", new Object[0]);
                return null;
            }
            stationDim = lat.getDimension(0);
        }
        CoordinateAxis alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            errlog.format("Must have a Time coordinate", new Object[0]);
            return null;
        }
        Dimension obsDim = time.getDimension(time.getRank() - 1);
        Table.Type obsTableType = Table.Type.Structure;
        Structure multidimStruct = Evaluator.getStructureWithDimensions(ds, stationDim, obsDim);
        if (multidimStruct == null) {
            errlog.format("Cannot figure out StationAsPoint table structure", new Object[0]);
            return null;
        }
        TableConfig obs = new TableConfig(obsTableType, obsDim.getName());
        obs.dim = obsDim;
        obs.structName = multidimStruct.getName();
        obs.isPsuedoStructure = false;
        obs.featureType = FeatureType.POINT;
        obs.lat = lat.getName();
        obs.lon = lon.getName();
        obs.time = time.getName();
        if (alt != null) {
            obs.elev = alt.getName();
        }
        ArrayList<String> vars = new ArrayList<String>(30);
        for (Variable v : ds.getVariables()) {
            if (v.getDimension(0) != stationDim || v.getRank() != 1 && (v.getRank() != 2 || v.getDataType() != DataType.CHAR)) continue;
            vars.add(v.getShortName());
        }
        StructurePseudo s = new StructurePseudo(ds, null, "stnStruct", vars, stationDim);
        obs.addJoin(new JoinMuiltdimStructure(s, obsDim.getLength()));
        obs.addJoin(new JoinArray(time, JoinArray.Type.modulo, obsDim.getLength()));
        if (needFinish) {
            ds.finish();
        }
        return obs;
    }
}

