/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ucar.ma2.StructureDataScalar;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class Cosmic
extends TableConfigurerImpl {
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String center = ds.findAttValueIgnoreCase(null, "center", null);
        return center != null && center.equals("UCAR/CDAAC");
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        TableConfig profile = new TableConfig(Table.Type.Singleton, "profile");
        profile.featureType = FeatureType.PROFILE;
        StructureDataScalar sdata = new StructureDataScalar("profile");
        sdata.addMember("lat", "Latitude (avg)", "degrees_north", ds.readAttributeDouble(null, "lat", Double.NaN));
        sdata.addMember("lon", "Longitude (avg)", "degrees_east", ds.readAttributeDouble(null, "lon", Double.NaN));
        Date time = this.makeTime(ds);
        sdata.addMember("time", "Time (avg)", "seconds since 1970-01-01 00:00", time.getTime() / 1000L);
        profile.sdata = sdata;
        profile.lat = "lat";
        profile.lon = "lon";
        profile.time = "time";
        TableConfig obs = new TableConfig(Table.Type.Structure, "levels");
        obs.isPsuedoStructure = true;
        obs.dim = ds.findDimension("MSL_alt");
        obs.elev = "MSL_alt";
        profile.addChild(obs);
        return obs;
    }

    Date makeTime(NetcdfDataset ds) {
        int year = ds.readAttributeInteger(null, "year", 0);
        int month = ds.readAttributeInteger(null, "month", 0);
        int dayOfMonth = ds.readAttributeInteger(null, "day", 0);
        int hourOfDay = ds.readAttributeInteger(null, "hour", 0);
        int minute = ds.readAttributeInteger(null, "minute", 0);
        int second = ds.readAttributeInteger(null, "second", 0);
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(year, month, dayOfMonth, hourOfDay, minute, second);
        return cal.getTime();
    }
}

