/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataFactory;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.point.StructureDataIteratorLimited;
import ucar.nc2.ft.point.standard.CoordVarExtractor;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedTable {
    private static Logger log = LoggerFactory.getLogger(NestedTable.class);
    private NetcdfDataset ds;
    private Formatter errlog;
    private Table leaf;
    private Table root;
    private FeatureType featureType;
    private CoordVarExtractor timeVE;
    private CoordVarExtractor nomTimeVE;
    private CoordVarExtractor latVE;
    private CoordVarExtractor lonVE;
    private CoordVarExtractor altVE;
    private CoordVarExtractor stnVE;
    private CoordVarExtractor stnDescVE;
    private CoordVarExtractor wmoVE;
    private CoordVarExtractor stnAltVE;
    private String featureVariableName = "featureName";
    private int nlevels;
    private DateFormatter dateFormatter = new DateFormatter();

    NestedTable(NetcdfDataset ds, TableConfig config, Formatter errlog) {
        this.ds = ds;
        this.errlog = errlog;
        this.leaf = Table.factory(ds, config);
        this.root = this.getRoot();
        this.nlevels = 0;
        Table t = this.leaf;
        while (t != null) {
            if (t.getFeatureType() != null) {
                this.featureType = t.getFeatureType();
            }
            if ((t = t.parent) instanceof Table.TableTop) continue;
            ++this.nlevels;
        }
        if (this.featureType == null) {
            this.featureType = FeatureDatasetFactoryManager.findFeatureType(ds);
        }
        this.timeVE = this.findCoordinateAxis(Table.CoordName.Time, this.leaf, 0);
        this.latVE = this.findCoordinateAxis(Table.CoordName.Lat, this.leaf, 0);
        this.lonVE = this.findCoordinateAxis(Table.CoordName.Lon, this.leaf, 0);
        this.altVE = this.findCoordinateAxis(Table.CoordName.Elev, this.leaf, 0);
        this.nomTimeVE = this.findCoordinateAxis(Table.CoordName.TimeNominal, this.leaf, 0);
        this.stnVE = this.findCoordinateAxis(Table.CoordName.StnId, this.leaf, 0);
        this.stnDescVE = this.findCoordinateAxis(Table.CoordName.StnDesc, this.leaf, 0);
        this.wmoVE = this.findCoordinateAxis(Table.CoordName.WmoId, this.leaf, 0);
        this.stnAltVE = this.findCoordinateAxis(Table.CoordName.StnAlt, this.leaf, 0);
        if (this.featureType == null) {
            if (this.nlevels == 1) {
                this.featureType = FeatureType.POINT;
            }
            if (this.nlevels == 2) {
                this.featureType = FeatureType.STATION;
            }
            if (this.nlevels == 3) {
                this.featureType = FeatureType.STATION_PROFILE;
            }
        }
        if (this.nlevels == 1 && this.featureType == FeatureType.STATION || this.featureType == FeatureType.PROFILE || this.featureType == FeatureType.TRAJECTORY || this.nlevels == 2 && this.featureType == FeatureType.STATION_PROFILE || this.featureType == FeatureType.SECTION) {
            StructureData sdata = StructureDataFactory.make(this.featureVariableName, ds.getLocation());
            TableConfig parentConfig = new TableConfig(Table.Type.Singleton, this.featureType.toString());
            parentConfig.sdata = sdata;
            this.root = Table.factory(ds, parentConfig);
            ++this.nlevels;
        }
    }

    Table getRoot() {
        Table p = this.leaf;
        while (p.parent != null) {
            p = p.parent;
        }
        return p;
    }

    private CoordVarExtractor findCoordinateAxis(Table.CoordName coordName, Table t, int nestingLevel) {
        if (t == null) {
            return null;
        }
        String axisName = t.findCoordinateVariableName(coordName);
        if (axisName != null) {
            Variable v = t.findVariable(axisName);
            if (v != null) {
                return new CoordVarExtractorVariable(v, axisName, nestingLevel);
            }
            if (t.extraJoins != null) {
                for (Join j : t.extraJoins) {
                    v = j.findVariable(axisName);
                    if (v == null) continue;
                    return new CoordVarExtractorVariable(v, axisName, nestingLevel);
                }
            }
            if (t instanceof Table.TableSingleton) {
                Table.TableSingleton ts = (Table.TableSingleton)t;
                return new CoordVarStructureData(axisName, ts.sdata);
            }
            if (t instanceof Table.TableTop) {
                v = this.ds.findVariable(axisName);
                if (v != null) {
                    return new CoordVarTop(v);
                }
                return new CoordVarConstant(coordName.toString(), "", axisName);
            }
            this.errlog.format("NestedTable: cant find variable %s for coordinate type %s %n", new Object[]{axisName, coordName});
        }
        return this.findCoordinateAxis(coordName, t.parent, nestingLevel + 1);
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public int getNumberOfLevels() {
        return this.nlevels;
    }

    public boolean hasCoords() {
        return this.timeVE != null && this.latVE != null && this.lonVE != null;
    }

    public DateUnit getTimeUnit() {
        try {
            return new DateUnit(this.timeVE.getUnitsString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error on time string = " + this.timeVE.getUnitsString() + " == " + e.getMessage());
        }
    }

    public List<VariableSimpleIF> getDataVariables() {
        ArrayList<VariableSimpleIF> data = new ArrayList<VariableSimpleIF>();
        this.addDataVariables(data, this.leaf);
        return data;
    }

    private void addDataVariables(List<VariableSimpleIF> list, Table t) {
        if (t.parent != null) {
            this.addDataVariables(list, t.parent);
        }
        list.addAll(t.cols);
    }

    public String getName() {
        Formatter formatter = new Formatter();
        formatter.format("%s", this.leaf.getName());
        Table t = this.leaf;
        while (t.parent != null) {
            t = t.parent;
            formatter.format("/%s", t.getName());
        }
        return formatter.toString();
    }

    public String toString() {
        Formatter formatter = new Formatter();
        formatter.format("NestedTable = %s\n", this.getName());
        formatter.format("  Time= %s\n", this.timeVE);
        formatter.format("  Lat= %s\n", this.latVE);
        formatter.format("  Lon= %s\n", this.lonVE);
        formatter.format("  Height= %s\n", this.altVE);
        return formatter.toString();
    }

    public void show(Formatter formatter) {
        formatter.format(" NestedTable = %s\n", this.getName());
        formatter.format("   nlevels = %d\n", this.nlevels);
        this.leaf.show(formatter, 2);
    }

    public StructureDataIterator getObsDataIterator(Cursor cursor, int bufferSize) throws IOException {
        return this.root.getStructureDataIterator(cursor, bufferSize);
    }

    public List<Station> makeStations(int bufferSize) throws IOException {
        if (this.root instanceof Table.TableConstruct) {
            return this.constructStations((Table.TableConstruct)this.root);
        }
        ArrayList<Station> result = new ArrayList<Station>();
        StructureDataIterator siter = this.getStationDataIterator(bufferSize);
        while (siter.hasNext()) {
            StructureData stationData = siter.next();
            result.add(this.makeStation(stationData));
        }
        return result;
    }

    public StructureDataIterator getStationDataIterator(int bufferSize) throws IOException {
        Table stationTable = this.root;
        StructureDataIterator siter = stationTable.getStructureDataIterator(null, bufferSize);
        if (stationTable.limit != null) {
            Variable limitV = this.ds.findVariable(stationTable.limit);
            int limit = limitV.readScalarInt();
            return new StructureDataIteratorLimited(siter, limit);
        }
        return siter;
    }

    public StructureDataIterator getStationObsDataIterator(Cursor cursor, int bufferSize) throws IOException {
        return this.leaf.getStructureDataIterator(cursor, bufferSize);
    }

    public StructureDataIterator getFeatureDataIterator(int bufferSize) throws IOException {
        return this.root.getStructureDataIterator(null, bufferSize);
    }

    public StructureDataIterator getFeatureObsDataIterator(Cursor cursor, int bufferSize) throws IOException {
        return this.leaf.getStructureDataIterator(cursor, bufferSize);
    }

    public StructureDataIterator getStationProfileDataIterator(Cursor cursor, int bufferSize) throws IOException {
        if (cursor.what instanceof StationConstruct) {
            StationConstruct sc = (StationConstruct)cursor.what;
            return sc.getStructureDataIterator(bufferSize);
        }
        return this.root.getStructureDataIterator(cursor, bufferSize);
    }

    public StructureDataIterator getStationProfileObsDataIterator(Cursor cursor, int bufferSize) throws IOException {
        if (this.getFeatureType() != FeatureType.STATION_PROFILE) {
            throw new UnsupportedOperationException("Not a StationProfileFeatureCollection");
        }
        return this.leaf.getStructureDataIterator(cursor, bufferSize);
    }

    public double getObsTime(Cursor cursor) {
        return this.getTime(this.timeVE, cursor.tableData);
    }

    public double getNomTime(Cursor cursor) {
        return this.getTime(this.nomTimeVE, cursor.tableData);
    }

    private double getTime(CoordVarExtractor cve, StructureData[] tableData) {
        if (cve == null) {
            return Double.NaN;
        }
        if (cve.isString()) {
            Date date;
            String timeString = this.timeVE.getCoordValueString(tableData);
            try {
                date = this.dateFormatter.isoDateTimeFormat(timeString);
            }
            catch (ParseException e) {
                log.error("Cant parse date - not ISO formatted, = " + timeString);
                return 0.0;
            }
            return (double)date.getTime() / 1000.0;
        }
        return cve.getCoordValue(tableData);
    }

    public double getLatitude(Cursor cursor) {
        if (cursor.what instanceof StationConstruct) {
            return ((StationConstruct)cursor.what).getLatitude();
        }
        return this.latVE.getCoordValue(cursor.tableData);
    }

    public double getLongitude(Cursor cursor) {
        if (cursor.what instanceof StationConstruct) {
            return ((StationConstruct)cursor.what).getLongitude();
        }
        return this.lonVE.getCoordValue(cursor.tableData);
    }

    public EarthLocation getEarthLocation(Cursor cursor) {
        double alt;
        if (cursor.what instanceof StationConstruct) {
            return (StationConstruct)cursor.what;
        }
        double lat = this.latVE.getCoordValue(cursor.tableData);
        double lon = this.lonVE.getCoordValue(cursor.tableData);
        double d = alt = this.altVE == null ? Double.NaN : this.altVE.getCoordValue(cursor.tableData);
        if (this.stnAltVE != null) {
            double stnElev = this.stnAltVE.getCoordValue(cursor.tableData);
            alt = this.altVE == null ? stnElev : (alt += stnElev);
        }
        return new EarthLocationImpl(lat, lon, alt);
    }

    public String getFeatureName(StructureData sdata) {
        if (this.featureVariableName == null) {
            return "unknown";
        }
        StructureMembers.Member m = sdata.findMember(this.featureVariableName);
        if (m == null) {
            return "unknown";
        }
        return sdata.getScalarString(m);
    }

    public Station makeStation(StructureData stationData) {
        String stationName = this.stnVE.getCoordValueString(stationData);
        String stationDesc = this.stnDescVE == null ? "" : this.stnDescVE.getCoordValueString(stationData);
        String stnWmoId = this.wmoVE == null ? "" : this.wmoVE.getCoordValueString(stationData);
        double lat = this.latVE.getCoordValue(stationData);
        double lon = this.lonVE.getCoordValue(stationData);
        double elev = this.stnAltVE == null ? Double.NaN : this.stnAltVE.getCoordValue(stationData);
        return new StationImpl(stationName, stationDesc, stnWmoId, lat, lon, elev);
    }

    public StructureData makeObsStructureData(Cursor cursor) {
        return StructureDataFactory.make(cursor.tableData);
    }

    public void addParentJoin(Cursor cursor) throws IOException {
        if (this.leaf.extraJoins != null) {
            ArrayList<StructureData> sdata = new ArrayList<StructureData>(3);
            sdata.add(cursor.tableData[0]);
            for (Join j : this.leaf.extraJoins) {
                sdata.add(j.getJoinData(cursor));
            }
            cursor.tableData[0] = StructureDataFactory.make(sdata.toArray(new StructureData[sdata.size()]));
        }
    }

    private List<Station> constructStations(Table.TableConstruct stationTable) throws IOException {
        HashMap<String, StationConstruct> stnMap = new HashMap<String, StationConstruct>();
        ArrayList<Station> result = new ArrayList<Station>();
        StructureDataIterator iter = stationTable.getStructureDataIterator(null, -1);
        int recno = 0;
        while (iter.hasNext()) {
            StructureData sdata = iter.next();
            StationConstruct snew = this.makeStationConstruct(sdata);
            StationConstruct s = (StationConstruct)stnMap.get(snew.getName());
            if (s == null) {
                s = snew;
                s.struct = stationTable.struct;
                stnMap.put(s.getName(), s);
                result.add(s);
            }
            double obsTime = this.timeVE.getCoordValue(sdata);
            s.addIndex(recno, obsTime);
            ++recno;
        }
        return result;
    }

    private StationConstruct makeStationConstruct(StructureData stationData) {
        String stationName = this.stnVE.getCoordValueString(stationData);
        String stationDesc = this.stnDescVE == null ? "" : this.stnDescVE.getCoordValueString(stationData);
        String stnWmoId = this.wmoVE == null ? "" : this.wmoVE.getCoordValueString(stationData);
        double lat = this.latVE.getCoordValue(stationData);
        double lon = this.lonVE.getCoordValue(stationData);
        double elev = this.stnAltVE == null ? Double.NaN : this.stnAltVE.getCoordValue(stationData);
        return new StationConstruct(stationName, stationDesc, stnWmoId, lat, lon, elev);
    }

    private class StationConstruct
    extends StationImpl {
        List<Index> index;
        Structure struct;

        StationConstruct(String name, String desc, String wmoId, double lat, double lon, double alt) {
            super(name, desc, wmoId, lat, lon, alt);
        }

        void addIndex(int recno, double time) {
            if (this.index == null) {
                this.index = new ArrayList<Index>();
            }
            Index i = new Index();
            i.recno = recno;
            i.time = time;
            this.index.add(i);
        }

        StructureDataIterator getStructureDataIterator(int bufferSize) {
            return new IndexedStructureDataIterator();
        }

        class IndexedStructureDataIterator
        implements StructureDataIterator {
            int count = 0;

            IndexedStructureDataIterator() {
            }

            public boolean hasNext() throws IOException {
                return this.count < StationConstruct.this.index.size();
            }

            public StructureData next() throws IOException {
                Index i = StationConstruct.this.index.get(this.count++);
                try {
                    return StationConstruct.this.struct.readStructure(i.recno);
                }
                catch (InvalidRangeException e) {
                    throw new IllegalStateException("bad recnum " + i.recno, e);
                }
            }

            public void setBufferSize(int bytes) {
            }

            public StructureDataIterator reset() {
                this.count = 0;
                return this;
            }

            public void finish() {
            }
        }

        class Index {
            int recno;
            double time;

            Index() {
            }
        }
    }

    private class CoordVarConstant
    extends CoordVarExtractor {
        String units;
        String value;

        CoordVarConstant(String name, String units, String value) {
            super(name, 0);
            this.units = units;
            this.value = value;
        }

        public double getCoordValue(StructureData sdata) {
            return Double.parseDouble(this.value);
        }

        public String getCoordValueString(StructureData sdata) {
            return this.value;
        }

        public String getUnitsString() {
            return this.units;
        }

        public boolean isString() {
            return true;
        }

        public String toString() {
            return "CoordVarConstant value= " + this.value;
        }
    }

    private class CoordVarStructureData
    extends CoordVarExtractor {
        protected StructureData sdata;

        CoordVarStructureData(String axisName, StructureData sdata) {
            super(axisName, 0);
            this.sdata = sdata;
        }

        public double getCoordValue(StructureData ignore) {
            return this.sdata.convertScalarDouble(this.axisName);
        }

        public String getCoordValueString(StructureData ignore) {
            return this.sdata.getScalarString(this.axisName);
        }

        public String getUnitsString() {
            StructureMembers.Member m = this.sdata.findMember(this.axisName);
            return m.getUnitsString();
        }

        public boolean isString() {
            StructureMembers.Member m = this.sdata.findMember(this.axisName);
            return m.getDataType().isString();
        }
    }

    private class CoordVarTop
    extends CoordVarExtractor {
        protected Variable varTop;

        CoordVarTop(Variable v) {
            super(v.getName(), 0);
            this.varTop = v;
        }

        public double getCoordValue(StructureData sdata) {
            try {
                return this.varTop.readScalarDouble();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        public String getUnitsString() {
            return this.varTop.getUnitsString();
        }

        public boolean isString() {
            return this.varTop.getDataType().isString();
        }

        public String getCoordValueString(StructureData sdata) {
            try {
                return this.varTop.readScalarString();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private class CoordVarExtractorVariable
    extends CoordVarExtractor {
        protected Variable coordVar;

        CoordVarExtractorVariable(Variable v, String axisName, int nestingLevel) {
            super(axisName, nestingLevel);
            this.coordVar = v;
        }

        public String getCoordValueString(StructureData sdata) {
            if (this.coordVar.getDataType().isString()) {
                return sdata.getScalarString(this.axisName);
            }
            if (this.coordVar.getDataType().isIntegral()) {
                return Integer.toString(sdata.convertScalarInt(this.axisName));
            }
            return Double.toString(sdata.convertScalarDouble(this.axisName));
        }

        public String getUnitsString() {
            return this.coordVar.getUnitsString();
        }

        public boolean isString() {
            return this.coordVar.getDataType().isString();
        }

        public double getCoordValue(StructureData sdata) {
            return sdata.convertScalarDouble(this.axisName);
        }
    }
}

