/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.StationFeatureImpl;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.remote.QueryMaker;
import ucar.nc2.ft.point.remote.RemotePointCollection;
import ucar.nc2.ft.point.remote.RemotePointFeatureIterator;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamRemote;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteStationCollection
extends StationTimeSeriesCollectionImpl {
    private NcStreamRemote ncremote;
    protected LatLonRect boundingBox;
    protected DateRange dateRange;
    private boolean restrictedList = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RemoteStationCollection(String name, NcStreamRemote ncremote) throws IOException {
        super(name);
        this.ncremote = ncremote;
        this.stationHelper = new StationHelper();
        HttpMethod method = null;
        try {
            String query = "stations";
            method = ncremote.sendQuery(query);
            InputStream in = method.getResponseBodyAsStream();
            int len = NcStream.readVInt(in);
            byte[] b = new byte[len];
            NcStream.readFully(in, b);
            PointStreamProto.StationList stationsp = PointStreamProto.StationList.parseFrom(b);
            for (PointStreamProto.Station sp : stationsp.getStationsList()) {
                StationImpl s = new StationImpl(sp.getId(), sp.getDesc(), sp.getWmoId(), sp.getLat(), sp.getLon(), sp.getAlt());
                this.stationHelper.addStation(s);
            }
            Object var13_12 = null;
            if (method == null) return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (method == null) throw throwable;
            method.releaseConnection();
            throw throwable;
        }
        method.releaseConnection();
    }

    protected RemoteStationCollection(String name, NcStreamRemote ncremote, StationHelper sh) throws IOException {
        super(name);
        this.ncremote = ncremote;
        this.stationHelper = sh;
        this.restrictedList = true;
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new PointFeatureCollectionIterator(){
            Iterator<Station> stationIter;
            {
                this.stationIter = RemoteStationCollection.this.stationHelper.getStations().iterator();
            }

            public boolean hasNext() throws IOException {
                return this.stationIter.hasNext();
            }

            public PointFeatureCollection next() throws IOException {
                return new RemoteStationFeatureImpl(this.stationIter.next(), null);
            }

            public void setBufferSize(int bytes) {
            }

            public void finish() {
            }
        };
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        StationHelper sh = new StationHelper();
        sh.setStations(stations);
        return new RemoteStationCollectionSubset(this, sh, null, null);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        if (boundingBox == null) {
            return this;
        }
        StationHelper sh = new StationHelper();
        sh.setStations(this.stationHelper.getStations(boundingBox));
        return new RemoteStationCollectionSubset(this, sh, boundingBox, null);
    }

    @Override
    public StationTimeSeriesFeature getStationFeature(Station s) throws IOException {
        return new RemoteStationFeatureImpl(s, null);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        QueryByStationList queryMaker = this.restrictedList ? new QueryByStationList() : null;
        RemotePointCollection pfc = new RemotePointCollection(this.getName() + "-flatten", this.ncremote, queryMaker);
        return pfc.subset(boundingBox, dateRange);
    }

    private class RemoteStationFeatureImpl
    extends StationFeatureImpl {
        RemotePointFeatureIterator riter;
        DateRange dateRange;

        RemoteStationFeatureImpl(Station s, DateRange dateRange) {
            super(s, null, -1);
            this.dateRange = dateRange;
        }

        public StationTimeSeriesFeature subset(DateRange dateRange) throws IOException {
            if (dateRange == null) {
                return this;
            }
            return new RemoteStationFeatureImpl(this.s, dateRange);
        }

        public PointFeatureCollection subset(LatLonRect boundingBox, DateRange dateRange) throws IOException {
            if (boundingBox != null) {
                if (!boundingBox.contains(this.s.getLatLon())) {
                    return null;
                }
                if (dateRange == null) {
                    return this;
                }
            }
            return this.subset(dateRange);
        }

        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            String query = PointDatasetRemote.makeQuery("stn=" + this.s.getName(), null, this.dateRange);
            HttpMethod method = null;
            try {
                method = RemoteStationCollection.this.ncremote.sendQuery(query);
                InputStream in = method.getResponseBodyAsStream();
                int len = NcStream.readVInt(in);
                byte[] b = new byte[len];
                NcStream.readFully(in, b);
                PointStreamProto.PointFeatureCollection pfc = PointStreamProto.PointFeatureCollection.parseFrom(b);
                this.riter = new RemotePointFeatureIterator(method, in, new PointDatasetRemote.ProtobufPointFeatureMaker(pfc));
                this.riter.setCalculateBounds(this);
                return this.riter;
            }
            catch (Throwable t) {
                if (method != null) {
                    method.releaseConnection();
                }
                throw new IOException(t.getMessage());
            }
        }
    }

    private class RemoteStationCollectionSubset
    extends RemoteStationCollection {
        RemoteStationCollectionSubset(RemoteStationCollection from, StationHelper sh, LatLonRect filter_bb, DateRange filter_date) throws IOException {
            super(from.getName(), from.ncremote, sh);
            if (filter_bb == null) {
                this.boundingBox = from.getBoundingBox();
            } else {
                LatLonRect latLonRect = this.boundingBox = from.getBoundingBox() == null ? filter_bb : from.getBoundingBox().intersect(filter_bb);
            }
            this.dateRange = filter_date == null ? from.dateRange : (from.dateRange == null ? filter_date : from.dateRange.intersect(filter_date));
        }
    }

    private class QueryByStationList
    implements QueryMaker {
        private QueryByStationList() {
        }

        public String makeQuery() {
            StringBuilder query = new StringBuilder("stns=");
            for (Station s : RemoteStationCollection.this.stationHelper.getStations()) {
                query.append(s.getName());
                query.append(",");
            }
            return PointDatasetRemote.makeQuery(query.toString(), RemoteStationCollection.this.boundingBox, RemoteStationCollection.this.dateRange);
        }
    }
}

