/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.remote.QueryMaker;
import ucar.nc2.ft.point.remote.RemotePointFeatureIterator;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamRemote;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

class RemotePointCollection
extends PointCollectionImpl
implements QueryMaker {
    private NcStreamRemote ncremote;
    private QueryMaker queryMaker;

    RemotePointCollection(String name, NcStreamRemote ncremote, QueryMaker queryMaker) {
        super(name);
        this.ncremote = ncremote;
        this.queryMaker = queryMaker == null ? this : queryMaker;
    }

    public String makeQuery() {
        return PointDatasetRemote.makeQuery(null, this.boundingBox, this.dateRange);
    }

    public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
        HttpMethod method = null;
        try {
            method = this.ncremote.sendQuery(this.queryMaker.makeQuery());
            InputStream in = method.getResponseBodyAsStream();
            int len = NcStream.readVInt(in);
            byte[] b = new byte[len];
            NcStream.readFully(in, b);
            PointStreamProto.PointFeatureCollection pfc = PointStreamProto.PointFeatureCollection.parseFrom(b);
            RemotePointFeatureIterator iter = new RemotePointFeatureIterator(method, in, new PointDatasetRemote.ProtobufPointFeatureMaker(pfc));
            iter.setCalculateBounds(this);
            return iter;
        }
        catch (Throwable t) {
            if (method != null) {
                method.releaseConnection();
            }
            throw new RuntimeException(t);
        }
    }

    public PointFeatureCollection subset(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        return new PointFeatureCollectionSubset(this, boundingBox, dateRange);
    }

    private class PointFeatureCollectionSubset
    extends RemotePointCollection {
        PointCollectionImpl from;

        PointFeatureCollectionSubset(RemotePointCollection from, LatLonRect filter_bb, DateRange filter_date) throws IOException {
            super(from.name, from.ncremote, null);
            this.from = from;
            if (filter_bb == null) {
                this.boundingBox = from.getBoundingBox();
            } else {
                LatLonRect latLonRect = this.boundingBox = from.getBoundingBox() == null ? filter_bb : from.getBoundingBox().intersect(filter_bb);
            }
            this.dateRange = filter_date == null ? from.getDateRange() : (from.getDateRange() == null ? filter_date : from.getDateRange().intersect(filter_date));
        }
    }
}

