/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import thredds.filesystem.ControllerIF;
import thredds.filesystem.DateExtractorFromFilename;
import thredds.filesystem.MCollection;
import thredds.filesystem.MFile;
import thredds.filesystem.WildcardMatchOnPath;
import ucar.nc2.ft.point.collection.TimedCollection;
import ucar.nc2.units.DateFromString;
import ucar.nc2.units.DateRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionManager2
implements TimedCollection {
    private static boolean show = true;
    private List<TimedCollection.Dataset> c;
    private DateRange dateRange;

    public static CollectionManager2 factory(ControllerIF cache, String collectionDesc, Formatter errlog) {
        return new CollectionManager2(cache, collectionDesc, errlog);
    }

    private CollectionManager2(ControllerIF cache, String collectionDesc, Formatter errlog) {
        int posWildcard = collectionDesc.lastIndexOf(47);
        String dirName = collectionDesc.substring(0, posWildcard);
        File locFile = new File(dirName);
        if (!locFile.exists()) {
            errlog.format(" Directory %s does not exist %n", dirName);
            return;
        }
        String dateFormatMark = null;
        int posFormat = collectionDesc.lastIndexOf(63);
        if (posFormat > 0) {
            dateFormatMark = collectionDesc.substring(posFormat + 1);
            collectionDesc = collectionDesc.substring(0, posFormat);
        }
        String filter = null;
        if (posWildcard < collectionDesc.length() - 2) {
            filter = collectionDesc.substring(posWildcard + 1);
        }
        if (show) {
            System.out.printf("CollectionManager collectionDesc=%s filter=%s dateFormatMark=%s %n", collectionDesc, filter, dateFormatMark);
        }
        WildcardMatchOnPath mfilter = null == filter ? null : new WildcardMatchOnPath(filter);
        DateExtractorFromFilename dateExtractor = dateFormatMark == null ? null : new DateExtractorFromFilename(dateFormatMark);
        MCollection mc = new MCollection(dirName, dirName, mfilter, dateExtractor);
        ArrayList<MFile> fileList = new ArrayList<MFile>();
        Iterator<MFile> invIter = cache.getInventory(mc);
        while (invIter.hasNext()) {
            fileList.add(invIter.next());
        }
        Collections.sort(fileList);
        this.c = new ArrayList<TimedCollection.Dataset>(fileList.size());
        for (MFile f : fileList) {
            this.c.add(new Dataset(f, dateFormatMark));
        }
        if (dateFormatMark != null) {
            for (int i = 0; i < this.c.size() - 1; ++i) {
                Dataset d1 = (Dataset)this.c.get(i);
                Dataset d2 = (Dataset)this.c.get(i + 1);
                d1.setDateRange(new DateRange(d1.start, d2.start));
                if (i != this.c.size() - 2) continue;
                d2.setDateRange(new DateRange(d2.start, d1.getDateRange().getDuration()));
            }
            Dataset first = (Dataset)this.c.get(0);
            Dataset last = (Dataset)this.c.get(this.c.size() - 1);
            this.dateRange = new DateRange(first.getDateRange().getStart().getDate(), last.getDateRange().getEnd().getDate());
        }
        if (show) {
            System.out.printf("%s %n", this);
        }
    }

    CollectionManager2(CollectionManager2 from, DateRange want) {
        this.c = new ArrayList<TimedCollection.Dataset>(from.c.size());
        for (TimedCollection.Dataset d : from.c) {
            if (!want.intersects(d.getDateRange())) continue;
            this.c.add(d);
        }
    }

    @Override
    public TimedCollection.Dataset getPrototype() {
        return this.c.get(0);
    }

    @Override
    public Iterator<TimedCollection.Dataset> getIterator() {
        return this.c.iterator();
    }

    @Override
    public TimedCollection subset(DateRange range) {
        return new CollectionManager2(this, range);
    }

    @Override
    public DateRange getDateRange() {
        return this.dateRange;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("CollectionManager{%n", new Object[0]);
        for (TimedCollection.Dataset d : this.c) {
            f.format(" %s%n", d);
        }
        f.format("}%n", new Object[0]);
        return f.toString();
    }

    private class Dataset
    implements TimedCollection.Dataset {
        String location;
        DateRange dateRange;
        Date start;

        Dataset(MFile f, String dateFormatMark) {
            this.location = f.getPath();
            if (dateFormatMark != null) {
                this.start = DateFromString.getDateUsingDemarkatedCount(f.getName(), dateFormatMark, '#');
            }
        }

        public String getLocation() {
            return this.location;
        }

        public DateRange getDateRange() {
            return this.dateRange;
        }

        public void setDateRange(DateRange dateRange) {
            this.dateRange = dateRange;
        }

        public String toString() {
            return "Dataset{location='" + this.location + '\'' + ", dateRange=" + this.dateRange + '}';
        }
    }
}

