/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.nc2.ft.point.collection.TimedCollection;
import ucar.nc2.units.DateFromString;
import ucar.nc2.units.DateRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionManager
implements TimedCollection {
    private boolean show = true;
    private List<TimedCollection.Dataset> c;
    private DateRange dateRange;

    public static CollectionManager factory(String collectionDesc, Formatter errlog) {
        return new CollectionManager(collectionDesc, errlog);
    }

    private CollectionManager(String collectionDesc, Formatter errlog) {
        int posWildcard = collectionDesc.lastIndexOf(47);
        String dirName = collectionDesc.substring(0, posWildcard);
        File dir = new File(dirName);
        File locFile = new File(dirName);
        if (!locFile.exists()) {
            errlog.format(" Directory %s does not exist %n", dirName);
            return;
        }
        String dateFormatMark = null;
        int posFormat = collectionDesc.lastIndexOf(63);
        if (posFormat > 0) {
            dateFormatMark = collectionDesc.substring(posFormat + 1);
            collectionDesc = collectionDesc.substring(0, posFormat);
        }
        String filter = null;
        if (posWildcard < collectionDesc.length() - 2) {
            filter = collectionDesc.substring(posWildcard + 1);
        }
        if (this.show) {
            System.out.printf("CollectionManager collectionDesc=%s filter=%s dateFormatMark=%s %n", collectionDesc, filter, dateFormatMark);
        }
        File[] files = filter == null ? dir.listFiles() : dir.listFiles(new WildcardMatchOnNameFilter(filter));
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList);
        this.c = new ArrayList<TimedCollection.Dataset>(fileList.size());
        for (File f : fileList) {
            this.c.add(new Dataset(f, dateFormatMark));
        }
        if (dateFormatMark != null) {
            for (int i = 0; i < this.c.size() - 1; ++i) {
                Dataset d1 = (Dataset)this.c.get(i);
                Dataset d2 = (Dataset)this.c.get(i + 1);
                d1.setDateRange(new DateRange(d1.start, d2.start));
                if (i != this.c.size() - 2) continue;
                d2.setDateRange(new DateRange(d2.start, d1.getDateRange().getDuration()));
            }
            Dataset first = (Dataset)this.c.get(0);
            Dataset last = (Dataset)this.c.get(this.c.size() - 1);
            this.dateRange = new DateRange(first.getDateRange().getStart().getDate(), last.getDateRange().getEnd().getDate());
        }
        if (this.show) {
            System.out.printf("%s %n", this);
        }
    }

    CollectionManager(CollectionManager from, DateRange want) {
        this.c = new ArrayList<TimedCollection.Dataset>(from.c.size());
        for (TimedCollection.Dataset d : from.c) {
            if (!want.intersects(d.getDateRange())) continue;
            this.c.add(d);
        }
    }

    @Override
    public TimedCollection.Dataset getPrototype() {
        return this.c.get(0);
    }

    @Override
    public Iterator<TimedCollection.Dataset> getIterator() {
        return this.c.iterator();
    }

    @Override
    public TimedCollection subset(DateRange range) {
        return new CollectionManager(this, range);
    }

    @Override
    public DateRange getDateRange() {
        return this.dateRange;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("CollectionManager{%n", new Object[0]);
        for (TimedCollection.Dataset d : this.c) {
            f.format(" %s%n", d);
        }
        f.format("}%n", new Object[0]);
        return f.toString();
    }

    private class WildcardMatchOnNameFilter
    implements FilenameFilter {
        protected Pattern pattern;

        public WildcardMatchOnNameFilter(String wildcardString) {
            String regExp = this.mapWildcardToRegExp(wildcardString);
            this.pattern = Pattern.compile(regExp);
        }

        private String mapWildcardToRegExp(String wildcardString) {
            wildcardString = wildcardString.replaceAll("\\.", "\\\\.");
            wildcardString = wildcardString.replaceAll("\\*", ".*");
            wildcardString = wildcardString.replaceAll("\\?", ".?");
            return wildcardString;
        }

        public boolean accept(File dir, String name) {
            Matcher matcher = this.pattern.matcher(name);
            return matcher.matches();
        }
    }

    private class Dataset
    implements TimedCollection.Dataset {
        String location;
        DateRange dateRange;
        Date start;

        Dataset(File f, String dateFormatMark) {
            this.location = f.getPath();
            if (dateFormatMark != null) {
                this.start = DateFromString.getDateUsingDemarkatedCount(f.getName(), dateFormatMark, '#');
            }
        }

        public String getLocation() {
            return this.location;
        }

        public DateRange getDateRange() {
            return this.dateRange;
        }

        public void setDateRange(DateRange dateRange) {
            this.dateRange = dateRange;
        }

        public String toString() {
            return "Dataset{location='" + this.location + '\'' + ", dateRange=" + this.dateRange + '}';
        }
    }
}

