/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.conv.COARDSConvention;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;

public class Nimbus
extends COARDSConvention {
    public static boolean isMine(NetcdfFile ncfile) {
        String s = ncfile.findAttValueIgnoreCase(null, "Convention", "none");
        return s.equalsIgnoreCase("NCAR-RAF/nimbus");
    }

    public Nimbus() {
        this.conventionName = "NCAR-RAF/nimbus";
    }

    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        String coordinates;
        Variable time;
        ds.addAttribute(null, new Attribute("cdm_data_type", FeatureType.TRAJECTORY.name()));
        this.setAxisType(ds, "LATC", AxisType.Lat);
        this.setAxisType(ds, "LONC", AxisType.Lon);
        this.setAxisType(ds, "PALT", AxisType.Height);
        boolean hasTime = this.setAxisType(ds, "Time", AxisType.Time);
        if (!hasTime) {
            hasTime = this.setAxisType(ds, "time", AxisType.Time);
        }
        if (!hasTime && (time = ds.findVariable("time_offset")) != null && time.getUnitsString() == null) {
            Variable base = ds.findVariable("base_time");
            int base_time = base.readScalarInt();
            try {
                DateUnit dunit = new DateUnit("seconds since 1970-01-01 00:00");
                String time_units = "seconds since " + dunit.makeStandardDateString(base_time);
                time.addAttribute(new Attribute("units", time_units));
                time.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.name()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((coordinates = ds.findAttValueIgnoreCase(null, "coordinates", null)) != null) {
            String[] vars;
            for (String vname : vars = coordinates.split(" ")) {
                AxisType atype;
                Variable v = ds.findVariable(vname);
                if (v == null || (atype = this.getAxisType(ds, (VariableEnhanced)((Object)v))) == null) continue;
                v.addAttribute(new Attribute("_CoordinateAxisType", atype.name()));
            }
        }
    }

    private boolean setAxisType(NetcdfDataset ds, String varName, AxisType atype) {
        Variable v = ds.findVariable(varName);
        if (v == null) {
            return false;
        }
        v.addAttribute(new Attribute("_CoordinateAxisType", atype.toString()));
        return true;
    }
}

