/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NCdumpW;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.iosp.netcdf3.SPFactory;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.IO;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheable;
import ucar.unidata.io.InMemoryRandomAccessFile;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.UncompressInputStream;
import ucar.unidata.io.bzip2.CBZip2InputStream;
import ucar.unidata.io.http.HTTPRandomAccessFile;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfFile
implements FileCacheable {
    public static final String IOSP_MESSAGE_ADD_RECORD_STRUCTURE = "AddRecordStructure";
    public static final String IOSP_MESSAGE_REMOVE_RECORD_STRUCTURE = "RemoveRecordStructure";
    private static Logger log;
    private static int default_buffersize;
    private static ArrayList<IOServiceProvider> registeredProviders;
    protected static boolean debugSPI;
    protected static boolean debugCompress;
    protected static boolean showRequest;
    static boolean debugStructureIterator;
    static boolean loadWarnings;
    private static boolean userLoads;
    public static final String reserved = " .!*'();:@&=+$,/?%#[]";
    protected String location;
    protected String id;
    protected String title;
    protected String cacheName;
    protected Group rootGroup = this.makeRootGroup();
    protected boolean unlocked = false;
    private boolean immutable = false;
    protected FileCache cache;
    protected IOServiceProvider spi;
    protected List<Variable> variables;
    protected List<Dimension> dimensions;
    protected List<Attribute> gattributes;

    public static String escapeName(String vname) {
        return StringUtil.escape2(vname, reserved);
    }

    public static String unescapeName(String vname) {
        return StringUtil.unescape(vname);
    }

    public static void registerIOProvider(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> ioClass = NetcdfFile.class.getClassLoader().loadClass(className);
        NetcdfFile.registerIOProvider(ioClass);
    }

    public static void registerIOProvider(Class iospClass) throws IllegalAccessException, InstantiationException {
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (userLoads) {
            registeredProviders.add(0, spi);
        } else {
            registeredProviders.add(spi);
        }
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugSPI = debugFlag.isSet("NetcdfFile/debugSPI");
        debugCompress = debugFlag.isSet("NetcdfFile/debugCompress");
        debugStructureIterator = debugFlag.isSet("NetcdfFile/structureIterator");
        N3header.disallowFileTruncation = debugFlag.isSet("NetcdfFile/disallowFileTruncation");
        N3header.debugHeaderSize = debugFlag.isSet("NetcdfFile/debugHeaderSize");
        showRequest = debugFlag.isSet("NetcdfFile/showRequest");
    }

    public static void setProperty(String name, String value) {
        N3iosp.setProperty(name, value);
    }

    public static NetcdfFile open(String location) throws IOException {
        return NetcdfFile.open(location, null);
    }

    public static NetcdfFile open(String location, CancelTask cancelTask) throws IOException {
        return NetcdfFile.open(location, -1, cancelTask);
    }

    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask) throws IOException {
        return NetcdfFile.open(location, buffer_size, cancelTask, null);
    }

    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        RandomAccessFile raf = NetcdfFile.getRaf(location, buffer_size);
        try {
            return NetcdfFile.open(raf, location, cancelTask, iospMessage);
        }
        catch (IOException ioe) {
            raf.close();
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canOpen(String location) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = NetcdfFile.getRaf(location, -1);
            boolean bl = raf != null ? NetcdfFile.canOpen(raf) : false;
            return bl;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    private static boolean canOpen(RandomAccessFile raf) throws IOException {
        if (N3header.isValidFile(raf)) {
            return true;
        }
        for (IOServiceProvider registeredSpi : registeredProviders) {
            if (!registeredSpi.isValidFile(raf)) continue;
            return true;
        }
        return false;
    }

    public static NetcdfFile open(String location, String iospClassName, int bufferSize, CancelTask cancelTask, Object iospMessage) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        String uriString;
        Class<?> iospClass = NetcdfFile.class.getClassLoader().loadClass(iospClassName);
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if ((uriString = location.trim()).startsWith("file://")) {
            uriString = uriString.substring(7);
        } else if (uriString.startsWith("file:")) {
            uriString = uriString.substring(5);
        }
        uriString = StringUtil.replace(uriString, '\\', "/");
        if (bufferSize <= 0) {
            bufferSize = default_buffersize;
        }
        RandomAccessFile raf = new RandomAccessFile(uriString, "r", bufferSize);
        NetcdfFile result = new NetcdfFile(spi, raf, location, cancelTask);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return result;
    }

    private static RandomAccessFile getRaf(String location, int buffer_size) throws IOException {
        RandomAccessFile raf;
        String uriString = location.trim();
        if (buffer_size <= 0) {
            buffer_size = default_buffersize;
        }
        if (uriString.startsWith("http:")) {
            raf = new HTTPRandomAccessFile(uriString);
        } else if (uriString.startsWith("nodods:")) {
            uriString = "http" + uriString.substring(6);
            raf = new HTTPRandomAccessFile(uriString);
        } else if (uriString.startsWith("slurp:")) {
            uriString = "http" + uriString.substring(5);
            byte[] contents = IO.readURLContentsToByteArray(uriString);
            raf = new InMemoryRandomAccessFile(uriString, contents);
        } else {
            if ((uriString = StringUtil.replace(uriString, '\\', "/")).startsWith("file:")) {
                uriString = uriString.substring(5);
            }
            String uncompressedFileName = null;
            try {
                uncompressedFileName = NetcdfFile.makeUncompressed(uriString);
            }
            catch (Exception e) {
                log.warn("Failed to uncompress " + uriString + " err= " + e.getMessage() + "; try as a regular file.");
            }
            raf = uncompressedFileName != null ? new RandomAccessFile(uncompressedFileName, "r", buffer_size) : new RandomAccessFile(uriString, "r", buffer_size);
        }
        return raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeUncompressed(String filename) throws Exception {
        int pos = filename.lastIndexOf(".");
        if (pos < 0) {
            return null;
        }
        String suffix = filename.substring(pos + 1);
        String uncompressedFilename = filename.substring(0, pos);
        if (!(suffix.equalsIgnoreCase("Z") || suffix.equalsIgnoreCase("zip") || suffix.equalsIgnoreCase("gzip") || suffix.equalsIgnoreCase("gz") || suffix.equalsIgnoreCase("bz2"))) {
            return null;
        }
        File uncompressedFile = DiskCache.getFileStandardPolicy(uncompressedFilename);
        if (uncompressedFile.exists() && uncompressedFile.length() > 0L) {
            FileInputStream stream = null;
            FileLock lock = null;
            try {
                stream = new FileInputStream(uncompressedFile);
                while (true) {
                    try {
                        lock = stream.getChannel().lock(0L, 1L, true);
                    }
                    catch (OverlappingFileLockException oe) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e1) {
                            break;
                        }
                    }
                }
                if (debugCompress) {
                    System.out.println("found uncompressed " + uncompressedFile + " for " + filename);
                }
                String oe = uncompressedFile.getPath();
                return oe;
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
                if (stream != null) {
                    stream.close();
                }
            }
        }
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        InputStream in = null;
        FileOutputStream fout = new FileOutputStream(uncompressedFile);
        FileLock lock = null;
        while (true) {
            try {
                lock = fout.getChannel().lock(0L, 1L, false);
            }
            catch (OverlappingFileLockException oe) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {}
                continue;
            }
            break;
        }
        try {
            if (suffix.equalsIgnoreCase("Z")) {
                in = new UncompressInputStream(new FileInputStream(filename));
                NetcdfFile.copy(in, fout, 100000);
                if (debugCompress) {
                    System.out.println("uncompressed " + filename + " to " + uncompressedFile);
                }
            } else if (suffix.equalsIgnoreCase("zip")) {
                in = new ZipInputStream(new FileInputStream(filename));
                NetcdfFile.copy(in, fout, 100000);
                if (debugCompress) {
                    System.out.println("unzipped " + filename + " to " + uncompressedFile);
                }
            } else if (suffix.equalsIgnoreCase("bz2")) {
                in = new CBZip2InputStream(new FileInputStream(filename), true);
                NetcdfFile.copy(in, fout, 100000);
                if (debugCompress) {
                    System.out.println("unbzipped " + filename + " to " + uncompressedFile);
                }
            } else if (suffix.equalsIgnoreCase("gzip") || suffix.equalsIgnoreCase("gz")) {
                in = new GZIPInputStream(new FileInputStream(filename));
                NetcdfFile.copy(in, fout, 100000);
                if (debugCompress) {
                    System.out.println("ungzipped " + filename + " to " + uncompressedFile);
                }
            }
        }
        catch (Exception e) {
            if (fout != null) {
                fout.close();
            }
            fout = null;
            if (uncompressedFile.exists() && !uncompressedFile.delete()) {
                log.warn("failed to delete uncompressed file (IOException)" + uncompressedFile);
            }
            throw e;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
        return uncompressedFile.getPath();
    }

    private static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static NetcdfFile openInMemory(String name, byte[] data) throws IOException {
        InMemoryRandomAccessFile raf = new InMemoryRandomAccessFile(name, data);
        return NetcdfFile.open(raf, name, null, null);
    }

    public static NetcdfFile openInMemory(String filename) throws IOException {
        File file = new File(filename);
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
        IO.copy(in, bos);
        return NetcdfFile.openInMemory(filename, bos.toByteArray());
    }

    public static NetcdfFile openInMemory(URI uri) throws IOException {
        URL url = uri.toURL();
        byte[] contents = IO.readContentsToByteArray(url.openStream());
        return NetcdfFile.openInMemory(uri.toString(), contents);
    }

    private static NetcdfFile open(RandomAccessFile raf, String location, CancelTask cancelTask, Object iospMessage) throws IOException {
        IOServiceProvider spi = null;
        if (debugSPI) {
            System.out.println("NetcdfFile try to open = " + location);
        }
        if (N3header.isValidFile(raf)) {
            spi = SPFactory.getServiceProvider();
        } else {
            for (IOServiceProvider registeredSpi : registeredProviders) {
                if (debugSPI) {
                    System.out.println(" try iosp = " + registeredSpi.getClass().getName());
                }
                if (!registeredSpi.isValidFile(raf)) continue;
                Class<?> c = registeredSpi.getClass();
                try {
                    spi = (IOServiceProvider)c.newInstance();
                    break;
                }
                catch (InstantiationException e) {
                    throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
                }
                catch (IllegalAccessException e) {
                    throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
                }
            }
        }
        if (spi == null) {
            raf.close();
            throw new IOException("Cant read " + location + ": not a valid NetCDF file.");
        }
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if (log.isDebugEnabled()) {
            log.debug("Using IOSP " + spi.getClass().getName());
        }
        NetcdfFile result = new NetcdfFile(spi, raf, location, cancelTask);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return result;
    }

    public synchronized boolean isUnlocked() {
        return this.unlocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.cache != null) {
            this.unlocked = true;
            this.cache.release(this);
        } else {
            try {
                if (null != this.spi) {
                    this.spi.close();
                }
            }
            finally {
                this.spi = null;
            }
        }
    }

    @Override
    public void setFileCache(FileCache cache) {
        this.cache = cache;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    protected void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Group getRootGroup() {
        return this.rootGroup;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public Variable findTopVariable(String name) {
        if (name == null) {
            return null;
        }
        for (Variable v : this.variables) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    public Group findGroup(String fullNameEscaped) {
        String[] groupNames;
        if (fullNameEscaped == null || fullNameEscaped.length() == 0) {
            return this.rootGroup;
        }
        Group g = this.rootGroup;
        for (String groupName : groupNames = fullNameEscaped.split("/")) {
            if ((g = g.findGroup(groupName)) != null) continue;
            return null;
        }
        return g;
    }

    public Variable findVariable(String fullNameEscaped) {
        StringTokenizer stoke;
        if (fullNameEscaped == null || fullNameEscaped.length() == 0) {
            return null;
        }
        Group g = this.rootGroup;
        String vars = fullNameEscaped;
        int pos = fullNameEscaped.lastIndexOf("/");
        if (pos >= 0) {
            String groups = fullNameEscaped.substring(0, pos);
            vars = fullNameEscaped.substring(pos + 1);
            StringTokenizer stoke2 = new StringTokenizer(groups, "/");
            while (stoke2.hasMoreTokens()) {
                String token = stoke2.nextToken();
                if ((g = g.findGroup(token)) != null) continue;
                return null;
            }
        }
        if (!(stoke = new StringTokenizer(vars, ".")).hasMoreTokens()) {
            return null;
        }
        String varShortName = NetcdfFile.unescapeName(stoke.nextToken());
        Variable v = g.findVariable(varShortName);
        if (v == null) {
            return null;
        }
        while (stoke.hasMoreTokens()) {
            if (!(v instanceof Structure)) {
                return null;
            }
            String name = NetcdfFile.unescapeName(stoke.nextToken());
            if ((v = ((Structure)v).findVariable(name)) != null) continue;
            return null;
        }
        return v;
    }

    public List<Dimension> getDimensions() {
        return this.immutable ? this.dimensions : new ArrayList<Dimension>(this.dimensions);
    }

    public Dimension findDimension(String name) {
        for (Dimension d : this.dimensions) {
            if (!name.equals(d.getName())) continue;
            return d;
        }
        return null;
    }

    public boolean hasUnlimitedDimension() {
        return this.getUnlimitedDimension() != null;
    }

    public Dimension getUnlimitedDimension() {
        for (Dimension d : this.dimensions) {
            if (!d.isUnlimited()) continue;
            return d;
        }
        return null;
    }

    public List<Attribute> getGlobalAttributes() {
        return this.immutable ? this.gattributes : new ArrayList<Attribute>(this.gattributes);
    }

    public Attribute findGlobalAttribute(String name) {
        for (Attribute a : this.gattributes) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findGlobalAttributeIgnoreCase(String name) {
        for (Attribute a : this.gattributes) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a;
        }
        return null;
    }

    public String findAttValueIgnoreCase(Variable v, String attName, String defaultValue) {
        String attValue = null;
        Attribute att = v == null ? this.rootGroup.findAttributeIgnoreCase(attName) : v.findAttributeIgnoreCase(attName);
        if (att != null && att.isString()) {
            attValue = att.getStringValue();
        }
        if (null == attValue) {
            attValue = defaultValue;
        }
        return attValue;
    }

    public double readAttributeDouble(Variable v, String attName, double defValue) {
        Attribute att = v == null ? this.rootGroup.findAttributeIgnoreCase(attName) : v.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defValue;
        }
        if (att.isString()) {
            return Double.parseDouble(att.getStringValue());
        }
        return att.getNumericValue().doubleValue();
    }

    public int readAttributeInteger(Variable v, String attName, int defValue) {
        Attribute att = v == null ? this.rootGroup.findAttributeIgnoreCase(attName) : v.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defValue;
        }
        if (att.isString()) {
            return Integer.parseInt(att.getStringValue());
        }
        return att.getNumericValue().intValue();
    }

    public void writeCDL(OutputStream out, boolean strict) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
        this.toStringStart(pw, strict);
        this.toStringEnd(pw);
        pw.flush();
    }

    public void writeCDL(PrintWriter pw, boolean strict) {
        this.toStringStart(pw, strict);
        this.toStringEnd(pw);
        pw.flush();
    }

    public String toString() {
        StringWriter writer = new StringWriter(50000);
        this.writeCDL(new PrintWriter(writer), false);
        return writer.toString();
    }

    protected void toStringStart(PrintWriter pw, boolean strict) {
        String name = this.getLocation();
        if (strict) {
            int pos = name.lastIndexOf(47);
            if (pos < 0) {
                pos = name.lastIndexOf(92);
            }
            if (pos >= 0) {
                name = name.substring(pos + 1);
            }
            if (name.endsWith(".nc")) {
                name = name.substring(0, name.length() - 3);
            }
            if (name.endsWith(".cdl")) {
                name = name.substring(0, name.length() - 4);
            }
        }
        pw.print("netcdf " + name + " {\n");
        this.rootGroup.writeCDL(pw, "", strict);
    }

    protected void toStringEnd(PrintWriter pw) {
        pw.print("}\n");
    }

    public void writeNcML(OutputStream os, String uri) throws IOException {
        NCdumpW.writeNcML(this, (Writer)new OutputStreamWriter(os), false, uri);
    }

    public void writeNcML(Writer writer, String uri) throws IOException {
        NCdumpW.writeNcML(this, writer, false, uri);
    }

    public boolean syncExtend() throws IOException {
        this.unlocked = false;
        return this.spi != null && this.spi.syncExtend();
    }

    @Override
    public boolean sync() throws IOException {
        this.unlocked = false;
        return this.spi != null && this.spi.sync();
    }

    public NetcdfFile(String filename) throws IOException {
        this.location = filename;
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        this.spi = SPFactory.getServiceProvider();
        this.spi.open(raf, this, null);
        this.finish();
    }

    public NetcdfFile(URL url) throws IOException {
        this.location = url.toString();
        HTTPRandomAccessFile raf = new HTTPRandomAccessFile(this.location);
        this.spi = SPFactory.getServiceProvider();
        this.spi.open(raf, this, null);
        this.finish();
    }

    protected NetcdfFile(String iospClassName, String iospParam, String location, int buffer_size, CancelTask cancelTask) throws IOException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> iospClass = this.getClass().getClassLoader().loadClass(iospClassName);
        this.spi = (IOServiceProvider)iospClass.newInstance();
        if (debugSPI) {
            System.out.println("NetcdfFile uses iosp = " + this.spi.getClass().getName());
        }
        this.spi.sendIospMessage(iospParam);
        this.location = location;
        RandomAccessFile raf = NetcdfFile.getRaf(location, buffer_size);
        try {
            this.spi.open(raf, this, cancelTask);
            this.finish();
        }
        catch (IOException e) {
            try {
                this.spi.close();
            }
            catch (Throwable t1) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            this.spi = null;
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.spi.close();
            }
            catch (Throwable t1) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            this.spi = null;
            throw e;
        }
        catch (Throwable t) {
            try {
                this.spi.close();
            }
            catch (Throwable t1) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            this.spi = null;
            throw new RuntimeException(t);
        }
        if (this.id == null) {
            this.setId(this.findAttValueIgnoreCase(null, "_Id", null));
        }
        if (this.title == null) {
            this.setId(this.findAttValueIgnoreCase(null, "_Title", null));
        }
    }

    protected NetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
        this.spi = spi;
        this.location = location;
        if (debugSPI) {
            System.out.println("NetcdfFile uses iosp = " + spi.getClass().getName());
        }
        try {
            spi.open(raf, this, cancelTask);
        }
        catch (IOException e) {
            try {
                spi.close();
            }
            catch (Throwable t1) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            this.spi = null;
            throw e;
        }
        catch (RuntimeException e) {
            try {
                spi.close();
            }
            catch (Throwable t1) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            this.spi = null;
            throw e;
        }
        catch (Throwable t) {
            try {
                spi.close();
            }
            catch (Throwable t1) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            this.spi = null;
            throw new RuntimeException(t);
        }
        if (this.id == null) {
            this.setId(this.findAttValueIgnoreCase(null, "_Id", null));
        }
        if (this.title == null) {
            this.setId(this.findAttValueIgnoreCase(null, "_Title", null));
        }
        this.finish();
    }

    protected NetcdfFile() {
    }

    protected NetcdfFile(NetcdfFile ncfile) {
        this.location = ncfile.getLocation();
        this.id = ncfile.getId();
        this.title = ncfile.getTitle();
        this.spi = ncfile.spi;
    }

    public Attribute addAttribute(Group parent, Attribute att) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        parent.addAttribute(att);
        return att;
    }

    public Group addGroup(Group parent, Group g) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        parent.addGroup(g);
        return g;
    }

    public Dimension addDimension(Group parent, Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        parent.addDimension(d);
        return d;
    }

    public boolean removeDimension(Group g, String dimName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        return g.removeDimension(dimName);
    }

    public Variable addVariable(Group g, Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        if (v != null) {
            g.addVariable(v);
        }
        return v;
    }

    public Variable addVariable(Group g, String shortName, DataType dtype, String dims) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        Variable v = new Variable(this, g, null, shortName);
        v.setDataType(dtype);
        v.setDimensions(dims);
        g.addVariable(v);
        return v;
    }

    public Variable addStringVariable(Group g, String shortName, String dims, int strlen) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        String dimName = shortName + "_strlen";
        this.addDimension(g, new Dimension(dimName, strlen));
        Variable v = new Variable(this, g, null, shortName);
        v.setDataType(DataType.CHAR);
        v.setDimensions(dims + " " + dimName);
        g.addVariable(v);
        return v;
    }

    public boolean removeVariable(Group g, String varName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g == null) {
            g = this.rootGroup;
        }
        return g.removeVariable(varName);
    }

    public Attribute addVariableAttribute(Variable v, Attribute att) {
        return v.addAttribute(att);
    }

    public Object sendIospMessage(Object message) {
        if (null == message) {
            return null;
        }
        if (message == IOSP_MESSAGE_ADD_RECORD_STRUCTURE) {
            Variable v = this.rootGroup.findVariable("record");
            boolean gotit = v != null && v instanceof Structure;
            return gotit || this.makeRecordStructure() != false;
        }
        if (message == IOSP_MESSAGE_REMOVE_RECORD_STRUCTURE) {
            boolean gotit;
            Variable v = this.rootGroup.findVariable("record");
            boolean bl = gotit = v != null && v instanceof Structure;
            if (gotit) {
                this.rootGroup.remove(v);
                this.variables.remove(v);
                this.removeRecordStructure();
            }
            return gotit;
        }
        if (this.spi != null) {
            return this.spi.sendIospMessage(message);
        }
        return null;
    }

    protected Boolean makeRecordStructure() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Boolean didit = false;
        if (this.spi != null && this.spi instanceof N3iosp && this.hasUnlimitedDimension()) {
            didit = (Boolean)this.spi.sendIospMessage(IOSP_MESSAGE_ADD_RECORD_STRUCTURE);
        }
        return didit;
    }

    protected Boolean removeRecordStructure() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Boolean didit = false;
        if (this.spi != null && this.spi instanceof N3iosp) {
            didit = (Boolean)this.spi.sendIospMessage(IOSP_MESSAGE_REMOVE_RECORD_STRUCTURE);
        }
        return didit;
    }

    public void setId(String id) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.id = id;
    }

    public void setTitle(String title) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.title = title;
    }

    public void setLocation(String location) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.location = location;
    }

    public NetcdfFile setImmutable() {
        if (this.immutable) {
            return this;
        }
        this.immutable = true;
        this.setImmutable(this.rootGroup);
        this.variables = Collections.unmodifiableList(this.variables);
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.gattributes = Collections.unmodifiableList(this.gattributes);
        return this;
    }

    private void setImmutable(Group g) {
        for (Variable v : g.variables) {
            v.setImmutable();
        }
        for (Dimension d : g.dimensions) {
            d.setImmutable();
        }
        for (Group nested : g.getGroups()) {
            this.setImmutable(nested);
        }
        g.setImmutable();
    }

    public void empty() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.variables = new ArrayList<Variable>();
        this.gattributes = new ArrayList<Attribute>();
        this.dimensions = new ArrayList<Dimension>();
        this.rootGroup = this.makeRootGroup();
    }

    protected Group makeRootGroup() {
        Group root = new Group(this, null, "");
        root.parent = null;
        return root;
    }

    public void finish() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.variables = new ArrayList<Variable>();
        this.dimensions = new ArrayList<Dimension>();
        this.gattributes = new ArrayList<Attribute>();
        this.finishGroup(this.rootGroup);
    }

    private void finishGroup(Group g) {
        String newName;
        this.variables.addAll(g.variables);
        for (Attribute oldAtt : g.attributes) {
            if (g == this.rootGroup) {
                this.gattributes.add(oldAtt);
                continue;
            }
            newName = this.makeFullNameWithString(g, oldAtt.getName());
            this.gattributes.add(new Attribute(newName, oldAtt));
        }
        for (Dimension oldDim : g.dimensions) {
            if (!oldDim.isShared()) continue;
            if (g == this.rootGroup) {
                this.dimensions.add(oldDim);
                continue;
            }
            newName = this.makeFullNameWithString(g, oldDim.getName());
            this.dimensions.add(new Dimension(newName, oldDim));
        }
        List<Group> groups = g.getGroups();
        for (Group nested : groups) {
            this.finishGroup(nested);
        }
    }

    protected String makeFullNameWithString(Group parent, String name) {
        StringBuilder sbuff = new StringBuilder();
        NetcdfFile.appendGroupName(sbuff, parent);
        sbuff.append(name);
        return sbuff.toString();
    }

    protected static String makeFullName(Group parent, Variable v) {
        if ((parent == null || parent.isRoot()) && !v.isMemberOfStructure()) {
            return v.getShortName();
        }
        StringBuilder sbuff = new StringBuilder();
        NetcdfFile.appendGroupName(sbuff, parent);
        NetcdfFile.appendStructureName(sbuff, v);
        return sbuff.toString();
    }

    private static void appendGroupName(StringBuilder sbuff, Group g) {
        boolean isRoot;
        boolean bl = isRoot = g.getParentGroup() == null;
        if (isRoot) {
            return;
        }
        if (g.getParentGroup() != null) {
            NetcdfFile.appendGroupName(sbuff, g.getParentGroup());
        }
        sbuff.append(g.getShortName());
        sbuff.append("/");
    }

    private static void appendStructureName(StringBuilder sbuff, Variable v) {
        if (v.isMemberOfStructure()) {
            NetcdfFile.appendStructureName(sbuff, v.getParentStructure());
            sbuff.append(".");
        }
        sbuff.append(v.getShortName());
    }

    protected static String makeFullNameEscaped(Group parent, Variable v) {
        StringBuilder sbuff = new StringBuilder();
        NetcdfFile.appendGroupNameEscaped(sbuff, parent);
        NetcdfFile.appendStructureNameEscaped(sbuff, v);
        return sbuff.toString();
    }

    private static void appendGroupNameEscaped(StringBuilder sbuff, Group g) {
        boolean isRoot;
        boolean bl = isRoot = g.getParentGroup() == null;
        if (isRoot) {
            return;
        }
        if (g.getParentGroup() != null) {
            NetcdfFile.appendGroupNameEscaped(sbuff, g.getParentGroup());
        }
        sbuff.append(NetcdfFile.escapeName(g.getShortName()));
        sbuff.append("/");
    }

    private static void appendStructureNameEscaped(StringBuilder sbuff, Variable v) {
        if (v.isMemberOfStructure()) {
            NetcdfFile.appendStructureNameEscaped(sbuff, v.getParentStructure());
            sbuff.append(".");
        }
        sbuff.append(NetcdfFile.escapeName(v.getShortName()));
    }

    protected Array readData(Variable v, Section ranges) throws IOException, InvalidRangeException {
        if (showRequest) {
            System.out.println("Data request for variable: " + v.getName() + " section= " + ranges);
        }
        if (this.unlocked) {
            String info = this.cache.getInfo(this);
            throw new IllegalStateException("File is unlocked - cannot use\n" + info);
        }
        Array result = this.spi.readData(v, ranges);
        result.setUnsigned(v.isUnsigned());
        return result;
    }

    protected long readToByteChannel(Variable v, Section section, WritableByteChannel wbc) throws IOException, InvalidRangeException {
        if (this.unlocked) {
            throw new IllegalStateException("File is unlocked - cannot use");
        }
        if (this.spi == null) {
            return AbstractIOServiceProvider.copyToByteChannel(v.read(section), wbc);
        }
        return this.spi.readToByteChannel(v, section, wbc);
    }

    public List<Array> readArrays(List<Variable> variables) throws IOException {
        ArrayList<Array> result = new ArrayList<Array>();
        for (Variable variable : variables) {
            result.add(variable.read());
        }
        return result;
    }

    public Array read(String variableSection, boolean flatten) throws IOException, InvalidRangeException {
        if (!flatten) {
            throw new UnsupportedOperationException("NetdfFile.read(String variableSection, boolean flatten=false)");
        }
        return this.readSection(variableSection);
    }

    public Array readSection(String variableSection) throws IOException, InvalidRangeException {
        if (this.unlocked) {
            throw new IllegalStateException("File is unlocked - cannot use");
        }
        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection(this, variableSection);
        if (cer.child == null) {
            Array result = cer.v.read(cer.section);
            result.setUnsigned(cer.v.isUnsigned());
            return result;
        }
        if (this.spi == null) {
            return IospHelper.readSection(cer);
        }
        return this.spi.readSection(cer);
    }

    protected String toStringDebug(Object o) {
        return this.spi == null ? "" : this.spi.toStringDebug(o);
    }

    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("NetcdfFile location= %s%n", this.getLocation());
        f.format("  title= %s%n", this.getTitle());
        f.format("  id= %s%n", this.getId());
        f.format("  fileType= %s%n", this.getFileTypeId());
        f.format("  fileDesc= %s%n", this.getFileTypeDescription());
        f.format("  class= %s%n", this.getClass().getName());
        if (this.spi == null) {
            f.format("  has no IOSP%n", new Object[0]);
        } else {
            f.format("  iosp= %s%n%n", this.spi.getClass());
            f.format(this.spi.getDetailInfo(), new Object[0]);
        }
        return f.toString();
    }

    public IOServiceProvider getIosp() {
        return this.spi;
    }

    public String getFileTypeId() {
        if (this.spi != null) {
            return this.spi.getFileTypeId();
        }
        return "N/A";
    }

    public String getFileTypeDescription() {
        if (this.spi != null) {
            return this.spi.getFileTypeDescription();
        }
        return "N/A";
    }

    public String getFileTypeVersion() {
        if (this.spi != null) {
            return this.spi.getFileTypeVersion();
        }
        return "N/A";
    }

    public static void main(String[] arg) throws Exception {
        try {
            String filename = "R:/testdata/hdf5/npoess/ExampleFiles/AVAFO_NPP_d2003125_t10109_e101038_b9_c2005829155458_devl_Tst.h5";
            NetcdfFile ncfile = NetcdfFile.open(filename);
            ncfile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        block66: {
            block65: {
                block64: {
                    block63: {
                        block62: {
                            block61: {
                                block60: {
                                    block59: {
                                        block58: {
                                            block57: {
                                                block56: {
                                                    block55: {
                                                        block54: {
                                                            block53: {
                                                                block52: {
                                                                    block51: {
                                                                        block50: {
                                                                            block49: {
                                                                                block48: {
                                                                                    block47: {
                                                                                        block46: {
                                                                                            block45: {
                                                                                                log = LoggerFactory.getLogger(NetcdfFile.class);
                                                                                                default_buffersize = 8092;
                                                                                                registeredProviders = new ArrayList();
                                                                                                debugSPI = false;
                                                                                                debugCompress = false;
                                                                                                showRequest = false;
                                                                                                debugStructureIterator = false;
                                                                                                loadWarnings = false;
                                                                                                userLoads = false;
                                                                                                try {
                                                                                                    NetcdfFile.registerIOProvider("ucar.nc2.stream.NcStreamIosp");
                                                                                                }
                                                                                                catch (Throwable e) {
                                                                                                    if (!loadWarnings) break block45;
                                                                                                    log.info("Cant load class: " + e);
                                                                                                }
                                                                                            }
                                                                                            try {
                                                                                                NetcdfFile.registerIOProvider("ucar.nc2.iosp.hdf5.H5iosp");
                                                                                            }
                                                                                            catch (Throwable e) {
                                                                                                if (!loadWarnings) break block46;
                                                                                                log.info("Cant load class: " + e);
                                                                                            }
                                                                                        }
                                                                                        try {
                                                                                            NetcdfFile.registerIOProvider("ucar.nc2.iosp.hdf4.H4iosp");
                                                                                        }
                                                                                        catch (Throwable e) {
                                                                                            if (!loadWarnings) break block47;
                                                                                            log.info("Cant load class: " + e);
                                                                                        }
                                                                                    }
                                                                                    try {
                                                                                        NetcdfFile.class.getClassLoader().loadClass("ucar.grib.grib2.Grib2Input");
                                                                                        NetcdfFile.registerIOProvider("ucar.nc2.iosp.grib.GribGridServiceProvider");
                                                                                    }
                                                                                    catch (Throwable e) {
                                                                                        if (!loadWarnings) break block48;
                                                                                        log.info("Cant load class: " + e);
                                                                                    }
                                                                                }
                                                                                try {
                                                                                    NetcdfFile.class.getClassLoader().loadClass("ucar.grib.grib2.Grib2Input");
                                                                                    NetcdfFile.registerIOProvider("ucar.nc2.iosp.gempak.GempakGridServiceProvider");
                                                                                }
                                                                                catch (Throwable e) {
                                                                                    if (!loadWarnings) break block49;
                                                                                    log.info("Cant load class: " + e);
                                                                                }
                                                                            }
                                                                            try {
                                                                                URL url = NetcdfFile.class.getResource("/resources/bufrTables/tables/tablelookup.txt");
                                                                                if (null != url) {
                                                                                    NetcdfFile.registerIOProvider("ucar.nc2.iosp.bufr.BufrIosp");
                                                                                }
                                                                            }
                                                                            catch (Throwable e) {
                                                                                if (!loadWarnings) break block50;
                                                                                log.info("Cant load resource: " + e);
                                                                            }
                                                                        }
                                                                        try {
                                                                            NetcdfFile.class.getClassLoader().loadClass("edu.wisc.ssec.mcidas.AreaFile");
                                                                            NetcdfFile.registerIOProvider("ucar.nc2.iosp.mcidas.AreaServiceProvider");
                                                                        }
                                                                        catch (Throwable e) {
                                                                            if (!loadWarnings) break block51;
                                                                            log.info("Cant load class: " + e);
                                                                        }
                                                                    }
                                                                    try {
                                                                        NetcdfFile.registerIOProvider("ucar.nc2.iosp.nexrad2.Nexrad2IOServiceProvider");
                                                                    }
                                                                    catch (Throwable e) {
                                                                        if (!loadWarnings) break block52;
                                                                        log.info("Cant load class: " + e);
                                                                    }
                                                                }
                                                                try {
                                                                    NetcdfFile.registerIOProvider("ucar.nc2.iosp.nids.Nidsiosp");
                                                                }
                                                                catch (Throwable e) {
                                                                    if (!loadWarnings) break block53;
                                                                    log.info("Cant load class: " + e);
                                                                }
                                                            }
                                                            try {
                                                                NetcdfFile.registerIOProvider("ucar.nc2.iosp.dorade.Doradeiosp");
                                                            }
                                                            catch (Throwable e) {
                                                                if (!loadWarnings) break block54;
                                                                log.info("Cant load class: " + e);
                                                            }
                                                        }
                                                        try {
                                                            NetcdfFile.registerIOProvider("ucar.nc2.iosp.dmsp.DMSPiosp");
                                                        }
                                                        catch (Throwable e) {
                                                            if (!loadWarnings) break block55;
                                                            log.info("Cant load class: " + e);
                                                        }
                                                    }
                                                    try {
                                                        NetcdfFile.registerIOProvider("ucar.nc2.iosp.cinrad.Cinrad2IOServiceProvider");
                                                    }
                                                    catch (Throwable e) {
                                                        if (!loadWarnings) break block56;
                                                        log.info("Cant load class: " + e);
                                                    }
                                                }
                                                try {
                                                    NetcdfFile.registerIOProvider("ucar.nc2.iosp.misc.GtopoIosp");
                                                }
                                                catch (Throwable e) {
                                                    if (!loadWarnings) break block57;
                                                    log.info("Cant load class: " + e);
                                                }
                                            }
                                            try {
                                                NetcdfFile.registerIOProvider("ucar.nc2.iosp.misc.NmcObsLegacy");
                                            }
                                            catch (Throwable e) {
                                                if (!loadWarnings) break block58;
                                                log.info("Cant load class: " + e);
                                            }
                                        }
                                        try {
                                            NetcdfFile.registerIOProvider("ucar.nc2.iosp.gini.Giniiosp");
                                        }
                                        catch (Throwable e) {
                                            if (!loadWarnings) break block59;
                                            log.info("Cant load class: " + e);
                                        }
                                    }
                                    try {
                                        NetcdfFile.registerIOProvider("ucar.nc2.iosp.uf.UFiosp");
                                    }
                                    catch (Throwable e) {
                                        if (!loadWarnings) break block60;
                                        log.info("Cant load class: " + e);
                                    }
                                }
                                try {
                                    NetcdfFile.registerIOProvider("ucar.nc2.iosp.misc.Uspln");
                                }
                                catch (Throwable e) {
                                    if (!loadWarnings) break block61;
                                    log.info("Cant load class: " + e);
                                }
                            }
                            try {
                                NetcdfFile.registerIOProvider("ucar.nc2.iosp.misc.Nldn");
                            }
                            catch (Throwable e) {
                                if (!loadWarnings) break block62;
                                log.info("Cant load class: " + e);
                            }
                        }
                        try {
                            NetcdfFile.registerIOProvider("ucar.nc2.iosp.fysat.Fysatiosp");
                        }
                        catch (Throwable e) {
                            if (!loadWarnings) break block63;
                            log.info("Cant load class: " + e);
                        }
                    }
                    try {
                        NetcdfFile.registerIOProvider("ucar.nc2.iosp.gempak.GempakSurfaceIOSP");
                    }
                    catch (Throwable e) {
                        if (!loadWarnings) break block64;
                        log.info("Cant load class: " + e);
                    }
                }
                try {
                    NetcdfFile.registerIOProvider("ucar.nc2.iosp.uamiv.UAMIVServiceProvider");
                }
                catch (Throwable e) {
                    if (!loadWarnings) break block65;
                    log.info("Cant load class: " + e);
                }
            }
            try {
                NetcdfFile.class.getClassLoader().loadClass("edu.wisc.ssec.mcidas.GridDirectory");
                NetcdfFile.registerIOProvider("ucar.nc2.iosp.mcidas.McIDASGridServiceProvider");
            }
            catch (Throwable e) {
                if (!loadWarnings) break block66;
                log.info("Cant load class: " + e);
            }
        }
        userLoads = true;
    }
}

