/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import java.io.Serializable;
import thredds.filesystem.CacheFile;

public class CacheDirectory
extends CacheFile
implements Serializable {
    private String parentDirName;
    private CacheFile[] children;

    public CacheDirectory(File dir) {
        super(dir);
        this.parentDirName = dir.getParent();
        File[] subs = dir.listFiles();
        if (subs == null) {
            subs = new File[]{};
        }
        this.children = new CacheFile[subs.length];
        int count = 0;
        for (File f : subs) {
            this.children[count++] = new CacheFile(f);
        }
    }

    public boolean notModified() {
        File f = new File(this.getPath());
        return f.lastModified() <= this.lastModified;
    }

    public String getPath() {
        return this.parentDirName + "/" + this.getPath();
    }

    public CacheFile[] getChildren() {
        return this.children;
    }
}

