/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Shape;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;

public abstract class SGSimpleArrow2D
extends SGDrawingElementArrow2D {
    protected SGTuple2f mStartPoint = new SGTuple2f();
    protected SGTuple2f mEndPoint = new SGTuple2f();
    protected float mMagnification = 1.0f;
    protected Color mColor = null;
    protected int mStartHeadType;
    protected int mEndHeadType;
    protected int mLineType;
    protected float mHeadSize;
    protected float mHeadOpenAngle;
    protected float mHeadCloseAngle;
    protected SGStroke mStroke = new SGStroke();
    protected Shape mStartHeadShape = null;
    protected Shape mEndHeadShape = null;

    public SGSimpleArrow2D() {
        this.mLine = this.createBodyInstance();
        this.mStartHead = this.createHeadInstance(this, true);
        this.mEndHead = this.createHeadInstance(this, false);
    }

    public void dispose() {
        super.dispose();
        this.mStroke = null;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        if ((double)f <= 0.0) {
            throw new IllegalArgumentException("mag <= 0.0");
        }
        this.mMagnification = f;
        this.mStroke.setMagnification(f);
        this.updateHeadAngle();
        this.updateHeadShape();
        return true;
    }

    public float getLineWidth() {
        return this.mStroke.getLineWidth();
    }

    public int getLineType() {
        return this.mLineType;
    }

    public float getHeadSize() {
        return this.mHeadSize;
    }

    public int getStartHeadType() {
        return this.mStartHeadType;
    }

    public int getEndHeadType() {
        return this.mEndHeadType;
    }

    public boolean setHeadAngle(Float f, Float f2) {
        Float f3;
        Float f4;
        Float f5 = f4 = f != null ? SGUtility.calcPropertyValue(f.floatValue(), null, null, 5.0, 85.0, -2) : Float.valueOf(this.mHeadOpenAngle);
        if (f4 == null) {
            return false;
        }
        Float f6 = f3 = f2 != null ? SGUtility.calcPropertyValue(f2.floatValue(), null, null, 5.0, 175.0, -2) : Float.valueOf(this.mHeadCloseAngle);
        if (f3 == null) {
            return false;
        }
        if (f3.floatValue() <= f4.floatValue()) {
            return false;
        }
        this.mHeadOpenAngle = f4.floatValue();
        this.mHeadCloseAngle = f3.floatValue();
        this.updateHeadAngle();
        this.updateHeadShape();
        return true;
    }

    public float getHeadOpenAngle() {
        return this.mHeadOpenAngle;
    }

    public float getHeadCloseAngle() {
        return this.mHeadCloseAngle;
    }

    public boolean setLineWidth(float f) {
        this.mStroke.setLineWidth(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setLineType(int n) {
        if (!SGDrawingElementLine.isValidLineType(n)) {
            return false;
        }
        this.mLineType = n;
        this.mStroke.setLineType(n);
        return true;
    }

    public boolean setStartHeadType(int n) {
        if (!SGDrawingElementArrow.isValidArrowHeadType(n)) {
            return false;
        }
        this.mStartHeadType = n;
        this.updateHeadAngle();
        this.updateHeadShape();
        return true;
    }

    public boolean setEndHeadType(int n) {
        if (!SGDrawingElementArrow.isValidArrowHeadType(n)) {
            return false;
        }
        this.mEndHeadType = n;
        this.updateHeadShape();
        return true;
    }

    public boolean setHeadSize(float f) {
        this.mHeadSize = f;
        this.updateHeadAngle();
        this.updateHeadShape();
        return true;
    }

    public Color getColor() {
        return this.mColor;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("cl == null");
        }
        this.mColor = color;
        return true;
    }

    public SGStroke getStroke() {
        return this.mStroke;
    }

    protected SGDrawingElementLine createBodyInstance() {
        return new SGDrawingElementArrow2D.ArrowBody(this);
    }

    protected SGDrawingElementSymbol createHeadInstance(SGDrawingElementArrow sGDrawingElementArrow, boolean bl) {
        return new SGDrawingElementArrow2D.ArrowHead(sGDrawingElementArrow, bl);
    }

    public SGTuple2f getEnd() {
        return new SGTuple2f(this.mEndPoint);
    }

    public SGTuple2f getStart() {
        return new SGTuple2f(this.mStartPoint);
    }

    public boolean setLocation(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        this.mStartPoint.setValues(sGTuple2f);
        this.mEndPoint.setValues(sGTuple2f2);
        this.updateHeadAngle();
        return true;
    }

    public boolean setEndX(float f) {
        this.mEndPoint.setX(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setEndY(float f) {
        this.mEndPoint.setY(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setStartX(float f) {
        this.mStartPoint.setX(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setStartY(float f) {
        this.mStartPoint.setY(f);
        this.updateHeadAngle();
        return true;
    }

    public Shape getStartHeadShape() {
        return this.mStartHeadShape;
    }

    public Shape getEndHeadShape() {
        return this.mEndHeadShape;
    }

    protected void updateHeadShape() {
        this.mStartHeadShape = ((SGDrawingElementSymbol2D)this.getStartHead()).createShape();
        this.mEndHeadShape = ((SGDrawingElementSymbol2D)this.getEndHead()).createShape();
    }
}

