/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGRadioButton;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.data.SGDataSetupDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGArrowPanel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDataDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIArrowPanelObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDataPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIVXYDataDialogObserver;

public class SGPropertyDialogVXYData
extends SGDataDialog {
    private static final long serialVersionUID = -8568651377496230416L;
    public static final String TITLE = "Data Properties";
    private SGRadioButton mAmplitudeInvariantRadioButton;
    private SGArrowPanel mArrowPanel;
    private SGTwoAxesSelectionPanel mAxisPanel;
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private JPanel mCommonPanel;
    private SGButton mDataColumnSelectionButton;
    private SGRadioButton mDirectionInvariantRadioButton;
    private JLabel mInvariantModeLabel;
    private SGCheckBox mLegendVisibleCheckBox;
    private JLabel mMagnitudePerCMLabel;
    private SGTextField mMagnitudePerCMTextField;
    private SGTextField mNameField;
    private JLabel mNameLabel;
    private SGButton mOKButton;
    private SGButton mPreviewButton;
    private JRadioButton mNoInvariantModeSelectionRadioButton = new JRadioButton();

    public SGPropertyDialogVXYData(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mCommonPanel = new JPanel();
        this.mLegendVisibleCheckBox = new SGCheckBox();
        this.mNameLabel = new JLabel();
        this.mNameField = new SGTextField();
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.mMagnitudePerCMLabel = new JLabel();
        this.mMagnitudePerCMTextField = new SGTextField();
        this.mDirectionInvariantRadioButton = new SGRadioButton();
        this.mAmplitudeInvariantRadioButton = new SGRadioButton();
        this.mInvariantModeLabel = new JLabel();
        this.mDataColumnSelectionButton = new SGButton();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPreviewButton = new SGButton();
        this.mArrowPanel = new SGArrowPanel();
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLegendVisibleCheckBox.setText("Legend Visible");
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.mCommonPanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        this.mNameLabel.setFont(new Font("Dialog", 0, 12));
        this.mNameLabel.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mCommonPanel.add((Component)this.mNameLabel, gridBagConstraints);
        this.mNameField.setColumns(16);
        this.mNameField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.mCommonPanel.add((Component)this.mNameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        this.mCommonPanel.add((Component)this.mAxisPanel, gridBagConstraints);
        this.mMagnitudePerCMLabel.setFont(new Font("Dialog", 0, 12));
        this.mMagnitudePerCMLabel.setText("Magnitude per cm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mCommonPanel.add((Component)this.mMagnitudePerCMLabel, gridBagConstraints);
        this.mMagnitudePerCMTextField.setColumns(6);
        this.mMagnitudePerCMTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.mCommonPanel.add((Component)this.mMagnitudePerCMTextField, gridBagConstraints);
        this.mDirectionInvariantRadioButton.setText("Direction");
        this.mDirectionInvariantRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mCommonPanel.add((Component)this.mDirectionInvariantRadioButton, gridBagConstraints);
        this.mAmplitudeInvariantRadioButton.setText("Amplitude");
        this.mAmplitudeInvariantRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mCommonPanel.add((Component)this.mAmplitudeInvariantRadioButton, gridBagConstraints);
        this.mInvariantModeLabel.setFont(new Font("Dialog", 0, 12));
        this.mInvariantModeLabel.setText("Invariant Mode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mCommonPanel.add((Component)this.mInvariantModeLabel, gridBagConstraints);
        this.mDataColumnSelectionButton.setText("Data Column");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.mCommonPanel.add((Component)this.mDataColumnSelectionButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setText("Preview");
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mArrowPanel.setBorder(BorderFactory.createBevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mArrowPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mDirectionInvariantRadioButton);
        buttonGroup.add(this.mAmplitudeInvariantRadioButton);
        buttonGroup.add(this.mNoInvariantModeSelectionRadioButton);
        this.mDataColumnSelectionButton.addActionListener(this);
        this.mArrowPanel.addActionListener(this);
        this.mAxisPanel.addActionListener(this);
        this.mAmplitudeInvariantRadioButton.addActionListener(this);
        this.mDirectionInvariantRadioButton.addActionListener(this);
        this.mLegendVisibleCheckBox.addActionListener(this);
        this.mNameField.setDescription("Name");
        this.mMagnitudePerCMTextField.setDescription("Magnitude per cm");
        return true;
    }

    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.addAll(this.mArrowPanel.getColorSelectionButtonsList());
        return arrayList;
    }

    public List getNumberTextFieldList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public List getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.addAll(this.mArrowPanel.getSpinnerList());
        return arrayList;
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        list.add(this.mNameField);
        list.add(this.mMagnitudePerCMTextField);
        return list;
    }

    public boolean addPropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        super.addPropertyDialogObserver(sGIPropertyDialogObserver);
        if (sGIPropertyDialogObserver instanceof SGIArrowPanelObserver) {
            this.mArrowPanel.addObserver((SGIArrowPanelObserver)((Object)sGIPropertyDialogObserver));
        }
        return true;
    }

    public boolean removePropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        super.removePropertyDialogObserver(sGIPropertyDialogObserver);
        if (sGIPropertyDialogObserver instanceof SGIArrowPanelObserver) {
            this.mArrowPanel.removeObserver((SGIArrowPanelObserver)((Object)sGIPropertyDialogObserver));
        }
        return true;
    }

    public boolean removeAllPropertyDialogObserver() {
        super.removeAllPropertyDialogObserver();
        this.mArrowPanel.removeAllObserver();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mDataColumnSelectionButton)) {
            this.showDataColumnSelectionDialog();
        } else if (object.equals(this.mDataColumnSelectionDialog)) {
            SGDataSetupDialog sGDataSetupDialog = (SGDataSetupDialog)object;
            if ("OK".equals(string)) {
                SGDataColumnInfo[] sGDataColumnInfoArray = sGDataSetupDialog.getDataColumnInfoSet().getDataColumnInfoArray();
                this.mDataInfoArray = sGDataColumnInfoArray;
            }
        }
    }

    public String getDataName() {
        return this.mNameField.getText();
    }

    public boolean setDataName(String string) {
        this.mNameField.setText(string);
        return true;
    }

    public Boolean getLegendVisible() {
        return this.mLegendVisibleCheckBox.getSelected();
    }

    public void setLegendVisible(Boolean bl) {
        this.mLegendVisibleCheckBox.setSelected(bl);
    }

    public boolean setDialogProperty() {
        List list = this.mPropertyDialogObserverList;
        int n = list.size();
        boolean bl = n == 1;
        this.mDataColumnSelectionButton.setEnabled(bl);
        if (!this.mAxisPanel.setSelected(list)) {
            return false;
        }
        String string = this.getDataNameFromObservers();
        this.setDataName(string);
        Boolean bl2 = this.getLegendVisibleFromObservers();
        this.setLegendVisible(bl2);
        Float f = this.getScalingFactorFromObservers();
        this.setMagnitudePerCM(f);
        Boolean bl3 = this.getInvarianceFromObservers();
        this.setDirectionInvariant(bl3);
        return this.mArrowPanel.setComponentsProperty();
    }

    public boolean setMagnitudePerCM(Object object) {
        return this.setValue(this.mMagnitudePerCMTextField, object);
    }

    public Number getMagnitudePerCM() {
        return this.getNumber(this.mMagnitudePerCMTextField);
    }

    private Float getScalingFactorFromObservers() {
        Object object;
        List list = this.mPropertyDialogObserverList;
        int n = list.size();
        if (n == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        for (int i = 0; i < n; ++i) {
            object = (SGIVXYDataDialogObserver)list.get(i);
            arrayList.add(Float.valueOf(object.getMagnitudePerCM()));
        }
        Float f = (Float)arrayList.get(0);
        object = f;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                Float f2 = (Float)arrayList.get(i);
                if (f.equals(f2)) continue;
                object = null;
                break;
            }
        }
        return object;
    }

    public Boolean isDirectionInvariant() {
        if (this.mDirectionInvariantRadioButton.isSelected()) {
            return Boolean.TRUE;
        }
        if (this.mAmplitudeInvariantRadioButton.isSelected()) {
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean setDirectionInvariant(Object object) {
        if (object == null) {
            this.mNoInvariantModeSelectionRadioButton.setSelected(true);
            return false;
        }
        Boolean bl = (Boolean)object;
        if (bl.booleanValue()) {
            this.mDirectionInvariantRadioButton.setSelected(true);
        } else {
            this.mAmplitudeInvariantRadioButton.setSelected(true);
        }
        return true;
    }

    private Boolean getInvarianceFromObservers() {
        Object object;
        List list = this.mPropertyDialogObserverList;
        int n = list.size();
        if (n == 0) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
        for (int i = 0; i < n; ++i) {
            object = (SGIVXYDataDialogObserver)list.get(i);
            arrayList.add(object.isDirectionInvariant());
        }
        Boolean bl = (Boolean)arrayList.get(0);
        object = bl;
        if (n > 1) {
            for (int i = 1; i < n; ++i) {
                Boolean bl2 = (Boolean)arrayList.get(i);
                if (bl.equals(bl2)) continue;
                object = null;
                break;
            }
        }
        return object;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        Boolean bl;
        Number number;
        Boolean bl2;
        String string;
        SGIDataPropertyDialogObserver sGIDataPropertyDialogObserver;
        SGIVXYDataDialogObserver sGIVXYDataDialogObserver = (SGIVXYDataDialogObserver)sGIPropertyDialogObserver;
        if (this.mDataInfoArray != null && !(sGIDataPropertyDialogObserver = (SGIDataPropertyDialogObserver)this.mPropertyDialogObserverList.get(0)).setColumnInfo(this.mDataInfoArray, this.mCommitActionStateMessage)) {
            return false;
        }
        int n = this.mAxisPanel.getXAxisLocation();
        int n2 = this.mAxisPanel.getYAxisLocation();
        if (n != -1) {
            sGIVXYDataDialogObserver.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGIVXYDataDialogObserver.setYAxisLocation(n2);
        }
        if ((string = this.getDataName()) != null) {
            sGIVXYDataDialogObserver.setName(string);
        }
        if ((bl2 = this.getLegendVisible()) != null) {
            sGIVXYDataDialogObserver.setVisibleInLegend(bl2);
        }
        if ((number = this.getMagnitudePerCM()) != null) {
            sGIVXYDataDialogObserver.setMagnitudePerCM(number.floatValue());
        }
        if ((bl = this.isDirectionInvariant()) != null) {
            sGIVXYDataDialogObserver.setDirectionInvariant(bl);
        }
        return this.mArrowPanel.setPropertiesToListeners(sGIVXYDataDialogObserver);
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    protected JButton getPreviewButton() {
        return this.mPreviewButton;
    }

    protected boolean hasValidInputValues() {
        boolean bl = true;
        if (!super.hasValidInputValues()) {
            bl = false;
        }
        if (!this.mNameField.hasValidText()) {
            this.addInputErrorDescription(this.mNameField.getDescription());
            bl = false;
        }
        if (!this.hasValidNumber(this.mMagnitudePerCMTextField, Float.valueOf(Float.MIN_VALUE), null)) {
            bl = false;
        }
        return bl;
    }
}

