/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.data.SGDataSetupDialog;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDataDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDataPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYZDataDialogObserver;

public class SGPropertyDialogSXYZData
extends SGDataDialog
implements SGIDataColumnTypeConstants {
    private static final long serialVersionUID = 4413621536454191591L;
    public static final String TITLE = "Data Properties";
    private SGTwoAxesSelectionPanel mAxisPanel;
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private JPanel mColorMapPanel;
    private JPanel mCommonPanel;
    private SGButton mDataColumnSelectionButton;
    private JLabel mHeightValueLabel;
    private SGTextField mHeightValueTextField;
    private SGCheckBox mLegendVisibleCheckBox;
    private SGTextField mNameField;
    private JLabel mNameLabel;
    private SGButton mOKButton;
    private SGButton mPreviewButton;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JLabel mWidthValueLabel;
    private SGTextField mWidthValueTextField;
    public static final String ERRMSG_WIDTH_VALUE_INVALID = "Width value is invalid.";
    public static final String ERRMSG_HEIGHT_VALUE_INVALID = "Width value is invalid.";

    public SGPropertyDialogSXYZData(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mCommonPanel = new JPanel();
        this.mLegendVisibleCheckBox = new SGCheckBox();
        this.mNameLabel = new JLabel();
        this.mNameField = new SGTextField();
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.mDataColumnSelectionButton = new SGButton();
        this.mColorMapPanel = new JPanel();
        this.mWidthValueLabel = new JLabel();
        this.mWidthValueTextField = new SGTextField();
        this.mHeightValueLabel = new JLabel();
        this.mHeightValueTextField = new SGTextField();
        this.mSizeLabel = new JLabel();
        this.mSizeSeparator = new JSeparator();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPreviewButton = new SGButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLegendVisibleCheckBox.setText("Legend Visible");
        this.mLegendVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.mCommonPanel.add((Component)this.mLegendVisibleCheckBox, gridBagConstraints);
        this.mNameLabel.setFont(new Font("Dialog", 0, 12));
        this.mNameLabel.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mCommonPanel.add((Component)this.mNameLabel, gridBagConstraints);
        this.mNameField.setColumns(16);
        this.mNameField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mCommonPanel.add((Component)this.mNameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        this.mCommonPanel.add((Component)this.mAxisPanel, gridBagConstraints);
        this.mDataColumnSelectionButton.setText("Data Column");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.mCommonPanel.add((Component)this.mDataColumnSelectionButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.mColorMapPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.mColorMapPanel.setPreferredSize(new Dimension(300, 200));
        this.mColorMapPanel.setLayout(new GridBagLayout());
        this.mWidthValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mWidthValueLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 5);
        this.mColorMapPanel.add((Component)this.mWidthValueLabel, gridBagConstraints);
        this.mWidthValueTextField.setHorizontalAlignment(2);
        this.mWidthValueTextField.setText("0.0");
        this.mWidthValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mWidthValueTextField.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 20);
        this.mColorMapPanel.add((Component)this.mWidthValueTextField, gridBagConstraints);
        this.mHeightValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mHeightValueLabel.setText("Height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mColorMapPanel.add((Component)this.mHeightValueLabel, gridBagConstraints);
        this.mHeightValueTextField.setHorizontalAlignment(2);
        this.mHeightValueTextField.setText("0.0");
        this.mHeightValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mHeightValueTextField.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 20);
        this.mColorMapPanel.add((Component)this.mHeightValueTextField, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mColorMapPanel.add((Component)this.mSizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 40, 5, 0);
        this.mColorMapPanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mColorMapPanel, gridBagConstraints);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setText("Preview");
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        this.mDataColumnSelectionButton.addActionListener(this);
        this.mAxisPanel.addActionListener(this);
        this.mLegendVisibleCheckBox.addActionListener(this);
        this.mNameField.setDescription("Name");
        this.mWidthValueTextField.setDescription("Width");
        this.mHeightValueTextField.setDescription("Height");
    }

    public List getColorSelectionButtonsList() {
        return new ArrayList();
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        list.add(this.mNameField);
        return list;
    }

    public List getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mWidthValueTextField);
        arrayList.add(this.mHeightValueTextField);
        return arrayList;
    }

    public List getSpinnerList() {
        return new ArrayList();
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    protected JButton getPreviewButton() {
        return this.mPreviewButton;
    }

    public boolean setDialogProperty() {
        List list = this.mPropertyDialogObserverList;
        int n = list.size();
        boolean bl = n == 1;
        this.mDataColumnSelectionButton.setEnabled(bl);
        if (!this.mAxisPanel.setSelected(list)) {
            return false;
        }
        String string = this.getDataNameFromObservers();
        this.mNameField.setText(string);
        Boolean bl2 = this.getLegendVisibleFromObservers();
        this.mLegendVisibleCheckBox.setSelected(bl2);
        SGISXYZDataDialogObserver sGISXYZDataDialogObserver = (SGISXYZDataDialogObserver)list.get(0);
        double d = sGISXYZDataDialogObserver.getRectangleWidthValue();
        double d2 = sGISXYZDataDialogObserver.getRectangleHeightValue();
        Double d3 = d;
        Double d4 = d2;
        if (list.size() > 1) {
            double d5;
            SGISXYZDataDialogObserver sGISXYZDataDialogObserver2;
            int n2;
            for (n2 = 1; n2 < list.size(); ++n2) {
                sGISXYZDataDialogObserver2 = (SGISXYZDataDialogObserver)list.get(n2);
                d5 = sGISXYZDataDialogObserver2.getRectangleWidthValue();
                if (d == d5) continue;
                d3 = null;
                break;
            }
            for (n2 = 1; n2 < list.size(); ++n2) {
                sGISXYZDataDialogObserver2 = (SGISXYZDataDialogObserver)list.get(n2);
                d5 = sGISXYZDataDialogObserver2.getRectangleHeightValue();
                if (d2 == d5) continue;
                d4 = null;
                break;
            }
        }
        this.setValue(this.mWidthValueTextField, (Object)d3);
        this.setValue(this.mHeightValueTextField, (Object)d4);
        this.updateComponents();
        return true;
    }

    private void updateComponents() {
        List list = this.mPropertyDialogObserverList;
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            SGISXYZDataDialogObserver sGISXYZDataDialogObserver = (SGISXYZDataDialogObserver)list.get(i);
            SGData sGData = sGISXYZDataDialogObserver.getData();
            if (SGDataUtility.isArrayData(sGData)) {
                bl = true;
            } else if (SGDataUtility.isNetCDFData(sGData)) {
                if (this.mDataInfoArray != null) {
                    boolean bl2 = false;
                    if (!bl2) {
                        bl = false;
                    }
                    if (!bl) {
                        break;
                    }
                } else {
                    SGNetCDFData sGNetCDFData = (SGNetCDFData)sGData;
                    bl = sGNetCDFData.isSerialNumberAvailable();
                }
            } else {
                throw new Error("Unsupported data type: " + sGData.getDataType());
            }
            if (!bl) break;
        }
        this.mSizeLabel.setEnabled(bl);
        this.mSizeSeparator.setEnabled(bl);
        this.mWidthValueLabel.setEnabled(bl);
        this.mWidthValueTextField.setEnabled(bl);
        this.mHeightValueLabel.setEnabled(bl);
        this.mHeightValueTextField.setEnabled(bl);
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        Boolean bl;
        String string;
        SGIDataPropertyDialogObserver sGIDataPropertyDialogObserver;
        SGISXYZDataDialogObserver sGISXYZDataDialogObserver = (SGISXYZDataDialogObserver)sGIPropertyDialogObserver;
        if (this.mDataInfoArray != null && !(sGIDataPropertyDialogObserver = (SGIDataPropertyDialogObserver)this.mPropertyDialogObserverList.get(0)).setColumnInfo(this.mDataInfoArray, this.mCommitActionStateMessage)) {
            return false;
        }
        int n = this.mAxisPanel.getXAxisLocation();
        int n2 = this.mAxisPanel.getYAxisLocation();
        Number number = this.getNumber(this.mWidthValueTextField);
        Number number2 = this.getNumber(this.mHeightValueTextField);
        if (!sGISXYZDataDialogObserver.hasValidRectangleWidthValue(n, number)) {
            this.setInputErrorMessage("Width value is invalid.");
            return false;
        }
        if (!sGISXYZDataDialogObserver.hasValidRectangleWidthValue(n2, number2)) {
            this.setInputErrorMessage("Width value is invalid.");
            return false;
        }
        if (n != -1) {
            sGISXYZDataDialogObserver.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGISXYZDataDialogObserver.setYAxisLocation(n2);
        }
        if ((string = this.mNameField.getText()) != null) {
            sGISXYZDataDialogObserver.setName(string);
        }
        if ((bl = this.mLegendVisibleCheckBox.getSelected()) != null) {
            sGISXYZDataDialogObserver.setVisibleInLegend(bl);
        }
        if (number != null) {
            sGISXYZDataDialogObserver.setRectangleWidthValue(number.doubleValue());
        }
        if (number2 != null) {
            sGISXYZDataDialogObserver.setRectangleHeightValue(number2.doubleValue());
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mDataColumnSelectionButton)) {
            this.showDataColumnSelectionDialog();
        } else if (object.equals(this.mDataColumnSelectionDialog)) {
            SGDataSetupDialog sGDataSetupDialog = (SGDataSetupDialog)object;
            if ("OK".equals(string)) {
                SGDataColumnInfo[] sGDataColumnInfoArray = sGDataSetupDialog.getDataColumnInfoSet().getDataColumnInfoArray();
                this.mDataInfoArray = sGDataColumnInfoArray;
                this.updateComponents();
            }
        }
    }

    protected boolean hasValidInputValues() {
        boolean bl = true;
        if (!super.hasValidInputValues()) {
            bl = false;
        }
        if (!this.mNameField.hasValidText()) {
            this.addInputErrorDescription(this.mNameField.getDescription());
            bl = false;
        }
        if (this.mColorMapPanel.isVisible()) {
            if (!this.hasValidNumber(this.mWidthValueTextField, Float.valueOf(Float.MIN_VALUE), null)) {
                bl = false;
            }
            if (!this.hasValidNumber(this.mHeightValueTextField, Float.valueOf(Float.MIN_VALUE), null)) {
                bl = false;
            }
        }
        return bl;
    }
}

