/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIChildObject;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGITimingLineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElement2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGITimingLineDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSimpleArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingLineDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGFigureElementTimingLine
extends SGFigureElement2D
implements SGIFigureElementTimingLine,
SGITimingLineConstants {
    private SGIFigureElementAxis mAxisElement = null;
    private SGPropertyDialog mPropertyDialog = null;
    private SGDrawingElementArrow2D mGuideArrow = null;

    public SGFigureElementTimingLine() {
        GuideArrow guideArrow = new GuideArrow();
        guideArrow.setVisible(false);
        this.mGuideArrow = guideArrow;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mPropertyDialog != null) {
            this.mPropertyDialog.dispose();
            this.mPropertyDialog = null;
        }
        if (this.mGuideArrow != null) {
            this.mGuideArrow.dispose();
            this.mGuideArrow = null;
        }
    }

    @Override
    public String getClassDescription() {
        return "Timing Lines";
    }

    @Override
    public void setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
    }

    @Override
    public void guideToAdd(int n, int n2) {
        float f;
        if (!this.getGraphRect().contains(n, n2)) {
            this.mGuideArrow.setVisible(false);
            this.repaint();
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getNearestAxisInfo(n, n2, arrayList, arrayList2);
        int n3 = (Integer)arrayList.get(0);
        float f2 = f = ((Number)arrayList2.get(0)).floatValue();
        SGTuple2f sGTuple2f = new SGTuple2f(n, n2);
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (n3 == 0) {
            sGTuple2f2.x = n;
            sGTuple2f2.y = (float)n2 + f2;
        } else if (n3 == 1) {
            sGTuple2f2.x = n;
            sGTuple2f2.y = (float)n2 - f2;
        } else if (n3 == 2) {
            sGTuple2f2.x = (float)n - f2;
            sGTuple2f2.y = n2;
        } else if (n3 == 3) {
            sGTuple2f2.x = (float)n + f2;
            sGTuple2f2.y = n2;
        }
        this.mGuideArrow.setLocation(sGTuple2f, sGTuple2f2);
        this.mGuideArrow.setVisible(true);
        this.repaint();
    }

    private void getNearestAxisInfo(int n, int n2, ArrayList arrayList, ArrayList arrayList2) {
        int n3;
        float f = this.getGraphRectX();
        float f2 = f + this.getGraphRectWidth();
        float f3 = this.getGraphRectY();
        float f4 = f3 + this.getGraphRectHeight();
        float f5 = (float)n - f;
        float f6 = f2 - (float)n;
        float f7 = (float)n2 - f3;
        float f8 = f4 - (float)n2;
        float[] fArray = new float[]{f5, f6, f7, f8};
        float f9 = Float.MAX_VALUE;
        int n4 = -1;
        for (n3 = 0; n3 < fArray.length; ++n3) {
            if (!(fArray[n3] < f9)) continue;
            f9 = fArray[n3];
            n4 = n3;
        }
        n3 = -1;
        if (n4 == 0) {
            n3 = 2;
        } else if (n4 == 1) {
            n3 = 3;
        } else if (n4 == 2) {
            n3 = 1;
        } else if (n4 == 3) {
            n3 = 0;
        }
        arrayList.add(n3);
        arrayList2.add(Float.valueOf(f9));
    }

    @Override
    public boolean addTimingLine(int n, int n2, double d) {
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(n2);
        if (sGAxis == null) {
            return false;
        }
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        return this.addTimingLine(n, sGAxis, d);
    }

    @Override
    public boolean addTimingLine(int n, int n2) {
        if (!this.getGraphRect().contains(n, n2)) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getNearestAxisInfo(n, n2, arrayList, arrayList2);
        int n3 = (Integer)arrayList.get(0);
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(n3);
        double d = this.mAxisElement.getValue(n3, n, n2);
        return this.addTimingLine(this.assignChildId(), sGAxis, d);
    }

    private boolean addTimingLine(int n, SGAxis sGAxis, double d) {
        TimingLine timingLine = new TimingLine();
        timingLine.setAxis(sGAxis);
        timingLine.setValue(d);
        timingLine.setMagnification(this.getMagnification());
        if (!this.addToList(n, timingLine)) {
            return false;
        }
        this.mGuideArrow.setVisible(false);
        this.updateFocusedObjectsList((SGISelectable)timingLine, 0);
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    @Override
    protected boolean addToList(SGIChildObject sGIChildObject) {
        if (!super.addToList(sGIChildObject)) {
            return false;
        }
        this.afterAddedToList(sGIChildObject);
        return true;
    }

    @Override
    protected boolean addToList(int n, SGIChildObject sGIChildObject) {
        if (!super.addToList(n, sGIChildObject)) {
            return false;
        }
        this.afterAddedToList(sGIChildObject);
        return true;
    }

    private void afterAddedToList(SGIChildObject sGIChildObject) {
        TimingLine timingLine = (TimingLine)sGIChildObject;
        timingLine.setDrawingElementsLocation();
        timingLine.initPropertiesHistory();
    }

    @Override
    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIFigureElementLegend)) {
            if (sGIFigureElement instanceof SGIFigureElementAxis) {
                SGIFigureElementAxis sGIFigureElementAxis = (SGIFigureElementAxis)sGIFigureElement;
                bl = this.synchronizeToAxisElement(sGIFigureElementAxis, string);
            } else if (!(sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementGraph || sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = this.synchronizeArgument(sGIFigureElement, string);
            }
        }
        return bl;
    }

    @Override
    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    @Override
    public SGProperties getProperties() {
        TimingElementProperties timingElementProperties = new TimingElementProperties();
        if (!this.getProperties(timingElementProperties)) {
            return null;
        }
        return timingElementProperties;
    }

    @Override
    public String getTagName() {
        return "TimingLines";
    }

    @Override
    public boolean writeProperty(Element element) {
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("TimingLine");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            TimingLine timingLine = new TimingLine();
            Element element2 = (Element)node;
            if (!timingLine.readProperty(element2)) {
                return false;
            }
            this.addToList(timingLine);
        }
        return true;
    }

    @Override
    public Element[] createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            TimingLine timingLine = (TimingLine)list.get(i);
            if (!timingLine.isValid()) continue;
            Element element2 = timingLine.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return new Element[]{element};
    }

    @Override
    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        return this.setAllAnchorEnabledDrawingElementsLocation();
    }

    private boolean calcLocationOfTimingLine(double d, SGAxis sGAxis, boolean bl, SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        float f = this.calcLocation(d, sGAxis, bl);
        if (Float.isNaN(f)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        if (bl) {
            sGTuple2f.x = f;
            sGTuple2f.y = (float)rectangle2D.getY();
            sGTuple2f2.x = f;
            sGTuple2f2.y = sGTuple2f.y + (float)rectangle2D.getHeight();
        } else {
            sGTuple2f.x = (float)rectangle2D.getX();
            sGTuple2f.y = f;
            sGTuple2f2.x = sGTuple2f.x + (float)rectangle2D.getWidth();
            sGTuple2f2.y = f;
        }
        return true;
    }

    private ArrayList getVisibleTimingElementListInside() {
        ArrayList<TimingLine> arrayList = new ArrayList<TimingLine>();
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            TimingLine timingLine = (TimingLine)list.get(i);
            if (!timingLine.isInsideRange()) continue;
            arrayList.add(timingLine);
        }
        return arrayList;
    }

    @Override
    public boolean onMouseClicked(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleTimingElementListInside();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!timingLine.isValid() || !this.clickDrawingElements(timingLine, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    private boolean clickDrawingElements(TimingLine timingLine, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (timingLine.contains(n, n2)) {
            this.updateFocusedObjectsList((SGISelectable)timingLine, mouseEvent);
            if (n3 == 1) {
                if (!SwingUtilities.isLeftMouseButton(mouseEvent) && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    timingLine.getPopupMenu().show(this.getComponent(), n, n2);
                }
            } else if (n3 == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.setPropertiesOfSelectedObjects();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getVisibleTimingElementListInside();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!timingLine.isValid() || !timingLine.contains(n, n2)) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            this.setMouseCursor(13);
            if (timingLine.isSelected()) {
                this.mDraggableFlag = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (!this.mDraggableFlag) {
            return false;
        }
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!timingLine.isValid()) continue;
            timingLine.translate(n, n2);
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getFocusedObjectsList();
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!timingLine.isValid() || !timingLine.contains(n, n2)) continue;
            bl = true;
        }
        if (bl) {
            this.setMouseCursor(12);
        } else {
            this.setMouseCursor(0);
        }
        this.unselectOuterLines();
        this.mDraggableFlag = false;
        this.notifyToRoot();
        return true;
    }

    @Override
    public boolean onDrawingElement(int n, int n2) {
        ArrayList arrayList = this.getVisibleTimingElementListInside();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            boolean bl;
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            if (!timingLine.isValid() || !(bl = timingLine.contains(n, n2))) continue;
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    @Override
    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    @Override
    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            timingLine.mTemporaryProperties = timingLine.getProperties();
        }
        return true;
    }

    @Override
    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            TimingLine timingLine = (TimingLine)arrayList.get(i);
            SGProperties sGProperties2 = timingLine.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = timingLine.getProperties()).equals(sGProperties2)) continue;
            timingLine.setChanged(true);
        }
        return true;
    }

    @Override
    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        TimingLine timingLine;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleTimingElementListInside();
        Rectangle2D rectangle2D = this.getGraphRect();
        if (this.mGuideArrow.isVisible()) {
            this.mGuideArrow.paint(graphics2D, rectangle2D);
        }
        if (bl) {
            SGUtilityForFigureElementJava2D.clipGraphRect(this, graphics2D);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            timingLine = (TimingLine)arrayList.get(n);
            if (!timingLine.isValid()) continue;
            if (bl) {
                timingLine.paint(graphics2D);
                continue;
            }
            timingLine.paint(graphics2D, rectangle2D);
        }
        if (bl) {
            graphics2D.setClip(this.getViewBounds());
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                timingLine = (TimingLine)arrayList.get(n);
                if (!timingLine.isValid()) continue;
                object = timingLine.getAnchorPointList();
                if (!timingLine.isAnchored()) {
                    SGUtilityForFigureElementJava2D.drawAnchorAsChildObject((List)object, graphics2D);
                    continue;
                }
                SGUtilityForFigureElementJava2D.drawAnchorPointsAsAnchoredChildObject((List<Point2D>)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList<SGISelectable> arrayList2 = new ArrayList<SGISelectable>();
            this.getFocusedObjectsList(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (TimingLine)arrayList2.get(i);
                if (!((TimingLine)object).isValid()) continue;
                ArrayList arrayList3 = ((TimingLine)object).getAnchorPointList();
                if (!((TimingLine)object).isAnchored()) {
                    SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(arrayList3, graphics2D);
                    continue;
                }
                SGUtilityForFigureElementJava2D.drawAnchorPointsAsAnchoredForcusObject(arrayList3, graphics2D);
            }
        }
    }

    protected boolean synchronizeToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        this.setAllAnchorEnabledDrawingElementsLocation();
        this.unselectOuterLines();
        return true;
    }

    protected boolean setAllDrawingElementsLocation() {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            TimingLine timingLine = (TimingLine)list.get(i);
            if (timingLine.setDrawingElementsLocation()) continue;
            return false;
        }
        return true;
    }

    protected boolean setAllAnchorEnabledDrawingElementsLocation() {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            TimingLine timingLine = (TimingLine)list.get(i);
            if (!timingLine.isAnchored()) {
                if (timingLine.setDrawingElementsLocation()) continue;
                return false;
            }
            if (!timingLine.setAxisValue()) {
                return false;
            }
            timingLine.setChanged(true);
        }
        return true;
    }

    private void unselectOuterLines() {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            TimingLine timingLine = (TimingLine)list.get(i);
            boolean bl = timingLine.isInsideRange();
            if (!timingLine.isSelected() || bl) continue;
            timingLine.setSelected(false);
        }
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof TimingElementProperties)) {
            return false;
        }
        TimingElementProperties timingElementProperties = (TimingElementProperties)sGProperties;
        timingElementProperties.visibleTimingElementList = new ArrayList<SGIChildObject>(this.getVisibleChildList());
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof TimingElementProperties)) {
            return false;
        }
        TimingElementProperties timingElementProperties = (TimingElementProperties)sGProperties;
        boolean bl = this.setVisibleChildList(timingElementProperties.visibleTimingElementList);
        return bl;
    }

    @Override
    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        List<SGICopiable> list = this.duplicateObjects();
        for (int i = 0; i < list.size(); ++i) {
            TimingLine timingLine = (TimingLine)list.get(i);
            timingLine.translate(n, n2);
            timingLine.setSelected(true);
            this.addToList(timingLine);
        }
        if (list.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean paste(List<SGICopiable> list) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            SGICopiable sGICopiable = list.get(i);
            if (!(sGICopiable instanceof TimingLine)) continue;
            TimingLine timingLine = (TimingLine)sGICopiable;
            timingLine.translate(n, n2);
            SGProperties sGProperties = timingLine.getProperties();
            TimingLine timingLine2 = new TimingLine();
            timingLine2.setMagnification(f);
            timingLine2.setProperties(sGProperties);
            timingLine2.mAxis = this.mAxisElement.getAxisInPlane(timingLine.mTempAxis);
            this.addToList(timingLine2);
            timingLine2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            TimingElementProperties timingElementProperties = (TimingElementProperties)list.get(i);
            hashSet.addAll(timingElementProperties.visibleTimingElementList);
        }
        return hashSet;
    }

    @Override
    public boolean setDialogOwner(Frame frame) {
        if (!super.setDialogOwner(frame)) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SGFigureElementTimingLine.this.mPropertyDialog == null) {
                    SGFigureElementTimingLine.this.mPropertyDialog = new SGTimingLineDialog(SGFigureElementTimingLine.this.mDialogOwner, true);
                }
            }
        });
        return true;
    }

    @Override
    public SGPropertyResults setChildProperties(int n, SGPropertyMap sGPropertyMap) {
        Object object;
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (sGIChildObject == null) {
            Object object2;
            object = null;
            String string = null;
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                object2 = string2.toString();
                if ("Axis".equalsIgnoreCase((String)object2)) {
                    object = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if (!"Value".equalsIgnoreCase((String)object2)) continue;
                string = sGPropertyMap.getValueString((String)object2);
            }
            if (object == null) {
                return null;
            }
            if (string == null) {
                return null;
            }
            int n2 = SGUtility.getAxisLocation((String)object);
            object2 = SGUtilityText.getDouble(string);
            if (n2 == -1) {
                return null;
            }
            if (object2 == null) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue((Double)object2)) {
                return null;
            }
            if (!this.addTimingLine(n, n2, ((Double)object2).doubleValue())) {
                return null;
            }
            sGIChildObject = this.getChild(n);
        }
        object = sGIChildObject.setProperties(sGPropertyMap);
        return object;
    }

    public static class TimingLineProperties
    extends SGDrawingElementLine.LineProperties {
        protected double mValue;
        protected SGAxis mAxis;
        protected boolean mAnchored;

        public boolean equals(Object object) {
            if (!(object instanceof TimingLineProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            TimingLineProperties timingLineProperties = (TimingLineProperties)object;
            if (timingLineProperties.mValue != this.mValue) {
                return false;
            }
            if (!SGUtility.equals(timingLineProperties.mAxis, this.mAxis)) {
                return false;
            }
            return timingLineProperties.mAnchored == this.mAnchored;
        }

        public void setValue(double d) {
            this.mValue = d;
        }

        public void setAxis(SGAxis sGAxis) {
            this.mAxis = sGAxis;
        }

        public void setAnchored(boolean bl) {
            this.mAnchored = bl;
        }

        public Double getValue() {
            return this.mValue;
        }

        public SGAxis getAxis() {
            return this.mAxis;
        }

        public Boolean getAnchored() {
            return this.mAnchored;
        }
    }

    public static class TimingElementProperties
    extends SGProperties {
        ArrayList visibleTimingElementList = new ArrayList();

        public void dispose() {
            super.dispose();
            this.visibleTimingElementList.clear();
            this.visibleTimingElementList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TimingElementProperties)) {
                return false;
            }
            TimingElementProperties timingElementProperties = (TimingElementProperties)object;
            return timingElementProperties.visibleTimingElementList.equals(this.visibleTimingElementList);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.visibleTimingElementList.toString());
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }

    protected class TimingLine
    extends SGDrawingElementLine2D
    implements ActionListener,
    SGIUndoable,
    SGICopiable,
    SGFigureElement.IMovableChild,
    SGITimingLineDialogObserver,
    SGINode,
    SGITimingLineConstants {
        protected SGStroke mStroke = new SGStroke();
        protected Color mColor = null;
        protected SGAxis mAxis = null;
        protected double mValue;
        protected boolean mIsAnchored;
        private SGTuple2f mLocation = new SGTuple2f();
        private int mID;
        private boolean mSelectedFlag = false;
        private SGProperties mTemporaryProperties = null;
        private TimingLinePopupMenu mPopupMenu = null;
        private SGTuple2f mStart = new SGTuple2f();
        private SGTuple2f mEnd = new SGTuple2f();
        private boolean mValidFlag = true;
        private SGUndoManager mUndoManager = new SGUndoManager(this);
        private int mTempAxis = -1;

        public SGAxis getAxis() {
            return this.mAxis;
        }

        public void setAxis(SGAxis sGAxis) {
            this.mAxis = sGAxis;
        }

        public double getValue() {
            return this.mValue;
        }

        public boolean setValue(double d) {
            if (!this.mAxis.isValidValue(d)) {
                return false;
            }
            this.mValue = d;
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mAxis = null;
            this.mPopupMenu = null;
            this.mUndoManager.dispose();
            this.mUndoManager = null;
            if (this.mTemporaryProperties != null) {
                this.mTemporaryProperties.dispose();
                this.mTemporaryProperties = null;
            }
            this.mStroke = null;
        }

        public int getID() {
            return this.mID;
        }

        public boolean setID(int n) {
            this.mID = n;
            return true;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        public Color getColor() {
            return this.mColor;
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public boolean setLineWidth(float f, String string) {
            Float f2 = SGUtility.getLineWidth(f, string);
            if (f2 == null) {
                return false;
            }
            return this.setLineWidth(f2.floatValue());
        }

        public boolean isAnchored() {
            return this.mIsAnchored;
        }

        public boolean setAnchored(boolean bl) {
            this.mIsAnchored = bl;
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public SGProperties getProperties() {
            TimingLineProperties timingLineProperties = new TimingLineProperties();
            if (!this.getProperties(timingLineProperties)) {
                return null;
            }
            return timingLineProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof TimingLineProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            TimingLineProperties timingLineProperties = (TimingLineProperties)sGProperties;
            timingLineProperties.mAxis = this.getAxis();
            timingLineProperties.mValue = this.getValue();
            timingLineProperties.mAnchored = this.isAnchored();
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof TimingLineProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            TimingLineProperties timingLineProperties = (TimingLineProperties)sGProperties;
            this.mAxis = timingLineProperties.mAxis;
            this.mValue = timingLineProperties.mValue;
            this.mIsAnchored = timingLineProperties.mAnchored;
            return true;
        }

        protected TimingLine() {
            this.init();
        }

        private void init() {
            this.setLineWidth(1.0f, "pt");
            this.setLineType(1);
            this.setColor(DEFAULT_LINE_COLOR);
            this.setAnchored(false);
            this.mStroke.setEndCap(0);
            this.mStroke.setJoin(2);
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            String string = SGFigureElementTimingLine.this.mAxisElement.getLocationName(this.mAxis);
            String string2 = this.isHorizontal() ? "X" : "Y";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.mID);
            stringBuffer.append(": ");
            stringBuffer.append(" Axis=");
            stringBuffer.append(string);
            stringBuffer.append(", ");
            stringBuffer.append(string2);
            stringBuffer.append("=");
            stringBuffer.append(this.getValue());
            return stringBuffer.toString();
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            Point2D.Float float_ = new Point2D.Float();
            Point2D.Float float_2 = new Point2D.Float();
            boolean bl = this.isHorizontal();
            float f = SGFigureElementTimingLine.this.calcLocation(this.mValue, this.mAxis, bl);
            Rectangle2D rectangle2D = SGFigureElementTimingLine.this.getGraphRect();
            if (bl) {
                float f2 = (float)rectangle2D.getY();
                float f3 = f2 + (float)rectangle2D.getHeight();
                ((Point2D)float_).setLocation(f, f2);
                ((Point2D)float_2).setLocation(f, f3);
            } else {
                float f4 = (float)rectangle2D.getX();
                float f5 = f4 + (float)rectangle2D.getWidth();
                ((Point2D)float_).setLocation(f4, f);
                ((Point2D)float_2).setLocation(f5, f);
            }
            arrayList.add(float_);
            arrayList.add(float_2);
            return arrayList;
        }

        public JPopupMenu getPopupMenu() {
            TimingLinePopupMenu timingLinePopupMenu = null;
            if (this.mPopupMenu != null) {
                timingLinePopupMenu = this.mPopupMenu;
            } else {
                timingLinePopupMenu = new TimingLinePopupMenu();
                timingLinePopupMenu.init(this);
                this.mPopupMenu = timingLinePopupMenu;
            }
            timingLinePopupMenu.setAnchored(this.isAnchored());
            return timingLinePopupMenu;
        }

        public int getAxisLocation() {
            return SGFigureElementTimingLine.this.mAxisElement.getLocationInPlane(this.mAxis);
        }

        public boolean setAxisLocation(int n) {
            SGAxis sGAxis = SGFigureElementTimingLine.this.mAxisElement.getAxisInPlane(n);
            if (sGAxis == null) {
                return false;
            }
            this.mAxis = sGAxis;
            return true;
        }

        private boolean setDrawingElementsLocation() {
            SGAxis sGAxis = this.mAxis;
            double d = this.mValue;
            boolean bl = this.isHorizontal();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[]{new SGTuple2f(), new SGTuple2f()};
            if (!SGFigureElementTimingLine.this.calcLocationOfTimingLine(d, sGAxis, bl, sGTuple2fArray[0], sGTuple2fArray[1])) {
                this.setValid(false);
                return false;
            }
            this.setValid(true);
            this.mStart.setValues(sGTuple2fArray[0]);
            this.mEnd.setValues(sGTuple2fArray[1]);
            return this.setLocation(this.mStart.x, this.mStart.y);
        }

        public boolean setLocation(float f, float f2) {
            float f3 = this.getMagnification();
            float f4 = (f - SGFigureElementTimingLine.this.mGraphRectX) / f3;
            float f5 = (f2 - SGFigureElementTimingLine.this.mGraphRectY) / f3;
            this.mLocation.setValues(f4, f5);
            return true;
        }

        private boolean setAxisValue() {
            SGAxis sGAxis = this.mAxis;
            boolean bl = this.isHorizontal();
            float f = bl ? this.getMagnification() * this.mLocation.x + SGFigureElementTimingLine.this.mGraphRectX : this.getMagnification() * this.mLocation.y + SGFigureElementTimingLine.this.mGraphRectY;
            double d = SGFigureElementTimingLine.this.calcValue(f, sGAxis, bl);
            if (Double.isNaN(d = SGFigureElementTimingLine.this.getNumberInRangeOrder(d, sGAxis)) || Double.isInfinite(d)) {
                return false;
            }
            this.setValue(d);
            this.setDrawingElementsLocation();
            return true;
        }

        public boolean isValid() {
            return this.mValidFlag;
        }

        public void setValid(boolean bl) {
            this.mValidFlag = bl;
        }

        public void translate(float f, float f2) {
            SGAxis sGAxis = this.mAxis;
            boolean bl = this.isHorizontal();
            float f3 = SGFigureElementTimingLine.this.calcLocation(this.getValue(), sGAxis, bl);
            float f4 = this.isHorizontal() ? f3 + f : f3 + f2;
            double d = SGFigureElementTimingLine.this.calcValue(f4, sGAxis, bl);
            d = SGFigureElementTimingLine.this.getNumberInRangeOrder(d, sGAxis);
            this.setValue(d);
            this.setDrawingElementsLocation();
        }

        private boolean isHorizontal() {
            ArrayList arrayList = SGFigureElementTimingLine.this.mAxisElement.getHorizontalAxisList();
            ArrayList arrayList2 = SGFigureElementTimingLine.this.mAxisElement.getPerpendicularAxisList();
            Boolean bl = null;
            if (arrayList.contains(this.mAxis)) {
                bl = Boolean.TRUE;
            }
            if (arrayList2.contains(this.mAxis)) {
                bl = Boolean.FALSE;
            }
            if (bl == null) {
                throw new Error("");
            }
            return bl;
        }

        public boolean hasValidValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mAxis : SGFigureElementTimingLine.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getValue();
            return sGAxis.isValidValue(d);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGFigureElementTimingLine.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") || string.equals("Cut") || string.equals("Paste") || string.equals("Delete") || string.equals("Duplicate") || string.equals("Bring to Front") || string.equals("Bring Forward") || string.equals("Send Backward") || string.equals("Send to Back")) {
                SGFigureElementTimingLine.this.notifyToListener(string);
            } else if (string.equals("Anchored")) {
                SGFigureElementTimingLine.this.notifyToListener(string, actionEvent.getSource());
            }
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.setChanged(true);
            }
            this.mTemporaryProperties = null;
            this.setDrawingElementsLocation();
            SGFigureElementTimingLine.this.repaint();
            SGFigureElementTimingLine.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.setDrawingElementsLocation();
            SGFigureElementTimingLine.this.repaint();
            SGFigureElementTimingLine.this.notifyChange();
            return true;
        }

        public boolean preview() {
            this.setDrawingElementsLocation();
            SGFigureElementTimingLine.this.repaint();
            SGFigureElementTimingLine.this.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            SGPropertyDialog sGPropertyDialog = null;
            if (SGFigureElementTimingLine.this.mPropertyDialog != null) {
                sGPropertyDialog = SGFigureElementTimingLine.this.mPropertyDialog;
            } else {
                sGPropertyDialog = new SGTimingLineDialog(SGFigureElementTimingLine.this.mDialogOwner, true);
                SGFigureElementTimingLine.this.mPropertyDialog = sGPropertyDialog;
            }
            return sGPropertyDialog;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public SGProperties getMemento() {
            return this.getProperties();
        }

        public boolean setMemento(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public boolean setMementoBackward() {
            if (!this.mUndoManager.setMementoBackward()) {
                return false;
            }
            SGFigureElementTimingLine.this.setAllDrawingElementsLocation();
            SGFigureElementTimingLine.this.notifyChangeOnUndo();
            return true;
        }

        public boolean setMementoForward() {
            if (!this.mUndoManager.setMementoForward()) {
                return false;
            }
            SGFigureElementTimingLine.this.setAllDrawingElementsLocation();
            SGFigureElementTimingLine.this.notifyChangeOnUndo();
            return true;
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public boolean deleteForwardHistory() {
            return this.mUndoManager.deleteForwardHistory();
        }

        public void notifyToRoot() {
            SGFigureElementTimingLine.this.notifyToRoot();
        }

        public boolean isChanged() {
            return this.mUndoManager.isChanged();
        }

        public void setChanged(boolean bl) {
            this.mUndoManager.setChanged(bl);
        }

        public boolean isChangedRoot() {
            return this.isChanged();
        }

        public void clearChanged() {
            this.setChanged(false);
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public String getTagName() {
            return "TimingLine";
        }

        public boolean writeProperty(Element element) {
            float f = (float)SGUtilityNumber.roundOffNumber(this.getLineWidth(), -3);
            element.setAttribute("Width", Float.toString(f) + "pt");
            element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.getLineType()));
            ArrayList<Color> arrayList = new ArrayList<Color>();
            arrayList.add(this.getColor());
            element.setAttribute("Color", SGUtilityText.getColorListString(arrayList));
            element.setAttribute("AxisPosition", SGFigureElementTimingLine.this.mAxisElement.getLocationName(this.mAxis));
            element.setAttribute("Value", Double.toString(this.mValue));
            element.setAttribute("Anchored", Boolean.toString(this.mIsAnchored));
            return true;
        }

        public boolean readProperty(Element element) {
            Object object;
            String string = null;
            Number number = null;
            List<Color> list = null;
            string = element.getAttribute("Width");
            if (string.length() != 0) {
                object = new StringBuffer();
                number = SGUtilityText.getNumber(string, (StringBuffer)object);
                if (number == null) {
                    return false;
                }
                float f = number.floatValue();
                if (!this.setLineWidth(f, ((StringBuffer)object).toString())) {
                    return false;
                }
            }
            if ((string = element.getAttribute("Type")).length() != 0) {
                number = SGDrawingElementLine.getLineTypeFromName(string);
                if (number == null) {
                    return false;
                }
                int n = number.intValue();
                if (!this.setLineType(n)) {
                    return false;
                }
            }
            if ((string = element.getAttribute("Color")).length() != 0) {
                list = SGUtilityText.getColorList(string);
                if (list == null) {
                    return false;
                }
                if (list.size() == 0) {
                    return false;
                }
                object = list.get(0);
                if (!this.setColor((Color)object)) {
                    return false;
                }
            }
            if ((string = element.getAttribute("AxisPosition")).length() != 0) {
                object = SGFigureElementTimingLine.this.mAxisElement.getAxis(string);
                if (object == null) {
                    return false;
                }
                this.setAxis((SGAxis)object);
            }
            if ((string = element.getAttribute("Value")).length() != 0) {
                number = SGUtilityText.getDouble(string);
                if (number == null) {
                    return false;
                }
                double d = number.doubleValue();
                if (!this.mAxis.isValidValue(d)) {
                    return false;
                }
                this.setValue(d);
            }
            if ((string = element.getAttribute("Anchored")).length() != 0) {
                Boolean bl = SGUtilityText.getBoolean(string);
                if (bl == null) {
                    return false;
                }
                this.setAnchored(bl);
            }
            return true;
        }

        public Object copy() {
            TimingLine timingLine = new TimingLine();
            timingLine.setProperties(this.getProperties());
            timingLine.mTempAxis = SGFigureElementTimingLine.this.mAxisElement.getLocationInPlane(this.mAxis);
            return timingLine;
        }

        public SGTuple2f getEnd() {
            return this.mEnd;
        }

        public SGTuple2f getStart() {
            return this.mStart;
        }

        protected SGStroke getStroke() {
            return this.mStroke;
        }

        public boolean setColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl == null");
            }
            this.mColor = color;
            return true;
        }

        public boolean setLineType(int n) {
            if (!SGDrawingElementLine.isValidLineType(n)) {
                return false;
            }
            this.mStroke.setLineType(n);
            return true;
        }

        public boolean setLineWidth(float f) {
            this.mStroke.setLineWidth(f);
            return true;
        }

        public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
            this.mStart.setValues(sGTuple2f);
            this.mEnd.setValues(sGTuple2f2);
            return true;
        }

        public float getMagnification() {
            return SGFigureElementTimingLine.this.getMagnification();
        }

        public boolean setMagnification(float f) {
            this.mStroke.setMagnification(f);
            return true;
        }

        public boolean isInsideRange() {
            return this.mAxis.insideRange(this.mValue);
        }

        public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
            SGPropertyResults sGPropertyResults = new SGPropertyResults();
            if (!this.prepare()) {
                return null;
            }
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = sGPropertyMap.getValueString(string);
                if ("Axis".equalsIgnoreCase(string)) {
                    int n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults.putResult("Axis", 1);
                        continue;
                    }
                    if (!this.setAxisLocation(n)) {
                        sGPropertyResults.putResult("Axis", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Axis", 0);
                    continue;
                }
                if ("Value".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("Value", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("Value", 1);
                        continue;
                    }
                    if (!this.setValue(d)) {
                        sGPropertyResults.putResult("Value", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Value", 0);
                    continue;
                }
                if ("LineWidth".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults.putResult("LineWidth", 1);
                        continue;
                    }
                    if (!this.setLineWidth(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults.putResult("LineWidth", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("LineWidth", 0);
                    continue;
                }
                if ("LineType".equalsIgnoreCase(string)) {
                    Integer n = SGDrawingElementLine.getLineTypeFromName(string2);
                    if (n == null) {
                        sGPropertyResults.putResult("LineType", 1);
                        continue;
                    }
                    if (!this.setLineType(n)) {
                        sGPropertyResults.putResult("LineType", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("LineType", 0);
                    continue;
                }
                if ("Color".equalsIgnoreCase(string)) {
                    Color color = SGUtilityText.getColor(string2);
                    if (color != null) {
                        if (!this.setColor(color)) {
                            sGPropertyResults.putResult("Color", 1);
                            continue;
                        }
                    } else {
                        color = SGUtilityText.parseColor(string2);
                        if (color == null) {
                            sGPropertyResults.putResult("Color", 1);
                            continue;
                        }
                        if (!this.setColor(color)) {
                            sGPropertyResults.putResult("Color", 1);
                            continue;
                        }
                    }
                    sGPropertyResults.putResult("Color", 0);
                    continue;
                }
                if (!"Anchored".equalsIgnoreCase(string)) continue;
                Boolean bl = SGUtilityText.getBoolean(string2);
                if (bl == null) {
                    sGPropertyResults.putResult("Anchored", 1);
                    continue;
                }
                if (!this.setAnchored(bl)) {
                    sGPropertyResults.putResult("Anchored", 1);
                    continue;
                }
                sGPropertyResults.putResult("Anchored", 0);
            }
            if (!this.commit()) {
                return null;
            }
            this.notifyToRoot();
            SGFigureElementTimingLine.this.notifyChange();
            SGFigureElementTimingLine.this.repaint();
            return sGPropertyResults;
        }
    }

    private static class TimingLinePopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = -121087808318837856L;
        private JCheckBoxMenuItem anchoredCheckBox;

        private TimingLinePopupMenu() {
        }

        void init(TimingLine timingLine) {
            this.setBounds(0, 0, 100, 100);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  -- Timing Line: ");
            stringBuffer.append(timingLine.getID());
            stringBuffer.append(" --");
            this.add(new JLabel(stringBuffer.toString()));
            this.addSeparator();
            SGUtility.addItem(this, timingLine, "Bring to Front");
            SGUtility.addItem(this, timingLine, "Bring Forward");
            SGUtility.addItem(this, timingLine, "Send Backward");
            SGUtility.addItem(this, timingLine, "Send to Back");
            this.addSeparator();
            SGUtility.addItem(this, timingLine, "Cut");
            SGUtility.addItem(this, timingLine, "Copy");
            SGUtility.addItem(this, timingLine, "Paste");
            this.addSeparator();
            SGUtility.addItem(this, timingLine, "Delete");
            SGUtility.addItem(this, timingLine, "Duplicate");
            this.addSeparator();
            this.anchoredCheckBox = new JCheckBoxMenuItem("Anchored");
            this.add(this.anchoredCheckBox);
            this.anchoredCheckBox.addActionListener(timingLine);
            this.addSeparator();
            SGUtility.addItem(this, timingLine, "Property");
        }

        void setAnchored(boolean bl) {
            this.anchoredCheckBox.setSelected(bl);
        }
    }

    private static class GuideArrow
    extends SGSimpleArrow2D {
        public GuideArrow() {
            this.setStartHeadType(-1);
            this.setEndHeadType(10);
            this.setLineWidth(3.0f);
            this.setLineType(1);
            this.setColor(Color.RED);
            this.setHeadSize(12.0f);
            this.setHeadAngle(Float.valueOf(36.0f), Float.valueOf(60.0f));
        }
    }
}

