/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIChildObject;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGISignificantDifferenceConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSignificantDifference2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElement2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISignificantDifferenceDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSignificantDifferenceDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGFigureElementSignificantDifference
extends SGFigureElement2D
implements SGIFigureElementSignificantDifference,
SGISignificantDifferenceConstants,
SGIStringConstants,
CaretListener,
DocumentListener,
ActionListener,
KeyListener {
    private SGIFigureElementAxis mAxisElement = null;
    private JTextField mEditField = null;
    private SigDiffSymbol mEditingSymbol = null;
    private SGPropertyDialog mPropertyDialog = null;

    public SGFigureElementSignificantDifference() {
        this.initEditField();
    }

    private void initEditField() {
        this.mEditField = new JTextField(10);
        this.mEditField.setVisible(false);
        this.mEditField.addActionListener(this);
        this.mEditField.addCaretListener(this);
        this.mEditField.getDocument().addDocumentListener(this);
        this.mEditField.addKeyListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mPropertyDialog != null) {
            this.mPropertyDialog.dispose();
            this.mPropertyDialog = null;
        }
        this.mAxisElement = null;
        this.mEditField = null;
        this.mEditingSymbol = null;
    }

    @Override
    public boolean addSignificantDifferenceSymbol(float f, float f2) {
        if (!this.getGraphRect().contains(f, f2)) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        return this.addSignificantDifferenceSymbol(this.assignChildId(), f, f2, sGAxis, sGAxis2);
    }

    private boolean addSignificantDifferenceSymbol(int n, float f, float f2, SGAxis sGAxis, SGAxis sGAxis2) {
        SigDiffSymbol sigDiffSymbol = new SigDiffSymbol();
        sigDiffSymbol.setMagnification(this.mMagnification);
        sigDiffSymbol.mXAxis = sGAxis;
        sigDiffSymbol.mYAxis = sGAxis2;
        if (!sigDiffSymbol.setLocation(f, f2)) {
            return false;
        }
        if (!sigDiffSymbol.createDrawingElement()) {
            return false;
        }
        if (!sigDiffSymbol.setAxisValuesWithShape()) {
            return false;
        }
        if (!this.addToList(n, sigDiffSymbol)) {
            return true;
        }
        sigDiffSymbol.initPropertiesHistory();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    @Override
    public boolean addSignificantDifferenceSymbol(int n, double d, double d2) {
        return this.addSignificantDifferenceSymbol(n, d, d2, "Bottom", "Left");
    }

    @Override
    public boolean addSignificantDifferenceSymbol(int n, double d, double d2, String string, String string2) {
        float f;
        SGAxis sGAxis = this.mAxisElement.getAxis(string);
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string2);
        if (sGAxis == null || sGAxis2 == null) {
            return false;
        }
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        if (!sGAxis2.isValidValue(d2)) {
            return false;
        }
        float f2 = this.calcLocation(d, sGAxis, true);
        return this.addSignificantDifferenceSymbol(n, f2, f = this.calcLocation(d2, sGAxis2, false), sGAxis, sGAxis2);
    }

    @Override
    public boolean addSignificantDifferenceSymbol(int n, double d, double d2, double d3, double d4, double d5) {
        return this.addSignificantDifferenceSymbol(n, d, d2, d3, d4, d5, "Bottom", "Left");
    }

    private boolean addSignificantDifferenceSymbol(int n, double d, double d2, double d3, double d4, double d5, String string, String string2) {
        String string3 = string != null ? string : "Bottom";
        String string4 = string2 != null ? string2 : "Left";
        SGAxis sGAxis = this.mAxisElement.getAxis(string3);
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string4);
        if (sGAxis == null || sGAxis2 == null) {
            return false;
        }
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        if (!sGAxis.isValidValue(d3)) {
            return false;
        }
        if (!sGAxis2.isValidValue(d2)) {
            return false;
        }
        if (!sGAxis2.isValidValue(d4)) {
            return false;
        }
        if (!sGAxis2.isValidValue(d5)) {
            return false;
        }
        SigDiffSymbol sigDiffSymbol = new SigDiffSymbol();
        sigDiffSymbol.setMagnification(this.mMagnification);
        sigDiffSymbol.mXAxis = sGAxis;
        sigDiffSymbol.mYAxis = sGAxis2;
        if (!sigDiffSymbol.createDrawingElement()) {
            return false;
        }
        if (!sigDiffSymbol.setLeftXValue(d)) {
            return false;
        }
        if (!sigDiffSymbol.setLeftYValue(d2)) {
            return false;
        }
        if (!sigDiffSymbol.setRightXValue(d3)) {
            return false;
        }
        if (!sigDiffSymbol.setRightYValue(d4)) {
            return false;
        }
        if (!sigDiffSymbol.setHorizontalYValue(d5)) {
            return false;
        }
        if (!this.addToList(n, sigDiffSymbol)) {
            return true;
        }
        sigDiffSymbol.initPropertiesHistory();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    @Override
    public void setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
    }

    @Override
    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIFigureElementGraph || sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementLegend)) {
            if (sGIFigureElement instanceof SGIFigureElementAxis) {
                bl = this.synchronizeToAxisElement((SGIFigureElementAxis)sGIFigureElement, string);
            } else if (!(sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return bl;
    }

    private boolean synchronizeToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)list.get(i);
            if (!sigDiffSymbol.isAnchored() ? !sigDiffSymbol.setShapeWithAxesValues() : !sigDiffSymbol.setAxisValuesWithShape()) continue;
            sigDiffSymbol.setChanged(true);
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    @Override
    public SGProperties getProperties() {
        SigDiffElementProperties sigDiffElementProperties = new SigDiffElementProperties();
        if (!this.getProperties(sigDiffElementProperties)) {
            return null;
        }
        return sigDiffElementProperties;
    }

    @Override
    public String getTagName() {
        return "SignificantDifferenceSymbols";
    }

    @Override
    public boolean writeProperty(Element element) {
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("SignificantDifferenceSymbol");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            SigDiffSymbol sigDiffSymbol = new SigDiffSymbol();
            Element element2 = (Element)node;
            if (!sigDiffSymbol.readProperty(element2)) {
                return false;
            }
            sigDiffSymbol.initPropertiesHistory();
            this.addToList(sigDiffSymbol);
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mEditField)) {
            this.closeTextField();
        }
    }

    @Override
    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        if (!super.setGraphRect(f, f2, f3, f4)) {
            return false;
        }
        if (!this.closeTextField()) {
            return false;
        }
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)list.get(i);
            if (!sigDiffSymbol.isAnchored()) {
                sigDiffSymbol.setShapeWithAxesValues();
                continue;
            }
            sigDiffSymbol.setAxisValuesWithShape();
        }
        return true;
    }

    @Override
    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        List<SGIChildObject> list = this.getVisibleChildList();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < list.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)list.get(i);
            Rectangle2D rectangle2D = sigDiffSymbol.getElementBounds();
            arrayList.add(rectangle2D);
        }
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        float f = this.mGraphRectY - (float)rectangle2D.getY();
        float f2 = -(this.mGraphRectY + this.mGraphRectHeight) + (float)(rectangle2D.getY() + rectangle2D.getHeight());
        float f3 = this.mGraphRectX - (float)rectangle2D.getX();
        float f4 = -(this.mGraphRectX + this.mGraphRectWidth) + (float)(rectangle2D.getX() + rectangle2D.getWidth());
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    @Override
    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        SigDiffSymbol sigDiffSymbol;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        List<SGIChildObject> list = this.getVisibleChildList();
        for (n = 0; n < list.size(); ++n) {
            sigDiffSymbol = (SigDiffSymbol)list.get(n);
            if (!sigDiffSymbol.isValid()) continue;
            sigDiffSymbol.paint(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < list.size(); ++n) {
                sigDiffSymbol = (SigDiffSymbol)list.get(n);
                if (!sigDiffSymbol.isValid()) continue;
                object = sigDiffSymbol.getAnchorPointList();
                if (!sigDiffSymbol.isAnchored()) {
                    SGUtilityForFigureElementJava2D.drawAnchorAsChildObject((List)object, graphics2D);
                    continue;
                }
                SGUtilityForFigureElementJava2D.drawAnchorPointsAsAnchoredChildObject((List<Point2D>)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList = this.getFocusedObjectsList();
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (SigDiffSymbol)arrayList.get(i);
                if (!((SigDiffSymbol)object).isValid()) continue;
                ArrayList arrayList2 = ((SigDiffSymbol)object).getAnchorPointList();
                if (!((SigDiffSymbol)object).isAnchored()) {
                    SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(arrayList2, graphics2D);
                    continue;
                }
                SGUtilityForFigureElementJava2D.drawAnchorPointsAsAnchoredForcusObject(arrayList2, graphics2D);
            }
        }
    }

    @Override
    public boolean onDrawingElement(int n, int n2) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)list.get(i);
            if (!sigDiffSymbol.isValid() || !sigDiffSymbol.contains(n, n2)) continue;
            if (sigDiffSymbol.isSelected()) {
                sigDiffSymbol.mMouseLocation = sigDiffSymbol.getMouseLocation(n, n2);
                this.setMouseCursor(sigDiffSymbol.getCursor(sigDiffSymbol.mMouseLocation));
                return true;
            }
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseClicked(MouseEvent mouseEvent) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)list.get(i);
            if (!sigDiffSymbol.isValid() || !this.clickDrawingElements(sigDiffSymbol, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    private boolean clickDrawingElements(SigDiffSymbol sigDiffSymbol, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getModifiers();
        boolean bl = (n3 & 2) != 0;
        boolean bl2 = (n3 & 1) != 0;
        int n4 = mouseEvent.getClickCount();
        if (sigDiffSymbol.contains(n, n2)) {
            if (sigDiffSymbol.getStringElement().contains(n, n2)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && n4 == 1) {
                    if (sigDiffSymbol.isSelected() && !bl && !bl2) {
                        this.mEditingSymbol = sigDiffSymbol;
                        Rectangle2D rectangle2D = sigDiffSymbol.getStringBounds();
                        int n5 = this.mPressedPoint.x - (int)rectangle2D.getX();
                        int n6 = this.mPressedPoint.y - (int)rectangle2D.getY();
                        this.showEditField(this.mEditField, (SGDrawingElementString2D)sigDiffSymbol.getStringElement(), n5, n6);
                    } else {
                        this.updateFocusedObjectsList((SGISelectable)sigDiffSymbol, mouseEvent);
                    }
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && n4 == 1) {
                    this.updateFocusedObjectsList((SGISelectable)sigDiffSymbol, mouseEvent);
                    sigDiffSymbol.getPopupMenu().show(this.getComponent(), n, n2);
                }
            } else {
                this.updateFocusedObjectsList((SGISelectable)sigDiffSymbol, mouseEvent);
                if (!SwingUtilities.isLeftMouseButton(mouseEvent) || n4 != 1) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && n4 == 2) {
                        this.setPropertiesOfSelectedObjects();
                    } else if (SwingUtilities.isRightMouseButton(mouseEvent) && n4 == 1) {
                        sigDiffSymbol.getPopupMenu().show(this.getComponent(), n, n2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void translateFocusedObjects(int n, int n2) {
        if (!this.closeTextField()) {
            return;
        }
        super.translateFocusedObjects(n, n2);
    }

    @Override
    public boolean onMousePressed(MouseEvent mouseEvent) {
        if (!this.closeTextField()) {
            return false;
        }
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)list.get(i);
            if (!sigDiffSymbol.isValid() || !sigDiffSymbol.pressDrawingElements(mouseEvent)) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            if (sigDiffSymbol.isSelected()) {
                this.mDraggableFlag = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (!this.mDraggableFlag) {
            return false;
        }
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 1) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(0);
            if (!sigDiffSymbol.isValid()) {
                return false;
            }
            if (!sigDiffSymbol.drag(mouseEvent)) {
                return false;
            }
            sigDiffSymbol.createDrawingElement();
            if (!sigDiffSymbol.setAxisValuesWithShape()) {
                return false;
            }
            if (!sigDiffSymbol.setShapeWithAxesValues()) {
                return false;
            }
            this.mPressedPoint = mouseEvent.getPoint();
            return true;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            sigDiffSymbol.translate(n, n2);
            sigDiffSymbol.createDrawingElement();
            if (!sigDiffSymbol.setAxisValuesWithShape()) {
                return false;
            }
            if (sigDiffSymbol.setShapeWithAxesValues()) continue;
            return false;
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent mouseEvent) {
        this.mDraggableFlag = false;
        return true;
    }

    @Override
    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            sigDiffSymbol.mTemporaryProperties = sigDiffSymbol.getProperties();
        }
        return true;
    }

    @Override
    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    @Override
    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)arrayList.get(i);
            SGProperties sGProperties2 = sigDiffSymbol.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = sigDiffSymbol.getProperties()).equals(sGProperties2)) continue;
            sigDiffSymbol.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean clearFocusedObjects() {
        if (!super.clearFocusedObjects()) {
            return false;
        }
        return this.closeTextField();
    }

    @Override
    public String getClassDescription() {
        return "Significant Difference Symbols";
    }

    @Override
    public void setComponent(JComponent jComponent) {
        super.setComponent(jComponent);
        jComponent.add(this.mEditField);
    }

    @Override
    public boolean closeTextField() {
        if (this.mEditField.isVisible()) {
            return this.commitEdit();
        }
        return true;
    }

    private boolean hideEditField() {
        this.mEditField.setText("");
        this.mEditField.setVisible(false);
        return true;
    }

    private boolean commitEdit() {
        if (this.mEditingSymbol == null) {
            return false;
        }
        String string = this.mEditingSymbol.getStringElement().getString();
        String string2 = this.mEditField.getText();
        if (SGUtilityText.isValidString(string2)) {
            this.mEditingSymbol.setText(string2);
            if (!string.equals(string2)) {
                this.mEditingSymbol.setChanged(true);
                this.notifyToRoot();
            }
            this.mEditingSymbol.createDrawingElement();
        }
        this.mEditingSymbol = null;
        this.hideEditField();
        this.repaint();
        return true;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffElementProperties)) {
            return false;
        }
        SigDiffElementProperties sigDiffElementProperties = (SigDiffElementProperties)sGProperties;
        sigDiffElementProperties.visibleSigDiffSymbolList = new ArrayList<SGIChildObject>(this.getVisibleChildList());
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffElementProperties)) {
            return false;
        }
        SigDiffElementProperties sigDiffElementProperties = (SigDiffElementProperties)sGProperties;
        boolean bl = this.setVisibleChildList(sigDiffElementProperties.visibleSigDiffSymbolList);
        return bl;
    }

    @Override
    public Element[] createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)list.get(i);
            if (!sigDiffSymbol.isValid()) continue;
            Element element2 = sigDiffSymbol.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return new Element[]{element};
    }

    @Override
    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.notifyChangeOnUndo();
        this.clearFocusedObjects();
        return true;
    }

    @Override
    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.notifyChangeOnUndo();
        this.clearFocusedObjects();
        return true;
    }

    @Override
    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        List<SGICopiable> list = this.duplicateObjects();
        for (int i = 0; i < list.size(); ++i) {
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)list.get(i);
            sigDiffSymbol.setShapeWithAxesValues();
            sigDiffSymbol.translate(n, n2);
            sigDiffSymbol.setSelected(true);
            this.addToList(sigDiffSymbol);
            sigDiffSymbol.initPropertiesHistory();
        }
        if (list.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean paste(List<SGICopiable> list) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            SGICopiable sGICopiable = list.get(i);
            if (!(sGICopiable instanceof SigDiffSymbol)) continue;
            SigDiffSymbol sigDiffSymbol = (SigDiffSymbol)sGICopiable;
            sigDiffSymbol.setShapeWithAxesValues();
            sigDiffSymbol.translate(n, n2);
            SGProperties sGProperties = sigDiffSymbol.getProperties();
            SigDiffSymbol sigDiffSymbol2 = new SigDiffSymbol();
            sigDiffSymbol2.setMagnification(f);
            sigDiffSymbol2.setProperties(sGProperties);
            sigDiffSymbol2.mXAxis = this.mAxisElement.getAxisInPlane(sigDiffSymbol.mTempXAxis);
            sigDiffSymbol2.mYAxis = this.mAxisElement.getAxisInPlane(sigDiffSymbol.mTempYAxis);
            sigDiffSymbol2.setShapeWithAxesValues();
            this.addToList(sigDiffSymbol2);
            sigDiffSymbol2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            SigDiffElementProperties sigDiffElementProperties = (SigDiffElementProperties)list.get(i);
            hashSet.addAll(sigDiffElementProperties.visibleSigDiffSymbolList);
        }
        return hashSet;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        char c = keyEvent.getKeyChar();
        if (object.equals(this.mEditField) && c == '\u001b') {
            this.hideEditField();
            this.mEditingSymbol = null;
        }
    }

    @Override
    public boolean setDialogOwner(Frame frame) {
        if (!super.setDialogOwner(frame)) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SGFigureElementSignificantDifference.this.mPropertyDialog == null) {
                    SGFigureElementSignificantDifference.this.mPropertyDialog = new SGSignificantDifferenceDialog(SGFigureElementSignificantDifference.this.mDialogOwner, true);
                }
            }
        });
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    private void updateLabelTextField() {
        if (this.mEditingSymbol != null) {
            Font font = new Font(this.mEditingSymbol.getFontName(), this.mEditingSymbol.getFontStyle(), (int)(this.mEditingSymbol.getFontSize() * this.getMagnification()));
            this.updateTextField(this.mEditField, font);
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void onMenuSelected() {
        this.closeTextField();
    }

    @Override
    public SGPropertyResults setChildProperties(int n, SGPropertyMap sGPropertyMap) {
        Object object;
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (sGIChildObject == null) {
            Object object2;
            Object object3;
            object = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = object3.toString();
                if ("HorizontalY".equalsIgnoreCase((String)object2)) {
                    object = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("LeftX".equalsIgnoreCase((String)object2)) {
                    string = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("LeftY".equalsIgnoreCase((String)object2)) {
                    string2 = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("RightX".equalsIgnoreCase((String)object2)) {
                    string3 = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("RightY".equalsIgnoreCase((String)object2)) {
                    string4 = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("AxisX".equalsIgnoreCase((String)object2)) {
                    string5 = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if (!"AxisY".equalsIgnoreCase((String)object2)) continue;
                string6 = sGPropertyMap.getValueString((String)object2);
            }
            if (object == null) {
                return null;
            }
            if (string == null) {
                return null;
            }
            if (string2 == null) {
                return null;
            }
            if (string3 == null) {
                return null;
            }
            if (string4 == null) {
                return null;
            }
            object3 = SGUtilityText.getDouble((String)object);
            object2 = SGUtilityText.getDouble(string);
            Double d = SGUtilityText.getDouble(string2);
            Double d2 = SGUtilityText.getDouble(string3);
            Double d3 = SGUtilityText.getDouble(string4);
            if (object3 == null) {
                return null;
            }
            if (object2 == null) {
                return null;
            }
            if (d == null) {
                return null;
            }
            if (d2 == null) {
                return null;
            }
            if (d3 == null) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue((Double)object2)) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue(d)) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue(d2)) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue(d3)) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue((Double)object3)) {
                return null;
            }
            if (!this.addSignificantDifferenceSymbol(n, (Double)object2, d, d2, d3, (Double)object3, string5, string6)) {
                return null;
            }
            sGIChildObject = this.getVisibleChild(n);
        }
        object = sGIChildObject.setProperties(sGPropertyMap);
        return object;
    }

    public static class SigDiffPropertiesWithAxes
    extends SGDrawingElementSignificantDifference.SigDiffProperties {
        private double mLeftXValue;
        private double mRightXValue;
        private double mLeftYValue;
        private double mRightYValue;
        private double mHorizontalYValue;
        private SGAxis mXAxis;
        private SGAxis mYAxis;
        private boolean mAnchored;

        public boolean equals(Object object) {
            if (!(object instanceof SigDiffPropertiesWithAxes)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = (SigDiffPropertiesWithAxes)object;
            if (sigDiffPropertiesWithAxes.mLeftXValue != this.mLeftXValue) {
                return false;
            }
            if (sigDiffPropertiesWithAxes.mRightXValue != this.mRightXValue) {
                return false;
            }
            if (sigDiffPropertiesWithAxes.mLeftYValue != this.mLeftYValue) {
                return false;
            }
            if (sigDiffPropertiesWithAxes.mRightYValue != this.mRightYValue) {
                return false;
            }
            if (sigDiffPropertiesWithAxes.mHorizontalYValue != this.mHorizontalYValue) {
                return false;
            }
            if (!sigDiffPropertiesWithAxes.mXAxis.equals(this.mXAxis)) {
                return false;
            }
            if (!sigDiffPropertiesWithAxes.mYAxis.equals(this.mYAxis)) {
                return false;
            }
            return sigDiffPropertiesWithAxes.mAnchored == this.mAnchored;
        }

        public double getLeftXValue() {
            return this.mLeftXValue;
        }

        public double getLeftYValue() {
            return this.mLeftYValue;
        }

        public double getRightXValue() {
            return this.mRightXValue;
        }

        public double getRightYValue() {
            return this.mRightYValue;
        }

        public double getHorizontalYValue() {
            return this.mHorizontalYValue;
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public boolean getAnchored() {
            return this.mAnchored;
        }

        public void setLeftXValue(double d) {
            this.mLeftXValue = d;
        }

        public void setLeftYValue(double d) {
            this.mLeftYValue = d;
        }

        public void setRightXValue(double d) {
            this.mRightXValue = d;
        }

        public void setRightYValue(double d) {
            this.mRightYValue = d;
        }

        public void setHorizontalYValue(double d) {
            this.mHorizontalYValue = d;
        }

        public void setXAxis(SGAxis sGAxis) {
            if (sGAxis == null) {
                throw new IllegalArgumentException("axis==null");
            }
            this.mXAxis = sGAxis;
        }

        public void setYAxis(SGAxis sGAxis) {
            if (sGAxis == null) {
                throw new IllegalArgumentException("axis==null");
            }
            this.mYAxis = sGAxis;
        }

        public void setAnchored(boolean bl) {
            this.mAnchored = bl;
        }
    }

    private class SigDiffSymbol
    extends SGDrawingElementSignificantDifference2D
    implements ActionListener,
    SGIUndoable,
    SGFigureElement.IMovableChild,
    SGICopiable,
    SGISignificantDifferenceDialogObserver,
    SGINode {
        private int mID;
        private SigDiffSymbol mTempSymbol = null;
        private boolean mSelectedFlag = false;
        private SGAxis mXAxis = null;
        private SGAxis mYAxis = null;
        private double mXValue1;
        private double mXValue2;
        private double mHorizontalYValue;
        private double mYValue1;
        private double mYValue2;
        private boolean mIsAnchored;
        private SGProperties mTemporaryProperties = null;
        private SigDiffSymbolPopupMenu mPopupMenu = null;
        private int mTempXAxis = -1;
        private int mTempYAxis = -1;
        private boolean mFlippingHorizontalFlag;
        private int mMouseLocation;
        private boolean mValidFlag = true;
        private SGUndoManager mUndoManager = new SGUndoManager(this);

        public int getID() {
            return this.mID;
        }

        public boolean setID(int n) {
            this.mID = n;
            return true;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        public String toString() {
            return "SigDiff:" + this.mID;
        }

        public void dispose() {
            super.dispose();
            this.mPopupMenu = null;
            if (this.mTemporaryProperties != null) {
                this.mTemporaryProperties.dispose();
                this.mTemporaryProperties = null;
            }
            this.mTempSymbol = null;
            this.mUndoManager.dispose();
            this.mUndoManager = null;
            this.mXAxis = null;
            this.mYAxis = null;
        }

        private SigDiffSymbol() {
            this.init();
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            String string = SGFigureElementSignificantDifference.this.mAxisElement.getLocationName(this.mXAxis);
            String string2 = SGFigureElementSignificantDifference.this.mAxisElement.getLocationName(this.mYAxis);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.mID);
            stringBuffer.append(": ");
            stringBuffer.append(SGUtility.removeEscapeChar(this.getText()));
            stringBuffer.append(", AxisX=");
            stringBuffer.append(string.toString());
            stringBuffer.append(", AxisY=");
            stringBuffer.append(string2.toString());
            stringBuffer.append(", LeftX=");
            stringBuffer.append(this.getLeftXValue());
            stringBuffer.append(", RightX=");
            stringBuffer.append(this.getRightXValue());
            stringBuffer.append(", HorizontalY=");
            stringBuffer.append(this.getHorizontalYValue());
            return stringBuffer.toString();
        }

        public int getXAxisLocation() {
            return SGFigureElementSignificantDifference.this.mAxisElement.getLocationInPlane(this.mXAxis);
        }

        public int getYAxisLocation() {
            return SGFigureElementSignificantDifference.this.mAxisElement.getLocationInPlane(this.mYAxis);
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 && n != 1) {
                return false;
            }
            SGAxis sGAxis = SGFigureElementSignificantDifference.this.mAxisElement.getAxisInPlane(n);
            if (sGAxis == null) {
                return false;
            }
            this.mXAxis = sGAxis;
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 && n != 3) {
                return false;
            }
            SGAxis sGAxis = SGFigureElementSignificantDifference.this.mAxisElement.getAxisInPlane(n);
            if (sGAxis == null) {
                return false;
            }
            this.mYAxis = sGAxis;
            return true;
        }

        public float getSpace(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSpace(), string);
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public float getFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getFontSize(), string);
        }

        public boolean setText(String string) {
            if (!SGUtilityText.isValidString(string)) {
                return false;
            }
            return super.setText(string);
        }

        public Object copy() {
            SigDiffSymbol sigDiffSymbol = new SigDiffSymbol();
            sigDiffSymbol.mTempXAxis = SGFigureElementSignificantDifference.this.mAxisElement.getLocationInPlane(this.mXAxis);
            sigDiffSymbol.mTempYAxis = SGFigureElementSignificantDifference.this.mAxisElement.getLocationInPlane(this.mYAxis);
            sigDiffSymbol.setMagnification(this.getMagnification());
            sigDiffSymbol.setProperties(this.getProperties());
            sigDiffSymbol.setLocation(this.getX(), this.getY());
            sigDiffSymbol.setAnchored(this.isAnchored());
            return sigDiffSymbol;
        }

        public JPopupMenu getPopupMenu() {
            SigDiffSymbolPopupMenu sigDiffSymbolPopupMenu = null;
            if (this.mPopupMenu != null) {
                sigDiffSymbolPopupMenu = this.mPopupMenu;
            } else {
                sigDiffSymbolPopupMenu = new SigDiffSymbolPopupMenu();
                sigDiffSymbolPopupMenu.init(this);
                this.mPopupMenu = sigDiffSymbolPopupMenu;
            }
            sigDiffSymbolPopupMenu.setAnchored(this.isAnchored());
            return sigDiffSymbolPopupMenu;
        }

        private boolean init() {
            this.setWidth(1.0f, "cm");
            this.setPerpendicularHeight1(1.0f, "cm");
            this.setPerpendicularHeight2(1.0f, "cm");
            this.setFontSize(24.0f, "pt");
            this.setFontName("Serif");
            this.setFontStyle(0);
            this.setLineWidth(1.0f, "pt");
            this.setColor(DEFAULT_SIGDIFF_SYMBOL_COLOR);
            this.setSpace(0.2f, "cm");
            this.setAnchored(false);
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public String getTagName() {
            return "SignificantDifferenceSymbol";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("LeftX", Double.toString(this.getLeftXValue()));
            element.setAttribute("LeftY", Double.toString(this.getLeftYValue()));
            element.setAttribute("RightX", Double.toString(this.getRightXValue()));
            element.setAttribute("RightY", Double.toString(this.getRightYValue()));
            element.setAttribute("HorizontalY", Double.toString(this.getHorizontalYValue()));
            element.setAttribute("XAxisPosition", SGFigureElementSignificantDifference.this.mAxisElement.getLocationName(this.mXAxis));
            element.setAttribute("YAxisPosition", SGFigureElementSignificantDifference.this.mAxisElement.getLocationName(this.mYAxis));
            element.setAttribute("Anchored", Boolean.toString(this.mIsAnchored));
            return true;
        }

        public boolean readProperty(Element element) {
            SGAxis sGAxis;
            if (!super.readProperty(element)) {
                return false;
            }
            String string = null;
            Double d = null;
            string = element.getAttribute("XAxisPosition");
            if (string.length() != 0) {
                sGAxis = SGFigureElementSignificantDifference.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mXAxis = sGAxis;
            }
            if ((string = element.getAttribute("YAxisPosition")).length() != 0) {
                sGAxis = SGFigureElementSignificantDifference.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mYAxis = sGAxis;
            }
            if ((string = element.getAttribute("LeftX")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d2 = d;
                if (!this.mXAxis.isValidValue(d2)) {
                    return false;
                }
                this.setLeftXValue(d2);
            }
            if ((string = element.getAttribute("LeftY")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d3 = d;
                if (!this.mYAxis.isValidValue(d3)) {
                    return false;
                }
                this.setLeftYValue(d3);
            }
            if ((string = element.getAttribute("RightX")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d4 = d;
                if (!this.mXAxis.isValidValue(d4)) {
                    return false;
                }
                this.setRightXValue(d4);
            }
            if ((string = element.getAttribute("RightY")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d5 = d;
                if (!this.mYAxis.isValidValue(d5)) {
                    return false;
                }
                this.setRightYValue(d5);
            }
            if ((string = element.getAttribute("HorizontalY")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d6 = d;
                if (!this.mYAxis.isValidValue(d6)) {
                    return false;
                }
                this.setHorizontalYValue(d6);
            }
            if ((string = element.getAttribute("Anchored")).length() != 0) {
                Boolean bl = SGUtilityText.getBoolean(string);
                if (bl == null) {
                    return false;
                }
                if (!this.setAnchored(bl)) {
                    return false;
                }
                this.setShapeWithAxesValues();
            }
            return true;
        }

        public SGProperties getProperties() {
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = new SigDiffPropertiesWithAxes();
            if (!this.getProperties(sigDiffPropertiesWithAxes)) {
                return null;
            }
            return sigDiffPropertiesWithAxes;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SigDiffPropertiesWithAxes)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = (SigDiffPropertiesWithAxes)sGProperties;
            sigDiffPropertiesWithAxes.mLeftXValue = this.getLeftXValue();
            sigDiffPropertiesWithAxes.mLeftYValue = this.getLeftYValue();
            sigDiffPropertiesWithAxes.mRightXValue = this.getRightXValue();
            sigDiffPropertiesWithAxes.mRightYValue = this.getRightYValue();
            sigDiffPropertiesWithAxes.mHorizontalYValue = this.getHorizontalYValue();
            sigDiffPropertiesWithAxes.mXAxis = this.mXAxis;
            sigDiffPropertiesWithAxes.mYAxis = this.mYAxis;
            sigDiffPropertiesWithAxes.mAnchored = this.mIsAnchored;
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SigDiffPropertiesWithAxes)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = (SigDiffPropertiesWithAxes)sGProperties;
            this.mXAxis = sigDiffPropertiesWithAxes.mXAxis;
            this.mYAxis = sigDiffPropertiesWithAxes.mYAxis;
            this.setLeftXValue(sigDiffPropertiesWithAxes.mLeftXValue);
            this.setLeftYValue(sigDiffPropertiesWithAxes.mLeftYValue);
            this.setRightXValue(sigDiffPropertiesWithAxes.mRightXValue);
            this.setRightYValue(sigDiffPropertiesWithAxes.mRightYValue);
            this.setHorizontalYValue(sigDiffPropertiesWithAxes.mHorizontalYValue);
            this.setAnchored(sigDiffPropertiesWithAxes.mAnchored);
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGFigureElementSignificantDifference.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") || string.equals("Cut") || string.equals("Paste") || string.equals("Delete") || string.equals("Duplicate") || string.equals("Bring to Front") || string.equals("Bring Forward") || string.equals("Send Backward") || string.equals("Send to Back")) {
                SGFigureElementSignificantDifference.this.notifyToListener(string);
            } else if (string.equals("Anchored")) {
                SGFigureElementSignificantDifference.this.notifyToListener(string, actionEvent.getSource());
            }
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mUndoManager.setChanged(true);
            }
            this.setShapeWithAxesValues();
            SGFigureElementSignificantDifference.this.repaint();
            SGFigureElementSignificantDifference.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            this.setShapeWithAxesValues();
            SGFigureElementSignificantDifference.this.repaint();
            SGFigureElementSignificantDifference.this.notifyChange();
            return true;
        }

        public boolean preview() {
            this.setShapeWithAxesValues();
            SGFigureElementSignificantDifference.this.repaint();
            SGFigureElementSignificantDifference.this.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            SGPropertyDialog sGPropertyDialog = null;
            if (SGFigureElementSignificantDifference.this.mPropertyDialog != null) {
                sGPropertyDialog = SGFigureElementSignificantDifference.this.mPropertyDialog;
            } else {
                sGPropertyDialog = new SGSignificantDifferenceDialog(SGFigureElementSignificantDifference.this.mDialogOwner, true);
                SGFigureElementSignificantDifference.this.mPropertyDialog = sGPropertyDialog;
            }
            return sGPropertyDialog;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public float getX() {
            float f = super.getX();
            return this.getMagnification() * f + SGFigureElementSignificantDifference.this.mGraphRectX;
        }

        public float getY() {
            float f = super.getY();
            return this.getMagnification() * f + SGFigureElementSignificantDifference.this.mGraphRectY;
        }

        public boolean setX(float f) {
            float f2 = (f - SGFigureElementSignificantDifference.this.mGraphRectX) / this.getMagnification();
            super.setX(f2);
            return true;
        }

        public boolean setY(float f) {
            float f2 = (f - SGFigureElementSignificantDifference.this.mGraphRectY) / this.getMagnification();
            super.setY(f2);
            return true;
        }

        public void translate(float f, float f2) {
            this.setLocation(this.getX() + f, this.getY() + f2);
            this.createDrawingElement();
            this.setAxisValuesWithShape();
            this.setShapeWithAxesValues();
        }

        public double getLeftXValue() {
            if (!this.isFlippingHorizontal()) {
                return this.mXValue1;
            }
            return this.mXValue2;
        }

        public double getLeftYValue() {
            if (!this.isFlippingHorizontal()) {
                return this.mYValue1;
            }
            return this.mYValue2;
        }

        public double getRightXValue() {
            if (!this.isFlippingHorizontal()) {
                return this.mXValue2;
            }
            return this.mXValue1;
        }

        public double getRightYValue() {
            if (!this.isFlippingHorizontal()) {
                return this.mYValue2;
            }
            return this.mYValue1;
        }

        public double getHorizontalYValue() {
            return this.mHorizontalYValue;
        }

        public boolean setLeftXValue(double d) {
            if (!this.mXAxis.isValidValue(d)) {
                return false;
            }
            if (!this.isFlippingHorizontal()) {
                this.mXValue1 = d;
            } else {
                this.mXValue2 = d;
            }
            return true;
        }

        public boolean setLeftYValue(double d) {
            if (!this.mYAxis.isValidValue(d)) {
                return false;
            }
            if (!this.isFlippingHorizontal()) {
                this.mYValue1 = d;
            } else {
                this.mYValue2 = d;
            }
            return true;
        }

        public boolean setRightXValue(double d) {
            if (!this.mXAxis.isValidValue(d)) {
                return false;
            }
            if (!this.isFlippingHorizontal()) {
                this.mXValue2 = d;
            } else {
                this.mXValue1 = d;
            }
            return true;
        }

        public boolean setRightYValue(double d) {
            if (!this.mYAxis.isValidValue(d)) {
                return false;
            }
            if (!this.isFlippingHorizontal()) {
                this.mYValue2 = d;
            } else {
                this.mYValue1 = d;
            }
            return true;
        }

        public boolean setHorizontalYValue(double d) {
            if (!this.mYAxis.isValidValue(d)) {
                return false;
            }
            this.mHorizontalYValue = d;
            return true;
        }

        public boolean hasValidValues() {
            Double d = this.getHorizontalYValue();
            Double d2 = this.getLeftXValue();
            Double d3 = this.getLeftYValue();
            Double d4 = this.getRightXValue();
            Double d5 = this.getRightYValue();
            if (!this.mYAxis.isValidValue(d)) {
                return false;
            }
            if (!this.mXAxis.isValidValue(d2)) {
                return false;
            }
            if (!this.mYAxis.isValidValue(d3)) {
                return false;
            }
            if (!this.mXAxis.isValidValue(d4)) {
                return false;
            }
            return this.mYAxis.isValidValue(d5);
        }

        public boolean hasValidHorizontalYValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementSignificantDifference.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getHorizontalYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidLeftXValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mXAxis : SGFigureElementSignificantDifference.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getLeftXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidLeftYValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementSignificantDifference.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getLeftYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidRightXValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mXAxis : SGFigureElementSignificantDifference.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getRightXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidRightYValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementSignificantDifference.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getRightYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean isAnchored() {
            return this.mIsAnchored;
        }

        public boolean setAnchored(boolean bl) {
            this.mIsAnchored = bl;
            return true;
        }

        private boolean pressDrawingElements(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (this.contains(n2, n = mouseEvent.getY()) || this.getStringElement().contains(n2, n)) {
                float f = this.getMagnification();
                this.mTempSymbol = new SigDiffSymbol();
                this.mTempSymbol.setMagnification(f);
                this.mTempSymbol.setLocation(this.getX(), this.getY());
                this.mTempSymbol.setSize(this.getWidth(), this.getPerpendicularHeight1(), this.getPerpendicularHeight2());
                this.mFlippingHorizontalFlag = this.isFlippingHorizontal();
                this.mMouseLocation = this.getMouseLocation(n2, n);
                Cursor cursor = null;
                if (this.mMouseLocation == 0 || this.mMouseLocation == 8) {
                    cursor = Cursor.getPredefinedCursor(13);
                } else {
                    this.getCursor(this.mMouseLocation);
                }
                SGFigureElementSignificantDifference.this.setMouseCursor(cursor);
                return true;
            }
            return false;
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            if (this.isLineVisible()) {
                arrayList.add(this.getLeftTerm());
                arrayList.add(this.getLeftMiddle());
                arrayList.add(this.getLeftJoint());
                arrayList.add(this.getHorizontalMiddle());
                arrayList.add(this.getRightJoint());
                arrayList.add(this.getRightMiddle());
                arrayList.add(this.getRightTerm());
            }
            Rectangle2D rectangle2D = ((SGDrawingElementString2DExtended)this.getStringElement()).getElementBounds();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            Point2D.Float float_ = new Point2D.Float(f, f2);
            Point2D.Float float_2 = new Point2D.Float(f + f3, f2);
            Point2D.Float float_3 = new Point2D.Float(f, f2 + f4);
            Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
            arrayList.add(float_);
            arrayList.add(float_2);
            arrayList.add(float_3);
            arrayList.add(float_4);
            return arrayList;
        }

        private boolean isInside(Point2D point2D, int n, int n2, int n3) {
            return Math.abs(point2D.getX() - (double)n2) < (double)n && Math.abs(point2D.getY() - (double)n3) < (double)n;
        }

        private int getMouseLocation(int n, int n2) {
            Point2D point2D = this.getHorizontalMiddle();
            Point2D point2D2 = this.getLeftMiddle();
            Point2D point2D3 = this.getRightMiddle();
            Point2D point2D4 = this.getLeftJoint();
            Point2D point2D5 = this.getRightJoint();
            Point2D point2D6 = this.getLeftTerm();
            Point2D point2D7 = this.getRightTerm();
            int n3 = -1;
            if (this.isLineVisible()) {
                n3 = this.isInside(point2D, 7, n, n2) ? 1 : (this.isInside(point2D4, 7, n, n2) ? 5 : (this.isInside(point2D5, 7, n, n2) ? 7 : (this.isInside(point2D6, 7, n, n2) ? 4 : (this.isInside(point2D2, 7, n, n2) ? 2 : (this.isInside(point2D7, 7, n, n2) ? 6 : (this.isInside(point2D3, 7, n, n2) ? 3 : 0))))));
            }
            if (this.getStringElement().contains(n, n2)) {
                n3 = 8;
            }
            return n3;
        }

        private Cursor getCursor(int n) {
            Cursor cursor = null;
            switch (n) {
                case 1: {
                    if (!this.isFlippingVertical()) {
                        cursor = new Cursor(8);
                        break;
                    }
                    cursor = new Cursor(9);
                    break;
                }
                case 2: {
                    cursor = new Cursor(10);
                    break;
                }
                case 3: {
                    cursor = new Cursor(11);
                    break;
                }
                case 4: {
                    if (!this.isFlippingVerticalLeft()) {
                        cursor = new Cursor(4);
                        break;
                    }
                    cursor = new Cursor(6);
                    break;
                }
                case 5: {
                    if (!this.isFlippingVerticalLeft()) {
                        cursor = new Cursor(6);
                        break;
                    }
                    cursor = new Cursor(4);
                    break;
                }
                case 6: {
                    if (!this.isFlippingVerticalRight()) {
                        cursor = new Cursor(5);
                        break;
                    }
                    cursor = new Cursor(7);
                    break;
                }
                case 7: {
                    if (!this.isFlippingVerticalRight()) {
                        cursor = new Cursor(7);
                        break;
                    }
                    cursor = new Cursor(5);
                    break;
                }
                case 8: {
                    cursor = new Cursor(12);
                    break;
                }
                default: {
                    cursor = new Cursor(12);
                }
            }
            return cursor;
        }

        private boolean drag(MouseEvent mouseEvent) {
            if (SGFigureElementSignificantDifference.this.mPressedPoint == null) {
                return false;
            }
            if (this.mMouseLocation == 0 || this.mMouseLocation == 8) {
                boolean bl = this.dragOtherPoint(mouseEvent);
                return bl;
            }
            float f = this.getMagnification();
            SigDiffSymbol sigDiffSymbol = this.mTempSymbol;
            float f2 = sigDiffSymbol.getX();
            float f3 = sigDiffSymbol.getY();
            float f4 = f * sigDiffSymbol.getWidth();
            float f5 = f * sigDiffSymbol.getPerpendicularHeight1();
            float f6 = f * sigDiffSymbol.getPerpendicularHeight2();
            int n = mouseEvent.getX() - ((SGFigureElementSignificantDifference)SGFigureElementSignificantDifference.this).mPressedPoint.x;
            int n2 = mouseEvent.getY() - ((SGFigureElementSignificantDifference)SGFigureElementSignificantDifference.this).mPressedPoint.y;
            float f7 = f4;
            float f8 = f5;
            float f9 = f6;
            float f10 = 0.0f;
            float f11 = 0.0f;
            float f12 = 0.0f;
            float f13 = f2;
            float f14 = f3;
            float f15 = f4;
            float f16 = f5;
            float f17 = f6;
            int n3 = this.mMouseLocation;
            boolean bl = this.mFlippingHorizontalFlag;
            if (n3 == 1) {
                f11 = f8 - (float)n2;
                f12 = f9 - (float)n2;
                f14 = f3 + f8 - f11;
                f16 = f11;
                f17 = f12;
            } else if (n3 == 2 && !bl || n3 == 3 && bl) {
                f10 = f7 - (float)n;
                f13 = f2 + f7 - f10;
                f15 = f10;
            } else if (n3 == 3 && !bl || n3 == 2 && bl) {
                f15 = f10 = f7 + (float)n;
            } else if (n3 == 5 && !bl || n3 == 7 && bl) {
                f11 = f8 - (float)n2;
                f12 = f9 - (float)n2;
                f10 = f7 - (float)n;
                f13 = f2 + f7 - f10;
                f14 = f3 + f8 - f11;
                f15 = f10;
                f16 = f11;
                f17 = f12;
            } else if (n3 == 7 && !bl || n3 == 5 && bl) {
                f10 = f7 + (float)n;
                f11 = f8 - (float)n2;
                f12 = f9 - (float)n2;
                f14 = f3 + f9 - f12;
                f15 = f10;
                f16 = f11;
                f17 = f12;
            } else if (n3 == 4 && !bl || n3 == 6 && bl) {
                f10 = f7 - (float)n;
                f11 = f8 + (float)n2;
                f13 = f2 + f7 - f10;
                f15 = f10;
                f16 = f11;
            } else if (n3 == 6 && !bl || n3 == 4 && bl) {
                f10 = f7 + (float)n;
                f12 = f9 + (float)n2;
                f15 = f10;
                f17 = f12;
            }
            SGFigureElementSignificantDifference.this.mPressedPoint.setLocation(SGFigureElementSignificantDifference.this.mPressedPoint.getX() + (double)n, SGFigureElementSignificantDifference.this.mPressedPoint.getY() + (double)n2);
            this.setLocation(f13, f14);
            this.setSize(f15 / f, f16 / f, f17 / f);
            this.createDrawingElement();
            sigDiffSymbol.setLocation(f13, f14);
            sigDiffSymbol.setSize(f15 / f, f16 / f, f17 / f);
            if (n3 == 4 || n3 == 5 || n3 == 6 || n3 == 7) {
                int n4 = this.getMouseLocation(mouseEvent.getX(), mouseEvent.getY());
                SGFigureElementSignificantDifference.this.setMouseCursor(this.getCursor(n4));
            }
            return true;
        }

        private boolean dragOtherPoint(MouseEvent mouseEvent) {
            if (SGFigureElementSignificantDifference.this.mPressedPoint != null) {
                int n = mouseEvent.getX() - ((SGFigureElementSignificantDifference)SGFigureElementSignificantDifference.this).mPressedPoint.x;
                int n2 = mouseEvent.getY() - ((SGFigureElementSignificantDifference)SGFigureElementSignificantDifference.this).mPressedPoint.y;
                this.translate(n, n2);
                SGFigureElementSignificantDifference.this.mPressedPoint = mouseEvent.getPoint();
            }
            return true;
        }

        private boolean setShapeWithAxesValues() {
            float f = SGFigureElementSignificantDifference.this.calcLocation(this.mXValue1, this.mXAxis, true);
            float f2 = SGFigureElementSignificantDifference.this.calcLocation(this.mXValue2, this.mXAxis, true);
            float f3 = SGFigureElementSignificantDifference.this.calcLocation(this.mHorizontalYValue, this.mYAxis, false);
            float f4 = SGFigureElementSignificantDifference.this.calcLocation(this.mYValue1, this.mYAxis, false);
            float f5 = SGFigureElementSignificantDifference.this.calcLocation(this.mYValue2, this.mYAxis, false);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4) || Float.isNaN(f5)) {
                this.setValid(false);
                return false;
            }
            this.setValid(true);
            this.setNodePointLocation(f, f4, f2, f5, f3);
            this.createDrawingElement();
            return true;
        }

        public boolean isValid() {
            return this.mValidFlag;
        }

        public void setValid(boolean bl) {
            this.mValidFlag = bl;
        }

        private boolean setAxisValuesWithShape() {
            double d = SGFigureElementSignificantDifference.this.calcValue(this.getX1(), this.mXAxis, true);
            double d2 = SGFigureElementSignificantDifference.this.calcValue(this.getY1(), this.mYAxis, false);
            double d3 = SGFigureElementSignificantDifference.this.calcValue(this.getX2(), this.mXAxis, true);
            double d4 = SGFigureElementSignificantDifference.this.calcValue(this.getY2(), this.mYAxis, false);
            double d5 = SGFigureElementSignificantDifference.this.calcValue(this.getY(), this.mYAxis, false);
            this.mXValue1 = SGFigureElementSignificantDifference.this.getNumberInRangeOrder(d, this.mXAxis);
            this.mYValue1 = SGFigureElementSignificantDifference.this.getNumberInRangeOrder(d2, this.mYAxis);
            this.mXValue2 = SGFigureElementSignificantDifference.this.getNumberInRangeOrder(d3, this.mXAxis);
            this.mYValue2 = SGFigureElementSignificantDifference.this.getNumberInRangeOrder(d4, this.mYAxis);
            this.mHorizontalYValue = SGFigureElementSignificantDifference.this.getNumberInRangeOrder(d5, this.mYAxis);
            this.setValid(true);
            this.createDrawingElement();
            return true;
        }

        public SGProperties getMemento() {
            return this.getProperties();
        }

        public boolean setMemento(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public boolean setMementoBackward() {
            if (!this.mUndoManager.setMementoBackward()) {
                return false;
            }
            this.setShapeWithAxesValues();
            if (this.isValid()) {
                this.createDrawingElement();
            }
            return true;
        }

        public boolean setMementoForward() {
            if (!this.mUndoManager.setMementoForward()) {
                return false;
            }
            this.setShapeWithAxesValues();
            if (this.isValid()) {
                this.createDrawingElement();
            }
            return true;
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public boolean isChanged() {
            return this.mUndoManager.isChanged();
        }

        public void setChanged(boolean bl) {
            this.mUndoManager.setChanged(bl);
        }

        public boolean deleteForwardHistory() {
            return this.mUndoManager.deleteForwardHistory();
        }

        public boolean isChangedRoot() {
            return this.isChanged();
        }

        public void clearChanged() {
            this.setChanged(false);
        }

        public void notifyToRoot() {
            SGFigureElementSignificantDifference.this.notifyToRoot();
        }

        public float getMagnification() {
            return SGFigureElementSignificantDifference.this.getMagnification();
        }

        public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
            SGPropertyResults sGPropertyResults = new SGPropertyResults();
            if (!this.prepare()) {
                return null;
            }
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                Number number;
                String string = iterator.next();
                String string2 = sGPropertyMap.getValueString(string);
                if ("AxisX".equalsIgnoreCase(string)) {
                    int n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults.putResult("AxisX", 1);
                        continue;
                    }
                    if (!this.setXAxisLocation(n)) {
                        sGPropertyResults.putResult("AxisX", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("AxisX", 0);
                    continue;
                }
                if ("AxisY".equalsIgnoreCase(string)) {
                    int n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults.putResult("AxisY", 1);
                        continue;
                    }
                    if (!this.setYAxisLocation(n)) {
                        sGPropertyResults.putResult("AxisY", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("AxisY", 0);
                    continue;
                }
                if ("LeftX".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("LeftX", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("LeftX", 1);
                        continue;
                    }
                    if (!this.setLeftXValue(d)) {
                        sGPropertyResults.putResult("LeftX", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("LeftX", 0);
                    continue;
                }
                if ("LeftY".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("LeftY", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("LeftY", 1);
                        continue;
                    }
                    if (!this.setLeftYValue(d)) {
                        sGPropertyResults.putResult("LeftY", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("LeftY", 0);
                    continue;
                }
                if ("RightX".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("RightX", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("RightX", 1);
                        continue;
                    }
                    if (!this.setRightXValue(d)) {
                        sGPropertyResults.putResult("RightX", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("RightX", 0);
                    continue;
                }
                if ("RightY".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("RightY", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("RightY", 1);
                        continue;
                    }
                    if (!this.setRightYValue(d)) {
                        sGPropertyResults.putResult("RightY", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("RightY", 0);
                    continue;
                }
                if ("HorizontalY".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("HorizontalY", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("HorizontalY", 1);
                        continue;
                    }
                    if (!this.setHorizontalYValue(d)) {
                        sGPropertyResults.putResult("HorizontalY", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("HorizontalY", 0);
                    continue;
                }
                if ("LineVisible".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults.putResult("LineVisible", 1);
                        continue;
                    }
                    if (!this.setLineVisible(bl)) {
                        sGPropertyResults.putResult("LineVisible", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("LineVisible", 0);
                    continue;
                }
                if ("Space".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults.putResult("Space", 1);
                        continue;
                    }
                    if (!this.setSpace(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults.putResult("Space", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Space", 0);
                    continue;
                }
                if ("LineWidth".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults.putResult("LineWidth", 1);
                        continue;
                    }
                    if (!this.setLineWidth(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults.putResult("LineWidth", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("LineWidth", 0);
                    continue;
                }
                if ("Text".equalsIgnoreCase(string)) {
                    if (!sGPropertyMap.isDoubleQuoted(string)) {
                        sGPropertyResults.putResult("Text", 1);
                        continue;
                    }
                    if (!this.setText(string2)) {
                        sGPropertyResults.putResult("Text", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Text", 0);
                    continue;
                }
                if ("FontName".equalsIgnoreCase(string)) {
                    String string3 = SGUtility.findFontFamilyName(string2);
                    if (string3 == null) {
                        sGPropertyResults.putResult("FontName", 1);
                        continue;
                    }
                    if (!this.setFontName(string3)) {
                        sGPropertyResults.putResult("FontName", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("FontName", 0);
                    continue;
                }
                if ("FontStyle".equalsIgnoreCase(string)) {
                    Integer n = SGUtilityText.getFontStyle(string2);
                    if (n == null) {
                        sGPropertyResults.putResult("FontStyle", 1);
                        continue;
                    }
                    if (!this.setFontStyle(n)) {
                        sGPropertyResults.putResult("FontStyle", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("FontStyle", 0);
                    continue;
                }
                if ("FontSize".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults.putResult("FontSize", 1);
                        continue;
                    }
                    if (!this.setFontSize(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults.putResult("FontSize", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("FontSize", 0);
                    continue;
                }
                if ("Color".equalsIgnoreCase(string)) {
                    Color color = SGUtilityText.getColor(string2);
                    if (color != null) {
                        if (!this.setColor(color)) {
                            sGPropertyResults.putResult("Color", 1);
                            continue;
                        }
                    } else {
                        color = SGUtilityText.parseColor(string2);
                        if (color == null) {
                            sGPropertyResults.putResult("Color", 1);
                            continue;
                        }
                        if (!this.setColor(color)) {
                            sGPropertyResults.putResult("Color", 1);
                            continue;
                        }
                    }
                    sGPropertyResults.putResult("Color", 0);
                    continue;
                }
                if (!"Anchored".equalsIgnoreCase(string)) continue;
                Boolean bl = SGUtilityText.getBoolean(string2);
                if (bl == null) {
                    sGPropertyResults.putResult("Anchored", 1);
                    continue;
                }
                if (!this.setAnchored(bl)) {
                    sGPropertyResults.putResult("Anchored", 1);
                    continue;
                }
                sGPropertyResults.putResult("Anchored", 0);
            }
            if (!this.commit()) {
                return null;
            }
            this.notifyToRoot();
            SGFigureElementSignificantDifference.this.notifyChange();
            SGFigureElementSignificantDifference.this.repaint();
            return sGPropertyResults;
        }
    }

    private static class SigDiffSymbolPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 4970384335056528846L;
        private JCheckBoxMenuItem anchoredCheckBox;

        private SigDiffSymbolPopupMenu() {
        }

        public void init(SigDiffSymbol sigDiffSymbol) {
            this.setBounds(0, 0, 100, 100);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  -- Significant Difference: ");
            stringBuffer.append(sigDiffSymbol.getID());
            stringBuffer.append(" --");
            this.add(new JLabel(stringBuffer.toString()));
            this.addSeparator();
            SGUtility.addItem(this, sigDiffSymbol, "Bring to Front");
            SGUtility.addItem(this, sigDiffSymbol, "Bring Forward");
            SGUtility.addItem(this, sigDiffSymbol, "Send Backward");
            SGUtility.addItem(this, sigDiffSymbol, "Send to Back");
            this.addSeparator();
            SGUtility.addItem(this, sigDiffSymbol, "Cut");
            SGUtility.addItem(this, sigDiffSymbol, "Copy");
            SGUtility.addItem(this, sigDiffSymbol, "Paste");
            this.addSeparator();
            SGUtility.addItem(this, sigDiffSymbol, "Delete");
            SGUtility.addItem(this, sigDiffSymbol, "Duplicate");
            this.addSeparator();
            this.anchoredCheckBox = new JCheckBoxMenuItem("Anchored");
            this.add(this.anchoredCheckBox);
            this.anchoredCheckBox.addActionListener(sigDiffSymbol);
            this.addSeparator();
            SGUtility.addItem(this, sigDiffSymbol, "Property");
        }

        void setAnchored(boolean bl) {
            this.anchoredCheckBox.setSelected(bl);
        }
    }

    public static class SigDiffElementProperties
    extends SGProperties {
        ArrayList visibleSigDiffSymbolList = new ArrayList();

        public void dispose() {
            super.dispose();
            this.visibleSigDiffSymbolList.clear();
            this.visibleSigDiffSymbolList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SigDiffElementProperties)) {
                return false;
            }
            SigDiffElementProperties sigDiffElementProperties = (SigDiffElementProperties)object;
            return sigDiffElementProperties.visibleSigDiffSymbolList.equals(this.visibleSigDiffSymbolList);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.visibleSigDiffSymbolList.toString());
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

