/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGColorBarModel;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGIChildObject;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDataSource;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGISXYData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYZTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYNetCDFData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGILegendConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISXYZDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIVXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrowForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBarForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupColorMap;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBarForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLineForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraphVXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbolForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabelForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDataPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetMultipleSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetSXYZ;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetVXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGILegendDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYZDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIVXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGMultipleSXYUtility;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGFigureElementLegend
extends SGFigureElementForData
implements SGIFigureElementLegend,
SGIStringConstants,
CaretListener,
DocumentListener,
KeyListener,
ActionListener,
SGILegendConstants,
SGIFigureDrawingElementConstants,
SGIMovable,
SGISelectable,
SGILegendDialogObserver {
    private SGIFigureElementGraph mGraphElement = null;
    private SGAxis mXAxis = null;
    private SGAxis mYAxis = null;
    private float mLegendX = 0.0f;
    private float mLegendY = 0.0f;
    private float mLegendWidth = 0.0f;
    private float mLegendHeight = 0.0f;
    private float mFontSize;
    private int mFontStyle;
    private String mFontName;
    private Color mFontColor;
    private float mSymbolSpan;
    private float mFrameLineWidth;
    private Color mFrameLineColor;
    private SGFillPaint mBackgroundPaint = new SGFillPaint();
    private boolean mLegendVisibleFlag = true;
    private boolean mFrameVisibleFlag = true;
    private SGProperties mTemporaryProperties = null;
    private JPopupMenu mPopupMenu = null;
    private SGPropertyDialog mPropertyDialog = null;
    private JTextField mTextField = new JTextField();
    public static final String MENUCMD_HIDE = "Hide";
    private boolean mStartFlag = true;
    private boolean mSelectedFlag = false;
    private static final float MARGIN_HORIZONTAL = 6.0f;
    private static final float MARGIN_VERTICAL = 6.0f;
    private static final float marginTop = 6.0f;
    private static final float marginBottom = 6.0f;
    private static final float marginLeft = 6.0f;
    private static final float marginRight = 6.0f;
    private static final float spaceDataAndString = 6.0f;
    private static final float spaceLegend = 6.0f;
    private ElementGroupSetInLegend mFocusedGroup = null;
    private Point mLegendLocation = null;

    public SGFigureElementLegend() {
        this.initEditField();
        this.init();
    }

    private void init() {
        this.setLegendVisible(true);
        this.setFontName("Serif");
        this.setFontSize(16.0f, "pt");
        this.setFontStyle(0);
        this.setFontColor(DEFAULT_LEGEND_FONT_COLOR);
        this.setFrameVisible(true);
        this.setFrameLineWidth(0.5f, "pt");
        this.setFrameLineColor(DEFAULT_LEGEND_FRAME_COLOR);
        this.setBackgroundColor(DEFAULT_LEGEND_BACKGROUND_COLOR);
        this.setBackgroundTransparent(0);
        this.setSymbolSpan(2.0f, "cm");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mPropertyDialog != null) {
            this.mPropertyDialog.dispose();
            this.mPropertyDialog = null;
        }
        this.mAxisElement = null;
        this.mFocusedGroup = null;
        this.mGraphElement = null;
        this.mTextField = null;
        this.mPopupMenu = null;
        this.mBackgroundPaint = null;
        this.mFontName = null;
        this.mFrameLineColor = null;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = null;
        if (this.mPopupMenu != null) {
            jPopupMenu = this.mPopupMenu;
        } else {
            this.mPopupMenu = jPopupMenu = this.createPopupMenu();
        }
        return jPopupMenu;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Legend --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_HIDE);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Property");
        return jPopupMenu;
    }

    @Override
    public String getClassDescription() {
        return "Legend";
    }

    @Override
    public boolean addData(SGData sGData, String string) {
        return this.addData(sGData, string, 0, false, null);
    }

    @Override
    public boolean addData(SGData sGData, String string, Map<String, Object> map) {
        return this.addData(sGData, string, 0, false, map);
    }

    @Override
    public boolean addData(SGData sGData, String string, int n, Map<String, Object> map) {
        return this.addData(sGData, string, n, true, map);
    }

    private boolean addData(SGData sGData, String string, int n, boolean bl, Map<String, Object> map) {
        if (!super.addData(sGData, string)) {
            return false;
        }
        if (this.mGraphElement == null) {
            throw new Error("mGraphElement==null");
        }
        ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.createGroupSet(sGData, string);
        if (elementGroupSetInLegend == null) {
            return false;
        }
        this.setInfoMapToGroupSet(elementGroupSetInLegend, map);
        if (bl ? !this.addToList(n, elementGroupSetInLegend) : !this.addToList(elementGroupSetInLegend)) {
            return false;
        }
        this.updateAllDrawingElements();
        elementGroupSetInLegend.initPropertiesHistory();
        this.updateAllDrawingElements();
        if (this.mStartFlag) {
            this.onStartup(sGData);
        }
        this.setChanged(true);
        return true;
    }

    private void setInfoMapToGroupSet(ElementGroupSetInLegend elementGroupSetInLegend, Map<String, Object> map) {
        if (!(elementGroupSetInLegend instanceof ElementGroupSetInLegendSXY) && !(elementGroupSetInLegend instanceof ElementGroupSetInLegendMultipleSXY)) {
            return;
        }
        if (map == null) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        Object object = map.get("PlotTypeLine");
        if (null != object && object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (null != (object = map.get("PlotTypeSymbol")) && object instanceof Boolean) {
            bl2 = (Boolean)object;
        }
        if (null != (object = map.get("PlotTypeBar")) && object instanceof Boolean) {
            bl3 = (Boolean)object;
        }
        if (null != (object = map.get("ErrorBar position is on line")) && object instanceof Boolean) {
            bl4 = (Boolean)object;
        }
        if (elementGroupSetInLegend instanceof ElementGroupSetInLegendMultipleSXY) {
            ElementGroupSetInLegendMultipleSXY elementGroupSetInLegendMultipleSXY = (ElementGroupSetInLegendMultipleSXY)elementGroupSetInLegend;
            elementGroupSetInLegendMultipleSXY.setLineVisible(bl);
            elementGroupSetInLegendMultipleSXY.setSymbolVisible(bl2);
            elementGroupSetInLegendMultipleSXY.setBarVisible(bl3);
            elementGroupSetInLegendMultipleSXY.setBarWidthValue(elementGroupSetInLegendMultipleSXY.getBarWidthValue());
            elementGroupSetInLegendMultipleSXY.setErrorBarOnLinePosition(bl4);
        } else {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)elementGroupSetInLegend;
            elementGroupSetInLegendSXY.setLineVisible(bl);
            elementGroupSetInLegendSXY.setSymbolVisible(bl2);
            elementGroupSetInLegendSXY.setBarVisible(bl3);
            elementGroupSetInLegendSXY.setBarWidthValue(elementGroupSetInLegendSXY.getBarWidthValue());
            elementGroupSetInLegendSXY.setErrorBarOnLinePosition(bl4);
        }
    }

    @Override
    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (this.mGraphElement == null || sGData == null) {
            throw new Error("mGraphElement==null || data==null");
        }
        if (!super.addData(sGData, string, sGProperties)) {
            return false;
        }
        ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.createGroupSet(sGData, string);
        if (elementGroupSetInLegend == null) {
            return false;
        }
        this.addToList(elementGroupSetInLegend);
        if (!elementGroupSetInLegend.setProperties(sGProperties)) {
            return false;
        }
        if (SGDataUtility.isSXYTypeData(sGData.getDataType()) && SGDataUtility.isNetCDFData(sGData)) {
            this.updateBarVerticalOfNetCDFData(elementGroupSetInLegend, sGData);
        }
        elementGroupSetInLegend.setName(string);
        elementGroupSetInLegend.setVisible(true);
        this.updateAllDrawingElements();
        elementGroupSetInLegend.initPropertiesHistory();
        this.updateAllDrawingElements();
        if (this.mStartFlag) {
            this.onStartup(sGData);
        }
        this.setChanged(true);
        return true;
    }

    private void updateBarVerticalOfNetCDFData(ElementGroupSetInLegend elementGroupSetInLegend, SGData sGData) {
        if (sGData instanceof SGSXYNetCDFData) {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY;
            SGSXYNetCDFData sGSXYNetCDFData = (SGSXYNetCDFData)sGData;
            boolean bl = sGSXYNetCDFData.isXVariableCoordinate();
            if (elementGroupSetInLegend instanceof ElementGroupSetInLegendMultipleSXY) {
                ElementGroupSetInLegendMultipleSXY elementGroupSetInLegendMultipleSXY = (ElementGroupSetInLegendMultipleSXY)elementGroupSetInLegend;
                if (elementGroupSetInLegendMultipleSXY.isBarVertical() != bl) {
                    elementGroupSetInLegendMultipleSXY.setBarVertical(bl);
                }
            } else if (elementGroupSetInLegend instanceof ElementGroupSetInLegendSXY && (elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)elementGroupSetInLegend).isBarVertical() != bl) {
                elementGroupSetInLegendSXY.setBarVertical(bl);
            }
        } else if (sGData instanceof SGSXYMultipleNetCDFData) {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY;
            SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)sGData;
            boolean bl = sGSXYMultipleNetCDFData.isXVariableCoordinate();
            if (elementGroupSetInLegend instanceof ElementGroupSetInLegendMultipleSXY) {
                ElementGroupSetInLegendMultipleSXY elementGroupSetInLegendMultipleSXY = (ElementGroupSetInLegendMultipleSXY)elementGroupSetInLegend;
                if (elementGroupSetInLegendMultipleSXY.isBarVertical() != bl) {
                    elementGroupSetInLegendMultipleSXY.setBarVertical(bl);
                }
            } else if (elementGroupSetInLegend instanceof ElementGroupSetInLegendSXY && (elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)elementGroupSetInLegend).isBarVertical() != bl) {
                elementGroupSetInLegendSXY.setBarVertical(bl);
            }
        }
    }

    private void onStartup(SGData sGData) {
        float f = this.getGraphRectX() + this.getGraphRectWidth() - this.mMagnification * this.getLegendWidth();
        float f2 = this.getGraphRectY();
        this.setLegendLocation(f, f2);
        double d = this.calcValue(this.getLegendX(), this.mXAxis, true);
        d = this.getNumberInRangeOrder(d, this.mXAxis);
        float f3 = this.calcLocation(d, this.mXAxis, true);
        this.mLegendX = (f3 - this.mGraphRectX) / this.mMagnification;
        double d2 = this.calcValue(this.getLegendY(), this.mYAxis, false);
        d2 = this.getNumberInRangeOrder(d2, this.mYAxis);
        float f4 = this.calcLocation(d2, this.mYAxis, false);
        this.mLegendY = (f4 - this.mGraphRectY) / this.mMagnification;
        this.updateAllDrawingElements();
        this.mStartFlag = false;
    }

    @Override
    public boolean getFocusedObjectsList(List<SGISelectable> list) {
        if (this.isSelected()) {
            list.add(this);
        }
        ArrayList arrayList = this.getVisibleLegendList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
            if (!elementGroupSetInLegend.isSelected()) continue;
            list.add(elementGroupSetInLegend);
        }
        return true;
    }

    @Override
    public boolean hideSelectedObjects() {
        if (!super.hideSelectedObjects()) {
            return false;
        }
        this.updateAllDrawingElements();
        this.repaint();
        return true;
    }

    @Override
    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        if (sGISelectable.equals(this)) {
            return true;
        }
        return super.hideSelectedObject(sGISelectable);
    }

    @Override
    public boolean hideData(int[] nArray) {
        if (!super.hideData(nArray)) {
            return false;
        }
        this.updateAllDrawingElements();
        this.repaint();
        return true;
    }

    @Override
    public void setSelected(boolean bl) {
        this.mSelectedFlag = bl;
    }

    @Override
    public boolean isSelected() {
        return this.mSelectedFlag;
    }

    public float getLegendX() {
        return this.mGraphRectX + this.mLegendX * this.mMagnification;
    }

    public float getLegendY() {
        return this.mGraphRectY + this.mLegendY * this.mMagnification;
    }

    public float getLegendWidth() {
        return this.mLegendWidth;
    }

    public float getLegendHeight() {
        return this.mLegendHeight;
    }

    public Point2D getLegendLocation() {
        Point2D.Float float_ = new Point2D.Float(this.getLegendX(), this.getLegendY());
        return float_;
    }

    public boolean setLegendLocation(float f, float f2) {
        this.mLegendX = (f - this.mGraphRectX) / this.mMagnification;
        this.mLegendY = (f2 - this.mGraphRectY) / this.mMagnification;
        return true;
    }

    @Override
    public boolean setXValue(double d) {
        float f;
        SGAxis sGAxis = this.mXAxis;
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        double d2 = this.calcValue(this.getLegendX(), sGAxis, true);
        d2 = this.getNumberInRangeOrder(d2, sGAxis);
        double d3 = this.getNumberInRangeOrder(d, sGAxis);
        if (d3 == d2) {
            f = this.mLegendX;
        } else {
            float f2 = this.calcLocation(d, sGAxis, true);
            f = (f2 - this.mGraphRectX) / this.mMagnification;
        }
        boolean bl = false;
        if (f != this.mLegendX) {
            bl = true;
        }
        this.mLegendX = f;
        if (bl) {
            this.updateAllDrawingElements();
        }
        return true;
    }

    @Override
    public boolean setYValue(double d) {
        float f;
        SGAxis sGAxis = this.mYAxis;
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        double d2 = this.calcValue(this.getLegendY(), sGAxis, false);
        d2 = this.getNumberInRangeOrder(d2, sGAxis);
        double d3 = this.getNumberInRangeOrder(d, sGAxis);
        if (d3 == d2) {
            f = this.mLegendY;
        } else {
            float f2 = this.calcLocation(d, sGAxis, false);
            f = (f2 - this.mGraphRectY) / this.mMagnification;
        }
        boolean bl = false;
        if (f != this.mLegendY) {
            bl = true;
        }
        this.mLegendY = f;
        if (bl) {
            this.updateAllDrawingElements();
        }
        return true;
    }

    @Override
    public boolean hasValidXAxisValue(int n, Number number) {
        SGAxis sGAxis = n == -1 ? this.mXAxis : this.mAxisElement.getAxisInPlane(n);
        double d = number != null ? number.doubleValue() : this.getXValue();
        return sGAxis.isValidValue(d);
    }

    @Override
    public boolean hasValidYAxisValue(int n, Number number) {
        SGAxis sGAxis = n == -1 ? this.mYAxis : this.mAxisElement.getAxisInPlane(n);
        double d = number != null ? number.doubleValue() : this.getYValue();
        return sGAxis.isValidValue(d);
    }

    @Override
    public void translate(float f, float f2) {
        this.setLegendLocation(this.getLegendX() + f, this.getLegendY() + f2);
        this.updateAllDrawingElements();
    }

    @Override
    public double getXValue() {
        SGAxis sGAxis = this.mXAxis;
        double d = this.calcValue(this.getLegendX(), sGAxis, true);
        if (Double.isNaN(d)) {
            return d;
        }
        d = this.getNumberInRangeOrder(d, sGAxis);
        return d;
    }

    @Override
    public double getYValue() {
        SGAxis sGAxis = this.mYAxis;
        double d = this.calcValue(this.getLegendY(), sGAxis, false);
        if (Double.isNaN(d)) {
            return d;
        }
        d = this.getNumberInRangeOrder(d, sGAxis);
        return d;
    }

    private void initEditField() {
        this.mTextField.setVisible(false);
        this.mTextField.addActionListener(this);
        this.mTextField.addCaretListener(this);
        this.mTextField.getDocument().addDocumentListener(this);
        this.mTextField.addKeyListener(this);
    }

    @Override
    public void setComponent(JComponent jComponent) {
        super.setComponent(jComponent);
        jComponent.add(this.mTextField);
    }

    @Override
    public boolean clearFocusedObjects() {
        if (!super.clearFocusedObjects()) {
            return false;
        }
        this.clearFocusedObjectsSub();
        return true;
    }

    @Override
    public boolean clearFocusedObjects(SGIFigureElement sGIFigureElement) {
        if (sGIFigureElement instanceof SGIFigureElementGraph) {
            this.setSelected(false);
        } else if (sGIFigureElement instanceof SGIFigureElementLegend) {
            SGIFigureElementLegend sGIFigureElementLegend = (SGIFigureElementLegend)sGIFigureElement;
            if (!sGIFigureElementLegend.equals(this)) {
                if (sGIFigureElementLegend.isSelected()) {
                    this.clearAllFocusedData();
                } else {
                    this.setSelected(false);
                }
            }
        } else if (!this.clearFocusedObjects()) {
            return false;
        }
        this.clearFocusedObjectsSub();
        return true;
    }

    private void clearFocusedObjectsSub() {
        if (this.mTextField.isVisible()) {
            this.closeTextField();
        }
        this.clearFocusedGroup();
    }

    @Override
    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    @Override
    public SGProperties getProperties() {
        LegendProperties legendProperties = new LegendProperties();
        if (!this.getProperties(legendProperties)) {
            return null;
        }
        return legendProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LegendProperties)) {
            return false;
        }
        LegendProperties legendProperties = (LegendProperties)sGProperties;
        legendProperties.x = this.mLegendX;
        legendProperties.y = this.mLegendY;
        legendProperties.visible = this.isLegendVisible();
        legendProperties.frameLineVisible = this.isFrameLineVisible();
        legendProperties.frameLineWidth = this.getFrameLineWidth();
        legendProperties.frameLineColor = this.getFrameLineColor();
        legendProperties.backgroundPaint.setColor(this.getBackgroundColor());
        legendProperties.backgroundPaint.setTransparency(this.getBackgroundTransparency());
        legendProperties.fontName = this.getFontName();
        legendProperties.fontSize = this.getFontSize();
        legendProperties.fontStyle = this.getFontStyle();
        legendProperties.stringColor = this.getStringColor();
        legendProperties.symbolSpan = this.getSymbolSpan();
        legendProperties.xAxis = this.mXAxis;
        legendProperties.yAxis = this.mYAxis;
        legendProperties.visibleElementGroupList = new ArrayList<SGIChildObject>(this.getVisibleChildList());
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LegendProperties)) {
            return false;
        }
        LegendProperties legendProperties = (LegendProperties)sGProperties;
        return this.setCommonProperties(legendProperties);
    }

    private boolean setCommonProperties(LegendProperties legendProperties) {
        this.mLegendX = legendProperties.x;
        this.mLegendY = legendProperties.y;
        this.setLegendVisible(legendProperties.visible);
        this.setFrameVisible(legendProperties.frameLineVisible);
        this.setFrameLineWidth(legendProperties.frameLineWidth);
        this.setFrameLineColor(legendProperties.frameLineColor);
        this.setBackgroundColor(legendProperties.backgroundPaint.getColor());
        this.setBackgroundTransparent(legendProperties.backgroundPaint.getTransparencyPercent());
        this.setFontName(legendProperties.fontName);
        this.setFontSize(legendProperties.fontSize);
        this.setFontStyle(legendProperties.fontStyle);
        this.setFontColor(legendProperties.stringColor);
        this.setSymbolSpan(legendProperties.symbolSpan);
        this.mXAxis = legendProperties.xAxis;
        this.mYAxis = legendProperties.yAxis;
        boolean bl = this.setVisibleChildList(legendProperties.visibleElementGroupList);
        return bl;
    }

    private boolean updateAllDrawingElements() {
        int n;
        float f;
        float f2;
        int n2;
        int n3;
        float f3 = this.mMagnification;
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        int n4 = arrayList.size();
        ElementGroupSetInLegend[] elementGroupSetInLegendArray = new ElementGroupSetInLegend[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            elementGroupSetInLegendArray[n3] = (ElementGroupSetInLegend)arrayList.get(n3);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            elementGroupSetInLegendArray[n3].createStringElement();
        }
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n4];
        for (int i = 0; i < n4; ++i) {
            rectangle2DArray[i] = elementGroupSetInLegendArray[i].getStringBounds();
        }
        float[] fArray = new float[n4];
        for (int i = 0; i < n4; ++i) {
            fArray[i] = (float)rectangle2DArray[i].getHeight();
        }
        float f4 = 0.0f;
        for (int i = 0; i < n4; ++i) {
            float f5 = (float)rectangle2DArray[i].getWidth();
            if (!(f5 > f4)) continue;
            f4 = f5;
        }
        float f6 = this.getSymbolSpan();
        for (int i = 0; i < n4; ++i) {
            float f7 = elementGroupSetInLegendArray[i].getMaxDataElementWidth() / f3;
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        float f8 = f6 + f4 / f3 + 6.0f;
        double[] dArray = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray[i] = elementGroupSetInLegendArray[i].getMaxDataElementHeight();
        }
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            fArray2[i] = (float)Math.max(dArray[i], (double)fArray[i]);
        }
        Rectangle2D[] rectangle2DArray2 = new Rectangle2D[n4];
        float f9 = this.getLegendY() + f3 * 6.0f;
        float f10 = this.getLegendX() + f3 * 6.0f;
        float f11 = f3 * f8;
        for (n2 = 0; n2 < n4; ++n2) {
            float f12 = f9;
            f2 = fArray2[n2];
            rectangle2DArray2[n2] = new Rectangle2D.Float(f10, f12, f11, f2);
            f9 += f2 + f3 * 6.0f;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            elementGroupSetInLegendArray[n2].setRect(rectangle2DArray2[n2]);
        }
        float f13 = f3 * f6;
        for (int i = 0; i < n4; ++i) {
            f2 = (float)rectangle2DArray2[i].getX();
            float f14 = (float)rectangle2DArray2[i].getY();
            f = (float)elementGroupSetInLegendArray[i].getMaxDataElementHeight();
            Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f14, f13, f);
            elementGroupSetInLegendArray[i].setDrawingElementBounds(float_);
        }
        float f15 = 0.0f;
        for (n = 0; n < n4; ++n) {
            f15 += fArray2[n] / f3;
        }
        f15 += (float)(n4 - 1) * 6.0f;
        for (n = 0; n < n4; ++n) {
            elementGroupSetInLegendArray[n].createDrawingElement();
        }
        float f16 = this.getLegendX() + f3 * (6.0f + f6 + 6.0f);
        for (int i = 0; i < n4; ++i) {
            f = (float)rectangle2DArray2[i].getY() - 0.5f * fArray[i] + 0.5f * fArray2[i] + (float)rectangle2DArray[i].getY();
            elementGroupSetInLegendArray[i].getStringElement().setLocation(f16, f);
        }
        this.mLegendWidth = 6.0f + f8 + 6.0f;
        this.mLegendHeight = 6.0f + f15 + 6.0f;
        return true;
    }

    @Override
    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        if (!this.closeTextField()) {
            return false;
        }
        return this.updateAllDrawingElements();
    }

    @Override
    public void paintGraphics(Graphics graphics, boolean bl) {
        ArrayList arrayList;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isLegendVisible() && (arrayList = this.getVisibleTotallyLegendList()).size() != 0) {
            if (this.getBackgroundTransparency() != 100) {
                Rectangle rectangle = this.getLegendRect().getBounds();
                graphics2D.setPaint(this.mBackgroundPaint.getPaint(rectangle));
                graphics2D.fill(rectangle);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
                elementGroupSetInLegend.paintGraphics2D(graphics2D);
            }
            if (this.mFrameVisibleFlag) {
                this.drawLegendFrameLines(graphics2D);
            }
            if (this.mSymbolsVisibleFlagAroundAllObjects) {
                ArrayList arrayList2 = this.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsChildObject(arrayList2, graphics2D);
            }
            if (this.mSymbolsVisibleFlagAroundFocusedObjects && this.isSelected()) {
                ArrayList arrayList3 = this.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(arrayList3, graphics2D);
            }
        }
    }

    private ArrayList getAnchorPointList() {
        ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
        Rectangle2D rectangle2D = this.getLegendRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Point2D.Float float_ = new Point2D.Float(f, f2);
        Point2D.Float float_2 = new Point2D.Float(f, f2 + f4);
        Point2D.Float float_3 = new Point2D.Float(f + f3, f2);
        Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
        arrayList.add(float_);
        arrayList.add(float_2);
        arrayList.add(float_3);
        arrayList.add(float_4);
        return arrayList;
    }

    private void drawLegendFrameLines(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        if (arrayList.size() == 0) {
            return;
        }
        graphics2D.setPaint(this.mFrameLineColor);
        graphics2D.setStroke(new BasicStroke(this.mMagnification * this.mFrameLineWidth, 0, 0));
        graphics2D.draw(this.getLegendRect().getBounds());
    }

    public boolean contains(int n, int n2) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), this.mLegendWidth, this.mLegendHeight);
        return float_.contains(n, n2);
    }

    @Override
    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            LegendProperties legendProperties = (LegendProperties)list.get(i);
            hashSet.addAll(legendProperties.visibleElementGroupList);
        }
        return hashSet;
    }

    @Override
    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (sGIFigureElement instanceof SGIFigureElementAxis) {
            SGIFigureElementAxis sGIFigureElementAxis = (SGIFigureElementAxis)sGIFigureElement;
            bl = this.synchronizeToAxisElement(sGIFigureElementAxis, string);
        } else if (sGIFigureElement instanceof SGIFigureElementGraph) {
            SGIFigureElementGraph sGIFigureElementGraph = (SGIFigureElementGraph)sGIFigureElement;
            bl = this.synchronizeToGraphElement(sGIFigureElementGraph, string);
        } else if (!(sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementLegend || sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
            bl = sGIFigureElement.synchronizeArgument(this, string);
        }
        return bl;
    }

    private boolean synchronizeToGraphElement(SGIFigureElementGraph sGIFigureElementGraph, String string) {
        List<SGData> list = sGIFigureElementGraph.getDataList();
        if (list.size() != this.mDataList.size()) {
            throw new Error("dataList.size()!= this.mDataList.size()  " + list.size() + ", " + this.mDataList.size());
        }
        if ("Notify the change".equals(string) || "Notify the change on commit".equals(string)) {
            List<SGIChildObject> list2 = this.getVisibleChildList();
            for (int i = 0; i < list2.size(); ++i) {
                SGElementGroupSetInFigureElement sGElementGroupSetInFigureElement = (SGElementGroupSetInFigureElement)list2.get(i);
                SGData sGData = sGElementGroupSetInFigureElement.getData();
                SGProperties sGProperties = sGIFigureElementGraph.getDataProperties(sGData);
                if ("Notify the change on commit".equals(string)) {
                    boolean bl = sGIFigureElementGraph.isDataChanged(sGData);
                    sGElementGroupSetInFigureElement.setChanged(bl);
                }
                if (sGElementGroupSetInFigureElement.setProperties(sGProperties)) continue;
                return false;
            }
            if (!this.updateAllDrawingElements()) {
                return false;
            }
        } else if ("Notify the selection of data".equals(string)) {
            List<SGIChildObject> list3 = this.getVisibleChildList();
            for (int i = 0; i < list3.size(); ++i) {
                ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)list3.get(i);
                SGData sGData = elementGroupSetInLegend.getData();
                boolean bl = sGIFigureElementGraph.isDataSelected(sGData);
                elementGroupSetInLegend.setSelected(bl);
            }
        }
        return true;
    }

    private boolean synchronizeToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        if ("Notify the change".equals(string) || "Notify the change on commit".equals(string)) {
            SGColorBarModel sGColorBarModel = this.getColorBarModel();
            for (int i = 0; i < this.mChildList.size(); ++i) {
                SGIChildObject sGIChildObject = (SGIChildObject)this.mChildList.get(i);
                if (!(sGIChildObject instanceof ElementGroupSetInLegendSXYZ)) continue;
                ElementGroupSetInLegendSXYZ elementGroupSetInLegendSXYZ = (ElementGroupSetInLegendSXYZ)sGIChildObject;
                ElementGroupColorMap elementGroupColorMap = (ElementGroupColorMap)elementGroupSetInLegendSXYZ.getColorMapGroup();
                elementGroupColorMap.setColorBarModel(sGColorBarModel);
            }
        }
        return true;
    }

    @Override
    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    @Override
    public boolean isDataSelected(SGData sGData) {
        if (sGData == null) {
            throw new IllegalArgumentException("data == null");
        }
        ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend == null) {
            throw new Error("Data is not found.");
        }
        return elementGroupSetInLegend.isSelected();
    }

    @Override
    public boolean setMagnification(float f) {
        if (!this.closeTextField()) {
            return false;
        }
        if (!super.setMagnification(f)) {
            return false;
        }
        return this.updateAllDrawingElements();
    }

    @Override
    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        Rectangle2D rectangle2D2 = this.getLegendRect();
        if (rectangle2D2.getWidth() < Double.MIN_VALUE || rectangle2D2.getHeight() < Double.MIN_VALUE) {
            return true;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(rectangle2D);
        if (this.isLegendVisible()) {
            arrayList.add(rectangle2D2);
        }
        Rectangle2D rectangle2D3 = SGUtility.createUnion(arrayList);
        float f = (float)(rectangle2D.getY() - rectangle2D3.getY());
        float f2 = (float)(rectangle2D3.getY() + rectangle2D3.getHeight() - (rectangle2D.getY() + rectangle2D.getHeight()));
        float f3 = (float)(rectangle2D.getX() - rectangle2D3.getX());
        float f4 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    @Override
    public boolean onKeyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        SGTuple2f sGTuple2f = this.getDisplacement(keyEvent);
        if (!sGTuple2f.isZero() && this.isSelected()) {
            if (!this.prepare()) {
                return false;
            }
            this.translate(sGTuple2f.x, sGTuple2f.y);
            if (!this.commit()) {
                return false;
            }
            this.updateAllDrawingElements();
            this.notifyToRoot();
            this.repaint();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean onMouseClicked(MouseEvent mouseEvent) {
        if (!this.isLegendVisible()) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        Rectangle2D rectangle2D = this.getLegendRect();
        if (rectangle2D.contains(n, n2)) {
            ArrayList arrayList = this.getVisibleTotallyLegendList();
            if (n3 == 1) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
                        Rectangle2D rectangle2D2 = elementGroupSetInLegend.getStringElement().getElementBounds();
                        if (rectangle2D2.contains(n, n2)) {
                            if (this.mPressedPoint == null) {
                                return false;
                            }
                            this.mFocusedGroup = elementGroupSetInLegend;
                            int n4 = this.mPressedPoint.x - (int)rectangle2D2.getX();
                            int n5 = this.mPressedPoint.y - (int)rectangle2D2.getY();
                            this.showEditField(this.mTextField, elementGroupSetInLegend.mDrawingString, n4, n5);
                            return true;
                        }
                        if (!elementGroupSetInLegend.contains(n, n2)) continue;
                        this.onDataClicked(elementGroupSetInLegend, mouseEvent);
                        return true;
                    }
                    this.updateFocusedObjectsList((SGISelectable)this, mouseEvent);
                    return true;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
                        if (!elementGroupSetInLegend.contains(n, n2)) continue;
                        this.onDataClicked(elementGroupSetInLegend, mouseEvent);
                        this.showDataPopupMenu(elementGroupSetInLegend, n, n2);
                        return true;
                    }
                    this.updateFocusedObjectsList((SGISelectable)this, mouseEvent);
                    this.getPopupMenu().show(this.getComponent(), n, n2);
                    return true;
                }
            } else if (n3 == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
                    ArrayList<SGElementGroup> arrayList2 = elementGroupSetInLegend.getElementGroupList();
                    for (int j = arrayList2.size() - 1; j >= 0; --j) {
                        SGElementGroup sGElementGroup = arrayList2.get(j);
                        if (!sGElementGroup.isVisible()) continue;
                        SGDrawingElement[] sGDrawingElementArray = sGElementGroup.getDrawingElementArray();
                        for (int k = 0; k < sGDrawingElementArray.length; ++k) {
                            boolean bl;
                            if (!sGDrawingElementArray[k].isVisible() || !(bl = sGDrawingElementArray[k].contains(n, n2))) continue;
                            elementGroupSetInLegend.onMouseClicked(mouseEvent);
                            this.onDataClicked(elementGroupSetInLegend, mouseEvent);
                            this.setSelected(false);
                            this.setPropertiesOfSelectedObjects();
                            return true;
                        }
                    }
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.clearAllFocusedData();
                    this.setPropertiesOfSelectedObjects();
                }
            }
            return true;
        }
        return false;
    }

    private void onDataClicked(ElementGroupSetInLegend elementGroupSetInLegend, MouseEvent mouseEvent) {
        this.updateFocusedObjectsList((SGISelectable)elementGroupSetInLegend, mouseEvent);
        this.notifyDataSelection();
    }

    @Override
    public void clearAllFocusedData() {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)list.get(i);
            elementGroupSetInLegend.setSelected(false);
        }
        this.clearFocusedObjectsSub();
    }

    @Override
    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    @Override
    public ArrayList getChildNodes() {
        return new ArrayList();
    }

    @Override
    public SGPropertyDialog getPropertyDialog() {
        SGPropertyDialog sGPropertyDialog = null;
        if (this.mPropertyDialog != null) {
            sGPropertyDialog = this.mPropertyDialog;
        } else {
            this.mPropertyDialog = sGPropertyDialog = new SGLegendDialog(this.mDialogOwner, true);
        }
        return sGPropertyDialog;
    }

    @Override
    public String getFontName() {
        return this.mFontName;
    }

    @Override
    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    @Override
    public float getFontSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFontSize(), string);
    }

    public float getFrameLineWidth() {
        return this.mFrameLineWidth;
    }

    @Override
    public float getFrameLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFrameLineWidth(), string);
    }

    @Override
    public Color getFrameLineColor() {
        return this.mFrameLineColor;
    }

    @Override
    public Color getBackgroundColor() {
        return this.mBackgroundPaint.getColor();
    }

    @Override
    public int getBackgroundTransparency() {
        return this.mBackgroundPaint.getTransparencyPercent();
    }

    @Override
    public Color getStringColor() {
        return this.mFontColor;
    }

    public float getSymbolSpan() {
        return this.mSymbolSpan;
    }

    @Override
    public float getSymbolSpan(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getSymbolSpan(), string);
    }

    public boolean setSymbolSpan(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("span < 0.0f");
        }
        this.mSymbolSpan = f;
        return true;
    }

    @Override
    public boolean setSymbolSpan(float f, String string) {
        Float f2 = SGUtility.calcPropertyValue(f, string, "cm", 0.5, 6.0, -2);
        if (f2 == null) {
            return false;
        }
        return this.setSymbolSpan(f2.floatValue());
    }

    private boolean isMoved() {
        boolean bl = (int)this.mLegendX == (int)this.mLegendLocation.getX();
        boolean bl2 = (int)this.mLegendY == (int)this.mLegendLocation.getY();
        boolean bl3 = !bl || !bl2;
        return bl3;
    }

    @Override
    public boolean closeTextField() {
        this.commitEdit();
        this.hideEditField();
        this.clearFocusedGroup();
        this.repaint();
        return true;
    }

    private boolean commitEdit() {
        String string = this.mTextField.getText();
        if (!SGUtilityText.isValidString(string)) {
            return false;
        }
        String string2 = this.mFocusedGroup.getName();
        String string3 = string;
        this.mFocusedGroup.setName(string3);
        this.updateAllDrawingElements();
        if (!string2.equals(string3)) {
            this.mFocusedGroup.setChanged(true);
        }
        this.notifyChange();
        this.notifyToRoot();
        return true;
    }

    private boolean hideEditField() {
        this.mTextField.setText("");
        this.mTextField.setVisible(false);
        return true;
    }

    private boolean clearFocusedGroup() {
        this.mFocusedGroup = null;
        return true;
    }

    @Override
    public boolean onMousePressed(MouseEvent mouseEvent) {
        Rectangle2D rectangle2D;
        if (!this.isLegendVisible()) {
            return false;
        }
        if (this.mTextField.isVisible()) {
            this.closeTextField();
        }
        if ((rectangle2D = this.getLegendRect()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.mLegendLocation = new Point((int)this.mLegendX, (int)this.mLegendY);
            this.mPressedPoint = mouseEvent.getPoint();
            this.setMouseCursor(13);
            return true;
        }
        this.clearFocusedGroup();
        return false;
    }

    @Override
    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (this.isSelected()) {
            int n = mouseEvent.getX() - this.mPressedPoint.x;
            int n2 = mouseEvent.getY() - this.mPressedPoint.y;
            this.translate(n, n2);
            this.mPressedPoint = mouseEvent.getPoint();
        }
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent mouseEvent) {
        Rectangle2D rectangle2D;
        if (this.mLegendLocation != null && this.isMoved()) {
            this.setChanged(true);
        }
        if ((rectangle2D = this.getLegendRect()).contains(mouseEvent.getPoint())) {
            this.setMouseCursor(12);
        } else {
            this.setMouseCursor(0);
        }
        return true;
    }

    @Override
    public boolean setTemporaryPropertiesOfFocusedObjects() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    @Override
    public boolean setChangedFocusedObjects() {
        SGProperties sGProperties;
        SGProperties sGProperties2;
        if (this.isSelected() && (sGProperties2 = this.mTemporaryProperties) != null && !(sGProperties = this.getProperties()).equals(sGProperties2)) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public Rectangle2D getLegendRect() {
        float f = this.mMagnification;
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), f * this.mLegendWidth, f * this.mLegendHeight);
        return float_;
    }

    public boolean isResizable(double d, double d2) {
        Rectangle2D rectangle2D = this.getLegendRect();
        return !(d < rectangle2D.getWidth()) && !(d2 < rectangle2D.getHeight());
    }

    @Override
    public boolean onDrawingElement(int n, int n2) {
        if (this.isLegendVisible() && this.getLegendRect().contains(n, n2)) {
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    @Override
    public boolean setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        this.mXAxis = sGAxis;
        this.mYAxis = sGAxis2;
        return true;
    }

    @Override
    public boolean setGraphElement(SGIFigureElementGraph sGIFigureElementGraph) {
        this.mGraphElement = sGIFigureElementGraph;
        return true;
    }

    @Override
    public int getXAxisLocation() {
        return this.mAxisElement.getLocationInPlane(this.mXAxis);
    }

    @Override
    public int getYAxisLocation() {
        return this.mAxisElement.getLocationInPlane(this.mYAxis);
    }

    @Override
    public boolean setXAxisLocation(int n) {
        if (n != 0 && n != 1) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(n);
        if (sGAxis == null) {
            return false;
        }
        this.mXAxis = sGAxis;
        return true;
    }

    @Override
    public boolean setYAxisLocation(int n) {
        if (n != 2 && n != 3) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(n);
        if (sGAxis == null) {
            return false;
        }
        this.mYAxis = sGAxis;
        return true;
    }

    public void setVisible(boolean bl) {
        this.mLegendVisibleFlag = bl;
    }

    @Override
    public boolean setLegendVisible(boolean bl) {
        this.setVisible(bl);
        return true;
    }

    @Override
    public boolean setBackgroundTransparent(int n) {
        return this.mBackgroundPaint.setTransparency(n);
    }

    @Override
    public boolean setFrameVisible(boolean bl) {
        this.mFrameVisibleFlag = bl;
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("lw < 0.0f");
        }
        this.mFrameLineWidth = f;
        return true;
    }

    @Override
    public boolean setFrameLineWidth(float f, String string) {
        Float f2 = SGUtility.getLineWidth(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setFrameLineWidth(f2.floatValue());
    }

    @Override
    public boolean setFrameLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("cl == null");
        }
        this.mFrameLineColor = color;
        return true;
    }

    @Override
    public boolean setBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("cl == null");
        }
        return this.mBackgroundPaint.setColor(color);
    }

    public boolean setFontSize(float f) {
        return this.setFont(this.getFontName(), this.getFontStyle(), f);
    }

    @Override
    public boolean setFontSize(float f, String string) {
        Float f2 = SGUtility.getFontSize(f, string);
        if (f2 == null) {
            return false;
        }
        return this.setFontSize(f2.floatValue());
    }

    @Override
    public boolean setFontStyle(int n) {
        if (!SGUtilityText.isValidFontStyle(n)) {
            return false;
        }
        return this.setFont(this.getFontName(), n, this.getFontSize());
    }

    @Override
    public boolean setFontColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        this.mFontColor = color;
        return true;
    }

    @Override
    public boolean setFontName(String string) {
        return this.setFont(string, this.getFontStyle(), this.getFontSize());
    }

    private boolean setFont(String string, int n, float f) {
        boolean bl = false;
        if (string != null) {
            if (!string.equals(this.mFontName)) {
                bl = true;
            }
        } else if (this.mFontName != null) {
            bl = true;
        }
        if (!bl && n != this.mFontStyle) {
            bl = true;
        }
        if (!bl && f != this.mFontSize) {
            bl = true;
        }
        this.mFontName = string;
        this.mFontStyle = n;
        this.mFontSize = f;
        if (bl) {
            this.updateAllDrawingElements();
        }
        return true;
    }

    private SGData getData(ElementGroupSetInLegend elementGroupSetInLegend) {
        for (int i = 0; i < this.mChildList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend2 = (ElementGroupSetInLegend)this.mChildList.get(i);
            if (!elementGroupSetInLegend2.equals(elementGroupSetInLegend)) continue;
            SGData sGData = elementGroupSetInLegend.getData();
            return sGData;
        }
        return null;
    }

    public boolean isVisible() {
        return this.mLegendVisibleFlag;
    }

    @Override
    public boolean isLegendVisible() {
        return this.isVisible();
    }

    @Override
    public boolean isFrameLineVisible() {
        return this.mFrameVisibleFlag;
    }

    public Rectangle2D getRectOfGroup(SGElementGroup sGElementGroup) {
        for (int i = 0; i < this.mChildList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mChildList.get(i);
            ArrayList<SGElementGroup> arrayList = elementGroupSetInLegend.getElementGroupList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGElementGroup sGElementGroup2 = arrayList.get(j);
                if (!sGElementGroup2.equals(sGElementGroup)) continue;
                return elementGroupSetInLegend.mDataRect;
            }
        }
        return null;
    }

    public Rectangle2D getRectOfGroupSet(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mChildList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mChildList.get(i);
            if (!sGElementGroupSet.equals(elementGroupSetInLegend)) continue;
            return elementGroupSetInLegend.mDataRect;
        }
        return null;
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList<SGElementGroup> arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList<SGElementGroup> arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList<SGElementGroup> arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    private ElementGroupErrorBar getGroupErrorBar(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList<SGElementGroup> arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupErrorBar)) continue;
            return (ElementGroupErrorBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupArrow getGroupArrow(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList<SGElementGroup> arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupArrow)) continue;
            return (ElementGroupArrow)sGElementGroup;
        }
        return null;
    }

    private ElementGroupColorMap getColorMap(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList<SGElementGroup> arrayList = elementGroupSetInLegend.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupColorMap)) continue;
            return (ElementGroupColorMap)sGElementGroup;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object.equals(this.mTextField)) {
            this.closeTextField();
            return;
        }
        if (string.equals(MENUCMD_HIDE)) {
            this.setLegendVisible(false);
            this.repaint();
            this.setChanged(true);
            this.notifyToRoot();
            return;
        }
        if (string.equals("Property")) {
            this.clearAllFocusedData();
            this.setPropertiesOfSelectedObjects();
        }
    }

    @Override
    public boolean commit() {
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.setChanged(true);
        }
        this.mTemporaryProperties = null;
        if (!this.updateAllDrawingElements()) {
            return false;
        }
        this.repaint();
        this.notifyChange();
        return true;
    }

    @Override
    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        if (!this.updateAllDrawingElements()) {
            return false;
        }
        this.repaint();
        this.notifyChange();
        return true;
    }

    @Override
    public boolean preview() {
        if (!this.updateAllDrawingElements()) {
            return false;
        }
        this.repaint();
        this.notifyChange();
        return true;
    }

    @Override
    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.updateAllDrawingElements();
        this.notifyChangeOnUndo();
        return true;
    }

    @Override
    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.updateAllDrawingElements();
        this.notifyChangeOnUndo();
        return true;
    }

    protected ArrayList getVisibleLegendList() {
        ArrayList<ElementGroupSetInLegend> arrayList = new ArrayList<ElementGroupSetInLegend>();
        for (int i = 0; i < this.mChildList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mChildList.get(i);
            if (!elementGroupSetInLegend.isVisible()) continue;
            arrayList.add(elementGroupSetInLegend);
        }
        return arrayList;
    }

    protected ArrayList getVisibleTotallyLegendList() {
        ArrayList<ElementGroupSetInLegend> arrayList = new ArrayList<ElementGroupSetInLegend>();
        for (int i = 0; i < this.mChildList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mChildList.get(i);
            if (!elementGroupSetInLegend.isVisibleTotally()) continue;
            arrayList.add(elementGroupSetInLegend);
        }
        return arrayList;
    }

    @Override
    public boolean createDataObject(Element element, SGData sGData, boolean bl) {
        if (!super.createDataObject(element, sGData, bl)) {
            return false;
        }
        this.updateAllDrawingElements();
        this.mStartFlag = false;
        return true;
    }

    @Override
    public List<SGData> getFocusedDataList() {
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof ElementGroupSetInLegend)) continue;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
            SGData sGData = this.getData(elementGroupSetInLegend);
            arrayList2.add(sGData);
        }
        return arrayList2;
    }

    @Override
    public List<SGICopiable> cutFocusedObjects() {
        return new ArrayList<SGICopiable>();
    }

    @Override
    public List<SGData> cutFocusedData() {
        List<SGData> list = this.getFocusedDataList();
        this.hideSelectedData();
        return list;
    }

    @Override
    protected boolean hideSelectedData() {
        if (!super.hideSelectedData()) {
            return false;
        }
        this.updateAllDrawingElements();
        this.repaint();
        return true;
    }

    @Override
    public boolean moveFocusedObjects(boolean bl) {
        return true;
    }

    @Override
    public boolean moveFocusedObjects(int n) {
        return true;
    }

    @Override
    public int getIndex(SGData sGData) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)list.get(i);
            SGData sGData2 = elementGroupSetInLegend.getData();
            if (!sGData2.equals(sGData)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean sortLegend(SGData[] sGDataArray, int[] nArray) {
        int n;
        int n2;
        if (sGDataArray == null || nArray == null) {
            throw new IllegalArgumentException("dataArray == null || indexArray == null");
        }
        if (sGDataArray.length != nArray.length) {
            throw new IllegalArgumentException("dataArray.length != indexArray.length");
        }
        int n3 = sGDataArray.length;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] < n4) {
                n4 = nArray[i];
            }
            if (nArray[i] <= n5) continue;
            n5 = nArray[i];
        }
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = nArray[n2] - n4;
        }
        n2 = n5 - n4 + 1;
        ArrayList[] arrayListArray = new ArrayList[n2];
        for (n = 0; n < n2; ++n) {
            arrayListArray[n] = new ArrayList();
        }
        for (n = 0; n < n3; ++n) {
            arrayListArray[nArray2[n]].add(sGDataArray[n]);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            arrayList.addAll(arrayListArray[i]);
        }
        ArrayList<SGElementGroupSetInFigureElement> arrayList2 = new ArrayList<SGElementGroupSetInFigureElement>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGData sGData = (SGData)arrayList.get(i);
            SGElementGroupSetInFigureElement sGElementGroupSetInFigureElement = this.getElementGroupSet(sGData);
            arrayList2.add(sGElementGroupSetInFigureElement);
        }
        this.mChildList.clear();
        this.mChildList.addAll(arrayList2);
        return true;
    }

    @Override
    public String getTagName() {
        return "Legend";
    }

    @Override
    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mFrameLineWidth, -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.mFontSize, -3);
        float f3 = (float)SGUtilityNumber.roundOffNumber(this.mSymbolSpan * 0.035277776f, -3);
        element.setAttribute("LegendVisible", Boolean.toString(this.mLegendVisibleFlag));
        element.setAttribute("XAxisPosition", this.mAxisElement.getLocationName(this.mXAxis));
        element.setAttribute("YAxisPosition", this.mAxisElement.getLocationName(this.mYAxis));
        element.setAttribute("XValue", Double.toString(this.getXValue()));
        element.setAttribute("YValue", Double.toString(this.getYValue()));
        element.setAttribute("FrameVisible", Boolean.toString(this.mFrameVisibleFlag));
        element.setAttribute("FrameLineWidth", Float.toString(f) + "pt");
        element.setAttribute("FrameLineColor", SGUtilityText.getColorString(this.mFrameLineColor));
        element.setAttribute("BackgroundColor", SGUtilityText.getColorString(this.mBackgroundPaint.getColor()));
        element.setAttribute("BackgroundTransparent", Integer.toString(this.mBackgroundPaint.getTransparencyPercent()) + "%");
        element.setAttribute("FontName", this.mFontName);
        element.setAttribute("FontSize", Float.toString(f2) + "pt");
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mFontStyle));
        element.setAttribute("StringColor", SGUtilityText.getColorString(this.mFontColor));
        element.setAttribute("SymbolSpan", Float.toString(f3) + "cm");
        return true;
    }

    @Override
    public Element[] createElement(Document document) {
        Element element = this.createThisElement(document);
        return new Element[]{element};
    }

    @Override
    public boolean readProperty(Element element) {
        float f;
        String string;
        SGAxis sGAxis;
        String string2 = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        string2 = element.getAttribute("LegendVisible");
        if (string2.length() != 0) {
            bl = SGUtilityText.getBoolean(string2);
            if (bl == null) {
                return false;
            }
            if (!this.setLegendVisible(bl)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("XAxisPosition")).length() != 0) {
            this.mXAxis = sGAxis = this.mAxisElement.getAxis(string2);
        }
        if ((string2 = element.getAttribute("YAxisPosition")).length() != 0) {
            this.mYAxis = sGAxis = this.mAxisElement.getAxis(string2);
        }
        if ((string2 = element.getAttribute("XValue")).length() != 0) {
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.mXAxis.isValidValue(d)) {
                return false;
            }
            if (!this.setXValue(d)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("YValue")).length() != 0) {
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.mYAxis.isValidValue(d)) {
                return false;
            }
            if (!this.setYValue(d)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("FrameVisible")).length() != 0) {
            bl = SGUtilityText.getBoolean(string2);
            if (bl == null) {
                return false;
            }
            if (!this.setFrameVisible(bl)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("FrameLineWidth")).length() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string2, stringBuffer);
            if (number == null) {
                return false;
            }
            if (!this.setFrameLineWidth(number.floatValue(), stringBuffer.toString())) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("FrameLineColor")).length() != 0) {
            color = SGUtilityText.parseColor(string2);
            if (color == null) {
                return false;
            }
            if (!this.setFrameLineColor(color)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("BackgroundColor")).length() != 0) {
            color = SGUtilityText.parseColor(string2);
            if (color == null) {
                return false;
            }
            if (!this.setBackgroundColor(color)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("BackgroundTransparent")).length() != 0) {
            bl = SGUtilityText.getBoolean(string2);
            if (bl != null) {
                if (bl == false ? !this.setBackgroundTransparent(0) : !this.setBackgroundTransparent(100)) {
                    return false;
                }
            } else {
                number = SGUtilityText.getInteger(string2, "%");
                if (number == null) {
                    return false;
                }
                if (!this.setBackgroundTransparent(number.intValue())) {
                    return false;
                }
            }
        }
        if ((string2 = element.getAttribute("FontName")).length() != 0 && !this.setFontName(string = string2)) {
            return false;
        }
        string2 = element.getAttribute("FontSize");
        if (string2.length() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string2, stringBuffer);
            if (number == null) {
                return false;
            }
            if (!this.setFontSize(number.floatValue(), stringBuffer.toString())) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("FontStyle")).length() != 0) {
            Integer n = SGUtilityText.getFontStyle(string2);
            if (n == null) {
                return false;
            }
            if (!this.setFontStyle(n)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("StringColor")).length() != 0) {
            color = SGUtilityText.parseColor(string2);
            if (color == null) {
                return false;
            }
            if (!this.setFontColor(color)) {
                return false;
            }
        }
        if ((string2 = element.getAttribute("SymbolSpan")).length() != 0) {
            number = SGUtilityText.getLengthInPoint(string2);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
        } else {
            number = Float.valueOf((float)SGUtilityText.convertToPoint(2.0, "cm"));
            f = number.floatValue();
        }
        return this.setSymbolSpan(f);
    }

    private boolean readProperty(SGElementGroup sGElementGroup, Element element) {
        String string = element.getAttribute("Visible");
        if (string.length() != 0) {
            Boolean bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            sGElementGroup.setVisible(bl);
        }
        return true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        char c = keyEvent.getKeyChar();
        if (object.equals(this.mTextField) && c == '\u001b') {
            this.hideEditField();
            this.clearFocusedGroup();
        }
    }

    @Override
    protected SGIElementGroupSetSXY createSXYGroupSetInstance(SGISXYTypeData sGISXYTypeData) {
        return new ElementGroupSetInLegendSXY((SGData)((Object)sGISXYTypeData));
    }

    @Override
    protected SGIElementGroupSetVXY createVXYGroupSetInstance(SGIVXYTypeData sGIVXYTypeData) {
        return new ElementGroupSetInLegendVXY((SGData)((Object)sGIVXYTypeData));
    }

    protected SGIElementGroupSetVXY createGridVXYGroupSetInstance(SGIVXYTypeData sGIVXYTypeData) {
        return new ElementGroupSetInLegendVXY((SGData)((Object)sGIVXYTypeData));
    }

    @Override
    protected SGIElementGroupSetMultipleSXY createMultipleSXYGroupSetInstance(SGISXYTypeMultipleData sGISXYTypeMultipleData) {
        return new ElementGroupSetInLegendMultipleSXY((SGData)((Object)sGISXYTypeMultipleData));
    }

    @Override
    protected SGIElementGroupSetSXYZ createSXYZGroupSetInstance(SGISXYZTypeData sGISXYZTypeData) {
        return new ElementGroupSetInLegendSXYZ((SGData)((Object)sGISXYZTypeData));
    }

    @Override
    public boolean setDialogOwner(Frame frame) {
        if (!super.setDialogOwner(frame)) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SGFigureElementLegend.this.mPropertyDialog == null) {
                    SGFigureElementLegend.this.mPropertyDialog = new SGLegendDialog(SGFigureElementLegend.this.mDialogOwner, true);
                }
            }
        });
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateLabelTextField();
    }

    private void updateLabelTextField() {
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)(this.getFontSize() * this.getMagnification()));
        this.updateTextField(this.mTextField, font);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void onMenuSelected() {
        if (this.mTextField.isVisible()) {
            this.closeTextField();
        }
    }

    public SGColorBarModel getColorBarModel() {
        return this.mAxisElement.getColorBarModel();
    }

    @Override
    public boolean moveLegendToEnd(int n, boolean bl) {
        ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.getVisibleChild(n);
        if (elementGroupSetInLegend == null) {
            return false;
        }
        this.moveChildToEnd(n, !bl);
        this.updateAllDrawingElements();
        this.repaint();
        return true;
    }

    @Override
    public boolean moveLegend(int n, boolean bl) {
        ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.getVisibleChild(n);
        if (elementGroupSetInLegend == null) {
            return false;
        }
        this.moveChild(n, !bl);
        this.updateAllDrawingElements();
        this.repaint();
        return true;
    }

    @Override
    public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
        SGPropertyResults sGPropertyResults = new SGPropertyResults();
        if (!this.prepare()) {
            return null;
        }
        Iterator<String> iterator = sGPropertyMap.getKeyIterator();
        while (iterator.hasNext()) {
            Number number;
            String string = iterator.next();
            String string2 = sGPropertyMap.getValueString(string);
            if ("AxisX".equalsIgnoreCase(string)) {
                int n = SGUtility.getAxisLocation(string2);
                if (n == -1) {
                    sGPropertyResults.putResult("AxisX", 1);
                    continue;
                }
                if (!this.setXAxisLocation(n)) {
                    sGPropertyResults.putResult("AxisX", 1);
                    continue;
                }
                sGPropertyResults.putResult("AxisX", 0);
                continue;
            }
            if ("AxisY".equalsIgnoreCase(string)) {
                int n = SGUtility.getAxisLocation(string2);
                if (n == -1) {
                    sGPropertyResults.putResult("AxisY", 1);
                    continue;
                }
                if (!this.setYAxisLocation(n)) {
                    sGPropertyResults.putResult("AxisY", 1);
                    continue;
                }
                sGPropertyResults.putResult("AxisY", 0);
                continue;
            }
            if ("X".equalsIgnoreCase(string)) {
                Double d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    sGPropertyResults.putResult("X", 1);
                    continue;
                }
                if (!SGUtility.isValidPropertyValue(d)) {
                    sGPropertyResults.putResult("X", 1);
                    continue;
                }
                if (!this.setXValue(d)) {
                    sGPropertyResults.putResult("X", 1);
                    continue;
                }
                sGPropertyResults.putResult("X", 0);
                continue;
            }
            if ("Y".equalsIgnoreCase(string)) {
                Double d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    sGPropertyResults.putResult("Y", 1);
                    continue;
                }
                if (!SGUtility.isValidPropertyValue(d)) {
                    sGPropertyResults.putResult("Y", 1);
                    continue;
                }
                if (!this.setYValue(d)) {
                    sGPropertyResults.putResult("Y", 1);
                    continue;
                }
                sGPropertyResults.putResult("Y", 0);
                continue;
            }
            if ("Visible".equalsIgnoreCase(string)) {
                Boolean bl = SGUtilityText.getBoolean(string2);
                if (bl == null) {
                    sGPropertyResults.putResult("Visible", 1);
                    continue;
                }
                this.setVisible(bl);
                sGPropertyResults.putResult("Visible", 0);
                continue;
            }
            if ("FontName".equalsIgnoreCase(string)) {
                String string3 = SGUtility.findFontFamilyName(string2);
                if (string3 == null) {
                    sGPropertyResults.putResult("FontName", 1);
                    continue;
                }
                if (!this.setFontName(string3)) {
                    sGPropertyResults.putResult("FontName", 1);
                    continue;
                }
                sGPropertyResults.putResult("FontName", 0);
                continue;
            }
            if ("FontStyle".equalsIgnoreCase(string)) {
                Integer n = SGUtilityText.getFontStyle(string2);
                if (n == null) {
                    sGPropertyResults.putResult("FontStyle", 1);
                    continue;
                }
                if (!this.setFontStyle(n)) {
                    sGPropertyResults.putResult("FontStyle", 1);
                    continue;
                }
                sGPropertyResults.putResult("FontStyle", 0);
                continue;
            }
            if ("FontSize".equalsIgnoreCase(string)) {
                StringBuffer stringBuffer = new StringBuffer();
                number = SGUtilityText.getNumber(string2, stringBuffer);
                if (number == null) {
                    sGPropertyResults.putResult("FontSize", 1);
                    continue;
                }
                if (!this.setFontSize(number.floatValue(), stringBuffer.toString())) {
                    sGPropertyResults.putResult("FontSize", 1);
                    continue;
                }
                sGPropertyResults.putResult("FontSize", 0);
                continue;
            }
            if ("FontColor".equalsIgnoreCase(string)) {
                Color color = SGUtilityText.getColor(string2);
                if (color != null) {
                    if (!this.setFontColor(color)) {
                        sGPropertyResults.putResult("FontColor", 1);
                        continue;
                    }
                } else {
                    color = SGUtilityText.parseColor(string2);
                    if (color == null) {
                        sGPropertyResults.putResult("FontColor", 1);
                        continue;
                    }
                    if (!this.setFontColor(color)) {
                        sGPropertyResults.putResult("FontColor", 1);
                        continue;
                    }
                }
                sGPropertyResults.putResult("FontColor", 0);
                continue;
            }
            if ("FrameVisible".equalsIgnoreCase(string)) {
                Boolean bl = SGUtilityText.getBoolean(string2);
                if (bl == null) {
                    sGPropertyResults.putResult("FrameVisible", 1);
                    continue;
                }
                if (!this.setFrameVisible(bl)) {
                    sGPropertyResults.putResult("FrameVisible", 1);
                    continue;
                }
                sGPropertyResults.putResult("FrameVisible", 0);
                continue;
            }
            if ("FrameLineWidth".equalsIgnoreCase(string)) {
                StringBuffer stringBuffer = new StringBuffer();
                number = SGUtilityText.getNumber(string2, stringBuffer);
                if (number == null) {
                    sGPropertyResults.putResult("FrameLineWidth", 1);
                    continue;
                }
                if (!this.setFrameLineWidth(number.floatValue(), stringBuffer.toString())) {
                    sGPropertyResults.putResult("FrameLineWidth", 1);
                    continue;
                }
                sGPropertyResults.putResult("FrameLineWidth", 0);
                continue;
            }
            if ("FrameColor".equalsIgnoreCase(string)) {
                Color color = SGUtilityText.getColor(string2);
                if (color != null) {
                    if (!this.setFrameLineColor(color)) {
                        sGPropertyResults.putResult("FrameColor", 1);
                        continue;
                    }
                } else {
                    color = SGUtilityText.parseColor(string2);
                    if (color == null) {
                        sGPropertyResults.putResult("FrameColor", 1);
                        continue;
                    }
                    if (!this.setFrameLineColor(color)) {
                        sGPropertyResults.putResult("FrameColor", 1);
                        continue;
                    }
                }
                sGPropertyResults.putResult("FrameColor", 0);
                continue;
            }
            if ("BackgroundTransparency".equalsIgnoreCase(string)) {
                Integer n = SGUtilityText.getInteger(string2, "%");
                if (n == null) {
                    sGPropertyResults.putResult("BackgroundTransparency", 1);
                    continue;
                }
                if (!this.setBackgroundTransparent(n)) {
                    sGPropertyResults.putResult("BackgroundTransparency", 1);
                    continue;
                }
                sGPropertyResults.putResult("BackgroundTransparency", 0);
                continue;
            }
            if ("BackgroundColor".equalsIgnoreCase(string)) {
                Color color = SGUtilityText.getColor(string2);
                if (color != null) {
                    if (!this.setBackgroundColor(color)) {
                        sGPropertyResults.putResult("BackgroundColor", 1);
                        continue;
                    }
                } else {
                    color = SGUtilityText.parseColor(string2);
                    if (color == null) {
                        sGPropertyResults.putResult("BackgroundColor", 1);
                        continue;
                    }
                    if (!this.setBackgroundColor(color)) {
                        sGPropertyResults.putResult("BackgroundColor", 1);
                        continue;
                    }
                }
                sGPropertyResults.putResult("BackgroundColor", 0);
                continue;
            }
            if (!"SymbolSpan".equalsIgnoreCase(string)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string2, stringBuffer);
            if (number == null) {
                sGPropertyResults.putResult("SymbolSpan", 1);
                continue;
            }
            if (!this.setSymbolSpan(number.floatValue(), stringBuffer.toString())) {
                sGPropertyResults.putResult("SymbolSpan", 1);
                continue;
            }
            sGPropertyResults.putResult("SymbolSpan", 0);
        }
        if (!this.updateAllDrawingElements()) {
            return null;
        }
        if (!this.commit()) {
            return null;
        }
        this.notifyChange();
        this.notifyToRoot();
        this.repaint();
        return sGPropertyResults;
    }

    private class ElementGroupColorMap
    extends SGElementGroupColorMap
    implements ILegendElement,
    SGISXYZDataConstants {
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();
        protected ElementGroupSetInLegend mGroupSet = null;
        private SGTuple2f mLocation = new SGTuple2f();

        private ElementGroupColorMap() {
        }

        protected SGDrawingElement createDrawingElementInstance(int n) {
            return new ColorMapRectangleInLegend(this, n);
        }

        public boolean createDrawingElementInLegend() {
            float f = this.getPreferredWidth();
            float f2 = this.getPreferredHeight();
            SGElementGroupColorMap.ColorMapRectangle colorMapRectangle = (SGElementGroupColorMap.ColorMapRectangle)this.mDrawingElementArray[0];
            colorMapRectangle.setWidth(f);
            colorMapRectangle.setHeight(f2);
            Rectangle2D rectangle2D = SGFigureElementLegend.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f3 = (float)rectangle2D.getX() + 0.5f * (float)rectangle2D2.getWidth();
            float f4 = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f = new SGTuple2f(f3, f4);
            return this.setLocation(new SGTuple2f[]{sGTuple2f});
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public float getPreferredHeight() {
            ElementGroupSetInLegendSXYZ elementGroupSetInLegendSXYZ = (ElementGroupSetInLegendSXYZ)this.mGroupSet;
            Rectangle2D rectangle2D = elementGroupSetInLegendSXYZ.mDrawingString.getElementBounds();
            return (float)rectangle2D.getHeight();
        }

        public float getPreferredWidth() {
            return this.getMagnification() * SGFigureElementLegend.this.getSymbolSpan();
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            SGElementGroupColorMap.ColorMapRectangle colorMapRectangle = (SGElementGroupColorMap.ColorMapRectangle)this.mDrawingElementArray[0];
            Rectangle rectangle = colorMapRectangle.getElementBounds().getBounds();
            double d = rectangle.getX();
            double d2 = rectangle.getY();
            double d3 = rectangle.getHeight();
            int n = (int)rectangle.getMinX();
            int n2 = (int)rectangle.getMaxX();
            double d4 = this.mColorBarModel.getMinValue();
            double d5 = this.mColorBarModel.getMaxValue();
            double d6 = d5 - d4;
            int n3 = n2 - n;
            if (n3 != 0) {
                for (int i = 0; i <= n3; ++i) {
                    Rectangle2D.Double double_ = new Rectangle2D.Double();
                    ((Rectangle2D)double_).setRect(d + (double)i, d2, 1.0, d3);
                    double d7 = (double)i / (double)n3;
                    double d8 = d4 + d7 * d6;
                    Color color = this.mColorBarModel.evaluate(d8, 0);
                    graphics2D.setColor(color);
                    graphics2D.fill(double_);
                }
            }
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(rectangle);
            if (this.mGroupSet.isVisibleTotally() && this.mGroupSet.isSelected() && SGFigureElementLegend.this.isSymbolsVisibleAroundFocusedObjects()) {
                SGUtilityForFigureElementJava2D.drawAnchorsOnRectangle(rectangle, graphics2D);
            }
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
                this.initDrawingElement(sGTuple2fArray);
            }
            this.mLocation.setValues(sGTuple2fArray[0]);
            return true;
        }

        public float getX(int n) {
            return this.mLocation.x;
        }

        public float getY(int n) {
            return this.mLocation.y;
        }
    }

    protected static class ColorMapRectangleInLegend
    extends SGElementGroupColorMap.ColorMapRectangle {
        public ColorMapRectangleInLegend(SGElementGroupColorMap sGElementGroupColorMap, int n) {
            super(sGElementGroupColorMap, n);
        }

        public float getWidth() {
            return this.mGroup.getRectangleWidth();
        }

        public float getHeight() {
            return this.mGroup.getRectangleHeight();
        }

        public boolean setWidth(float f) {
            return this.mGroup.setRectangleWidth(f);
        }

        public boolean setHeight(float f) {
            return this.mGroup.setRectangleHeight(f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementGroupSetInLegendSXYZ
    extends ElementGroupSetInLegend
    implements SGIElementGroupSetSXYZ,
    SGISXYZDataConstants,
    SGISXYZDataDialogObserver {
        protected ElementGroupSetInLegendSXYZ(SGData sGData) {
            super(sGData);
        }

        @Override
        boolean onMouseClicked(MouseEvent mouseEvent) {
            return false;
        }

        @Override
        void paintSymbol(Graphics2D graphics2D) {
            ElementGroupColorMap elementGroupColorMap = SGFigureElementLegend.this.getColorMap(this);
            if (elementGroupColorMap != null && elementGroupColorMap.isVisible()) {
                elementGroupColorMap.paintElement(graphics2D);
            }
        }

        @Override
        public boolean addDrawingElementGroup(int n) {
            ElementGroupColorMap elementGroupColorMap = null;
            if (n != 2) {
                throw new Error();
            }
            ElementGroupColorMap elementGroupColorMap2 = new ElementGroupColorMap();
            elementGroupColorMap2.setColorBarModel(SGFigureElementLegend.this.getColorBarModel());
            elementGroupColorMap = elementGroupColorMap2;
            this.addDrawingElementGroup(elementGroupColorMap);
            return true;
        }

        @Override
        public SGElementGroupColorMap getColorMap() {
            return SGFigureElementLegend.this.getColorMap(this);
        }

        @Override
        public boolean setZAxis(SGAxis sGAxis) {
            this.mZAxis = sGAxis;
            return true;
        }

        @Override
        public double getRectangleWidthValue() {
            return this.getColorMap().getWidthValue();
        }

        @Override
        public double getRectangleHeightValue() {
            return this.getColorMap().getHeightValue();
        }

        @Override
        public boolean setRectangleWidthValue(double d) {
            this.getColorMap().setWidthValue(d);
            return true;
        }

        @Override
        public boolean setRectangleHeightValue(double d) {
            this.getColorMap().setHeightValue(d);
            return true;
        }

        @Override
        public boolean hasValidRectangleWidthValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mXAxis : SGFigureElementLegend.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getRectangleWidthValue();
            return sGAxis.isValidValue(d);
        }

        @Override
        public boolean hasValidRectangleHeightValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementLegend.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getRectangleHeightValue();
            return sGAxis.isValidValue(d);
        }

        @Override
        public int getXAxisLocation() {
            return SGFigureElementLegend.this.mAxisElement.getLocationInPlane(this.getXAxis());
        }

        @Override
        public int getYAxisLocation() {
            return SGFigureElementLegend.this.mAxisElement.getLocationInPlane(this.getYAxis());
        }

        @Override
        public boolean setXAxisLocation(int n) {
            this.mXAxis = this.getAxis(n);
            return true;
        }

        @Override
        public boolean setYAxisLocation(int n) {
            this.mYAxis = this.getAxis(n);
            return true;
        }

        public List<SGElementGroupColorMap> getColorMapGroups() {
            ArrayList<SGElementGroupColorMap> arrayList = new ArrayList<SGElementGroupColorMap>();
            List<SGElementGroup> list = SGUtilityForFigureElement.getGroups(SGElementGroupColorMap.class, this.mDrawingElementGroupList);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add((SGElementGroupColorMap)list.get(i));
            }
            return arrayList;
        }

        public SGElementGroupColorMap getColorMapGroup() {
            return (SGElementGroupColorMap)SGUtilityForFigureElement.getGroup(SGElementGroupColorMap.class, this.mDrawingElementGroupList);
        }

        @Override
        protected boolean setElementGroupProperties(List list) {
            for (int i = 0; i < list.size(); ++i) {
                SGProperties sGProperties = (SGProperties)list.get(i);
                SGElementGroupColorMap sGElementGroupColorMap = null;
                if (!(sGProperties instanceof SGElementGroupColorMap.ColorMapProperties)) {
                    throw new Error("Illegal group property: " + sGProperties);
                }
                sGElementGroupColorMap = this.getColorMapGroup();
                if (sGElementGroupColorMap == null || ((SGElementGroup)sGElementGroupColorMap).setProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean updateColorMapSize() {
            SGISXYZTypeData sGISXYZTypeData = (SGISXYZTypeData)((Object)this.getData());
            SGAxis sGAxis = this.getXAxis();
            double[] dArray = sGISXYZTypeData.getXValueArray();
            double d = SGUtilityForFigureElementJava2D.calcSizeValue(dArray, sGAxis, true);
            SGAxis sGAxis2 = this.getYAxis();
            double[] dArray2 = sGISXYZTypeData.getYValueArray();
            double d2 = SGUtilityForFigureElementJava2D.calcSizeValue(dArray2, sGAxis2, false);
            SGElementGroupColorMap sGElementGroupColorMap = this.getColorMap();
            sGElementGroupColorMap.setWidthValue(d);
            sGElementGroupColorMap.setHeightValue(d2);
            return true;
        }
    }

    public static class LegendProperties
    extends SGProperties {
        float x;
        float y;
        boolean visible;
        boolean frameLineVisible;
        float frameLineWidth;
        Color frameLineColor;
        String fontName;
        float fontSize;
        int fontStyle;
        Color stringColor;
        SGFillPaint backgroundPaint = new SGFillPaint();
        float symbolSpan;
        SGAxis xAxis;
        SGAxis yAxis;
        ArrayList visibleElementGroupList = new ArrayList();

        public void dispose() {
            super.dispose();
            this.frameLineColor = null;
            this.fontName = null;
            this.stringColor = null;
            this.stringColor = null;
            this.backgroundPaint = null;
            this.xAxis = null;
            this.yAxis = null;
            this.visibleElementGroupList.clear();
            this.visibleElementGroupList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof LegendProperties)) {
                return false;
            }
            LegendProperties legendProperties = (LegendProperties)object;
            if (legendProperties.x != this.x) {
                return false;
            }
            if (legendProperties.y != this.y) {
                return false;
            }
            if (legendProperties.visible != this.visible) {
                return false;
            }
            if (legendProperties.frameLineVisible != this.frameLineVisible) {
                return false;
            }
            if (legendProperties.frameLineWidth != this.frameLineWidth) {
                return false;
            }
            if (!legendProperties.frameLineColor.equals(this.frameLineColor)) {
                return false;
            }
            if (!legendProperties.fontName.equals(this.fontName)) {
                return false;
            }
            if (legendProperties.fontSize != this.fontSize) {
                return false;
            }
            if (legendProperties.fontStyle != this.fontStyle) {
                return false;
            }
            if (!legendProperties.stringColor.equals(this.stringColor)) {
                return false;
            }
            if (!legendProperties.backgroundPaint.equals(this.backgroundPaint)) {
                return false;
            }
            if (legendProperties.symbolSpan != this.symbolSpan) {
                return false;
            }
            if (!legendProperties.xAxis.equals(this.xAxis)) {
                return false;
            }
            if (!legendProperties.yAxis.equals(this.yAxis)) {
                return false;
            }
            return legendProperties.visibleElementGroupList.equals(this.visibleElementGroupList);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[x=");
            stringBuffer.append(this.x);
            stringBuffer.append(", y=");
            stringBuffer.append(this.y);
            stringBuffer.append(", visible=");
            stringBuffer.append(this.visible);
            stringBuffer.append(", frameLineVisible=");
            stringBuffer.append(this.frameLineVisible);
            stringBuffer.append(", frameLineWidth=");
            stringBuffer.append(this.frameLineWidth);
            stringBuffer.append(", frameLineColor=");
            stringBuffer.append(this.frameLineColor);
            stringBuffer.append(", fontName=");
            stringBuffer.append(this.fontName);
            stringBuffer.append(", fontSize=");
            stringBuffer.append(this.fontSize);
            stringBuffer.append(", fontStyle=");
            stringBuffer.append(this.fontStyle);
            stringBuffer.append(", stringColor=");
            stringBuffer.append(this.stringColor);
            stringBuffer.append(", innerColor=");
            stringBuffer.append(this.backgroundPaint.getColor());
            stringBuffer.append(", transparent=");
            stringBuffer.append(this.backgroundPaint.getTransparencyPercent());
            stringBuffer.append(", grouopSetList=");
            stringBuffer.append(this.visibleElementGroupList.toString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private class ElementGroupTickLabels
    extends SGElementGroupTickLabelForData
    implements ILegendElement,
    SGISXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet;

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        ElementGroupTickLabels(SGISXYData sGISXYData) {
            super(sGISXYData);
            this.mGroupSet = null;
        }

        protected SGDrawingElement createDrawingElementInstance(int n) {
            return new SGDrawingElementString2DExtended();
        }

        public boolean createDrawingElementInLegend() {
            return true;
        }

        public float getPreferredWidth() {
            return 0.0f;
        }

        public float getPreferredHeight() {
            return 0.0f;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
        }

        public int getNumberOfPoints() {
            return 0;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGFigureElementLegend.this.readProperty(this, element);
        }

        public boolean contains(int n, int n2) {
            return false;
        }

        public boolean updateLocation() {
            return true;
        }
    }

    private class ElementGroupErrorBar
    extends SGElementGroupErrorBarForData
    implements ILegendElement,
    SGISXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet;
        private static final float DEFAULT_ERROR_BAR_HEIGHT = 10.0f;
        private Rectangle2D mBoundsRect;
        private SGTuple2f mCenter;
        private SGTuple2f mLower;
        private SGTuple2f mUpper;

        protected ElementGroupErrorBar(SGISXYData sGISXYData) {
            super(sGISXYData);
            this.mGroupSet = null;
            this.mBoundsRect = new Rectangle2D.Float();
            this.mCenter = new SGTuple2f();
            this.mLower = new SGTuple2f();
            this.mUpper = new SGTuple2f();
        }

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        public float getPreferredWidth() {
            return this.getMagnification() * this.getHeadSize();
        }

        public float getPreferredHeight() {
            float f;
            float f2;
            SGIDisposable sGIDisposable;
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)this.mGroupSet;
            SGData sGData = elementGroupSetInLegendSXY.getData();
            if (sGData instanceof SGISXYData && !(sGIDisposable = (SGISXYData)((Object)sGData)).isErrorBarAvailable()) {
                return 0.0f;
            }
            sGIDisposable = elementGroupSetInLegendSXY.getSymbolGroup();
            SGElementGroupBar sGElementGroupBar = elementGroupSetInLegendSXY.getBarGroup();
            float f3 = 0.0f;
            if (((SGElementGroup)sGIDisposable).isVisible() || sGElementGroupBar.isVisible()) {
                f2 = ((SGElementGroup)sGIDisposable).isVisible() ? ((ILegendElement)((Object)sGIDisposable)).getPreferredHeight() : 0.0f;
                f = sGElementGroupBar.isVisible() ? ((ILegendElement)((Object)sGElementGroupBar)).getPreferredHeight() : 0.0f;
                f3 = f2 > f ? f2 : f;
            } else {
                f3 = 10.0f;
            }
            f2 = this.getMagnification();
            f = 1.2f * f2 * f3;
            float f4 = f2 * this.getHeadSize();
            return f + 2.0f * f4;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            float f;
            SGTuple2f sGTuple2f = new SGTuple2f();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            SGTuple2f sGTuple2f3 = new SGTuple2f();
            Rectangle2D rectangle2D = SGFigureElementLegend.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f2 = this.getMagnification();
            sGTuple2f.x = f = (float)rectangle2D.getX() + 0.5f * (float)rectangle2D2.getWidth();
            sGTuple2f2.x = f;
            sGTuple2f3.x = f;
            float f3 = f2 * this.getHeadSize();
            float f4 = (float)rectangle2D.getY() + (float)rectangle2D.getHeight() / 2.0f;
            float f5 = ((float)rectangle2D2.getHeight() - f3) / 2.0f;
            sGTuple2f.y = f4;
            sGTuple2f2.y = f4 + f5;
            sGTuple2f3.y = f4 - f5;
            this.mCenter = sGTuple2f;
            this.mLower = sGTuple2f2;
            this.mUpper = sGTuple2f3;
            return this.setLocation(new SGTuple2f[]{sGTuple2f}, new SGTuple2f[]{sGTuple2f2}, new SGTuple2f[]{sGTuple2f3});
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGFigureElementLegend.this.readProperty(this, element);
        }

        public boolean contains(int n, int n2) {
            SGISXYData sGISXYData = (SGISXYData)((Object)SGFigureElementLegend.this.getData(this.mGroupSet));
            if (!sGISXYData.isErrorBarAvailable()) {
                return false;
            }
            return super.contains(n, n2);
        }

        public boolean updateLocation() {
            return true;
        }

        public SGTuple2f getLowerEndLocation(int n) {
            return this.mLower;
        }

        public SGTuple2f getStartLocation(int n) {
            return this.mCenter;
        }

        public SGTuple2f getUpperEndLocation(int n) {
            return this.mUpper;
        }
    }

    private class ElementGroupArrow
    extends SGElementGroupArrowForData
    implements ILegendElement,
    SGIVXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet = null;
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();
        private SGTuple2f mStartPoint = new SGTuple2f();
        private SGTuple2f mEndPoint = new SGTuple2f();
        private SGDrawingElementString2DExtended mMagnitudeString = new SGDrawingElementString2DExtended();

        protected ElementGroupArrow() {
            this.mMagnitudeString.setFontName("Serif");
            this.mMagnitudeString.setFontStyle(0);
            this.mMagnitudeString.setFontSize(16.0f, "pt");
            this.mMagnitudeString.setColor(SGILegendConstants.DEFAULT_LEGEND_FONT_COLOR);
        }

        protected SGDrawingElement createDrawingElementInstance(int n) {
            return new SGElementGroupArrow.ArrowInGroup(this, n);
        }

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        public float getPreferredWidth() {
            return this.getMagnification() * SGFigureElementLegend.this.getSymbolSpan();
        }

        private Rectangle2D getDataElementBounds() {
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (sGDrawingElementArray != null) {
                if (sGDrawingElementArray.length == 0) {
                    return new Rectangle2D.Float();
                }
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)sGDrawingElementArray[0];
                Rectangle2D rectangle2D = sGDrawingElementArrow2D.getElementBounds();
                return rectangle2D;
            }
            return new Rectangle2D.Float();
        }

        public float getPreferredHeight() {
            float f = 1.2f * (float)this.getDataElementBounds().getHeight();
            float f2 = (float)this.mMagnitudeString.getElementBounds().getHeight();
            float f3 = f + 2.0f * f2;
            return f3;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGFigureElementLegend.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f = this.getMagnification() * this.getHeadSize();
            int n = this.getStartHeadType();
            int n2 = this.getEndHeadType();
            float f2 = (float)rectangle2D.getX();
            float f3 = (float)rectangle2D.getY();
            float f4 = (float)rectangle2D2.getWidth();
            float f5 = (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = f2;
            if (this.doShiftX(n)) {
                sGTuple2f.x += f;
            }
            sGTuple2f.y = f3 + 0.5f * f5;
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = f2 + f4;
            if (this.doShiftX(n2)) {
                sGTuple2f2.x -= f;
            }
            sGTuple2f2.y = sGTuple2f.y;
            this.mStartPoint = sGTuple2f;
            this.mEndPoint = sGTuple2f2;
            if (!this.setLocation(new SGTuple2f[]{sGTuple2f}, new SGTuple2f[]{sGTuple2f2})) {
                return false;
            }
            this.updateMagnitudeString();
            return true;
        }

        private boolean doShiftX(int n) {
            boolean bl = n != 10 && n != 8 && n != -1;
            return bl;
        }

        private boolean updateMagnitudeString() {
            ElementGroupSetInLegendVXY elementGroupSetInLegendVXY = (ElementGroupSetInLegendVXY)this.mGroupSet;
            float f = elementGroupSetInLegendVXY.getMagnitudePerCM();
            if (Float.isNaN(f)) {
                this.mMagnitudeString.setString("NaN");
            } else {
                float f2 = SGFigureElementLegend.this.getSymbolSpan("cm");
                float f3 = f * f2;
                float f4 = (float)SGUtilityNumber.getNumberInNumberOrder(f3, f3, 3, 4);
                this.mMagnitudeString.setString(Float.toString(f4));
            }
            Rectangle2D rectangle2D = SGFigureElementLegend.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            Rectangle2D rectangle2D3 = this.mMagnitudeString.getElementBounds();
            Rectangle2D rectangle2D4 = this.getDataElementBounds();
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)(rectangle2D.getX() + 0.5 * (rectangle2D2.getWidth() - rectangle2D3.getWidth()));
            sGTuple2f.y = (float)(rectangle2D4.getY() + rectangle2D4.getHeight()) + 2.0f;
            this.mMagnitudeString.setLocation(sGTuple2f);
            return true;
        }

        public boolean setMagnification(float f) {
            if (!super.setMagnification(f)) {
                return false;
            }
            return this.mMagnitudeString.setMagnification(f);
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            super.paintElement(graphics2D, rectangle2D);
            this.mMagnitudeString.paint(graphics2D, rectangle2D);
            if (this.mGroupSet.isVisibleTotally() && this.mGroupSet.isSelected() && SGFigureElementLegend.this.isSymbolsVisibleAroundFocusedObjects()) {
                SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)this.mDrawingElementArray[0];
                SGTuple2f sGTuple2f = sGDrawingElementArrow.getStart();
                SGTuple2f sGTuple2f2 = sGDrawingElementArrow.getEnd();
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(new Point2D.Float(sGTuple2f.x, sGTuple2f.y), graphics2D);
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(new Point2D.Float(sGTuple2f2.x, sGTuple2f2.y), graphics2D);
            }
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGFigureElementLegend.this.readProperty(this, element);
        }

        public SGTuple2f getEndLocation(int n) {
            return this.mEndPoint;
        }

        public SGTuple2f getStartLocation(int n) {
            return this.mStartPoint;
        }

        public boolean initDrawingElement(float[] fArray, float[] fArray2) {
            return false;
        }

        public boolean setLocation(float[] fArray, float[] fArray2) {
            return false;
        }
    }

    private class ElementGroupSymbol
    extends SGElementGroupSymbolForData
    implements ILegendElement,
    SGISXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet;
        private Rectangle2D mBoundsRect;
        private SGTuple2f mLocation;

        protected ElementGroupSymbol(SGISXYData sGISXYData) {
            super(sGISXYData);
            this.mGroupSet = null;
            this.mBoundsRect = new Rectangle2D.Float();
            this.mLocation = new SGTuple2f();
        }

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        public float getPreferredWidth() {
            return this.getDataElementSize();
        }

        public float getPreferredHeight() {
            return 1.2f * this.getDataElementSize();
        }

        private float getDataElementSize() {
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (sGDrawingElementArray != null) {
                if (sGDrawingElementArray.length == 0) {
                    return 0.0f;
                }
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[0];
                Rectangle2D rectangle2D = sGDrawingElementSymbol2D.getElementBounds().getBounds2D();
                return (float)rectangle2D.getHeight();
            }
            return 0.0f;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            SGTuple2f sGTuple2f;
            Rectangle2D rectangle2D = SGFigureElementLegend.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f = (float)rectangle2D.getX() + 0.5f * (float)rectangle2D2.getWidth();
            float f2 = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            this.mLocation = sGTuple2f = new SGTuple2f(f, f2);
            return this.setLocation(new SGTuple2f[]{sGTuple2f});
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            SGIElementGroupSetXY sGIElementGroupSetXY;
            if (!super.paintElement(graphics2D, rectangle2D)) {
                return false;
            }
            if (this.mGroupSet.isVisibleTotally() && this.mGroupSet.isSelected() && SGFigureElementLegend.this.isSymbolsVisibleAroundFocusedObjects() && this.mGroupSet instanceof SGIElementGroupSetXY && !(sGIElementGroupSetXY = (SGIElementGroupSetXY)((Object)this.mGroupSet)).getBarGroup().isVisible()) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[0];
                Rectangle2D rectangle2D2 = sGDrawingElementSymbol2D.getElementBounds();
                SGUtilityForFigureElementJava2D.drawAnchorsOnRectangle(rectangle2D2, graphics2D);
            }
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGFigureElementLegend.this.readProperty(this, element);
        }

        public SGTuple2f getLocation(int n) {
            return this.mLocation;
        }
    }

    private class ElementGroupBar
    extends SGElementGroupBarForData
    implements ILegendElement,
    SGISXYDataConstants {
        protected ElementGroupSetInLegend mGroupSet;
        private Rectangle2D mBoundsRect;
        private SGTuple2f mLocation;

        protected ElementGroupBar(SGISXYData sGISXYData) {
            super(sGISXYData);
            this.mGroupSet = null;
            this.mBoundsRect = new Rectangle2D.Float();
            this.mLocation = new SGTuple2f();
        }

        protected SGDrawingElement createDrawingElementInstance(int n) {
            return new BarInLegend(this, n);
        }

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        public float getPreferredWidth() {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)this.mGroupSet;
            Rectangle2D rectangle2D = elementGroupSetInLegendSXY.mDrawingString.getElementBounds();
            return (float)rectangle2D.getHeight();
        }

        public float getPreferredHeight() {
            return this.getPreferredWidth();
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGFigureElementLegend.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f = this.getPreferredWidth();
            this.setRectangleHeight(f);
            float f2 = (float)rectangle2D2.getWidth();
            this.setRectangleWidth(f2);
            float f3 = (float)rectangle2D.getX();
            float f4 = (float)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - (double)(this.getPreferredHeight() / 2.0f));
            SGTuple2f sGTuple2f = new SGTuple2f(f3, f4);
            this.setLocation(new SGTuple2f[]{sGTuple2f});
            return true;
        }

        public boolean initDrawingElement(int n) {
            super.initDrawingElement(n);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
                this.initDrawingElement(sGTuple2fArray);
            }
            this.mLocation = sGTuple2fArray[0];
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            if (!super.paintElement(graphics2D, rectangle2D)) {
                return false;
            }
            if (this.mGroupSet.isVisibleTotally() && this.mGroupSet.isSelected() && SGFigureElementLegend.this.isSymbolsVisibleAroundFocusedObjects()) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[0];
                Rectangle2D rectangle2D2 = sGDrawingElementBar2D.getElementBounds();
                SGUtilityForFigureElementJava2D.drawAnchorsOnRectangle(rectangle2D2, graphics2D);
            }
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGFigureElementLegend.this.readProperty(this, element);
        }

        public float getX(int n) {
            return this.mLocation.x;
        }

        public float getY(int n) {
            return this.mLocation.y;
        }
    }

    protected static class BarInLegend
    extends SGElementGroupBar.BarInGroup {
        public BarInLegend(ElementGroupBar elementGroupBar, int n) {
            super(elementGroupBar, n);
        }

        public float getWidth() {
            return this.mGroup.getRectangleWidth();
        }

        public float getHeight() {
            return this.mGroup.getRectangleHeight();
        }

        public boolean setWidth(float f) {
            return this.mGroup.setRectangleWidth(f);
        }

        public boolean setHeight(float f) {
            return this.mGroup.setRectangleHeight(f);
        }
    }

    private class ElementGroupLine
    extends SGElementGroupLineForData
    implements ILegendElement,
    SGISXYDataConstants {
        private SGTuple2f mStart;
        private SGTuple2f mEnd;
        protected ElementGroupSetInLegend mGroupSet;
        private Rectangle2D mBoundsRect;

        protected ElementGroupLine(SGISXYData sGISXYData) {
            super(sGISXYData);
            this.mStart = new SGTuple2f();
            this.mEnd = new SGTuple2f();
            this.mGroupSet = null;
            this.mBoundsRect = new Rectangle2D.Float();
            this.mEndPointsIndexArray = new int[1][2];
        }

        public boolean setElementGroupSet(ElementGroupSetInLegend elementGroupSetInLegend) {
            this.mGroupSet = elementGroupSetInLegend;
            return true;
        }

        public float getPreferredWidth() {
            return this.getMagnification() * SGFigureElementLegend.this.getSymbolSpan();
        }

        public float getPreferredHeight() {
            return this.getMagnification() * this.getLineWidth();
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 2;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGFigureElementLegend.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX();
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = sGTuple2f.x + (float)rectangle2D2.getWidth();
            sGTuple2f2.y = sGTuple2f.y;
            if (!this.setLocation(new SGTuple2f[]{sGTuple2f, sGTuple2f2})) {
                return false;
            }
            this.mStart = sGTuple2f;
            this.mEnd = sGTuple2f2;
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            SGIElementGroupSetXY sGIElementGroupSetXY;
            if (!super.paintElement(graphics2D, rectangle2D)) {
                return false;
            }
            if (this.mGroupSet.isVisibleTotally() && this.mGroupSet.isSelected() && SGFigureElementLegend.this.isSymbolsVisibleAroundFocusedObjects() && this.mGroupSet instanceof SGIElementGroupSetXY && !(sGIElementGroupSetXY = (SGIElementGroupSetXY)((Object)this.mGroupSet)).getSymbolGroup().isVisible() && !sGIElementGroupSetXY.getBarGroup().isVisible()) {
                SGDrawingElementLine2D sGDrawingElementLine2D = (SGDrawingElementLine2D)this.mDrawingElementArray[0];
                SGTuple2f sGTuple2f = sGDrawingElementLine2D.getStart();
                SGTuple2f sGTuple2f2 = sGDrawingElementLine2D.getEnd();
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(new Point2D.Float(sGTuple2f.x, sGTuple2f.y), graphics2D);
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(new Point2D.Float(sGTuple2f2.x, sGTuple2f2.y), graphics2D);
            }
            return true;
        }

        public boolean readProperty(Element element) {
            if (!super.readProperty(element)) {
                return false;
            }
            return SGFigureElementLegend.this.readProperty(this, element);
        }

        public SGTuple2f getEnd(int n) {
            return this.mEnd;
        }

        public SGTuple2f getStart(int n) {
            return this.mStart;
        }

        protected SGElementGroupSymbol getElementGroupSymbol() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementGroupSetInLegendVXY
    extends ElementGroupSetInLegend
    implements SGIElementGroupSetVXY,
    SGIVXYDataDialogObserver,
    SGIVXYDataConstants {
        private float mMagnitudePerCM;
        private boolean mDirectionFixedFlag;

        protected ElementGroupSetInLegendVXY(SGData sGData) {
            super(sGData);
            this.mMagnitudePerCM = 1.0f;
        }

        @Override
        public float getMagnitudePerCM() {
            return this.mMagnitudePerCM;
        }

        @Override
        public boolean setMagnitudePerCM(float f) {
            if ((double)f <= 0.0) {
                throw new IllegalArgumentException("mag <= 0.0");
            }
            SGIVXYTypeData sGIVXYTypeData = (SGIVXYTypeData)((Object)this.mData);
            this.mMagnitudePerCM = Float.isNaN(f) ? f : SGUtilityForFigureElement.roundMagnitudePerCM(f, sGIVXYTypeData);
            return true;
        }

        @Override
        public boolean isDirectionInvariant() {
            return this.mDirectionFixedFlag;
        }

        @Override
        public boolean setDirectionInvariant(boolean bl) {
            this.mDirectionFixedFlag = bl;
            return true;
        }

        @Override
        public boolean addDrawingElementGroup(int n) {
            ElementGroupArrow elementGroupArrow = null;
            if (n != 3) {
                throw new Error();
            }
            elementGroupArrow = new ElementGroupArrow();
            this.addDrawingElementGroup(elementGroupArrow);
            return true;
        }

        @Override
        void paintSymbol(Graphics2D graphics2D) {
            ElementGroupArrow elementGroupArrow = SGFigureElementLegend.this.getGroupArrow(this);
            if (elementGroupArrow != null && elementGroupArrow.isVisible()) {
                elementGroupArrow.paintElement(graphics2D);
            }
        }

        @Override
        boolean onMouseClicked(MouseEvent mouseEvent) {
            return true;
        }

        @Override
        public int getXAxisLocation() {
            return SGFigureElementLegend.this.mAxisElement.getLocationInPlane(this.getXAxis());
        }

        @Override
        public int getYAxisLocation() {
            return SGFigureElementLegend.this.mAxisElement.getLocationInPlane(this.getYAxis());
        }

        @Override
        public float getLineWidth(String string) {
            return this.getArrowGroup().getLineWidth(string);
        }

        @Override
        public int getLineType() {
            return this.getArrowGroup().getLineType();
        }

        @Override
        public Color getColor() {
            return this.getArrowGroup().getColor();
        }

        @Override
        public float getHeadSize(String string) {
            return this.getArrowGroup().getHeadSize(string);
        }

        @Override
        public float getHeadOpenAngle() {
            return this.getArrowGroup().getHeadOpenAngle();
        }

        @Override
        public float getHeadCloseAngle() {
            return this.getArrowGroup().getHeadCloseAngle();
        }

        @Override
        public int getStartHeadType() {
            return this.getArrowGroup().getStartHeadType();
        }

        @Override
        public int getEndHeadType() {
            return this.getArrowGroup().getEndHeadType();
        }

        @Override
        public boolean setXAxisLocation(int n) {
            this.mXAxis = this.getAxis(n);
            return true;
        }

        @Override
        public boolean setYAxisLocation(int n) {
            this.mYAxis = this.getAxis(n);
            return true;
        }

        @Override
        public boolean setLineWidth(float f, String string) {
            return this.getArrowGroup().setLineWidth(f, string);
        }

        @Override
        public boolean setLineType(int n) {
            return this.getArrowGroup().setLineType(n);
        }

        @Override
        public boolean setColor(Color color) {
            return this.getArrowGroup().setColor(color);
        }

        @Override
        public boolean setHeadSize(float f, String string) {
            return this.getArrowGroup().setHeadSize(f, string);
        }

        @Override
        public boolean setHeadAngle(Float f, Float f2) {
            return this.getArrowGroup().setHeadAngle(f.floatValue(), f2.floatValue());
        }

        @Override
        public boolean setStartHeadType(int n) {
            return this.getArrowGroup().setStartHeadType(n);
        }

        @Override
        public boolean setEndHeadType(int n) {
            return this.getArrowGroup().setEndHeadType(n);
        }

        @Override
        public boolean hasValidAngle(Number number, Number number2) {
            float f = number != null ? number.floatValue() : this.getHeadOpenAngle();
            float f2 = number2 != null ? number2.floatValue() : this.getHeadCloseAngle();
            return f < f2;
        }

        @Override
        public SGProperties getProperties() {
            SGElementGroupSetInGraphVXY.ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = new SGElementGroupSetInGraphVXY.ElementGroupSetInVXYGraphProperties();
            if (!this.getProperties(elementGroupSetInVXYGraphProperties)) {
                return null;
            }
            return elementGroupSetInVXYGraphProperties;
        }

        @Override
        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInGraphVXY.ElementGroupSetInVXYGraphProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInGraphVXY.ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = (SGElementGroupSetInGraphVXY.ElementGroupSetInVXYGraphProperties)sGProperties;
            elementGroupSetInVXYGraphProperties.mMagnitudeScalingFactor = this.getMagnitudePerCM();
            elementGroupSetInVXYGraphProperties.mDirectionInvariant = this.isDirectionInvariant();
            return true;
        }

        @Override
        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInGraphVXY.ElementGroupSetInVXYGraphProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInGraphVXY.ElementGroupSetInVXYGraphProperties elementGroupSetInVXYGraphProperties = (SGElementGroupSetInGraphVXY.ElementGroupSetInVXYGraphProperties)sGProperties;
            this.setMagnitudePerCM(elementGroupSetInVXYGraphProperties.mMagnitudeScalingFactor);
            this.setDirectionInvariant(elementGroupSetInVXYGraphProperties.mDirectionInvariant);
            return true;
        }

        @Override
        public List<SGElementGroupArrow> getArrowGroups() {
            ArrayList<SGElementGroupArrow> arrayList = new ArrayList<SGElementGroupArrow>();
            List<SGElementGroup> list = SGUtilityForFigureElement.getGroups(SGElementGroupArrow.class, this.mDrawingElementGroupList);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add((SGElementGroupArrow)list.get(i));
            }
            return arrayList;
        }

        @Override
        public SGElementGroupArrow getArrowGroup() {
            return (SGElementGroupArrow)SGUtilityForFigureElement.getGroup(SGElementGroupArrow.class, this.mDrawingElementGroupList);
        }

        @Override
        protected boolean setElementGroupProperties(List list) {
            for (int i = 0; i < list.size(); ++i) {
                SGProperties sGProperties = (SGProperties)list.get(i);
                SGElementGroupArrow sGElementGroupArrow = null;
                if (!(sGProperties instanceof SGElementGroupArrow.ArrowProperties)) {
                    throw new Error("Illegal group property: " + sGProperties);
                }
                sGElementGroupArrow = this.getArrowGroup();
                if (sGElementGroupArrow == null || ((SGElementGroup)sGElementGroupArrow).setProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementGroupSetInLegendMultipleSXY
    extends ElementGroupSetInLegendSXY
    implements SGIElementGroupSetMultipleSXY,
    SGISXYDataDialogObserver,
    SGISXYDataConstants {
        protected ArrayList<SGIElementGroupSetInFigureElement> mElementGroupSetList;

        @Override
        public void addChildGroupSet(SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement) {
            this.mElementGroupSetList.add(sGIElementGroupSetInFigureElement);
        }

        @Override
        public void removeChildGroupSet(SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement) {
            this.mElementGroupSetList.remove(sGIElementGroupSetInFigureElement);
        }

        @Override
        public SGIElementGroupSetInFigureElement[] getChildGroupSetArray() {
            SGIElementGroupSetInFigureElement[] sGIElementGroupSetInFigureElementArray = new SGIElementGroupSetInFigureElement[this.mElementGroupSetList.size()];
            this.mElementGroupSetList.toArray(sGIElementGroupSetInFigureElementArray);
            return sGIElementGroupSetInFigureElementArray;
        }

        protected ElementGroupSetInLegendMultipleSXY(SGData sGData) {
            super(sGData);
            this.mElementGroupSetList = new ArrayList();
        }

        @Override
        public void dispose() {
            super.dispose();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mElementGroupSetList.get(i);
                SGData sGData = elementGroupSetInLegend.mData;
                if (sGData == null) continue;
                sGData.dispose();
            }
        }

        @Override
        public SGIElementGroupSetInFigureElement getFirst() {
            if (this.mElementGroupSetList.size() == 0) {
                return null;
            }
            return (SGElementGroupSetInFigureElement)this.mElementGroupSetList.get(0);
        }

        @Override
        public SGProperties getProperties() {
            SGElementGroupSetInFigureElement.MultipleElementGroupSetProperties multipleElementGroupSetProperties = new SGElementGroupSetInFigureElement.MultipleElementGroupSetProperties();
            if (!this.getProperties(multipleElementGroupSetProperties)) {
                return null;
            }
            return multipleElementGroupSetProperties;
        }

        @Override
        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.MultipleElementGroupSetProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.MultipleElementGroupSetProperties multipleElementGroupSetProperties = (SGElementGroupSetInFigureElement.MultipleElementGroupSetProperties)sGProperties;
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                multipleElementGroupSetProperties.mChildPropertyList.add(sGIElementGroupSetInFigureElement.getProperties());
            }
            return true;
        }

        @Override
        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.MultipleElementGroupSetProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            if (!SGMultipleSXYUtility.removeAllChildData(this)) {
                return false;
            }
            if (!SGFigureElementLegend.this.updateChildGroupSet(this)) {
                return false;
            }
            SGElementGroupSetInFigureElement.MultipleElementGroupSetProperties multipleElementGroupSetProperties = (SGElementGroupSetInFigureElement.MultipleElementGroupSetProperties)sGProperties;
            int n = 0;
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                sGIElementGroupSetInFigureElement.setMagnification(this.mMagnification);
                if (!sGIElementGroupSetInFigureElement.setProperties(multipleElementGroupSetProperties.mChildPropertyList.get(n))) {
                    return false;
                }
                if (++n < multipleElementGroupSetProperties.mChildPropertyList.size()) continue;
                n = multipleElementGroupSetProperties.mChildPropertyList.size() - 1;
            }
            return true;
        }

        @Override
        public boolean setXAxis(SGAxis sGAxis) {
            if (!super.setXAxis(sGAxis)) {
                return false;
            }
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                if (sGIElementGroupSetInFigureElement.setXAxis(sGAxis)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean setYAxis(SGAxis sGAxis) {
            if (!super.setYAxis(sGAxis)) {
                return false;
            }
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                if (sGIElementGroupSetInFigureElement.setYAxis(sGAxis)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean setXAxisLocation(int n) {
            if (!super.setXAxisLocation(n)) {
                return false;
            }
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                if (sGIElementGroupSetInFigureElement.setXAxisLocation(n)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean setYAxisLocation(int n) {
            if (!super.setYAxisLocation(n)) {
                return false;
            }
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                if (sGIElementGroupSetInFigureElement.setYAxisLocation(n)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean setName(String string) {
            if (!super.setName(string)) {
                return false;
            }
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                if (sGIElementGroupSetInFigureElement.setName(string)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean setVisibleInLegend(boolean bl) {
            if (!super.setVisibleInLegend(bl)) {
                return false;
            }
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                if (sGIElementGroupSetInFigureElement.setVisibleInLegend(bl)) continue;
                return false;
            }
            return true;
        }

        @Override
        public SGElementGroupErrorBar createErrorBars(SGISXYTypeMultipleData sGISXYTypeMultipleData) {
            if (!this.addDrawingElementGroup(4)) {
                return null;
            }
            return this.getErrorBarGroup();
        }

        @Override
        public SGElementGroupTickLabel createTickLabels(SGISXYTypeMultipleData sGISXYTypeMultipleData) {
            if (!this.addDrawingElementGroup(5)) {
                return null;
            }
            return this.getTickLabelGroup();
        }

        @Override
        public List<SGElementGroupLine> getLineGroups() {
            return SGMultipleSXYUtility.getLineGroups(this);
        }

        public List<SGElementGroupLine> getLineGroupsIgnoreNull() {
            return SGMultipleSXYUtility.getLineGroupsIgnoreNull(this);
        }

        @Override
        public boolean setLineVisible(boolean bl) {
            return SGMultipleSXYUtility.setLineVisible(this.getLineGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setLineWidth(float f) {
            return SGMultipleSXYUtility.setLineWidth(this.getLineGroupsIgnoreNull(), f);
        }

        @Override
        public boolean setLineWidth(float f, String string) {
            return SGMultipleSXYUtility.setLineWidth(this.getLineGroupsIgnoreNull(), f, string);
        }

        @Override
        public boolean setLineType(int n) {
            return SGMultipleSXYUtility.setLineType(this.getLineGroupsIgnoreNull(), n);
        }

        @Override
        public boolean setLineColor(Color color) {
            return SGMultipleSXYUtility.setLineColor(this.getLineGroupsIgnoreNull(), color);
        }

        @Override
        public boolean setLineConnectingAll(boolean bl) {
            return SGMultipleSXYUtility.setLineConnectingAll(this.getLineGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setLineShiftX(double d) {
            return SGMultipleSXYUtility.setLineShiftX(this.getLineGroupsIgnoreNull(), d);
        }

        @Override
        public boolean setLineShiftY(double d) {
            return SGMultipleSXYUtility.setLineShiftY(this.getLineGroupsIgnoreNull(), d);
        }

        @Override
        public List<SGElementGroupSymbol> getSymbolGroups() {
            return SGMultipleSXYUtility.getSymbolGroups(this);
        }

        public List<SGElementGroupSymbol> getSymbolGroupsIgnoreNull() {
            return SGMultipleSXYUtility.getSymbolGroupsIgnoreNull(this);
        }

        @Override
        public boolean setSymbolVisible(boolean bl) {
            return SGMultipleSXYUtility.setSymbolVisible(this.getSymbolGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setSymbolType(int n) {
            return SGMultipleSXYUtility.setSymbolType(this.getSymbolGroupsIgnoreNull(), n);
        }

        @Override
        public boolean setSymbolSize(float f) {
            return SGMultipleSXYUtility.setSymbolSize(this.getSymbolGroupsIgnoreNull(), f);
        }

        @Override
        public boolean setSymbolSize(float f, String string) {
            return SGMultipleSXYUtility.setSymbolSize(this.getSymbolGroupsIgnoreNull(), f, string);
        }

        @Override
        public boolean setSymbolLineWidth(float f) {
            return SGMultipleSXYUtility.setSymbolLineWidth(this.getSymbolGroupsIgnoreNull(), f);
        }

        @Override
        public boolean setSymbolLineWidth(float f, String string) {
            return SGMultipleSXYUtility.setSymbolLineWidth(this.getSymbolGroupsIgnoreNull(), f, string);
        }

        @Override
        public boolean setSymbolInnerPaint(SGIPaint sGIPaint) {
            return SGMultipleSXYUtility.setSymbolInnerPaint(this.getSymbolGroupsIgnoreNull(), sGIPaint);
        }

        @Override
        public boolean setSymbolLineColor(Color color) {
            return SGMultipleSXYUtility.setSymbolLineColor(this.getSymbolGroupsIgnoreNull(), color);
        }

        @Override
        public boolean setSymbolLineVisible(boolean bl) {
            return SGMultipleSXYUtility.setSymbolLineVisible(this.getSymbolGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setSymbolShiftX(double d) {
            return SGMultipleSXYUtility.setSymbolShiftX(this.getSymbolGroupsIgnoreNull(), d);
        }

        @Override
        public boolean setSymbolShiftY(double d) {
            return SGMultipleSXYUtility.setSymbolShiftY(this.getSymbolGroupsIgnoreNull(), d);
        }

        @Override
        public List<SGElementGroupBar> getBarGroups() {
            return SGMultipleSXYUtility.getBarGroups(this);
        }

        public List<SGElementGroupBar> getBarGroupsIgnoreNull() {
            return SGMultipleSXYUtility.getBarGroupsIgnoreNull(this);
        }

        @Override
        public boolean setBarVisible(boolean bl) {
            return SGMultipleSXYUtility.setBarVisible(this.getBarGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setBarVertical(boolean bl) {
            return SGMultipleSXYUtility.setBarVertical(this.getBarGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setBarBaselineValue(double d) {
            return SGMultipleSXYUtility.setBarBaselineValue(this.getBarGroupsIgnoreNull(), d);
        }

        @Override
        public boolean setBarWidth(float f) {
            return SGMultipleSXYUtility.setBarWidth(this.getBarGroupsIgnoreNull(), f);
        }

        @Override
        public boolean setBarWidthValue(double d) {
            return SGMultipleSXYUtility.setBarWidthValue(this.getBarGroupsIgnoreNull(), d);
        }

        @Override
        public boolean setBarEdgeLineWidth(float f) {
            return SGMultipleSXYUtility.setBarEdgeLineWidth(this.getBarGroupsIgnoreNull(), f);
        }

        @Override
        public boolean setBarEdgeLineWidth(float f, String string) {
            return SGMultipleSXYUtility.setBarEdgeLineWidth(this.getBarGroupsIgnoreNull(), f, string);
        }

        @Override
        public boolean setBarInnerPaint(SGIPaint sGIPaint) {
            return SGMultipleSXYUtility.setBarInnerPaint(this.getBarGroupsIgnoreNull(), sGIPaint);
        }

        @Override
        public boolean setBarEdgeLineColor(Color color) {
            return SGMultipleSXYUtility.setBarEdgeLineColor(this.getBarGroupsIgnoreNull(), color);
        }

        @Override
        public boolean setBarEdgeLineVisible(boolean bl) {
            return SGMultipleSXYUtility.setBarEdgeLineVisible(this.getBarGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setBarShiftX(double d) {
            return SGMultipleSXYUtility.setBarShiftX(this.getBarGroupsIgnoreNull(), d);
        }

        @Override
        public boolean setBarShiftY(double d) {
            return SGMultipleSXYUtility.setBarShiftY(this.getBarGroupsIgnoreNull(), d);
        }

        @Override
        public boolean setBarInterval(double d) {
            return SGMultipleSXYUtility.setBarInterval(this.getBarGroupsIgnoreNull(), d);
        }

        @Override
        public List<SGElementGroupErrorBar> getErrorBarGroups() {
            return SGMultipleSXYUtility.getErrorBarGroups(this);
        }

        public List<SGElementGroupErrorBar> getErrorBarGroupsIgnoreNull() {
            return SGMultipleSXYUtility.getErrorBarGroupsIgnoreNull(this);
        }

        @Override
        public boolean setErrorBarVisible(boolean bl) {
            return SGMultipleSXYUtility.setErrorBarVisible(this.getErrorBarGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setErrorBarVertical(boolean bl) {
            return SGMultipleSXYUtility.setErrorBarVertical(this.getErrorBarGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setErrorBarHeadType(int n) {
            return SGMultipleSXYUtility.setErrorBarHeadType(this.getErrorBarGroupsIgnoreNull(), n);
        }

        @Override
        public boolean setErrorBarHeadSize(float f) {
            return SGMultipleSXYUtility.setErrorBarHeadSize(this.getErrorBarGroupsIgnoreNull(), f);
        }

        @Override
        public boolean setErrorBarHeadSize(float f, String string) {
            return SGMultipleSXYUtility.setErrorBarHeadSize(this.getErrorBarGroupsIgnoreNull(), f, string);
        }

        @Override
        public boolean setErrorBarColor(Color color) {
            return SGMultipleSXYUtility.setErrorBarColor(this.getErrorBarGroupsIgnoreNull(), color);
        }

        @Override
        public boolean setErrorBarLineWidth(float f) {
            return SGMultipleSXYUtility.setErrorBarLineWidth(this.getErrorBarGroupsIgnoreNull(), f);
        }

        @Override
        public boolean setErrorBarLineWidth(float f, String string) {
            return SGMultipleSXYUtility.setErrorBarLineWidth(this.getErrorBarGroupsIgnoreNull(), f, string);
        }

        @Override
        public boolean setErrorBarStyle(int n) {
            return SGMultipleSXYUtility.setErrorBarStyle(this.getErrorBarGroupsIgnoreNull(), n);
        }

        @Override
        public boolean setErrorBarOnLinePosition(boolean bl) {
            return SGMultipleSXYUtility.setErrorBarOnLinePosition(this.getErrorBarGroupsIgnoreNull(), bl);
        }

        @Override
        public List<SGElementGroupTickLabel> getTickLabelGroups() {
            return SGMultipleSXYUtility.getTickLabelGroups(this);
        }

        public List<SGElementGroupTickLabel> getTickLabelGroupsIgnoreNull() {
            return SGMultipleSXYUtility.getTickLabelGroupsIgnoreNull(this);
        }

        @Override
        public boolean setTickLabelVisible(boolean bl) {
            return SGMultipleSXYUtility.setTickLabelVisible(this.getTickLabelGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setTickLabelHorizontalAlignment(boolean bl) {
            return SGMultipleSXYUtility.setTickLabelHorizontalAlignment(this.getTickLabelGroupsIgnoreNull(), bl);
        }

        @Override
        public boolean setTickLabelFontName(String string) {
            return SGMultipleSXYUtility.setTickLabelFontName(this.getTickLabelGroupsIgnoreNull(), string);
        }

        @Override
        public boolean setTickLabelFontStyle(int n) {
            return SGMultipleSXYUtility.setTickLabelFontStyle(this.getTickLabelGroupsIgnoreNull(), n);
        }

        @Override
        public boolean setTickLabelFontSize(float f) {
            return SGMultipleSXYUtility.setTickLabelFontSize(this.getTickLabelGroupsIgnoreNull(), f);
        }

        @Override
        public boolean setTickLabelFontSize(float f, String string) {
            return SGMultipleSXYUtility.setTickLabelFontSize(this.getTickLabelGroupsIgnoreNull(), f, string);
        }

        @Override
        public boolean setTickLabelColor(Color color) {
            return SGMultipleSXYUtility.setTickLabelColor(this.getTickLabelGroupsIgnoreNull(), color);
        }

        @Override
        public boolean setTickLabelAngle(float f) {
            return SGMultipleSXYUtility.setTickLabelAngle(this.getTickLabelGroupsIgnoreNull(), f);
        }

        @Override
        public boolean setTickLabelDecimalPlaces(int n) {
            return SGMultipleSXYUtility.setTickLabelDecimalPlaces(this.getTickLabelGroupsIgnoreNull(), n);
        }

        @Override
        public boolean setTickLabelExponent(int n) {
            return SGMultipleSXYUtility.setTickLabelExponent(this.getTickLabelGroupsIgnoreNull(), n);
        }

        @Override
        public boolean contains(SGElementGroupSetInFigureElement sGElementGroupSetInFigureElement) {
            if (super.contains(sGElementGroupSetInFigureElement)) {
                return true;
            }
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                if (!sGIElementGroupSetInFigureElement.equals(sGElementGroupSetInFigureElement)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean setColumnInfo(SGDataColumnInfo[] sGDataColumnInfoArray, String string) {
            SGFigureElementLegend.this.mGraphElement.undoDataConversion();
            boolean bl = SGDataUtility.isPickupColumnContained(this.getDataColumnInfoArray());
            boolean bl2 = SGDataUtility.isPickupColumnContained(sGDataColumnInfoArray);
            if (!this.isSelected()) {
                this.setSelected(true);
                SGFigureElementLegend.this.notifyDataSelection();
            }
            if (bl != bl2) {
                if (this.mData instanceof SGSXYMultipleNetCDFData) {
                    SGFigureElementLegend.this.mGraphElement.notifyDataConversion(this.getData(), this.getName(), sGDataColumnInfoArray, string);
                    return true;
                }
                if ("Notify action preview".equals(string)) {
                    return false;
                }
            }
            if (!super.setColumnInfo(sGDataColumnInfoArray, string)) {
                return false;
            }
            return SGMultipleSXYUtility.setColumnInfo(this, SGFigureElementLegend.this);
        }

        @Override
        public boolean cancel() {
            SGFigureElementLegend.this.mGraphElement.undoDataConversion();
            return super.cancel();
        }

        @Override
        protected List<SGElementGroupSetInFigureElement.PopupMenuItem> getOptionalCommandList() {
            List<SGElementGroupSetInFigureElement.PopupMenuItem> list = super.getOptionalCommandList();
            List<SGData> list2 = SGFigureElementLegend.this.mGraphElement.getFocusedDataList();
            if (list2.size() > 1) {
                for (SGElementGroupSetInFigureElement.PopupMenuItem popupMenuItem : list) {
                    if (!popupMenuItem.mItemString.equals("Transform")) continue;
                    popupMenuItem.setEnabled(false);
                    break;
                }
            }
            boolean bl = false;
            if (this.mData instanceof SGISXYTypeMultipleData && ((SGISXYTypeMultipleData)((Object)this.mData)).isSplitEnabled()) {
                bl = true;
            }
            list.add(new SGElementGroupSetInFigureElement.PopupMenuItem("Split", bl));
            list.add(new SGElementGroupSetInFigureElement.PopupMenuItem("Merge", this.isMergeEnabled()));
            return list;
        }

        private boolean isMergeEnabled() {
            List<SGData> list = SGFigureElementLegend.this.mGraphElement.getFocusedDataList();
            SGIDataSource sGIDataSource = this.mData.getDataSource();
            int n = 0;
            for (int i = 0; i < list.size(); ++i) {
                if (!sGIDataSource.equals(list.get(i).getDataSource()) || ++n <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
        }

        @Override
        public int getMultipleDimensionStart() {
            SGData sGData = this.getData();
            if (sGData instanceof SGSXYMultipleNetCDFData) {
                SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)sGData;
                return sGSXYMultipleNetCDFData.getDimensionStart();
            }
            return -1;
        }

        @Override
        public boolean setMultipleDimensionStart(int n) {
            SGData sGData = this.getData();
            if (sGData instanceof SGSXYMultipleNetCDFData) {
                SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)sGData;
                return sGSXYMultipleNetCDFData.setDimensionStart(n);
            }
            return false;
        }

        @Override
        public int getMultipleDimensionEnd() {
            SGData sGData = this.getData();
            if (sGData instanceof SGSXYMultipleNetCDFData) {
                SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)sGData;
                return sGSXYMultipleNetCDFData.getDimensionEnd();
            }
            return -1;
        }

        @Override
        public boolean setMultipleDimensionEnd(int n) {
            SGData sGData = this.getData();
            if (sGData instanceof SGSXYMultipleNetCDFData) {
                SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)sGData;
                return sGSXYMultipleNetCDFData.setDimensionEnd(n);
            }
            return false;
        }

        @Override
        public int getMultipleDimensionStep() {
            SGData sGData = this.getData();
            if (sGData instanceof SGSXYMultipleNetCDFData) {
                SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)sGData;
                return sGSXYMultipleNetCDFData.getDimensionStep();
            }
            return -1;
        }

        @Override
        public boolean setMultipleDimensionStep(int n) {
            SGData sGData = this.getData();
            if (sGData instanceof SGSXYMultipleNetCDFData) {
                SGSXYMultipleNetCDFData sGSXYMultipleNetCDFData = (SGSXYMultipleNetCDFData)sGData;
                return sGSXYMultipleNetCDFData.setDimensionStep(n);
            }
            return false;
        }

        @Override
        public boolean setData(SGData sGData) {
            if (!super.setData(sGData)) {
                return false;
            }
            if (sGData == null) {
                for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                    SGIElementGroupSetInFigureElement sGIElementGroupSetInFigureElement = this.mElementGroupSetList.get(i);
                    SGData sGData2 = sGIElementGroupSetInFigureElement.getData();
                    if (sGData2 != null) {
                        sGData2.dispose();
                    }
                    sGIElementGroupSetInFigureElement.setData(null);
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementGroupSetInLegendSXY
    extends ElementGroupSetInLegend
    implements SGIElementGroupSetSXY,
    SGISXYDataDialogObserver,
    SGISXYDataConstants {
        private int mSelectedTabIndex;

        protected ElementGroupSetInLegendSXY(SGData sGData) {
            super(sGData);
            this.mSelectedTabIndex = -1;
        }

        @Override
        public int getSelectedTabIndex() {
            return this.mSelectedTabIndex;
        }

        @Override
        void paintSymbol(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            SGElementGroup sGElementGroup;
            SGISXYData sGISXYData;
            ElementGroupBar elementGroupBar = SGFigureElementLegend.this.getGroupBar(this);
            if (elementGroupBar != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D);
            }
            if ((sGISXYData = (SGISXYData)((Object)this.getData())).isErrorBarAvailable() && (sGElementGroup = SGFigureElementLegend.this.getGroupErrorBar(this)) != null && sGElementGroup.isVisible()) {
                sGElementGroup.paintElement(graphics2D);
            }
            if ((sGElementGroup = SGFigureElementLegend.this.getGroupLine(this)) != null && sGElementGroup.isVisible()) {
                sGElementGroup.paintElement(graphics2D);
            }
            if ((elementGroupSymbol = SGFigureElementLegend.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D);
            }
        }

        @Override
        public List<SGElementGroupLine> getLineGroups() {
            ArrayList<SGElementGroupLine> arrayList = new ArrayList<SGElementGroupLine>();
            List<SGElementGroup> list = SGUtilityForFigureElement.getGroups(SGElementGroupLine.class, this.mDrawingElementGroupList);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add((SGElementGroupLine)list.get(i));
            }
            return arrayList;
        }

        @Override
        public List<SGElementGroupSymbol> getSymbolGroups() {
            ArrayList<SGElementGroupSymbol> arrayList = new ArrayList<SGElementGroupSymbol>();
            List<SGElementGroup> list = SGUtilityForFigureElement.getGroups(SGElementGroupSymbol.class, this.mDrawingElementGroupList);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add((SGElementGroupSymbol)list.get(i));
            }
            return arrayList;
        }

        @Override
        public List<SGElementGroupBar> getBarGroups() {
            ArrayList<SGElementGroupBar> arrayList = new ArrayList<SGElementGroupBar>();
            List<SGElementGroup> list = SGUtilityForFigureElement.getGroups(SGElementGroupBar.class, this.mDrawingElementGroupList);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add((SGElementGroupBar)list.get(i));
            }
            return arrayList;
        }

        @Override
        public List<SGElementGroupErrorBar> getErrorBarGroups() {
            ArrayList<SGElementGroupErrorBar> arrayList = new ArrayList<SGElementGroupErrorBar>();
            List<SGElementGroup> list = SGUtilityForFigureElement.getGroups(SGElementGroupErrorBar.class, this.mDrawingElementGroupList);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add((SGElementGroupErrorBar)list.get(i));
            }
            return arrayList;
        }

        @Override
        public List<SGElementGroupTickLabel> getTickLabelGroups() {
            ArrayList<SGElementGroupTickLabel> arrayList = new ArrayList<SGElementGroupTickLabel>();
            List<SGElementGroup> list = SGUtilityForFigureElement.getGroups(SGElementGroupTickLabel.class, this.mDrawingElementGroupList);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add((SGElementGroupTickLabel)list.get(i));
            }
            return arrayList;
        }

        @Override
        public SGElementGroupLine getLineGroup() {
            return (SGElementGroupLine)SGUtilityForFigureElement.getGroup(SGElementGroupLine.class, this.mDrawingElementGroupList);
        }

        @Override
        public SGElementGroupSymbol getSymbolGroup() {
            return (SGElementGroupSymbol)SGUtilityForFigureElement.getGroup(SGElementGroupSymbol.class, this.mDrawingElementGroupList);
        }

        @Override
        public SGElementGroupBar getBarGroup() {
            return (SGElementGroupBar)SGUtilityForFigureElement.getGroup(SGElementGroupBar.class, this.mDrawingElementGroupList);
        }

        @Override
        public SGElementGroupErrorBar getErrorBarGroup() {
            return (SGElementGroupErrorBar)SGUtilityForFigureElement.getGroup(SGElementGroupErrorBar.class, this.mDrawingElementGroupList);
        }

        @Override
        public SGElementGroupTickLabel getTickLabelGroup() {
            return (SGElementGroupTickLabel)SGUtilityForFigureElement.getGroup(SGElementGroupTickLabel.class, this.mDrawingElementGroupList);
        }

        @Override
        public boolean isLineVisible() {
            return this.getLineGroup().isVisible();
        }

        public float getLineWidth() {
            return this.getLineGroup().getLineWidth();
        }

        @Override
        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        @Override
        public int getLineType() {
            return this.getLineGroup().getLineType();
        }

        @Override
        public Color getLineColor() {
            return this.getLineGroup().getColor();
        }

        @Override
        public boolean isLineConnectingAll() {
            return this.getLineGroup().isLineConnectingAll();
        }

        @Override
        public double getLineShiftX() {
            return this.getLineGroup().getLineShiftX();
        }

        @Override
        public double getLineShiftY() {
            return this.getLineGroup().getLineShiftY();
        }

        @Override
        public boolean setLineVisible(boolean bl) {
            this.getLineGroup().setVisible(bl);
            return true;
        }

        public boolean setLineWidth(float f) {
            return this.getLineGroup().setLineWidth(f);
        }

        @Override
        public boolean setLineWidth(float f, String string) {
            return this.setLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        @Override
        public boolean setLineType(int n) {
            return this.getLineGroup().setLineType(n);
        }

        @Override
        public boolean setLineColor(Color color) {
            return this.getLineGroup().setColor(color);
        }

        @Override
        public boolean setLineConnectingAll(boolean bl) {
            return this.getLineGroup().setLineConnectingAll(bl);
        }

        @Override
        public boolean setLineShiftX(double d) {
            return this.getLineGroup().setLineShiftX(d);
        }

        @Override
        public boolean setLineShiftY(double d) {
            return this.getLineGroup().setLineShiftY(d);
        }

        @Override
        public boolean isSymbolVisible() {
            return this.getSymbolGroup().isVisible();
        }

        @Override
        public int getSymbolType() {
            return this.getSymbolGroup().getType();
        }

        public float getSymbolSize() {
            return this.getSymbolGroup().getSize();
        }

        @Override
        public float getSymbolSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolSize(), string);
        }

        public float getSymbolLineWidth() {
            return this.getSymbolGroup().getLineWidth();
        }

        @Override
        public float getSymbolLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolLineWidth(), string);
        }

        @Override
        public SGIPaint getSymbolInnerPaint() {
            return this.getSymbolGroup().getInnerPaint();
        }

        @Override
        public Color getSymbolLineColor() {
            return this.getSymbolGroup().getLineColor();
        }

        @Override
        public boolean isSymbolLineVisible() {
            return this.getSymbolGroup().isLineVisible();
        }

        @Override
        public double getSymbolShiftX() {
            return this.getSymbolGroup().getShiftX();
        }

        @Override
        public double getSymbolShiftY() {
            return this.getSymbolGroup().getShiftY();
        }

        @Override
        public boolean setSymbolVisible(boolean bl) {
            this.getSymbolGroup().setVisible(bl);
            return true;
        }

        @Override
        public boolean setSymbolType(int n) {
            return this.getSymbolGroup().setType(n);
        }

        public boolean setSymbolSize(float f) {
            return this.getSymbolGroup().setSize(f);
        }

        @Override
        public boolean setSymbolSize(float f, String string) {
            return this.setSymbolSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setSymbolLineWidth(float f) {
            return this.getSymbolGroup().setLineWidth(f);
        }

        @Override
        public boolean setSymbolLineWidth(float f, String string) {
            return this.setSymbolLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        @Override
        public boolean setSymbolInnerPaint(SGIPaint sGIPaint) {
            return this.getSymbolGroup().setInnerPaint(sGIPaint);
        }

        @Override
        public boolean setSymbolLineColor(Color color) {
            return this.getSymbolGroup().setLineColor(color);
        }

        @Override
        public boolean setSymbolLineVisible(boolean bl) {
            return this.getSymbolGroup().setLineVisible(bl);
        }

        @Override
        public boolean setSymbolShiftX(double d) {
            return this.getSymbolGroup().setShiftX(d);
        }

        @Override
        public boolean setSymbolShiftY(double d) {
            return this.getSymbolGroup().setShiftY(d);
        }

        @Override
        public boolean isBarVisible() {
            return this.getBarGroup().isVisible();
        }

        @Override
        public double getBarBaselineValue() {
            return this.getBarGroup().getBaselineValue();
        }

        public float getBarWidth() {
            return this.getBarGroup().getRectangleWidth();
        }

        @Override
        public double getBarWidthValue() {
            return this.getBarGroup().getWidthValue();
        }

        public float getBarEdgeLineWidth() {
            return this.getBarGroup().getEdgeLineWidth();
        }

        @Override
        public float getBarEdgeLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getBarEdgeLineWidth(), string);
        }

        @Override
        public SGIPaint getBarInnerPaint() {
            return this.getBarGroup().getInnerPaint();
        }

        @Override
        public Color getBarEdgeLineColor() {
            return this.getBarGroup().getEdgeLineColor();
        }

        @Override
        public boolean isBarEdgeLineVisible() {
            return this.getBarGroup().isEdgeLineVisible();
        }

        @Override
        public boolean isBarVertical() {
            return this.getBarGroup().isVertical();
        }

        @Override
        public double getBarShiftX() {
            return this.getBarGroup().getShiftX();
        }

        @Override
        public double getBarShiftY() {
            return this.getBarGroup().getShiftY();
        }

        @Override
        public double getBarInterval() {
            return this.getBarGroup().getInterval();
        }

        @Override
        public boolean setBarVisible(boolean bl) {
            this.getBarGroup().setVisible(bl);
            return true;
        }

        @Override
        public boolean setBarBaselineValue(double d) {
            return this.getBarGroup().setBaselineValue(d);
        }

        public boolean setBarWidth(float f) {
            return this.getBarGroup().setRectangleWidth(f);
        }

        @Override
        public boolean setBarWidthValue(double d) {
            return this.getBarGroup().setWidthValue(d);
        }

        public boolean setBarEdgeLineWidth(float f) {
            return this.getBarGroup().setEdgeLineWidth(f);
        }

        @Override
        public boolean setBarEdgeLineWidth(float f, String string) {
            return this.setBarEdgeLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        @Override
        public boolean setBarInnerPaint(SGIPaint sGIPaint) {
            return this.getBarGroup().setInnerPaint(sGIPaint);
        }

        @Override
        public boolean setBarEdgeLineColor(Color color) {
            return this.getBarGroup().setEdgeLineColor(color);
        }

        @Override
        public boolean setBarEdgeLineVisible(boolean bl) {
            return this.getBarGroup().setEdgeLineVisible(bl);
        }

        @Override
        public boolean setBarVertical(boolean bl) {
            return this.getBarGroup().setVertical(bl);
        }

        @Override
        public boolean hasValidBaselineValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementLegend.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getBarBaselineValue();
            return sGAxis.isValidValue(d);
        }

        @Override
        public boolean setBarShiftX(double d) {
            return this.getBarGroup().setShiftX(d);
        }

        @Override
        public boolean setBarShiftY(double d) {
            return this.getBarGroup().setShiftY(d);
        }

        @Override
        public boolean setBarInterval(double d) {
            return this.getBarGroup().setInterval(d);
        }

        @Override
        public boolean isErrorBarAvailable() {
            if (this.mData instanceof SGISXYData) {
                SGISXYData sGISXYData = (SGISXYData)((Object)this.mData);
                return sGISXYData.isErrorBarAvailable();
            }
            return false;
        }

        @Override
        public boolean isErrorBarVisible() {
            return this.getErrorBarGroup().isVisible();
        }

        @Override
        public boolean isErrorBarVertical() {
            return this.getErrorBarGroup().isVertical();
        }

        @Override
        public int getErrorBarHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getErrorBarHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        @Override
        public float getErrorBarHeadSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarHeadSize(), string);
        }

        @Override
        public Color getErrorBarColor() {
            return this.getErrorBarGroup().getColor();
        }

        public float getErrorBarLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        @Override
        public float getErrorBarLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarLineWidth(), string);
        }

        @Override
        public int getErrorBarStyle() {
            return this.getErrorBarGroup().getErrorBarStyle();
        }

        @Override
        public boolean isErrorBarOnLinePosition() {
            return this.getErrorBarGroup().isPositionOnLine();
        }

        @Override
        public boolean setErrorBarVisible(boolean bl) {
            this.getErrorBarGroup().setVisible(bl);
            return true;
        }

        @Override
        public boolean setErrorBarHeadType(int n) {
            this.getErrorBarGroup().setHeadType(n);
            return true;
        }

        public boolean setErrorBarHeadSize(float f) {
            this.getErrorBarGroup().setHeadSize(f);
            return true;
        }

        @Override
        public boolean setErrorBarHeadSize(float f, String string) {
            return this.setErrorBarHeadSize((float)SGUtilityText.convertToPoint(f, string));
        }

        @Override
        public boolean setErrorBarColor(Color color) {
            return this.getErrorBarGroup().setColor(color);
        }

        public boolean setErrorBarLineWidth(float f) {
            this.getErrorBarGroup().setLineWidth(f);
            return true;
        }

        @Override
        public boolean setErrorBarLineWidth(float f, String string) {
            return this.setErrorBarLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        @Override
        public boolean setErrorBarStyle(int n) {
            this.getErrorBarGroup().setErrorBarStyle(n);
            return true;
        }

        @Override
        public boolean setErrorBarVertical(boolean bl) {
            return this.getErrorBarGroup().setVertical(bl);
        }

        @Override
        public boolean setErrorBarOnLinePosition(boolean bl) {
            return this.getErrorBarGroup().setPositionOnLine(bl);
        }

        @Override
        public boolean isTickLabelAvailable() {
            if (this.mData instanceof SGISXYData) {
                SGISXYData sGISXYData = (SGISXYData)((Object)this.mData);
                return sGISXYData.isTickLabelAvailable();
            }
            return false;
        }

        @Override
        public boolean isTickLabelVisible() {
            return this.getTickLabelGroup().isVisible();
        }

        @Override
        public String getTickLabelFontName() {
            return this.getTickLabelGroup().getFontName();
        }

        @Override
        public int getTickLabelFontStyle() {
            return this.getTickLabelGroup().getFontStyle();
        }

        public float getTickLabelFontSize() {
            return this.getTickLabelGroup().getFontSize();
        }

        @Override
        public float getTickLabelFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getTickLabelFontSize(), string);
        }

        @Override
        public Color getTickLabelColor() {
            return this.getTickLabelGroup().getColor();
        }

        @Override
        public float getTickLabelAngle() {
            return this.getTickLabelGroup().getAngle();
        }

        @Override
        public boolean hasTickLabelHorizontalAlignment() {
            return this.getTickLabelGroup().hasHorizontalAlignment();
        }

        @Override
        public int getTickLabelDecimalPlaces() {
            return this.getTickLabelGroup().getDecimalPlaces();
        }

        @Override
        public int getTickLabelExponent() {
            return this.getTickLabelGroup().getExponent();
        }

        @Override
        public boolean setTickLabelVisible(boolean bl) {
            this.getTickLabelGroup().setVisible(bl);
            return true;
        }

        @Override
        public boolean setTickLabelFontName(String string) {
            return this.getTickLabelGroup().setFontName(string);
        }

        @Override
        public boolean setTickLabelFontStyle(int n) {
            return this.getTickLabelGroup().setFontStyle(n);
        }

        public boolean setTickLabelFontSize(float f) {
            return this.getTickLabelGroup().setFontSize(f);
        }

        @Override
        public boolean setTickLabelFontSize(float f, String string) {
            return this.setTickLabelFontSize((float)SGUtilityText.convertToPoint(f, string));
        }

        @Override
        public boolean setTickLabelColor(Color color) {
            return this.getTickLabelGroup().setColor(color);
        }

        @Override
        public boolean setTickLabelAngle(float f) {
            return this.getTickLabelGroup().setAngle(f);
        }

        @Override
        public boolean setTickLabelHorizontalAlignment(boolean bl) {
            return this.getTickLabelGroup().setHorizontalAlignment(bl);
        }

        @Override
        public boolean setTickLabelDecimalPlaces(int n) {
            this.getTickLabelGroup().setDecimalPlaces(n);
            return true;
        }

        @Override
        public boolean setTickLabelExponent(int n) {
            this.getTickLabelGroup().setExponent(n);
            return true;
        }

        @Override
        public void updateTickLabelStrings() {
        }

        @Override
        boolean onMouseClicked(MouseEvent mouseEvent) {
            SGElementGroup sGElementGroup = this.getElementGroupAt(mouseEvent.getX(), mouseEvent.getY());
            int n = -1;
            if (sGElementGroup instanceof ElementGroupLine) {
                n = 0;
            } else if (sGElementGroup instanceof ElementGroupSymbol) {
                n = 1;
            } else if (sGElementGroup instanceof ElementGroupBar) {
                n = 2;
            } else if (sGElementGroup instanceof ElementGroupErrorBar) {
                n = 3;
            } else if (sGElementGroup instanceof ElementGroupTickLabels) {
                n = 4;
            }
            this.mSelectedTabIndex = n;
            return true;
        }

        @Override
        public boolean addDrawingElementGroup(int n) {
            SGISXYData sGISXYData = (SGISXYData)((Object)this.mData);
            SGElementGroup sGElementGroup = null;
            if (n == 0) {
                sGElementGroup = new ElementGroupLine(sGISXYData);
            } else if (n == 2) {
                sGElementGroup = new ElementGroupBar(sGISXYData);
            } else if (n == 1) {
                sGElementGroup = new ElementGroupSymbol(sGISXYData);
            } else if (n == 4) {
                sGElementGroup = new ElementGroupErrorBar(sGISXYData);
            } else if (n == 5) {
                sGElementGroup = new ElementGroupTickLabels(sGISXYData);
            } else {
                throw new Error();
            }
            this.addDrawingElementGroup(sGElementGroup);
            return true;
        }

        @Override
        public int getXAxisLocation() {
            return SGFigureElementLegend.this.mAxisElement.getLocationInPlane(this.getXAxis());
        }

        @Override
        public int getYAxisLocation() {
            return SGFigureElementLegend.this.mAxisElement.getLocationInPlane(this.getYAxis());
        }

        @Override
        public boolean setXAxisLocation(int n) {
            if (n != 0 && n != 1) {
                return false;
            }
            this.mXAxis = this.getAxis(n);
            return true;
        }

        @Override
        public boolean setYAxisLocation(int n) {
            if (n != 2 && n != 3) {
                return false;
            }
            this.mYAxis = this.getAxis(n);
            return true;
        }

        @Override
        public SGElementGroupErrorBar createErrorBars(SGISXYTypeData sGISXYTypeData) {
            if (!this.addDrawingElementGroup(4)) {
                return null;
            }
            return this.getErrorBarGroup();
        }

        @Override
        public SGElementGroupTickLabel createTickLabels(SGISXYTypeData sGISXYTypeData) {
            if (!this.addDrawingElementGroup(5)) {
                return null;
            }
            return this.getTickLabelGroup();
        }

        @Override
        protected boolean setElementGroupProperties(List list) {
            for (int i = 0; i < list.size(); ++i) {
                SGProperties sGProperties = (SGProperties)list.get(i);
                SGElementGroup sGElementGroup = null;
                if (sGProperties instanceof SGElementGroupLine.LineProperties) {
                    sGElementGroup = this.getLineGroup();
                } else if (sGProperties instanceof SGElementGroupSymbol.SymbolProperties) {
                    sGElementGroup = this.getSymbolGroup();
                } else if (sGProperties instanceof SGElementGroupBar.BarProperties) {
                    sGElementGroup = this.getBarGroup();
                } else if (sGProperties instanceof SGElementGroupErrorBar.ErrorBarProperties) {
                    sGElementGroup = this.getErrorBarGroup();
                } else if (sGProperties instanceof SGElementGroupString.StringProperties) {
                    sGElementGroup = this.getTickLabelGroup();
                } else {
                    throw new Error("Illegal group property: " + sGProperties);
                }
                if (sGElementGroup == null || ((SGElementGroup)sGElementGroup).setProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getMultipleDimensionStart() {
            return -1;
        }

        @Override
        public boolean setMultipleDimensionStart(int n) {
            return false;
        }

        @Override
        public int getMultipleDimensionEnd() {
            return -1;
        }

        @Override
        public boolean setMultipleDimensionEnd(int n) {
            return false;
        }

        @Override
        public int getMultipleDimensionStep() {
            return -1;
        }

        @Override
        public boolean setMultipleDimensionStep(int n) {
            return false;
        }

        @Override
        public boolean setErrorBarDirection(boolean bl) {
            return this.setErrorBarVertical(bl);
        }

        @Override
        public boolean setTickLabelAlignment(boolean bl) {
            return this.setTickLabelHorizontalAlignment(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ElementGroupSetInLegend
    extends SGElementGroupSetInFigureElement
    implements ActionListener,
    SGIChildObject,
    SGISelectable,
    SGIUndoable,
    SGIDataPropertyDialogObserver {
        protected Rectangle2D mDataRect;
        protected SGDrawingElementString2DExtended mDrawingString;
        protected SGProperties mTemporaryPropertiesInner;

        protected ElementGroupSetInLegend(SGData sGData) {
            super(sGData);
            this.mDataRect = null;
            this.mDrawingString = null;
            this.mTemporaryPropertiesInner = null;
        }

        @Override
        protected List<String> getMoveCommandList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Move to Top");
            arrayList.add("Move to Upper");
            arrayList.add("Move to Lower");
            arrayList.add("Move to Bottom");
            return arrayList;
        }

        @Override
        public boolean setName(String string) {
            if (!super.setName(string)) {
                return false;
            }
            JPopupMenu jPopupMenu = this.getPopupMenu();
            if (jPopupMenu != null) {
                Component[] componentArray = jPopupMenu.getComponents();
                JLabel jLabel = (JLabel)componentArray[0];
                jLabel.setText(this.getPopupMenuTitle());
            }
            return true;
        }

        private boolean isVisibleTotally() {
            return this.isVisible() && this.isVisibleInLegend();
        }

        @Override
        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        @Override
        public boolean setXAxisLocation(int n) {
            if (n != 0 && n != 1) {
                return false;
            }
            this.mXAxis = SGFigureElementLegend.this.mAxisElement.getAxisInPlane(n);
            return true;
        }

        @Override
        public boolean setYAxisLocation(int n) {
            if (n != 2 && n != 3) {
                return false;
            }
            this.mYAxis = SGFigureElementLegend.this.mAxisElement.getAxisInPlane(n);
            return true;
        }

        private boolean createStringElement() {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended;
            this.mDrawingString = sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended(this.mName, SGFigureElementLegend.this.mFontName, SGFigureElementLegend.this.mFontStyle, SGFigureElementLegend.this.mFontSize, SGFigureElementLegend.this.mFontColor, this.getMagnification(), 0.0f);
            return true;
        }

        private boolean paintString(Graphics2D graphics2D) {
            if (this.mDrawingString != null) {
                this.mDrawingString.paint(graphics2D);
            }
            return true;
        }

        @Override
        public boolean setMagnification(float f) {
            if (!super.setMagnification(f)) {
                return false;
            }
            return this.mDrawingString == null || this.mDrawingString.setMagnification(f);
        }

        public SGDrawingElementString2DExtended getStringElement() {
            return this.mDrawingString;
        }

        public Rectangle2D getStringBounds() {
            if (this.mDrawingString == null) {
                return null;
            }
            Rectangle2D rectangle2D = this.mDrawingString.getStringRect();
            float f = (float)rectangle2D.getHeight();
            float f2 = (float)rectangle2D.getY();
            float f3 = this.mDrawingString.getStrikethroughOffset();
            float f4 = this.mDrawingString.getAdvance();
            float f5 = -f2 + f3;
            float f6 = f - f5;
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (f6 > f5) {
                f8 = f7 = f6 - f5;
            } else {
                f7 = f5 - f6;
            }
            rectangle2D.setRect(0.0, f8, f4, f + f7);
            return rectangle2D;
        }

        private void setRect(Rectangle2D rectangle2D) {
            this.mDataRect = rectangle2D;
        }

        public float getMaxDataElementWidth() {
            float f = 0.0f;
            List list = this.mDrawingElementGroupList;
            for (int i = 0; i < list.size(); ++i) {
                ILegendElement iLegendElement = (ILegendElement)list.get(i);
                float f2 = iLegendElement.getPreferredWidth();
                if (!(f2 > f)) continue;
                f = f2;
            }
            return f;
        }

        public double getMaxDataElementHeight() {
            double d = 0.0;
            List list = this.mDrawingElementGroupList;
            for (int i = 0; i < list.size(); ++i) {
                ILegendElement iLegendElement;
                double d2;
                SGElementGroup sGElementGroup = (SGElementGroup)list.get(i);
                if (!sGElementGroup.isVisible() || !((d2 = (double)(iLegendElement = (ILegendElement)list.get(i)).getPreferredHeight()) > d)) continue;
                d = d2;
            }
            return d;
        }

        void setDrawingElementBounds(Rectangle2D rectangle2D) {
            List list = this.mDrawingElementGroupList;
            for (int i = 0; i < list.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)list.get(i);
                if (!sGElementGroup.isVisible()) continue;
                ILegendElement iLegendElement = (ILegendElement)list.get(i);
                iLegendElement.setDataElementBounds(rectangle2D);
            }
        }

        protected boolean createDrawingElement() {
            List list = this.mDrawingElementGroupList;
            for (int i = 0; i < list.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)list.get(i);
                if (!sGElementGroup.isVisible()) continue;
                ILegendElement iLegendElement = (ILegendElement)((Object)sGElementGroup);
                iLegendElement.createDrawingElementInLegend();
            }
            return true;
        }

        @Override
        public void paintGraphics2D(Graphics2D graphics2D) {
            graphics2D.setPaint(SGFigureElementLegend.this.mFontColor);
            this.paintString(graphics2D);
            this.paintSymbol(graphics2D);
        }

        abstract void paintSymbol(Graphics2D var1);

        abstract boolean onMouseClicked(MouseEvent var1);

        boolean addDrawingElementGroup(SGElementGroup sGElementGroup) {
            ILegendElement iLegendElement = (ILegendElement)((Object)sGElementGroup);
            iLegendElement.setElementGroupSet(this);
            sGElementGroup.initDrawingElement(iLegendElement.getNumberOfPoints());
            sGElementGroup.setMagnification(this.getMagnification());
            this.mDrawingElementGroupList.add(sGElementGroup);
            return true;
        }

        protected SGAxis getAxis(int n) {
            return SGFigureElementLegend.this.mAxisElement.getAxisInPlane(n);
        }

        @Override
        public SGPropertyDialog getPropertyDialog() {
            SGData sGData = this.getData();
            SGPropertyDialog sGPropertyDialog = SGFigureElementLegend.this.getDataDialog(sGData);
            return sGPropertyDialog;
        }

        @Override
        public boolean prepare() {
            this.mTemporaryPropertiesInner = this.getProperties();
            return true;
        }

        @Override
        public boolean updateWithData() {
            return SGFigureElementLegend.this.updateAllDrawingElements();
        }

        @Override
        public boolean commit() {
            this.compareDataColumns("Data columns are changed on commit", this.mTemporaryPropertiesInner);
            SGProperties sGProperties = this.mTemporaryPropertiesInner;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.setChanged(true);
            }
            this.mTemporaryPropertiesInner = null;
            if (!this.updateWithData()) {
                return false;
            }
            SGFigureElementLegend.this.repaint();
            SGFigureElementLegend.this.notifyChangeOnCommit();
            return true;
        }

        @Override
        public boolean cancel() {
            this.compareDataColumns("Data columns are changed on commit", this.mTemporaryPropertiesInner);
            if (!this.setProperties(this.mTemporaryPropertiesInner)) {
                return false;
            }
            this.mTemporaryPropertiesInner = null;
            if (!this.updateWithData()) {
                return false;
            }
            SGFigureElementLegend.this.repaint();
            SGFigureElementLegend.this.notifyChange();
            return true;
        }

        @Override
        public boolean preview() {
            this.compareDataColumns("Data columns are changed on commit", this.mTemporaryPropertiesInner);
            if (!this.updateWithData()) {
                return false;
            }
            SGFigureElementLegend.this.repaint();
            SGFigureElementLegend.this.notifyChange();
            return true;
        }

        @Override
        protected void notifyToListener(String string) {
            SGFigureElementLegend.this.notifyToListener(string);
        }

        @Override
        protected void notifyToListener(String string, Object object) {
            SGFigureElementLegend.this.notifyToListener(string, object);
        }

        @Override
        public String getTagName() {
            return "";
        }

        public boolean writeProperty(Element element) {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGFigureElementLegend.this.setSelected(false);
                SGFigureElementLegend.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Move to Top")) {
                SGFigureElementLegend.this.moveChildToEnd(this.getID(), false);
            } else if (string.equals("Move to Upper")) {
                SGFigureElementLegend.this.moveChild(this.getID(), false);
            } else if (string.equals("Move to Lower")) {
                SGFigureElementLegend.this.moveChild(this.getID(), true);
            } else if (string.equals("Move to Bottom")) {
                SGFigureElementLegend.this.moveChildToEnd(this.getID(), true);
            } else if (string.equals("Play Animation")) {
                this.mTempDataProperties = this.mData.getProperties();
                this.notifyToListener(string);
                SGFigureElementLegend.this.doAnimation(this);
            } else {
                this.notifyToListener(string);
            }
            SGFigureElementLegend.this.updateAllDrawingElements();
            SGFigureElementLegend.this.repaint();
        }

        @Override
        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)sGProperties;
            SGIFigureElementAxis sGIFigureElementAxis = SGFigureElementLegend.this.mAxisElement;
            elementGroupSetPropertiesInFigureElement.xAxis = sGIFigureElementAxis.getLocationInPlane(this.getXAxis());
            elementGroupSetPropertiesInFigureElement.yAxis = sGIFigureElementAxis.getLocationInPlane(this.getYAxis());
            return true;
        }

        @Override
        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement elementGroupSetPropertiesInFigureElement = (SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement)sGProperties;
            SGIFigureElementAxis sGIFigureElementAxis = SGFigureElementLegend.this.mAxisElement;
            this.setXAxis(sGIFigureElementAxis.getAxisInPlane(elementGroupSetPropertiesInFigureElement.xAxis));
            this.setYAxis(sGIFigureElementAxis.getAxisInPlane(elementGroupSetPropertiesInFigureElement.yAxis));
            return true;
        }

        @Override
        public boolean setMementoBackward() {
            if (!super.setMementoBackward()) {
                return false;
            }
            SGFigureElementLegend.this.updateAllDrawingElements();
            SGFigureElementLegend.this.notifyChangeOnUndo();
            return true;
        }

        @Override
        public boolean setMementoForward() {
            if (!super.setMementoForward()) {
                return false;
            }
            SGFigureElementLegend.this.updateAllDrawingElements();
            SGFigureElementLegend.this.notifyChangeOnUndo();
            return true;
        }

        @Override
        public void notifyToRoot() {
            SGFigureElementLegend.this.notifyToRoot();
        }

        @Override
        public void setCurrentFrameIndex(int n) {
            super.setCurrentFrameIndex(n);
            SGFigureElementLegend.this.notifyChange();
        }

        @Override
        protected void onSaveChanges() {
            this.setChanged(true);
            SGFigureElementLegend.this.notifyChangeOnCommit();
            this.notifyToRoot();
        }

        @Override
        public void cancelChanges() {
            super.cancelChanges();
            SGFigureElementLegend.this.notifyChange();
        }

        @Override
        public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
            return null;
        }

        @Override
        protected boolean columnTypeChanged(SGData sGData) {
            return true;
        }
    }

    private static interface ILegendElement {
        public float getPreferredWidth();

        public float getPreferredHeight();

        public void setDataElementBounds(Rectangle2D var1);

        public boolean createDrawingElementInLegend();

        public int getNumberOfPoints();

        public boolean setElementGroupSet(ElementGroupSetInLegend var1);
    }
}

