/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIChildObject;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisBreakConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementAxisBreak2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElement2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisBreakDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGFigureElementAxisBreak
extends SGFigureElement2D
implements SGIFigureElementAxisBreak,
SGIAxisBreakConstants {
    private SGIFigureElementAxis mAxisElement = null;
    private SGPropertyDialog mPropertyDialog = null;

    @Override
    public void dispose() {
        super.dispose();
        if (this.mPropertyDialog != null) {
            this.mPropertyDialog.dispose();
            this.mPropertyDialog = null;
        }
        this.mAxisElement = null;
    }

    @Override
    public String getClassDescription() {
        return "Axis Break Symbols";
    }

    @Override
    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIFigureElementGraph || sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementLegend)) {
            if (sGIFigureElement instanceof SGIFigureElementAxis) {
                bl = this.synchronizeToAxisElement((SGIFigureElementAxis)sGIFigureElement, string);
            } else if (!(sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return bl;
    }

    private boolean synchronizeToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            if (!axisBreakSymbol.isAnchored() ? !axisBreakSymbol.setDrawingElementsLocation() : !axisBreakSymbol.setAxisValue()) continue;
            axisBreakSymbol.setChanged(true);
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    @Override
    public void setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
    }

    @Override
    public String getTagName() {
        return "AxisBreakSymbols";
    }

    @Override
    public boolean writeProperty(Element element) {
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("AxisBreakSymbol");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol();
            Element element2 = (Element)node;
            if (!axisBreakSymbol.readProperty(element2)) {
                return false;
            }
            axisBreakSymbol.initPropertiesHistory();
            this.addToList(axisBreakSymbol);
        }
        return true;
    }

    @Override
    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        this.setLocationOfAllDrawingElements();
        return true;
    }

    private boolean setLocationOfAllDrawingElements() {
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            if (!axisBreakSymbol.isAnchored()) {
                axisBreakSymbol.setDrawingElementsLocation();
                continue;
            }
            axisBreakSymbol.setAxisValue();
            if (axisBreakSymbol.setDrawingElementsLocation()) continue;
        }
        return true;
    }

    @Override
    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        AxisBreakSymbol axisBreakSymbol;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        List<SGIChildObject> list = this.getVisibleChildList();
        for (n = 0; n < list.size(); ++n) {
            axisBreakSymbol = (AxisBreakSymbol)list.get(n);
            if (!axisBreakSymbol.isValid()) continue;
            axisBreakSymbol.paint(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < list.size(); ++n) {
                axisBreakSymbol = (AxisBreakSymbol)list.get(n);
                if (!axisBreakSymbol.isValid()) continue;
                object = axisBreakSymbol.getAnchorPointList();
                if (!axisBreakSymbol.isAnchored()) {
                    SGUtilityForFigureElementJava2D.drawAnchorAsChildObject((List)object, graphics2D);
                    continue;
                }
                SGUtilityForFigureElementJava2D.drawAnchorPointsAsAnchoredChildObject((List<Point2D>)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList<SGISelectable> arrayList = new ArrayList<SGISelectable>();
            this.getFocusedObjectsList(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (AxisBreakSymbol)arrayList.get(i);
                if (!((AxisBreakSymbol)object).isValid()) continue;
                ArrayList arrayList2 = ((AxisBreakSymbol)object).getAnchorPointList();
                if (!((AxisBreakSymbol)object).isAnchored()) {
                    SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(arrayList2, graphics2D);
                    continue;
                }
                SGUtilityForFigureElementJava2D.drawAnchorPointsAsAnchoredForcusObject(arrayList2, graphics2D);
            }
        }
    }

    @Override
    public Element[] createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            if (!axisBreakSymbol.isValid()) continue;
            Element element2 = axisBreakSymbol.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return new Element[]{element};
    }

    @Override
    public boolean addAxisBreakSymbol(float f, float f2) {
        if (!this.getGraphRect().contains(f, f2)) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        if (sGAxis == null || sGAxis2 == null) {
            return false;
        }
        return this.addAxisBreakSymbol(this.assignChildId(), f, f2, sGAxis, sGAxis2);
    }

    private boolean addAxisBreakSymbol(int n, float f, float f2, SGAxis sGAxis, SGAxis sGAxis2) {
        AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol(1.0f, "cm", 0.5f, "cm", 0.5f, 0.0f, true);
        axisBreakSymbol.setInnerColor(DEFAULT_AXIS_BREAK_INNER_COLOR);
        axisBreakSymbol.setLineColor(DEFAULT_AXIS_BREAK_LINE_COLOR);
        axisBreakSymbol.setLineWidth(1.5f, "pt");
        axisBreakSymbol.setMagnification(this.mMagnification);
        axisBreakSymbol.mXAxis = sGAxis;
        axisBreakSymbol.mYAxis = sGAxis2;
        axisBreakSymbol.setLocation(f, f2);
        axisBreakSymbol.setAxisValue();
        if (!this.addToList(n, axisBreakSymbol)) {
            return false;
        }
        axisBreakSymbol.initPropertiesHistory();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    @Override
    public boolean addAxisBreakSymbol(int n, double d, double d2) {
        return this.addAxisBreakSymbol(n, d, d2, "Bottom", "Left");
    }

    @Override
    public boolean addAxisBreakSymbol(int n, double d, double d2, String string, String string2) {
        float f;
        String string3 = string != null ? string : "Bottom";
        String string4 = string2 != null ? string2 : "Left";
        SGAxis sGAxis = this.mAxisElement.getAxis(string3);
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string4);
        if (sGAxis == null || sGAxis2 == null) {
            return false;
        }
        if (!sGAxis.isValidValue(d)) {
            return false;
        }
        if (!sGAxis2.isValidValue(d2)) {
            return false;
        }
        float f2 = this.calcLocation(d, sGAxis, true);
        return this.addAxisBreakSymbol(n, f2, f = this.calcLocation(d2, sGAxis2, false), sGAxis, sGAxis2);
    }

    protected boolean setAllDrawingElementsLocation() {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = 0; i < list.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            if (axisBreakSymbol.setDrawingElementsLocation()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    @Override
    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    @Override
    public boolean onMouseClicked(MouseEvent mouseEvent) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            if (!axisBreakSymbol.isValid() || !this.clickDrawingElements(axisBreakSymbol, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.mTemporaryProperties = axisBreakSymbol.getProperties();
        }
        return true;
    }

    @Override
    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    private boolean clickDrawingElements(AxisBreakSymbol axisBreakSymbol, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (axisBreakSymbol.contains(n, n2)) {
            this.updateFocusedObjectsList((SGISelectable)axisBreakSymbol, mouseEvent);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || n3 != 1) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && n3 == 2) {
                    this.setPropertiesOfSelectedObjects();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && n3 == 1) {
                    axisBreakSymbol.getPopupMenu().show(this.getComponent(), n, n2);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            if (!axisBreakSymbol.isValid() || !axisBreakSymbol.contains(n, n2)) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            this.setMouseCursor(13);
            if (axisBreakSymbol.isSelected()) {
                this.mDraggableFlag = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (!this.mDraggableFlag) {
            return false;
        }
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid()) continue;
            axisBreakSymbol.translate(n, n2);
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    @Override
    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            SGProperties sGProperties2 = axisBreakSymbol.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = axisBreakSymbol.getProperties()).equals(sGProperties2)) continue;
            axisBreakSymbol.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean onMouseReleased(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid()) continue;
            Rectangle2D rectangle2D = axisBreakSymbol.getElementBounds();
            if (rectangle2D.contains(mouseEvent.getPoint())) {
                this.setMouseCursor(12);
                continue;
            }
            this.setMouseCursor(0);
        }
        this.mDraggableFlag = false;
        this.notifyToRoot();
        return true;
    }

    @Override
    public boolean onDrawingElement(int n, int n2) {
        List<SGIChildObject> list = this.getVisibleChildList();
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean bl;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            if (!axisBreakSymbol.isValid() || !(bl = axisBreakSymbol.contains(n, n2))) continue;
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    @Override
    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        Cloneable cloneable;
        Object object;
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        List<SGIChildObject> list = this.getVisibleChildList();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < list.size(); ++i) {
            object = (AxisBreakSymbol)list.get(i);
            cloneable = ((SGDrawingElementAxisBreak2D)object).getElementBounds();
            arrayList.add((Rectangle2D)cloneable);
        }
        Rectangle2D rectangle2D = null;
        if (arrayList.size() != 0) {
            rectangle2D = SGUtility.createUnion(arrayList);
        }
        object = this.getGraphRect();
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(object);
        if (rectangle2D != null) {
            ((ArrayList)cloneable).add(rectangle2D);
        }
        Rectangle2D rectangle2D2 = SGUtility.createUnion((ArrayList)cloneable);
        float f = (float)(((RectangularShape)object).getY() - rectangle2D2.getY());
        float f2 = (float)(rectangle2D2.getY() + rectangle2D2.getHeight() - (((RectangularShape)object).getY() + ((RectangularShape)object).getHeight()));
        float f3 = (float)(((RectangularShape)object).getX() - rectangle2D2.getX());
        float f4 = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() - (((RectangularShape)object).getX() + ((RectangularShape)object).getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    @Override
    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            AxisProperties axisProperties = (AxisProperties)list.get(i);
            hashSet.addAll(axisProperties.visibleAxisBreakSymbolList);
        }
        return hashSet;
    }

    @Override
    public SGProperties getProperties() {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.visibleAxisBreakSymbolList = this.getVisibleChildList();
        return axisProperties;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisProperties)) {
            return false;
        }
        AxisProperties axisProperties = (AxisProperties)sGProperties;
        boolean bl = this.setVisibleChildList(axisProperties.visibleAxisBreakSymbolList);
        return bl;
    }

    @Override
    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        List<SGICopiable> list = this.duplicateObjects();
        for (int i = 0; i < list.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)list.get(i);
            axisBreakSymbol.translate(n, n2);
            axisBreakSymbol.setSelected(true);
            this.addToList(axisBreakSymbol);
            axisBreakSymbol.initPropertiesHistory();
        }
        if (list.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean paste(List<SGICopiable> list) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            SGICopiable sGICopiable = list.get(i);
            if (!(sGICopiable instanceof AxisBreakSymbol)) continue;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)sGICopiable;
            axisBreakSymbol.translate(n, n2);
            SGProperties sGProperties = axisBreakSymbol.getProperties();
            AxisBreakSymbol axisBreakSymbol2 = new AxisBreakSymbol();
            axisBreakSymbol2.setMagnification(f);
            axisBreakSymbol2.setProperties(sGProperties);
            axisBreakSymbol2.mXAxis = this.mAxisElement.getAxisInPlane(axisBreakSymbol.mTempXAxis);
            axisBreakSymbol2.mYAxis = this.mAxisElement.getAxisInPlane(axisBreakSymbol.mTempYAxis);
            axisBreakSymbol2.setDrawingElementsLocation();
            axisBreakSymbol2.setAxisValue();
            this.addToList(axisBreakSymbol2);
            axisBreakSymbol2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    @Override
    public boolean setDialogOwner(Frame frame) {
        if (!super.setDialogOwner(frame)) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SGFigureElementAxisBreak.this.mPropertyDialog == null) {
                    SGFigureElementAxisBreak.this.mPropertyDialog = new SGAxisBreakDialog(SGFigureElementAxisBreak.this.mDialogOwner, true);
                }
            }
        });
        return true;
    }

    @Override
    public SGPropertyResults setChildProperties(int n, SGPropertyMap sGPropertyMap) {
        Object object;
        SGIChildObject sGIChildObject = this.getVisibleChild(n);
        if (sGIChildObject == null) {
            Object object2;
            Object object3;
            object = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = object3.toString();
                if ("X".equalsIgnoreCase((String)object2)) {
                    object = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("Y".equalsIgnoreCase((String)object2)) {
                    string = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if ("AxisX".equalsIgnoreCase((String)object2)) {
                    string2 = sGPropertyMap.getValueString((String)object2);
                    continue;
                }
                if (!"AxisY".equalsIgnoreCase((String)object2)) continue;
                string3 = sGPropertyMap.getValueString((String)object2);
            }
            if (object == null) {
                return null;
            }
            if (string == null) {
                return null;
            }
            object3 = SGUtilityText.getDouble((String)object);
            object2 = SGUtilityText.getDouble(string);
            if (object3 == null) {
                return null;
            }
            if (object2 == null) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue((Double)object3)) {
                return null;
            }
            if (!SGUtility.isValidPropertyValue((Double)object2)) {
                return null;
            }
            if (!this.addAxisBreakSymbol(n, (Double)object3, (Double)object2, string2, string3)) {
                return null;
            }
            sGIChildObject = this.getVisibleChild(n);
        }
        object = sGIChildObject.setProperties(sGPropertyMap);
        return object;
    }

    public static class AxisBreakSymbolWithAxesProperties
    extends SGDrawingElementAxisBreak.AxisBreakSymbolProperties {
        private double mXValue = 0.0;
        private double mYValue = 0.0;
        private SGAxis mXAxis = null;
        private SGAxis mYAxis = null;
        private boolean mAnchored = false;

        public boolean equals(Object object) {
            if (!(object instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)object;
            if (axisBreakSymbolWithAxesProperties.mXValue != this.mXValue) {
                return false;
            }
            if (axisBreakSymbolWithAxesProperties.mYValue != this.mYValue) {
                return false;
            }
            if (!this.mXAxis.equals(axisBreakSymbolWithAxesProperties.mXAxis)) {
                return false;
            }
            if (!this.mYAxis.equals(axisBreakSymbolWithAxesProperties.mYAxis)) {
                return false;
            }
            return axisBreakSymbolWithAxesProperties.mAnchored == this.mAnchored;
        }

        public Double getXValue() {
            return this.mXValue;
        }

        public Double getYValue() {
            return this.mYValue;
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public boolean getAnchored() {
            return this.mAnchored;
        }

        public boolean setXValue(double d) {
            this.mXValue = d;
            return true;
        }

        public boolean setYValue(double d) {
            this.mYValue = d;
            return true;
        }

        public boolean setAnchored(boolean bl) {
            this.mAnchored = bl;
            return true;
        }
    }

    private class AxisBreakSymbol
    extends SGDrawingElementAxisBreak2D
    implements ActionListener,
    SGIUndoable,
    SGFigureElement.IMovableChild,
    SGICopiable,
    SGINode,
    SGIAxisBreakDialogObserver {
        private int mID;
        private SGAxis mXAxis;
        private SGAxis mYAxis;
        private double mXValue;
        private double mYValue;
        private boolean mIsAnchored;
        private SGProperties mTemporaryProperties;
        private AxisBreakSymbolPopupMenu mPopupMenu;
        private boolean mDisposed;
        private int mTempXAxis;
        private int mTempYAxis;
        private boolean mValidFlag;
        private SGUndoManager mUndoManager;
        private boolean mSelectedFlag;

        public int getID() {
            return this.mID;
        }

        public boolean setID(int n) {
            this.mID = n;
            return true;
        }

        AxisBreakSymbol() {
            this.mXAxis = null;
            this.mYAxis = null;
            this.mTemporaryProperties = null;
            this.mPopupMenu = null;
            this.mDisposed = false;
            this.mTempXAxis = -1;
            this.mTempYAxis = -1;
            this.mValidFlag = true;
            this.mUndoManager = new SGUndoManager(this);
            this.mSelectedFlag = false;
        }

        AxisBreakSymbol(float f, String string, float f2, String string2, float f3, float f4, boolean bl) {
            super(f, string, f2, string2, f3, f4, bl);
            this.mXAxis = null;
            this.mYAxis = null;
            this.mTemporaryProperties = null;
            this.mPopupMenu = null;
            this.mDisposed = false;
            this.mTempXAxis = -1;
            this.mTempYAxis = -1;
            this.mValidFlag = true;
            this.mUndoManager = new SGUndoManager(this);
            this.mSelectedFlag = false;
        }

        public void dispose() {
            super.dispose();
            this.mPopupMenu = null;
            if (this.mTemporaryProperties != null) {
                this.mTemporaryProperties.dispose();
                this.mTemporaryProperties = null;
            }
            this.mUndoManager.dispose();
            this.mUndoManager = null;
            this.mXAxis = null;
            this.mYAxis = null;
        }

        public boolean isDisposed() {
            return this.mDisposed;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getSimpleName());
            stringBuffer.append(":");
            stringBuffer.append(this.mID);
            return stringBuffer.toString();
        }

        public int getXAxisLocation() {
            return SGFigureElementAxisBreak.this.mAxisElement.getLocationInPlane(this.mXAxis);
        }

        public int getYAxisLocation() {
            return SGFigureElementAxisBreak.this.mAxisElement.getLocationInPlane(this.mYAxis);
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 && n != 1) {
                return false;
            }
            SGAxis sGAxis = SGFigureElementAxisBreak.this.mAxisElement.getAxisInPlane(n);
            if (sGAxis == null) {
                return false;
            }
            this.mXAxis = sGAxis;
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 && n != 3) {
                return false;
            }
            SGAxis sGAxis = SGFigureElementAxisBreak.this.mAxisElement.getAxisInPlane(n);
            if (sGAxis == null) {
                return false;
            }
            this.mYAxis = sGAxis;
            return true;
        }

        public double getXValue() {
            return this.mXValue;
        }

        public double getYValue() {
            return this.mYValue;
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public float getLength(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLength(), string);
        }

        public float getInterval(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getInterval(), string);
        }

        public boolean setXValue(double d) {
            if (!this.mXAxis.isValidValue(d)) {
                return false;
            }
            this.mXValue = d;
            return true;
        }

        public boolean setYValue(double d) {
            if (!this.mYAxis.isValidValue(d)) {
                return false;
            }
            this.mYValue = d;
            return true;
        }

        public boolean hasValidXValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mXAxis : SGFigureElementAxisBreak.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidYValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGFigureElementAxisBreak.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean isAnchored() {
            return this.mIsAnchored;
        }

        public boolean setAnchored(boolean bl) {
            this.mIsAnchored = bl;
            return true;
        }

        public Object copy() {
            AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol();
            axisBreakSymbol.setMagnification(this.getMagnification());
            axisBreakSymbol.setProperties(this.getProperties());
            axisBreakSymbol.setLocation(this.getX(), this.getY());
            axisBreakSymbol.mTempXAxis = SGFigureElementAxisBreak.this.mAxisElement.getLocationInPlane(this.mXAxis);
            axisBreakSymbol.mTempYAxis = SGFigureElementAxisBreak.this.mAxisElement.getLocationInPlane(this.mYAxis);
            axisBreakSymbol.setAnchored(this.isAnchored());
            return axisBreakSymbol;
        }

        public SGPropertyDialog getPropertyDialog() {
            SGPropertyDialog sGPropertyDialog = null;
            if (SGFigureElementAxisBreak.this.mPropertyDialog != null) {
                sGPropertyDialog = SGFigureElementAxisBreak.this.mPropertyDialog;
            } else {
                sGPropertyDialog = new SGAxisBreakDialog(SGFigureElementAxisBreak.this.mDialogOwner, true);
                SGFigureElementAxisBreak.this.mPropertyDialog = sGPropertyDialog;
            }
            return sGPropertyDialog;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            SGIFigureElementAxis sGIFigureElementAxis = SGFigureElementAxisBreak.this.mAxisElement;
            String string = sGIFigureElementAxis.getLocationName(this.mXAxis);
            String string2 = sGIFigureElementAxis.getLocationName(this.mYAxis);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.mID);
            stringBuffer.append(": ");
            stringBuffer.append(" AxisX=");
            stringBuffer.append(string.toString());
            stringBuffer.append(", AxisY=");
            stringBuffer.append(string2.toString());
            stringBuffer.append(", X=");
            stringBuffer.append(this.getXValue());
            stringBuffer.append(", Y=");
            stringBuffer.append(this.getYValue());
            return stringBuffer.toString();
        }

        public JPopupMenu getPopupMenu() {
            AxisBreakSymbolPopupMenu axisBreakSymbolPopupMenu = null;
            if (this.mPopupMenu != null) {
                axisBreakSymbolPopupMenu = this.mPopupMenu;
            } else {
                axisBreakSymbolPopupMenu = new AxisBreakSymbolPopupMenu();
                axisBreakSymbolPopupMenu.init(this);
                this.mPopupMenu = axisBreakSymbolPopupMenu;
            }
            axisBreakSymbolPopupMenu.setAnchored(this.isAnchored());
            return axisBreakSymbolPopupMenu;
        }

        public SGTuple2f getLocation() {
            float f = super.getX();
            float f2 = super.getY();
            float f3 = this.getMagnification() * f + SGFigureElementAxisBreak.this.mGraphRectX;
            float f4 = this.getMagnification() * f2 + SGFigureElementAxisBreak.this.mGraphRectY;
            return new SGTuple2f(f3, f4);
        }

        public float getX() {
            return this.getLocation().x;
        }

        public float getY() {
            return this.getLocation().y;
        }

        public boolean setLocation(float f, float f2) {
            float f3 = this.getMagnification();
            float f4 = (f - SGFigureElementAxisBreak.this.mGraphRectX) / f3;
            float f5 = (f2 - SGFigureElementAxisBreak.this.mGraphRectY) / f3;
            super.setLocation(f4, f5);
            return true;
        }

        public void translate(float f, float f2) {
            this.setLocation(this.getX() + f, this.getY() + f2);
            this.setAxisValue();
            this.setDrawingElementsLocation();
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            Shape[] shapeArray = this.getShapeArray();
            if (shapeArray.length == 0) {
                return arrayList;
            }
            Line2D line2D = (Line2D)shapeArray[1];
            Line2D line2D2 = (Line2D)shapeArray[3];
            Point2D point2D = line2D.getP1();
            Point2D point2D2 = line2D.getP2();
            Point2D point2D3 = line2D2.getP1();
            Point2D point2D4 = line2D2.getP2();
            Point2D.Float float_ = new Point2D.Float((float)(point2D4.getX() + point2D.getX()) / 2.0f, (float)(point2D4.getY() + point2D.getY()) / 2.0f);
            Point2D.Float float_2 = new Point2D.Float((float)(point2D2.getX() + point2D3.getX()) / 2.0f, (float)(point2D2.getY() + point2D3.getY()) / 2.0f);
            arrayList.add(point2D4);
            arrayList.add(float_);
            arrayList.add(point2D);
            arrayList.add(point2D2);
            arrayList.add(float_2);
            arrayList.add(point2D3);
            return arrayList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGFigureElementAxisBreak.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") || string.equals("Cut") || string.equals("Paste") || string.equals("Delete") || string.equals("Duplicate") || string.equals("Bring to Front") || string.equals("Bring Forward") || string.equals("Send Backward") || string.equals("Send to Back")) {
                SGFigureElementAxisBreak.this.notifyToListener(string);
            } else if (string.equals("Anchored")) {
                SGFigureElementAxisBreak.this.notifyToListener(string, actionEvent.getSource());
            }
        }

        public boolean isValid() {
            return this.mValidFlag;
        }

        public void setValid(boolean bl) {
            this.mValidFlag = bl;
        }

        public boolean setDrawingElementsLocation() {
            float f = SGFigureElementAxisBreak.this.calcLocation(this.mXValue, this.mXAxis, true);
            float f2 = SGFigureElementAxisBreak.this.calcLocation(this.mYValue, this.mYAxis, false);
            if (Float.isNaN(f) || Float.isNaN(f2)) {
                this.setValid(false);
                return false;
            }
            this.setValid(true);
            this.setLocation(f, f2);
            return true;
        }

        public boolean setAxisValue() {
            double d = SGFigureElementAxisBreak.this.calcValue(this.getX(), this.mXAxis, true);
            double d2 = SGFigureElementAxisBreak.this.calcValue(this.getY(), this.mYAxis, false);
            this.mXValue = SGFigureElementAxisBreak.this.getNumberInRangeOrder(d, this.mXAxis);
            this.mYValue = SGFigureElementAxisBreak.this.getNumberInRangeOrder(d2, this.mYAxis);
            return true;
        }

        public String getTagName() {
            return "AxisBreakSymbol";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute("XValue", Double.toString(this.mXValue));
            element.setAttribute("YValue", Double.toString(this.mYValue));
            element.setAttribute("XAxisPosition", SGFigureElementAxisBreak.this.mAxisElement.getLocationName(this.mXAxis));
            element.setAttribute("YAxisPosition", SGFigureElementAxisBreak.this.mAxisElement.getLocationName(this.mYAxis));
            element.setAttribute("Anchored", Boolean.toString(this.mIsAnchored));
            return true;
        }

        public boolean readProperty(Element element) {
            SGAxis sGAxis;
            if (!super.readProperty(element)) {
                return false;
            }
            String string = null;
            Double d = null;
            string = element.getAttribute("XAxisPosition");
            if (string.length() != 0) {
                sGAxis = SGFigureElementAxisBreak.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mXAxis = sGAxis;
            }
            if ((string = element.getAttribute("YAxisPosition")).length() != 0) {
                sGAxis = SGFigureElementAxisBreak.this.mAxisElement.getAxis(string);
                if (sGAxis == null) {
                    return false;
                }
                this.mYAxis = sGAxis;
            }
            if ((string = element.getAttribute("XValue")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d2 = d;
                if (!this.mXAxis.isValidValue(d2)) {
                    return false;
                }
                if (!this.setXValue(d2)) {
                    return false;
                }
            }
            if ((string = element.getAttribute("YValue")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                double d3 = d;
                if (!this.mYAxis.isValidValue(d3)) {
                    return false;
                }
                if (!this.setYValue(d3)) {
                    return false;
                }
            }
            if ((string = element.getAttribute("Anchored")).length() != 0) {
                Boolean bl = SGUtilityText.getBoolean(string);
                if (bl == null) {
                    return false;
                }
                if (!this.setAnchored(bl)) {
                    return false;
                }
                this.setDrawingElementsLocation();
            }
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean commit() {
            SGProperties sGProperties = this.getProperties();
            if (sGProperties == null) {
                return false;
            }
            if (!sGProperties.equals(this.mTemporaryProperties)) {
                this.setChanged(true);
            }
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGFigureElementAxisBreak.this.repaint();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGFigureElementAxisBreak.this.repaint();
            return true;
        }

        public boolean preview() {
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGFigureElementAxisBreak.this.repaint();
            return true;
        }

        public SGProperties getMemento() {
            return this.getProperties();
        }

        public boolean setMemento(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public boolean setMementoBackward() {
            if (!this.mUndoManager.setMementoBackward()) {
                return false;
            }
            this.create();
            this.setDrawingElementsLocation();
            return true;
        }

        public boolean setMementoForward() {
            if (!this.mUndoManager.setMementoForward()) {
                return false;
            }
            this.create();
            this.setDrawingElementsLocation();
            return true;
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public boolean isChanged() {
            return this.mUndoManager.isChanged();
        }

        public void setChanged(boolean bl) {
            this.mUndoManager.setChanged(bl);
        }

        public boolean deleteForwardHistory() {
            return this.mUndoManager.deleteForwardHistory();
        }

        public boolean isChangedRoot() {
            return this.isChanged();
        }

        public void clearChanged() {
            this.setChanged(false);
        }

        public void notifyToRoot() {
            SGFigureElementAxisBreak.this.notifyToRoot();
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)sGProperties;
            Double d = axisBreakSymbolWithAxesProperties.getXValue();
            if (d == null) {
                return false;
            }
            this.mXValue = d;
            Double d2 = axisBreakSymbolWithAxesProperties.getYValue();
            if (d2 == null) {
                return false;
            }
            this.mYValue = d2;
            this.mXAxis = axisBreakSymbolWithAxesProperties.mXAxis;
            this.mYAxis = axisBreakSymbolWithAxesProperties.mYAxis;
            Boolean bl = axisBreakSymbolWithAxesProperties.getAnchored();
            if (bl == null) {
                return false;
            }
            this.mIsAnchored = bl;
            return true;
        }

        public SGProperties getProperties() {
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = new AxisBreakSymbolWithAxesProperties();
            if (!this.getProperties(axisBreakSymbolWithAxesProperties)) {
                return null;
            }
            return axisBreakSymbolWithAxesProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)sGProperties;
            axisBreakSymbolWithAxesProperties.setXValue(this.mXValue);
            axisBreakSymbolWithAxesProperties.setYValue(this.mYValue);
            axisBreakSymbolWithAxesProperties.mXAxis = this.mXAxis;
            axisBreakSymbolWithAxesProperties.mYAxis = this.mYAxis;
            axisBreakSymbolWithAxesProperties.setAnchored(this.mIsAnchored);
            return true;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        public float getMagnification() {
            return SGFigureElementAxisBreak.this.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }

        public SGPropertyResults setProperties(SGPropertyMap sGPropertyMap) {
            SGPropertyResults sGPropertyResults = new SGPropertyResults();
            if (!this.prepare()) {
                return null;
            }
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                Number number;
                String string = iterator.next();
                String string2 = sGPropertyMap.getValueString(string);
                if ("AxisX".equalsIgnoreCase(string)) {
                    int n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults.putResult("AxisX", 1);
                        continue;
                    }
                    if (!this.setXAxisLocation(n)) {
                        sGPropertyResults.putResult("AxisX", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("AxisX", 0);
                    continue;
                }
                if ("AxisY".equalsIgnoreCase(string)) {
                    int n = SGUtility.getAxisLocation(string2);
                    if (n == -1) {
                        sGPropertyResults.putResult("AxisY", 1);
                        continue;
                    }
                    if (!this.setYAxisLocation(n)) {
                        sGPropertyResults.putResult("AxisY", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("AxisY", 0);
                    continue;
                }
                if ("X".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("X", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("X", 1);
                        continue;
                    }
                    if (!this.setXValue(d)) {
                        sGPropertyResults.putResult("X", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("X", 0);
                    continue;
                }
                if ("Y".equalsIgnoreCase(string)) {
                    Double d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        sGPropertyResults.putResult("Y", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(d)) {
                        sGPropertyResults.putResult("Y", 1);
                        continue;
                    }
                    if (!this.setYValue(d)) {
                        sGPropertyResults.putResult("Y", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Y", 0);
                    continue;
                }
                if ("Length".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults.putResult("Length", 1);
                        continue;
                    }
                    if (!this.setLength(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults.putResult("Length", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Length", 0);
                    continue;
                }
                if ("Interval".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults.putResult("Interval", 1);
                        continue;
                    }
                    if (!this.setInterval(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults.putResult("Interval", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Interval", 0);
                    continue;
                }
                if ("Distortion".equalsIgnoreCase(string)) {
                    Float f = SGUtilityText.getFloat(string2);
                    if (f == null) {
                        sGPropertyResults.putResult("Distortion", 1);
                        continue;
                    }
                    if (!SGUtility.isValidPropertyValue(((Number)f).floatValue())) {
                        sGPropertyResults.putResult("Distortion", 1);
                        continue;
                    }
                    if (!this.setDistortion(((Number)f).floatValue())) {
                        sGPropertyResults.putResult("Distortion", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Distortion", 0);
                    continue;
                }
                if ("Angle".equalsIgnoreCase(string)) {
                    Float f = SGUtilityText.getFloat(string2);
                    if (f == null) {
                        sGPropertyResults.putResult("Angle", 1);
                        continue;
                    }
                    if (!this.setAngle(((Number)f).floatValue())) {
                        sGPropertyResults.putResult("Angle", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Angle", 0);
                    continue;
                }
                if ("LineWidth".equalsIgnoreCase(string)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    number = SGUtilityText.getNumber(string2, stringBuffer);
                    if (number == null) {
                        sGPropertyResults.putResult("LineWidth", 1);
                        continue;
                    }
                    if (!this.setLineWidth(number.floatValue(), stringBuffer.toString())) {
                        sGPropertyResults.putResult("LineWidth", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("LineWidth", 0);
                    continue;
                }
                if ("Horizontal".equalsIgnoreCase(string)) {
                    Boolean bl = SGUtilityText.getBoolean(string2);
                    if (bl == null) {
                        sGPropertyResults.putResult("Horizontal", 1);
                        continue;
                    }
                    if (!this.setForHorizontalAxisFlag(bl)) {
                        sGPropertyResults.putResult("Horizontal", 1);
                        continue;
                    }
                    sGPropertyResults.putResult("Horizontal", 0);
                    continue;
                }
                if ("LineColor".equalsIgnoreCase(string)) {
                    Color color = SGUtilityText.getColor(string2);
                    if (color != null) {
                        if (!this.setLineColor(color)) {
                            sGPropertyResults.putResult("LineColor", 1);
                            continue;
                        }
                    } else {
                        color = SGUtilityText.parseColor(string2);
                        if (color == null) {
                            sGPropertyResults.putResult("LineColor", 1);
                            continue;
                        }
                        if (!this.setLineColor(color)) {
                            sGPropertyResults.putResult("LineColor", 1);
                            continue;
                        }
                    }
                    sGPropertyResults.putResult("LineColor", 0);
                    continue;
                }
                if ("InnerColor".equalsIgnoreCase(string)) {
                    Color color = SGUtilityText.getColor(string2);
                    if (color != null) {
                        if (!this.setInnerColor(color)) {
                            sGPropertyResults.putResult("InnerColor", 1);
                            continue;
                        }
                    } else {
                        color = SGUtilityText.parseColor(string2);
                        if (color == null) {
                            sGPropertyResults.putResult("InnerColor", 1);
                            continue;
                        }
                        if (!this.setInnerColor(color)) {
                            sGPropertyResults.putResult("InnerColor", 1);
                            continue;
                        }
                    }
                    sGPropertyResults.putResult("InnerColor", 0);
                    continue;
                }
                if (!"Anchored".equalsIgnoreCase(string)) continue;
                Boolean bl = SGUtilityText.getBoolean(string2);
                if (bl == null) {
                    sGPropertyResults.putResult("Anchored", 1);
                    continue;
                }
                if (!this.setAnchored(bl)) {
                    sGPropertyResults.putResult("Anchored", 1);
                    continue;
                }
                sGPropertyResults.putResult("Anchored", 0);
            }
            if (!this.commit()) {
                return null;
            }
            this.notifyToRoot();
            SGFigureElementAxisBreak.this.notifyChange();
            SGFigureElementAxisBreak.this.repaint();
            return sGPropertyResults;
        }
    }

    private static class AxisBreakSymbolPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = -2688401892783919136L;
        private JCheckBoxMenuItem anchoredCheckBox;

        private AxisBreakSymbolPopupMenu() {
        }

        void init(AxisBreakSymbol axisBreakSymbol) {
            this.setBounds(0, 0, 100, 100);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  -- AxisBreak: ");
            stringBuffer.append(axisBreakSymbol.getID());
            stringBuffer.append(" --");
            this.add(new JLabel(stringBuffer.toString()));
            this.addSeparator();
            SGUtility.addItem(this, axisBreakSymbol, "Bring to Front");
            SGUtility.addItem(this, axisBreakSymbol, "Bring Forward");
            SGUtility.addItem(this, axisBreakSymbol, "Send Backward");
            SGUtility.addItem(this, axisBreakSymbol, "Send to Back");
            this.addSeparator();
            SGUtility.addItem(this, axisBreakSymbol, "Cut");
            SGUtility.addItem(this, axisBreakSymbol, "Copy");
            SGUtility.addItem(this, axisBreakSymbol, "Paste");
            this.addSeparator();
            SGUtility.addItem(this, axisBreakSymbol, "Delete");
            SGUtility.addItem(this, axisBreakSymbol, "Duplicate");
            this.addSeparator();
            this.anchoredCheckBox = new JCheckBoxMenuItem("Anchored");
            this.add(this.anchoredCheckBox);
            this.anchoredCheckBox.addActionListener(axisBreakSymbol);
            this.addSeparator();
            SGUtility.addItem(this, axisBreakSymbol, "Property");
        }

        void setAnchored(boolean bl) {
            this.anchoredCheckBox.setSelected(bl);
        }
    }

    public static class AxisProperties
    extends SGProperties {
        List visibleAxisBreakSymbolList = new ArrayList();

        AxisProperties() {
        }

        public void dispose() {
            super.dispose();
            this.visibleAxisBreakSymbolList.clear();
            this.visibleAxisBreakSymbolList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AxisProperties)) {
                return false;
            }
            AxisProperties axisProperties = (AxisProperties)object;
            return ((Object)axisProperties.visibleAxisBreakSymbolList).equals(this.visibleAxisBreakSymbolList);
        }
    }
}

