/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupSymbol
extends SGElementGroupSXY
implements SGISymbolConstants,
SGIElementGroupConstants,
SGIFigureDrawingElementConstants {
    protected float mSymbolSize;
    protected int mSymbolType;
    protected Color mLineColor;
    protected SGFillPaint mInnerPaint = new SGFillPaint();
    protected float mLineWidth;
    protected boolean mLineVisible;
    protected float mAngle;
    private Shape mShape = null;
    protected double mShiftX;
    protected double mShiftY;

    public void dispose() {
        super.dispose();
        this.mLineColor = null;
        this.mShape = null;
    }

    public float getSize() {
        return this.mSymbolSize;
    }

    public float getSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getSize(), string);
    }

    public int getType() {
        return this.mSymbolType;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public boolean isLineVisible() {
        return this.mLineVisible;
    }

    public Color getInnerColor() {
        return this.mInnerPaint.getColor();
    }

    public SGIPaint getInnerPaint() {
        return this.mInnerPaint;
    }

    public boolean setSize(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("size < 0.0f");
        }
        this.mSymbolSize = f;
        this.updateShape();
        return true;
    }

    public abstract boolean setSize(float var1, String var2);

    public boolean setType(int n) {
        if (!SGDrawingElementSymbol.isValidSymbolType(n)) {
            return false;
        }
        this.mSymbolType = n;
        this.updateShape();
        return true;
    }

    public boolean setLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        this.mLineColor = color;
        return true;
    }

    public boolean setLineVisible(boolean bl) {
        this.mLineVisible = bl;
        return true;
    }

    public boolean setInnerColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (this.mInnerPaint == null) {
            this.mInnerPaint = new SGFillPaint();
        }
        return this.mInnerPaint.setColor(color);
    }

    public boolean setInnerTransparency(int n) {
        if (this.mInnerPaint == null) {
            this.mInnerPaint = new SGFillPaint();
        }
        return this.mInnerPaint.setTransparency(n);
    }

    public boolean setInnerPaint(SGIPaint sGIPaint) {
        if (sGIPaint == null) {
            throw new IllegalArgumentException("paint == null");
        }
        try {
            this.mInnerPaint = (SGFillPaint)sGIPaint.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
        return true;
    }

    public boolean setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("lw < 0.0f");
        }
        this.mLineWidth = f;
        return true;
    }

    public abstract boolean setLineWidth(float var1, String var2);

    public float getAngle() {
        return this.mAngle;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        return true;
    }

    public double getShiftX() {
        return this.mShiftX;
    }

    public double getShiftY() {
        return this.mShiftY;
    }

    public boolean setShiftX(double d) {
        this.mShiftX = d;
        return true;
    }

    public boolean setShiftY(double d) {
        this.mShiftY = d;
        return true;
    }

    public abstract SGTuple2f getLocation(int var1);

    public boolean setMagnification(float f) {
        if (!super.setMagnification(f)) {
            return false;
        }
        this.updateShape();
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[i];
                if (!sGDrawingElementSymbol2D.isVisible()) continue;
                sGDrawingElementSymbol2D.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    public String getTagName() {
        return "Symbol";
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mSymbolSize * 0.035277776f, -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.getLineWidth(), -3);
        SGFillPaint sGFillPaint = (SGFillPaint)this.getInnerPaint();
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(sGFillPaint.getColor());
        element.setAttribute("Size", Float.toString(f) + "cm");
        element.setAttribute("Type", SGDrawingElementSymbol.getSymbolTypeName(this.mSymbolType));
        element.setAttribute("LineWidth", Float.toString(f2) + "pt");
        element.setAttribute("LineColor", SGUtilityText.getColorString(this.mLineColor));
        element.setAttribute("LineVisible", Boolean.toString(this.mLineVisible));
        element.setAttribute("InnerColor", SGUtilityText.getColorListString(arrayList));
        element.setAttribute("InnerTransparent", Integer.toString(sGFillPaint.getTransparencyPercent()) + "%");
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        Object object;
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        string = element.getAttribute("Size");
        if (string.length() != 0) {
            object = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)object);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setSize(f, ((StringBuffer)object).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Type")).length() != 0) {
            number = SGDrawingElementSymbol.getSymbolTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("InnerColor")).length() != 0) {
            object = SGUtilityText.getColorList(string);
            if (object == null) {
                return false;
            }
            if (object.size() < 1) {
                return false;
            }
            Color color2 = (Color)object.get(0);
            if (!this.setInnerColor(color2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("InnerTransparent")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl != null) {
                if (bl == false ? !this.setInnerTransparency(0) : !this.setInnerTransparency(100)) {
                    return false;
                }
            } else {
                number = SGUtilityText.getInteger(string, "%");
                if (number == null) {
                    return false;
                }
                if (!this.setInnerTransparency(number.intValue())) {
                    return false;
                }
            }
        }
        if ((string = element.getAttribute("LineWidth")).length() != 0) {
            object = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)object);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLineWidth(f, ((StringBuffer)object).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("LineColor")).length() != 0) {
            color = SGUtilityText.parseColor(string);
            if (color == null) {
                return false;
            }
            object = color;
            if (!this.setLineColor((Color)object)) {
                return false;
            }
        }
        if ((string = element.getAttribute("LineVisible")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            if (!this.setLineVisible(bl)) {
                return false;
            }
        }
        return true;
    }

    protected SGDrawingElement createDrawingElementInstance(int n) {
        return new SymbolInGroup(this, n);
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        this.initDrawingElement(n);
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < n; ++i) {
            ((SGDrawingElementSymbol)sGDrawingElementArray[i]).setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            this.initDrawingElement(sGTuple2fArray);
        }
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)this.mDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            sGDrawingElementSymbol2D.setVisible(bl);
        }
        return true;
    }

    public SGProperties getProperties() {
        SymbolProperties symbolProperties = new SymbolProperties();
        this.getProperties(symbolProperties);
        return symbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        symbolProperties.setSize(this.getSize());
        symbolProperties.setSymbolType(this.getType());
        symbolProperties.setLineWidth(this.getLineWidth());
        symbolProperties.setLineColor(this.getLineColor());
        symbolProperties.setLineVisible(this.isLineVisible());
        symbolProperties.setInnerPaint(this.getInnerPaint());
        symbolProperties.mShiftX = this.getShiftX();
        symbolProperties.mShiftY = this.getShiftY();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        Float f = symbolProperties.getSize();
        if (f == null) {
            return false;
        }
        this.setSize(f.floatValue());
        Integer n = symbolProperties.getSymbolType();
        if (n == null) {
            return false;
        }
        this.setType(n);
        Float f2 = symbolProperties.getLineWidth();
        if (f2 == null) {
            return false;
        }
        this.setLineWidth(f2.floatValue());
        Color color = symbolProperties.getLineColor();
        if (color == null) {
            return false;
        }
        this.setLineColor(color);
        Boolean bl = symbolProperties.isLineVisible();
        if (bl == null) {
            return false;
        }
        this.setLineVisible(bl);
        SGIPaint sGIPaint = symbolProperties.getInnerPaint();
        if (sGIPaint == null) {
            return false;
        }
        this.setInnerPaint(sGIPaint);
        this.setShiftX(symbolProperties.mShiftX);
        this.setShiftY(symbolProperties.mShiftY);
        return true;
    }

    protected Shape getShape() {
        return this.mShape;
    }

    protected void updateShape() {
        this.mShape = SGDrawingElementSymbol2D.createShape(this.getType(), this.getMagnification() * this.getSize());
    }

    public static class SymbolProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementSymbol.SymbolProperties mSymbolProperties = new SGDrawingElementSymbol.SymbolProperties();
        private double mShiftX;
        private double mShiftY;

        public Object copy() {
            Object object = super.copy();
            SymbolProperties symbolProperties = (SymbolProperties)object;
            symbolProperties.mSymbolProperties = (SGDrawingElementSymbol.SymbolProperties)this.mSymbolProperties.copy();
            symbolProperties.mShiftX = this.mShiftX;
            symbolProperties.mShiftY = this.mShiftY;
            return symbolProperties;
        }

        public void dispose() {
            super.dispose();
            this.mSymbolProperties.dispose();
        }

        public boolean equals(Object object) {
            if (!(object instanceof SymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SymbolProperties symbolProperties = (SymbolProperties)object;
            if (!this.mSymbolProperties.equals(symbolProperties.mSymbolProperties)) {
                return false;
            }
            if (this.mShiftX != symbolProperties.mShiftX) {
                return false;
            }
            return this.mShiftY == symbolProperties.mShiftY;
        }

        public Float getSize() {
            return this.mSymbolProperties.getSize();
        }

        public Integer getSymbolType() {
            return this.mSymbolProperties.getSymbolType();
        }

        public Float getLineWidth() {
            return this.mSymbolProperties.getLineWidth();
        }

        public Color getLineColor() {
            return this.mSymbolProperties.getLineColor();
        }

        public Boolean isLineVisible() {
            return this.mSymbolProperties.isLineVisible();
        }

        public SGIPaint getInnerPaint() {
            return this.mSymbolProperties.getInnerPaint();
        }

        public boolean setSize(float f) {
            return this.mSymbolProperties.setSize(f);
        }

        public boolean setSymbolType(int n) {
            return this.mSymbolProperties.setSymbolType(n);
        }

        public boolean setLineWidth(float f) {
            return this.mSymbolProperties.setLineWidth(f);
        }

        public boolean setLineColor(Color color) {
            return this.mSymbolProperties.setLineColor(color);
        }

        public boolean setLineVisible(boolean bl) {
            return this.mSymbolProperties.setLineVisible(bl);
        }

        public boolean setInnerPaint(SGIPaint sGIPaint) {
            return this.mSymbolProperties.setInnerPaint(sGIPaint);
        }
    }

    protected class SymbolInGroup
    extends SGDrawingElementSymbol2D {
        protected SGElementGroupSymbol mGroup = null;
        protected int mIndex = -1;

        public SymbolInGroup(SGElementGroupSymbol sGElementGroupSymbol2, int n) {
            this.mGroup = sGElementGroupSymbol2;
            this.mIndex = n;
        }

        public void dispose() {
            super.dispose();
            this.mGroup = null;
        }

        public boolean setSize(float f) {
            return true;
        }

        public boolean setType(int n) {
            return true;
        }

        public boolean setAngle(float f) {
            return true;
        }

        public boolean setLineColor(Color color) {
            return true;
        }

        public boolean setLineWidth(float f) {
            return true;
        }

        public boolean setLineVisible(boolean bl) {
            return true;
        }

        public float getSize() {
            return this.mGroup.getSize();
        }

        public int getType() {
            return this.mGroup.getType();
        }

        public Color getLineColor() {
            return this.mGroup.getLineColor();
        }

        public float getLineWidth() {
            return this.mGroup.getLineWidth();
        }

        public boolean isLineVisible() {
            return this.mGroup.isLineVisible();
        }

        public float getMagnification() {
            return this.mGroup.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }

        public SGIPaint getInnerPaint() {
            return this.mGroup.getInnerPaint();
        }

        public boolean setInnerColor(Color color) {
            return true;
        }

        public float getAngle() {
            return this.mGroup.getAngle();
        }

        public SGTuple2f getLocation() {
            return this.mGroup.getLocation(this.mIndex);
        }

        public boolean setLocation(float f, float f2) {
            return true;
        }

        public boolean setLocation(SGTuple2f sGTuple2f) {
            return true;
        }

        public boolean setX(float f) {
            return true;
        }

        public boolean setY(float f) {
            return true;
        }

        protected Shape getShape() {
            return SGElementGroupSymbol.this.mShape;
        }

        protected void updateShape() {
        }
    }
}

