/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGColorBarModel;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGIData;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGISXYZTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupColorMap;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupColorMapForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupColorMapInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupSetSXYZ;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYZDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGElementGroupSetInGraphSXYZ
extends SGElementGroupSetInGraph
implements SGIElementGroupSetSXYZ,
SGISXYZDataDialogObserver {
    private SGTuple2f[] mPointsArray = null;
    private float[] mXArray = null;
    private float[] mYArray = null;

    public SGElementGroupSetInGraphSXYZ(SGData sGData, SGFigureElementGraph sGFigureElementGraph) {
        super(sGData, sGFigureElementGraph);
    }

    protected void initPointsArray(int n) {
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
        for (int i = 0; i < n; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
        }
        this.mPointsArray = sGTuple2fArray;
    }

    protected void initPointsArray(int n, int n2) {
        this.mXArray = new float[n];
        this.mYArray = new float[n2];
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mPointsArray = null;
        this.mXArray = null;
        this.mYArray = null;
    }

    @Override
    public boolean updateDrawingElementsLocation(SGIData sGIData) {
        if (!(sGIData instanceof SGISXYZTypeData)) {
            return false;
        }
        SGISXYZTypeData sGISXYZTypeData = (SGISXYZTypeData)sGIData;
        if (this.isGridMode((SGData)sGIData)) {
            double[] dArray = sGISXYZTypeData.getXValueArray();
            double[] dArray2 = sGISXYZTypeData.getYValueArray();
            this.initPointsArray(dArray.length, dArray2.length);
            if (!this.mGraph.calcLocationOfPoints(dArray, this.getXAxis(), true, this.mXArray)) {
                return false;
            }
            if (!this.mGraph.calcLocationOfPoints(dArray2, this.getYAxis(), false, this.mYArray)) {
                return false;
            }
            double[] dArray3 = sGISXYZTypeData.getZValueArray();
            List list = this.mDrawingElementGroupList;
            for (int i = 0; i < list.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)list.get(i);
                if (!sGElementGroup.isVisible() || !(sGElementGroup instanceof SGElementGroupColorMap)) continue;
                SGElementGroupColorMap sGElementGroupColorMap = (SGElementGroupColorMap)sGElementGroup;
                if (!sGElementGroupColorMap.setLocation(this.mXArray, this.mYArray)) {
                    return false;
                }
                if (sGElementGroupColorMap.setZValues(dArray3)) continue;
                return false;
            }
        } else {
            int n = sGISXYZTypeData.getPointsNumber();
            this.initPointsArray(n);
            if (!this.mGraph.calcLocationOfPoints(sGISXYZTypeData.getXYValueArray(), this.getXAxis(), this.getYAxis(), this.mPointsArray)) {
                return false;
            }
            double[] dArray = sGISXYZTypeData.getZValueArray();
            List list = this.mDrawingElementGroupList;
            for (int i = 0; i < list.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)list.get(i);
                if (!sGElementGroup.isVisible() || !(sGElementGroup instanceof SGElementGroupColorMap)) continue;
                SGElementGroupColorMap sGElementGroupColorMap = (SGElementGroupColorMap)sGElementGroup;
                if (!sGElementGroupColorMap.setLocation(this.mPointsArray)) {
                    return false;
                }
                sGElementGroupColorMap.setZValues(dArray);
            }
        }
        return true;
    }

    @Override
    public boolean addDrawingElementGroup(int n) {
        SGElementGroupColorMapInGraph sGElementGroupColorMapInGraph = null;
        if (n != 2) {
            return false;
        }
        sGElementGroupColorMapInGraph = new SGElementGroupColorMapInGraph(this.mGraph);
        sGElementGroupColorMapInGraph.setColorBarModel(this.mGraph.getColorBarModel());
        sGElementGroupColorMapInGraph.setGridMode(this.isGridMode());
        if (!this.addElementGroup(sGElementGroupColorMapInGraph)) {
            return false;
        }
        if (!this.isGridMode()) {
            SGISXYZTypeData sGISXYZTypeData = (SGISXYZTypeData)((Object)this.mData);
            double[] dArray = sGISXYZTypeData.getZValueArray();
            sGElementGroupColorMapInGraph.setColors(dArray);
        }
        return true;
    }

    private boolean addElementGroup(SGElementGroupColorMap sGElementGroupColorMap) {
        SGIElementGroupInGraph sGIElementGroupInGraph = (SGIElementGroupInGraph)((Object)sGElementGroupColorMap);
        sGIElementGroupInGraph.setElementGroupSet(this);
        if (!sGElementGroupColorMap.initDrawingElement(this.mXArray, this.mYArray)) {
            return false;
        }
        if (!sGElementGroupColorMap.initDrawingElement(this.mPointsArray)) {
            return false;
        }
        this.mDrawingElementGroupList.add(sGElementGroupColorMap);
        return true;
    }

    @Override
    public void paintGraphics2D(Graphics2D graphics2D) {
        SGElementGroupColorMapInGraph sGElementGroupColorMapInGraph;
        Rectangle2D rectangle2D = null;
        if (!this.getClipFlag()) {
            rectangle2D = this.mGraph.getGraphRect();
        }
        if ((sGElementGroupColorMapInGraph = this.mGraph.getColorMap(this)) != null && sGElementGroupColorMapInGraph.isVisible()) {
            sGElementGroupColorMapInGraph.paintElement(graphics2D, rectangle2D);
        }
    }

    @Override
    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    @Override
    public String getClassDescription() {
        return "";
    }

    @Override
    public boolean getLegendVisibleFlag() {
        return this.isVisibleInLegend();
    }

    @Override
    public SGElementGroupColorMap getColorMap() {
        return this.getColorMapGroup();
    }

    public boolean setColorBarModel(SGColorBarModel sGColorBarModel) {
        List<SGElementGroupColorMap> list = this.getColorMapGroups();
        for (int i = 0; i < list.size(); ++i) {
            SGElementGroupColorMap sGElementGroupColorMap = list.get(i);
            sGElementGroupColorMap.setColorBarModel(sGColorBarModel);
        }
        this.mZAxis = sGColorBarModel.getAxis();
        return true;
    }

    @Override
    public double getRectangleWidthValue() {
        return this.getColorMap().getWidthValue();
    }

    @Override
    public double getRectangleHeightValue() {
        return this.getColorMap().getHeightValue();
    }

    @Override
    public boolean setRectangleWidthValue(double d) {
        return this.getColorMap().setWidthValue(d);
    }

    @Override
    public boolean setRectangleHeightValue(double d) {
        return this.getColorMap().setHeightValue(d);
    }

    @Override
    public int getXAxisLocation() {
        return this.mGraph.getAxisElement().getLocationInPlane(this.getXAxis());
    }

    @Override
    public int getYAxisLocation() {
        return this.mGraph.getAxisElement().getLocationInPlane(this.getYAxis());
    }

    @Override
    public boolean hasValidRectangleWidthValue(int n, Number number) {
        SGAxis sGAxis = n == -1 ? this.mXAxis : this.mGraph.getAxisElement().getAxisInPlane(n);
        double d = number != null ? number.doubleValue() : this.getRectangleWidthValue();
        return sGAxis.isValidValue(d);
    }

    @Override
    public boolean hasValidRectangleHeightValue(int n, Number number) {
        SGAxis sGAxis = n == -1 ? this.mYAxis : this.mGraph.getAxisElement().getAxisInPlane(n);
        double d = number != null ? number.doubleValue() : this.getRectangleHeightValue();
        return sGAxis.isValidValue(d);
    }

    @Override
    public boolean writeProperty(Element element, int n) {
        if (!super.writeProperty(element, n)) {
            return false;
        }
        String string = this.mGraph.getAxisElement().getLocationName(this.getXAxis());
        String string2 = this.mGraph.getAxisElement().getLocationName(this.getYAxis());
        element.setAttribute("XAxisPosition", string);
        element.setAttribute("YAxisPosition", string2);
        return true;
    }

    public SGTuple2f getLocation(int n) {
        if (this.mPointsArray == null) {
            return null;
        }
        if (n < 0 || n >= this.mPointsArray.length) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        return this.mPointsArray[n];
    }

    @Override
    protected SGPropertyResults setProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
        SGPropertyResults sGPropertyResults2 = (SGPropertyResults)sGPropertyResults.clone();
        if ((sGPropertyResults2 = super.setProperties(sGPropertyMap, sGPropertyResults2)) == null) {
            return null;
        }
        List<SGElementGroupColorMap> list = this.getColorMapGroups();
        for (int i = 0; i < list.size(); ++i) {
            SGElementGroupColorMapForData sGElementGroupColorMapForData = (SGElementGroupColorMapForData)list.get(i);
            sGPropertyResults2 = sGElementGroupColorMapForData.setProperties(sGPropertyMap, sGPropertyResults2);
            if (sGPropertyResults2 != null) continue;
            return null;
        }
        return sGPropertyResults2;
    }

    public List<SGElementGroupColorMap> getColorMapGroups() {
        ArrayList<SGElementGroupColorMap> arrayList = new ArrayList<SGElementGroupColorMap>();
        List<SGElementGroup> list = SGUtilityForFigureElement.getGroups(SGElementGroupColorMap.class, this.mDrawingElementGroupList);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add((SGElementGroupColorMap)list.get(i));
        }
        return arrayList;
    }

    public SGElementGroupColorMap getColorMapGroup() {
        return (SGElementGroupColorMap)SGUtilityForFigureElement.getGroup(SGElementGroupColorMap.class, this.mDrawingElementGroupList);
    }

    @Override
    protected boolean setElementGroupProperties(List list) {
        for (int i = 0; i < list.size(); ++i) {
            SGProperties sGProperties = (SGProperties)list.get(i);
            SGElementGroupColorMap sGElementGroupColorMap = null;
            if (!(sGProperties instanceof SGElementGroupColorMap.ColorMapProperties)) {
                throw new Error("Illegal group property: " + sGProperties);
            }
            sGElementGroupColorMap = this.getColorMapGroup();
            if (sGElementGroupColorMap == null || ((SGElementGroup)sGElementGroupColorMap).setProperties(sGProperties)) continue;
            return false;
        }
        return true;
    }

    public boolean isGridMode() {
        return this.isGridMode(this.getData());
    }

    public boolean isGridMode(SGData sGData) {
        if (SGDataUtility.isNetCDFData(sGData)) {
            SGNetCDFData sGNetCDFData = (SGNetCDFData)sGData;
            return !sGNetCDFData.isSerialNumberAvailable();
        }
        return false;
    }

    @Override
    public boolean setColumnInfo(SGDataColumnInfo[] sGDataColumnInfoArray, String string) {
        if (!super.setColumnInfo(sGDataColumnInfoArray, string)) {
            return false;
        }
        SGISXYZTypeData sGISXYZTypeData = (SGISXYZTypeData)((Object)this.getData());
        this.initPointsArray(sGISXYZTypeData.getPointsNumber());
        return this.updateGridMode();
    }

    private boolean updateGridMode() {
        boolean bl = this.isGridMode();
        List<SGElementGroupColorMap> list = this.getColorMapGroups();
        for (int i = 0; i < list.size(); ++i) {
            SGElementGroupColorMap sGElementGroupColorMap = list.get(i);
            if (sGElementGroupColorMap.setGridMode(bl)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!super.setData(sGData)) {
            return false;
        }
        if (sGData == null) {
            this.initPointsArray(0);
            return true;
        }
        if (!(sGData instanceof SGISXYZTypeData)) {
            return false;
        }
        SGISXYZTypeData sGISXYZTypeData = (SGISXYZTypeData)((Object)sGData);
        this.initPointsArray(sGISXYZTypeData.getPointsNumber());
        return this.updateDrawingElementsLocation(sGISXYZTypeData);
    }

    @Override
    public boolean updateColorMapSize() {
        SGISXYZTypeData sGISXYZTypeData = (SGISXYZTypeData)((Object)this.getData());
        SGAxis sGAxis = this.getXAxis();
        double[] dArray = sGISXYZTypeData.getXValueArray();
        double d = SGUtilityForFigureElementJava2D.calcSizeValue(dArray, sGAxis, true);
        SGAxis sGAxis2 = this.getYAxis();
        double[] dArray2 = sGISXYZTypeData.getYValueArray();
        double d2 = SGUtilityForFigureElementJava2D.calcSizeValue(dArray2, sGAxis2, false);
        SGElementGroupColorMap sGElementGroupColorMap = this.getColorMap();
        sGElementGroupColorMap.setWidthValue(d);
        sGElementGroupColorMap.setHeightValue(d2);
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        this.updateGridMode();
        return true;
    }
}

