/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.io.Serializable;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGGradationPaint;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGPatternPaint;
import jp.riken.brain.ni.samuraigraph.base.SGSelectablePaint;
import jp.riken.brain.ni.samuraigraph.base.SGTransparentPaint;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIRectangleConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGPaintUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementRectangle2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import org.w3c.dom.Element;

public abstract class SGElementGroupRectangle
extends SGElementGroupSXY
implements SGIRectangleConstants,
SGIFigureDrawingElementConstants {
    protected SGStroke mStroke = new SGStroke();
    protected float mRectangleWidth;
    protected float mRectangleHeight;
    protected Color mEdgeLineColor;
    private boolean mEdgeLineVisible;
    protected SGIPaint mInnerPaint = new SGFillPaint();

    public SGElementGroupRectangle() {
        this.mStroke.setJoin(0);
    }

    public void dispose() {
        super.dispose();
        this.mEdgeLineColor = null;
        this.mStroke = null;
        this.mInnerPaint = null;
    }

    protected SGStroke getStroke() {
        return this.mStroke;
    }

    public abstract float getX(int var1);

    public abstract float getY(int var1);

    public float getRectangleWidth() {
        return this.mRectangleWidth;
    }

    public float getRectangleWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getRectangleWidth(), string);
    }

    public float getRectangleHeight() {
        return this.mRectangleHeight;
    }

    public float getRectangleHeight(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getRectangleHeight(), string);
    }

    public float getEdgeLineWidth() {
        return this.mStroke.getLineWidth();
    }

    public float getEdgeLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getEdgeLineWidth(), string);
    }

    public Color getEdgeLineColor() {
        return this.mEdgeLineColor;
    }

    public boolean isEdgeLineVisible() {
        return this.mEdgeLineVisible;
    }

    public SGIPaint getInnerPaint() {
        try {
            return (SGIPaint)this.mInnerPaint.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public int getEdgeLineType() {
        return this.mStroke.getLineType();
    }

    public float getTransparency() {
        return this.mInnerPaint.getAlpha();
    }

    public boolean setRectangleWidth(float f) {
        this.mRectangleWidth = f;
        return true;
    }

    public boolean setRectangleWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setRectangleWidth((float)d);
    }

    public boolean setRectangleHeight(float f) {
        this.mRectangleHeight = f;
        return true;
    }

    public boolean setRectangleHeight(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setRectangleHeight((float)d);
    }

    public boolean setEdgeLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("lw < 0.0f");
        }
        this.mStroke.setLineWidth(f);
        return true;
    }

    public abstract boolean setEdgeLineWidth(float var1, String var2);

    public boolean setEdgeLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        this.mEdgeLineColor = color;
        return true;
    }

    public boolean setEdgeLineColor(String string) {
        Color color = SGUtilityText.getColor(string);
        if (color == null) {
            return false;
        }
        return this.setEdgeLineColor(color);
    }

    public boolean setEdgeLineVisible(boolean bl) {
        this.mEdgeLineVisible = bl;
        return true;
    }

    public boolean setInnerPaint(SGIPaint sGIPaint) {
        if (sGIPaint == null) {
            throw new IllegalArgumentException("paint == null");
        }
        this.mInnerPaint = sGIPaint;
        this.mInnerPaint.setMagnification(this.mMagnification);
        return true;
    }

    public boolean setInnerPaintStyle(int n) {
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setSelectedPaintStyle(n);
        }
        return false;
    }

    public boolean setInnerFillColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (this.mInnerPaint instanceof SGFillPaint) {
            return ((SGFillPaint)this.mInnerPaint).setColor(color);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setFillColor(color);
        }
        return false;
    }

    public boolean setInnerPatternColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (this.mInnerPaint instanceof SGPatternPaint) {
            return ((SGPatternPaint)this.mInnerPaint).setColor(color);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setPatternColor(color);
        }
        return false;
    }

    public boolean setInnerPatternType(int n) {
        if (this.mInnerPaint instanceof SGPatternPaint) {
            return ((SGPatternPaint)this.mInnerPaint).setTypeIndex(n);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setPatternIndex(n);
        }
        return false;
    }

    public boolean setInnerGradationColor1(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (this.mInnerPaint instanceof SGGradationPaint) {
            return ((SGGradationPaint)this.mInnerPaint).setColor1(color);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setGradationColor1(color);
        }
        return false;
    }

    public boolean setInnerGradationColor2(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        if (this.mInnerPaint instanceof SGGradationPaint) {
            return ((SGGradationPaint)this.mInnerPaint).setColor2(color);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setGradationColor2(color);
        }
        return false;
    }

    public boolean setInnerGradationDirection(int n) {
        if (this.mInnerPaint instanceof SGGradationPaint) {
            return ((SGGradationPaint)this.mInnerPaint).setDirection(n);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setGradationDirection(n);
        }
        return false;
    }

    public boolean setInnerGradationOrder(int n) {
        if (this.mInnerPaint instanceof SGGradationPaint) {
            return ((SGGradationPaint)this.mInnerPaint).setOrder(n);
        }
        if (this.mInnerPaint instanceof SGSelectablePaint) {
            return ((SGSelectablePaint)this.mInnerPaint).setGradationOrder(n);
        }
        return false;
    }

    public boolean setEdgeLineColor(String string, String string2, String string3) {
        Color color = SGUtilityText.getColor(string, string2, string3);
        if (color == null) {
            return false;
        }
        return this.setEdgeLineColor(color);
    }

    public boolean setTransparent(float f) {
        return this.mInnerPaint.setAlpha(f);
    }

    public boolean setTransparentPercent(int n) {
        return ((SGTransparentPaint)this.mInnerPaint).setTransparency(n);
    }

    protected SGDrawingElement createDrawingElementInstance(int n) {
        return new RectInGroup(this, n);
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        if (!this.initDrawingElement(n)) {
            return false;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            ((SGDrawingElementRectangle)sGDrawingElementArray[i]).setLocation(sGTuple2fArray[i].x, sGTuple2fArray[i].y);
        }
        return true;
    }

    public boolean setMagnification(float f) {
        if (!super.setMagnification(f)) {
            return false;
        }
        this.mStroke.setMagnification(f);
        this.mInnerPaint.setMagnification(f);
        return true;
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mRectangleWidth * 0.035277776f, -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.mRectangleHeight * 0.035277776f, -3);
        float f3 = (float)SGUtilityNumber.roundOffNumber(this.getEdgeLineWidth(), -3);
        element.setAttribute("Width", Float.toString(f) + "cm");
        element.setAttribute("Height", Float.toString(f2) + "cm");
        element.setAttribute("EdgeLineWidth", Float.toString(f3) + "pt");
        element.setAttribute("EdgeLineColor", SGUtilityText.getColorString(this.mEdgeLineColor));
        element.setAttribute("EdgeLineVisible", Boolean.toString(this.mEdgeLineVisible));
        return SGPaintUtility.writeProperty(element, this.mInnerPaint);
    }

    public boolean readProperty(Element element) {
        Serializable serializable;
        Object object;
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        string = element.getAttribute("Width");
        if (string.length() != 0) {
            string = element.getAttribute("Width");
            if (string.length() == 0) {
                return false;
            }
            object = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)object);
            if (number == null) {
                return false;
            }
            if (!this.setRectangleWidth(number.floatValue(), ((StringBuffer)object).toString())) {
                return false;
            }
        }
        if (null == (object = SGPaintUtility.readProperty(element))) {
            return false;
        }
        this.setInnerPaint((SGIPaint)object);
        string = element.getAttribute("EdgeLineWidth");
        if (string.length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)serializable);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setEdgeLineWidth(f, ((StringBuffer)serializable).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineColor")).length() != 0) {
            color = SGUtilityText.parseColor(string);
            if (color == null) {
                return false;
            }
            serializable = color;
            if (!this.setEdgeLineColor((Color)serializable)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineVisible")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            if (!this.setEdgeLineVisible(bl)) {
                return false;
            }
        }
        return true;
    }

    protected static class RectInGroup
    extends SGDrawingElementRectangle2D {
        protected SGElementGroupRectangle mGroup = null;
        protected int mIndex = -1;

        public RectInGroup(SGElementGroupRectangle sGElementGroupRectangle, int n) {
            this.mGroup = sGElementGroupRectangle;
            this.mIndex = n;
        }

        public void dispose() {
            super.dispose();
            this.mGroup = null;
        }

        public Color getEdgeLineColor() {
            return this.mGroup.getEdgeLineColor();
        }

        public int getEdgeLineType() {
            return this.mGroup.getEdgeLineType();
        }

        public float getEdgeLineWidth() {
            return this.mGroup.getEdgeLineWidth();
        }

        public boolean isEdgeLineVisible() {
            return this.mGroup.isEdgeLineVisible();
        }

        public float getHeight() {
            return this.mGroup.getRectangleHeight();
        }

        public float getWidth() {
            return this.mGroup.getRectangleWidth();
        }

        public float getTransparency() {
            return this.mGroup.getTransparency();
        }

        public boolean setEdgeLineColor(Color color) {
            return true;
        }

        public boolean setEdgeLineType(int n) {
            return true;
        }

        public boolean setEdgeLineWidth(float f) {
            return true;
        }

        public boolean setEdgeLineVisible(boolean bl) {
            return false;
        }

        public boolean setHeight(float f) {
            return true;
        }

        public boolean setTransparent(float f) {
            return true;
        }

        public boolean setWidth(float f) {
            return true;
        }

        protected SGStroke getStroke() {
            return this.mGroup.getStroke();
        }

        public float getMagnification() {
            return this.mGroup.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }

        public SGIPaint getInnerPaint() {
            return this.mGroup.getInnerPaint();
        }

        public boolean setInnerPaint(SGIPaint sGIPaint) {
            return true;
        }

        public float getX() {
            return this.mGroup.getX(this.mIndex);
        }

        public float getY() {
            return this.mGroup.getY(this.mIndex);
        }

        public boolean setX(float f) {
            return true;
        }

        public boolean setY(float f) {
            return true;
        }
    }
}

