/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGISXYDataConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLineForData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraphSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIStrokeEditDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Element;

public class SGElementGroupLineInGraph
extends SGElementGroupLineForData
implements SGIElementGroupInGraph,
SGIStrokeEditDialogObserver,
SGISXYDataConstants {
    public static final int MAX_NUMBER_OF_ANCHORS = 8;
    private SGFigureElementGraph mGraph = null;
    private SGElementGroupSetInGraph mGroupSet = null;
    private boolean mFocusedFlag = false;

    public boolean setElementGroupSet(SGElementGroupSetInGraph sGElementGroupSetInGraph) {
        this.mGroupSet = sGElementGroupSetInGraph;
        return true;
    }

    public void setFocused(boolean bl) {
        this.mFocusedFlag = bl;
    }

    public boolean isFocused() {
        return this.mFocusedFlag;
    }

    public SGElementGroupLineInGraph(SGISXYData sGISXYData, SGFigureElementGraph sGFigureElementGraph) {
        super(sGISXYData);
        this.mGraph = sGFigureElementGraph;
    }

    public boolean writeProperty(Element element) {
        if (!super.writeProperty(element)) {
            return false;
        }
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("ConnectAllEffectivePoints", Boolean.toString(this.mConnectingAllFlag));
        element.setAttribute("ShiftX", Double.toString(this.getLineShiftX()));
        element.setAttribute("ShiftY", Double.toString(this.getLineShiftY()));
        return true;
    }

    public boolean readProperty(Element element) {
        SGElementGroupSymbol sGElementGroupSymbol;
        double d;
        if (!super.readProperty(element)) {
            return false;
        }
        String string = null;
        Double d2 = null;
        string = element.getAttribute("ShiftX");
        if (string.length() != 0) {
            d2 = SGUtilityText.getDouble(string);
            if (d2 == null) {
                return false;
            }
            d = d2;
            if (!this.setLineShiftX(d)) {
                return false;
            }
            sGElementGroupSymbol = this.getElementGroupSymbol();
            if (null == sGElementGroupSymbol || !sGElementGroupSymbol.setShiftX(d)) {
                return false;
            }
        }
        if ((string = element.getAttribute("ShiftY")).length() != 0) {
            d2 = SGUtilityText.getDouble(string);
            if (d2 == null) {
                return false;
            }
            d = d2;
            if (!this.setLineShiftY(d)) {
                return false;
            }
            sGElementGroupSymbol = this.getElementGroupSymbol();
            if (null == sGElementGroupSymbol || !sGElementGroupSymbol.setShiftY(d)) {
                return false;
            }
        }
        return this.mGraph.readProperty(this, element);
    }

    protected SGElementGroupSymbol getElementGroupSymbol() {
        ArrayList<SGElementGroup> arrayList = this.mGroupSet.getElementGroupList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup;
            if (!((SGElementGroup)arrayList.get(i)).getTagName().equals("Symbol") || !((sGElementGroup = (SGElementGroup)arrayList.get(i)) instanceof SGElementGroupSymbol)) continue;
            return (SGElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        int n = this.mGraph.getMode();
        if (n == 0) {
            this.mMode = 0;
        } else if (n == 1) {
            this.mMode = 1;
        }
        return this.setLocationSub(sGTuple2fArray);
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        super.paintElement(graphics2D, rectangle2D);
        SGElementGroupSetInGraphSXY sGElementGroupSetInGraphSXY = (SGElementGroupSetInGraphSXY)this.mGroupSet;
        if (this.isFocused() && this.mGraph.isSymbolsVisibleAroundFocusedObjects() && !sGElementGroupSetInGraphSXY.isSymbolVisible() && !sGElementGroupSetInGraphSXY.isBarVisible()) {
            List list = this.mConnectedPathList;
            for (int i = 0; i < list.size(); ++i) {
                int n;
                GeneralPath generalPath = (GeneralPath)list.get(i);
                int n2 = 0;
                ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
                PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
                float[] fArray = new float[6];
                pathIterator.currentSegment(fArray);
                Point2D.Float float_ = new Point2D.Float(fArray[0], fArray[1]);
                pathIterator.next();
                while (!pathIterator.isDone()) {
                    pathIterator.currentSegment(fArray);
                    Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                    ((Point2D)float_2).setLocation((((Point2D)float_).getX() + ((Point2D)float_2).getX()) / 2.0, (((Point2D)float_).getY() + ((Point2D)float_2).getY()) / 2.0);
                    ((Point2D)float_).setLocation(fArray[0], fArray[1]);
                    arrayList.add(float_2);
                    pathIterator.next();
                    ++n2;
                }
                if (n2 <= 8) {
                    for (n = 0; n < n2; ++n) {
                        Point2D point2D = (Point2D)arrayList.get(n);
                        SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(point2D, graphics2D);
                    }
                    continue;
                }
                n = n2 / 8;
                int n3 = 0;
                do {
                    Point2D point2D = (Point2D)arrayList.get(n3);
                    SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(point2D, graphics2D);
                } while ((n3 += n) < n2);
            }
        }
        return true;
    }

    public boolean contains(int n, int n2) {
        Rectangle2D rectangle2D = this.mGraph.getGraphRect();
        if (!rectangle2D.contains(n, n2)) {
            return false;
        }
        return super.contains(n, n2);
    }

    public SGTuple2f getEnd(int n) {
        if (this.mGroupSet instanceof SGElementGroupSetInGraphSXY) {
            SGElementGroupSetInGraphSXY sGElementGroupSetInGraphSXY = (SGElementGroupSetInGraphSXY)this.mGroupSet;
            int n2 = this.getEndIndex(n);
            SGTuple2f sGTuple2f = sGElementGroupSetInGraphSXY.getLineLocation(n2);
            return new SGTuple2f(sGTuple2f);
        }
        throw new Error("Not supported.");
    }

    public SGTuple2f getStart(int n) {
        if (this.mGroupSet instanceof SGElementGroupSetInGraphSXY) {
            SGElementGroupSetInGraphSXY sGElementGroupSetInGraphSXY = (SGElementGroupSetInGraphSXY)this.mGroupSet;
            int n2 = this.getStartIndex(n);
            SGTuple2f sGTuple2f = sGElementGroupSetInGraphSXY.getLineLocation(n2);
            return new SGTuple2f(sGTuple2f);
        }
        throw new Error("Not supported.");
    }
}

