/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupLine
extends SGElementGroupSXY
implements SGILineConstants,
SGIElementGroupConstants {
    public static final int MODE_ALL = 0;
    public static final int MODE_OMIT = 1;
    protected int mMode = 1;
    protected SGStroke mStroke = new SGStroke();
    protected int mLineType;
    protected List<GeneralPath> mConnectedPathList = new ArrayList<GeneralPath>();
    protected boolean mConnectingAllFlag = true;
    protected Color mColor = null;
    protected double mShiftX;
    protected double mShiftY;
    protected int[][] mEndPointsIndexArray = null;

    public void dispose() {
        super.dispose();
        this.mConnectedPathList.clear();
        this.mConnectedPathList = null;
    }

    protected SGStroke getStroke() {
        return this.mStroke;
    }

    public boolean setMagnification(float f) {
        if (!super.setMagnification(f)) {
            return false;
        }
        this.mStroke.setMagnification(f);
        return true;
    }

    public boolean setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("width < 0.0f");
        }
        this.mStroke.setLineWidth(f);
        return true;
    }

    public abstract boolean setLineWidth(float var1, String var2);

    public boolean setLineType(int n) {
        if (!SGDrawingElementLine.isValidLineType(n)) {
            return false;
        }
        this.mLineType = n;
        this.mStroke.setLineType(n);
        return true;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("cl == null");
        }
        this.mColor = color;
        return true;
    }

    public boolean setLineConnectingAll(boolean bl) {
        this.mConnectingAllFlag = bl;
        return true;
    }

    public boolean setLineShiftX(double d) {
        this.mShiftX = d;
        return true;
    }

    public boolean setLineShiftY(double d) {
        this.mShiftY = d;
        return true;
    }

    public float getLineWidth() {
        return this.mStroke.getLineWidth();
    }

    public float getLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
    }

    public int getLineType() {
        return this.mLineType;
    }

    public Color getColor() {
        return this.mColor;
    }

    public boolean isLineConnectingAll() {
        return this.mConnectingAllFlag;
    }

    public double getLineShiftX() {
        return this.mShiftX;
    }

    public double getLineShiftY() {
        return this.mShiftY;
    }

    public abstract SGTuple2f getStart(int var1);

    public abstract SGTuple2f getEnd(int var1);

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(this.getColor());
        BasicStroke basicStroke = this.mStroke.getBasicStroke();
        graphics2D.setStroke(basicStroke);
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>(this.mConnectedPathList);
        if (rectangle2D == null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                graphics2D.draw(generalPath);
            }
        } else {
            Area area = new Area(rectangle2D);
            for (int i = 0; i < arrayList.size(); ++i) {
                GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                Shape shape = basicStroke.createStrokedShape(generalPath);
                Area area2 = new Area(shape);
                area2.intersect(area);
                graphics2D.fill(area2);
            }
        }
        return true;
    }

    public String getTagName() {
        return "Line";
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.getLineWidth(), -3);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.getColor());
        element.setAttribute("Width", Float.toString(f) + "pt");
        element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.mLineType));
        element.setAttribute("Color", SGUtilityText.getColorListString(arrayList));
        return true;
    }

    public boolean readProperty(Element element) {
        Serializable serializable;
        String string = null;
        Number number = null;
        Boolean bl = null;
        List<Color> list = null;
        string = element.getAttribute("Width");
        if (string.length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, serializable);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setLineWidth(f, serializable.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Type")).length() != 0) {
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setLineType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            serializable = list.get(0);
            if (!this.setColor((Color)serializable)) {
                return false;
            }
        }
        if ((string = element.getAttribute("ConnectAllEffectivePoints")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            if (!this.setLineConnectingAll(bl)) {
                return false;
            }
        }
        return true;
    }

    protected SGDrawingElement createDrawingElementInstance(int n) {
        return new LineInGroup(this, n);
    }

    public boolean initDrawingElement(int n) {
        int n2 = n == 0 ? 0 : n - 1;
        return super.initDrawingElement(n2);
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        if (!this.initDrawingElement(n)) {
            return false;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        this.mEndPointsIndexArray = new int[sGDrawingElementArray.length][2];
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            ((SGDrawingElementLine)sGDrawingElementArray[i]).setTermPoints(sGTuple2fArray[i], sGTuple2fArray[i + 1]);
            this.mEndPointsIndexArray[i][0] = i;
            this.mEndPointsIndexArray[i][1] = i + 1;
        }
        return true;
    }

    protected void setEndPointIndices(int n, int n2, int n3) {
        this.mEndPointsIndexArray[n][0] = n2;
        this.mEndPointsIndexArray[n][1] = n3;
    }

    protected int getStartIndex(int n) {
        return this.mEndPointsIndexArray[n][0];
    }

    protected int getEndIndex(int n) {
        return this.mEndPointsIndexArray[n][1];
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        return this.setLocationSub(sGTuple2fArray);
    }

    protected boolean setLocationSub(SGTuple2f[] sGTuple2fArray) {
        int n;
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length - 1 != this.mDrawingElementArray.length) {
            this.initDrawingElement(sGTuple2fArray);
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        List<GeneralPath> list = this.mConnectedPathList;
        list.clear();
        boolean bl = true;
        boolean[] blArray = new boolean[sGTuple2fArray.length];
        for (n = 0; n < blArray.length; ++n) {
            boolean bl2 = blArray[n] = !sGTuple2fArray[n].isInfinite() && !sGTuple2fArray[n].isNaN();
            if (blArray[n]) continue;
            bl = false;
        }
        if (bl) {
            int n2;
            for (n = 0; n < sGTuple2fArray.length - 1; ++n) {
                this.setEndPointIndices(n, n, n + 1);
            }
            for (n = 0; n < sGDrawingElementArray.length; ++n) {
                SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElementArray[n];
                sGDrawingElementLine.setVisible(true);
            }
            SGTuple2f[] sGTuple2fArray2 = sGTuple2fArray;
            if (this.mMode == 1) {
                sGTuple2fArray2 = this.reduceClosePoints(sGTuple2fArray2);
            }
            if ((n2 = sGTuple2fArray2.length) > 1) {
                GeneralPath generalPath = new GeneralPath();
                Line2D.Float float_ = new Line2D.Float(sGTuple2fArray2[0].x, sGTuple2fArray2[0].y, sGTuple2fArray2[1].x, sGTuple2fArray2[1].y);
                generalPath.append(float_, true);
                if (n2 > 2) {
                    for (int i = 2; i < n2; ++i) {
                        generalPath.lineTo(sGTuple2fArray2[i].x, sGTuple2fArray2[i].y);
                    }
                }
                list.add(generalPath);
            }
        } else {
            int n3;
            ArrayList<SGDrawingElementLine> arrayList;
            ArrayList arrayList2 = new ArrayList();
            if (this.mConnectingAllFlag) {
                int n4;
                arrayList = new ArrayList<SGDrawingElementLine>();
                n3 = 0;
                for (n4 = 0; n4 < sGTuple2fArray.length - 1; ++n4) {
                    int n5 = -1;
                    if (!blArray[n4]) continue;
                    for (int i = n4 + 1; i < sGTuple2fArray.length; ++i) {
                        if (!blArray[i]) continue;
                        n5 = i;
                        break;
                    }
                    if (n5 == -1) break;
                    SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElementArray[n3];
                    this.setEndPointIndices(n3, n4, n5);
                    sGDrawingElementLine.setVisible(true);
                    arrayList.add(sGDrawingElementLine);
                    ++n3;
                }
                if (arrayList.size() != 0) {
                    arrayList2.add(arrayList);
                }
                for (n4 = n3; n4 < sGDrawingElementArray.length; ++n4) {
                    SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElementArray[n4];
                    sGDrawingElementLine.setVisible(false);
                }
            } else {
                arrayList = new ArrayList();
                for (n3 = 0; n3 < sGTuple2fArray.length - 1; ++n3) {
                    SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElementArray[n3];
                    boolean bl3 = blArray[n3] && blArray[n3 + 1];
                    sGDrawingElementLine.setVisible(bl3);
                    if (bl3) {
                        this.setEndPointIndices(n3, n3, n3 + 1);
                        arrayList.add(sGDrawingElementLine);
                        continue;
                    }
                    if (arrayList.size() == 0) continue;
                    arrayList2.add(arrayList);
                    arrayList = new ArrayList();
                }
                if (arrayList.size() != 0) {
                    arrayList2.add(arrayList);
                }
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                List list2 = (List)arrayList2.get(i);
                GeneralPath generalPath = new GeneralPath();
                SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)list2.get(0);
                Line2D line2D = SGDrawingElementLine2D.getLine(sGDrawingElementLine);
                generalPath.append(line2D, true);
                if (list2.size() >= 2) {
                    Point2D point2D = line2D.getP2();
                    int n6 = (int)point2D.getX();
                    int n7 = (int)point2D.getY();
                    for (int j = 1; j < list2.size(); ++j) {
                        SGDrawingElementLine sGDrawingElementLine2 = (SGDrawingElementLine)list2.get(j);
                        SGTuple2f sGTuple2f = sGDrawingElementLine2.getEnd();
                        float f = sGTuple2f.x;
                        float f2 = sGTuple2f.y;
                        if ((int)f == n6 && (int)f2 == n7) continue;
                        generalPath.lineTo(f, f2);
                        n6 = (int)f;
                        n7 = (int)f2;
                    }
                }
                list.add(generalPath);
            }
        }
        return true;
    }

    private SGTuple2f[] reduceClosePoints(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        if (n < 2) {
            return sGTuple2fArray;
        }
        ArrayList<SGTuple2f> arrayList = new ArrayList<SGTuple2f>();
        arrayList.add(sGTuple2fArray[0]);
        int n2 = (int)sGTuple2fArray[0].x;
        int n3 = (int)sGTuple2fArray[0].y;
        for (int i = 1; i < n; ++i) {
            float f = sGTuple2fArray[i].x;
            float f2 = sGTuple2fArray[i].y;
            if ((int)f == n2 && (int)f2 == n3) continue;
            arrayList.add(sGTuple2fArray[i]);
            n2 = (int)f;
            n3 = (int)f2;
        }
        SGTuple2f[] sGTuple2fArray2 = arrayList.toArray(new SGTuple2f[0]);
        return sGTuple2fArray2;
    }

    public SGProperties getProperties() {
        LineProperties lineProperties = new LineProperties();
        this.getProperties(lineProperties);
        return lineProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        LineProperties lineProperties = (LineProperties)sGProperties;
        lineProperties.setLineWidth(this.getLineWidth());
        lineProperties.setLineType(this.getLineType());
        lineProperties.setColor(this.getColor());
        lineProperties.mConnectAllFlag = this.mConnectingAllFlag;
        lineProperties.mShiftX = this.mShiftX;
        lineProperties.mShiftY = this.mShiftY;
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LineProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        LineProperties lineProperties = (LineProperties)sGProperties;
        Float f = lineProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        Integer n = lineProperties.getLineType();
        if (n == null) {
            return false;
        }
        Color color = lineProperties.getColor();
        if (color == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        this.setLineType(n);
        this.setLineConnectingAll(lineProperties.mConnectAllFlag);
        this.setColor(color);
        this.setLineShiftX(lineProperties.mShiftX);
        this.setLineShiftY(lineProperties.mShiftY);
        return true;
    }

    public void setLineNumber1(int n) {
        this.mStroke.setLineNumber1(this.mLineType, n);
    }

    public void setLineNumber2(int n) {
        this.mStroke.setLineNumber2(this.mLineType, n);
    }

    public void setLineLength1(float f) {
        this.mStroke.setLineLength1(this.mLineType, f);
    }

    public void setLineLength2(float f) {
        this.mStroke.setLineLength2(this.mLineType, f);
    }

    public void setSpace(float f) {
        this.mStroke.setSpace(this.mLineType, f);
    }

    public int getLineNum1() {
        return this.mStroke.getLineNum1(this.mLineType);
    }

    public int getLineNum2() {
        return this.mStroke.getLineNum2(this.mLineType);
    }

    public float getLineLength1() {
        return this.mStroke.getLineLength1(this.mLineType);
    }

    public float getLineLength2() {
        return this.mStroke.getLineLength2(this.mLineType);
    }

    public float getSpace() {
        return this.mStroke.getSpace(this.mLineType);
    }

    public static class LineProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementLine.LineProperties mLineProperties = new SGDrawingElementLine.LineProperties();
        private boolean mConnectAllFlag = true;
        private double mShiftX;
        private double mShiftY;

        public Object copy() {
            Object object = super.copy();
            LineProperties lineProperties = (LineProperties)object;
            lineProperties.mLineProperties = (SGDrawingElementLine.LineProperties)this.mLineProperties.copy();
            lineProperties.mConnectAllFlag = this.mConnectAllFlag;
            lineProperties.mShiftX = this.mShiftX;
            lineProperties.mShiftY = this.mShiftY;
            return lineProperties;
        }

        public void dispose() {
            super.dispose();
            this.mLineProperties.dispose();
        }

        public boolean equals(Object object) {
            if (!(object instanceof LineProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            LineProperties lineProperties = (LineProperties)object;
            if (!this.mLineProperties.equals(lineProperties.mLineProperties)) {
                return false;
            }
            if (this.mConnectAllFlag != lineProperties.mConnectAllFlag) {
                return false;
            }
            if (this.mShiftX != lineProperties.mShiftX) {
                return false;
            }
            return this.mShiftY == lineProperties.mShiftY;
        }

        public Float getLineWidth() {
            return this.mLineProperties.getLineWidth();
        }

        public Integer getLineType() {
            return this.mLineProperties.getLineType();
        }

        public Color getColor() {
            return this.mLineProperties.getColor();
        }

        public boolean setLineWidth(float f) {
            return this.mLineProperties.setLineWidth(f);
        }

        public boolean setLineType(int n) {
            return this.mLineProperties.setLineType(n);
        }

        public boolean setColor(Color color) {
            return this.mLineProperties.setColor(color);
        }
    }

    protected static class LineInGroup
    extends SGDrawingElementLine2D {
        protected SGElementGroupLine mGroup = null;
        protected int mIndex = -1;

        public LineInGroup(SGElementGroupLine sGElementGroupLine, int n) {
            this.mGroup = sGElementGroupLine;
            this.mIndex = n;
        }

        public void dispose() {
            super.dispose();
            this.mGroup = null;
        }

        protected SGStroke getStroke() {
            return this.mGroup.getStroke();
        }

        public boolean setLineWidth(float f) {
            return true;
        }

        public boolean setLineType(int n) {
            return true;
        }

        public float getMagnification() {
            return this.mGroup.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }

        public Color getColor() {
            return this.mGroup.getColor();
        }

        public boolean setColor(Color color) {
            return true;
        }

        public SGTuple2f getEnd() {
            return this.mGroup.getEnd(this.mIndex);
        }

        public SGTuple2f getStart() {
            return this.mGroup.getStart(this.mIndex);
        }

        public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
            return true;
        }

        public boolean contains(int n, int n2) {
            return super.contains(n, n2);
        }
    }
}

