/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIErrorBarConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementErrorBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import org.w3c.dom.Element;

public abstract class SGElementGroupErrorBar
extends SGElementGroup
implements SGILineConstants,
SGISymbolConstants,
SGIErrorBarConstants,
SGIArrowConstants {
    protected SGStroke mStroke = new SGStroke();
    protected float mHeadSize;
    protected int mHeadType;
    protected int mErrorBarStyle;
    protected Color mColor;
    protected Shape mHeadShape;
    protected boolean mVerticalFlag;
    protected boolean mPositionOnLine;

    protected SGDrawingElement createDrawingElementInstance(int n) {
        return new ErrorBarInGroup(this, n);
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2, SGTuple2f[] sGTuple2fArray3) {
        SGDrawingElement[] sGDrawingElementArray;
        if (sGTuple2fArray == null || sGTuple2fArray2 == null || sGTuple2fArray3 == null) {
            throw new IllegalArgumentException("centerArray == null || lowerArray==null || upperArray==null");
        }
        if (sGTuple2fArray.length != sGTuple2fArray2.length) {
            throw new IllegalArgumentException("centerArray.length != lowerArray.length");
        }
        if (sGTuple2fArray.length != sGTuple2fArray3.length) {
            throw new IllegalArgumentException("centerArray.length != upperArray.length");
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            this.initDrawingElement(sGTuple2fArray.length);
        }
        if ((sGDrawingElementArray = this.mDrawingElementArray) == null) {
            return false;
        }
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            ((SGDrawingElementErrorBar)sGDrawingElementArray[i]).setLocation(sGTuple2fArray[i], sGTuple2fArray2[i], sGTuple2fArray3[i]);
        }
        return true;
    }

    public boolean setMagnification(float f) {
        if (!super.setMagnification(f)) {
            return false;
        }
        this.mStroke.setMagnification(f);
        this.updateHeadShape();
        return true;
    }

    protected SGStroke getStroke() {
        return this.mStroke;
    }

    public Color getColor() {
        return this.mColor;
    }

    public float getLineWidth() {
        return this.mStroke.getLineWidth();
    }

    public float getLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
    }

    public boolean setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("lw < 0.0f");
        }
        this.mStroke.setLineWidth(f);
        return true;
    }

    public abstract boolean setLineWidth(float var1, String var2);

    public float getHeadSize() {
        return this.mHeadSize;
    }

    public float getHeadSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getHeadSize(), string);
    }

    public boolean setHeadSize(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("size < 0.0f");
        }
        this.mHeadSize = f;
        this.updateHeadShape();
        return true;
    }

    public abstract boolean setHeadSize(float var1, String var2);

    public int getErrorBarStyle() {
        return this.mErrorBarStyle;
    }

    public boolean setErrorBarStyle(int n) {
        if (!SGDrawingElementErrorBar.isValidErrorBarStyle(n)) {
            return false;
        }
        this.mErrorBarStyle = n;
        return true;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color == null");
        }
        this.mColor = color;
        return true;
    }

    public boolean isPositionOnLine() {
        return this.mPositionOnLine;
    }

    public boolean setPositionOnLine(boolean bl) {
        this.mPositionOnLine = bl;
        return true;
    }

    public abstract SGTuple2f getStartLocation(int var1);

    public abstract SGTuple2f getUpperEndLocation(int var1);

    public abstract SGTuple2f getLowerEndLocation(int var1);

    public String getTagName() {
        return "ErrorBar";
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mHeadSize * 0.035277776f, -3);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.getLineWidth(), -3);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.getColor());
        element.setAttribute("Style", SGDrawingElementErrorBar.getErrorBarStyleName(this.mErrorBarStyle));
        element.setAttribute("HeadSize", Float.toString(f) + "cm");
        element.setAttribute("Width", Float.toString(f2) + "pt");
        element.setAttribute("HeadType", SGDrawingElementErrorBar.getHeadTypeName(this.getHeadType()));
        element.setAttribute("Color", SGUtilityText.getColorListString(arrayList));
        element.setAttribute("Vertical", Boolean.toString(this.mVerticalFlag));
        element.setAttribute("Position", SGDrawingElementErrorBar.getErrorBarPositionName(this.mPositionOnLine ? 1 : 2));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        Serializable serializable;
        String string = null;
        Number number = null;
        Boolean bl = null;
        List<Color> list = null;
        string = element.getAttribute("Color");
        if (string.length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            serializable = list.get(0);
            if (!this.setColor((Color)serializable)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Width")).length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)serializable);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLineWidth(f, ((StringBuffer)serializable).toString())) {
                return false;
            }
        } else {
            string = element.getAttribute("LineWidth");
            if (string.length() != 0) {
                serializable = new StringBuffer();
                number = SGUtilityText.getNumber(string, (StringBuffer)serializable);
                if (number == null) {
                    return false;
                }
                f = number.floatValue();
                if (!this.setLineWidth(f, ((StringBuffer)serializable).toString())) {
                    return false;
                }
            }
        }
        if ((string = element.getAttribute("HeadSize")).length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)serializable);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setHeadSize(f, ((StringBuffer)serializable).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Style")).length() != 0) {
            number = SGDrawingElementErrorBar.getErrorBarStyleFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setErrorBarStyle(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("HeadType")).length() != 0) {
            Integer n = SGDrawingElementErrorBar.getHeadTypeFromName(string);
            if (n == null) {
                return false;
            }
            int n2 = n;
            if (!this.setHeadType(n2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Vertical")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            if (!this.setVertical(bl)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Position")).length() != 0) {
            number = SGDrawingElementErrorBar.getErrorBarPositionFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!SGDrawingElementErrorBar.isValidErrorBarPosition(n)) {
                return false;
            }
            if (!this.setPositionOnLine(n == 1)) {
                return false;
            }
        }
        return true;
    }

    public int getHeadType() {
        return this.mHeadType;
    }

    public boolean setHeadType(int n) {
        if (!SGDrawingElementErrorBar.isValidHeadType(n)) {
            return false;
        }
        this.mHeadType = n;
        this.updateHeadShape();
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementErrorBar2D sGDrawingElementErrorBar2D = (SGDrawingElementErrorBar2D)sGDrawingElementArray[i];
                if (!sGDrawingElementErrorBar2D.isVisible()) continue;
                sGDrawingElementErrorBar2D.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    public SGProperties getProperties() {
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        if (!this.getProperties(errorBarProperties)) {
            return null;
        }
        return errorBarProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        errorBarProperties.setLineWidth(this.getLineWidth());
        errorBarProperties.setHeadSize(this.getHeadSize());
        errorBarProperties.setHeadType(this.getHeadType());
        errorBarProperties.setErrorBarStyle(this.getErrorBarStyle());
        errorBarProperties.setColor(this.getColor());
        errorBarProperties.setVertical(this.isVertical());
        errorBarProperties.mPositionOnLine = this.isPositionOnLine();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        this.setLineWidth(errorBarProperties.getLineWidth().floatValue());
        this.setHeadSize(errorBarProperties.getHeadSize().floatValue());
        this.setHeadType(errorBarProperties.getHeadType());
        this.setColor(errorBarProperties.getColor());
        this.setVertical(errorBarProperties.isVertical());
        Integer n = errorBarProperties.getErrorBarStyle();
        if (n == null) {
            return false;
        }
        this.setErrorBarStyle(n);
        this.setPositionOnLine(errorBarProperties.mPositionOnLine);
        return true;
    }

    public abstract boolean updateLocation();

    public Shape getStartHeadShape() {
        return null;
    }

    public Shape getEndHeadShape() {
        return this.mHeadShape;
    }

    protected void updateHeadShape() {
        int n = this.getHeadType();
        float f = this.getMagnification() * this.getHeadSize();
        this.mHeadShape = SGDrawingElementArrow2D.createHeadShape(n, f, 0.0f, 0.0f);
    }

    public boolean isVertical() {
        return this.mVerticalFlag;
    }

    public boolean setVertical(boolean bl) {
        this.mVerticalFlag = bl;
        return true;
    }

    protected static class ErrorBarHeadInGroup
    extends SGDrawingElementArrow2D.ArrowHead {
        public ErrorBarHeadInGroup(SGDrawingElementArrow sGDrawingElementArrow, boolean bl) {
            super(sGDrawingElementArrow, bl);
        }

        public int getType() {
            if (this.mStartFlag) {
                return -1;
            }
            return this.mArrow.getEndHeadType();
        }
    }

    protected static class ErrorBarArrowInGroup
    extends SGElementGroupArrow.ArrowInGroup {
        private SGTuple2f mEndPoint = new SGTuple2f();

        private SGElementGroupErrorBar getErrorBarGroup() {
            return (SGElementGroupErrorBar)this.mGroup;
        }

        public boolean setLocation(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
            if (!super.setLocation(sGTuple2f, sGTuple2f2)) {
                return false;
            }
            this.mEndPoint.setValues(sGTuple2f2);
            return true;
        }

        public ErrorBarArrowInGroup(SGElementGroupErrorBar sGElementGroupErrorBar, int n) {
            this.mGroup = sGElementGroupErrorBar;
            this.mIndex = n;
            this.mLine = this.createBodyInstance();
            this.mStartHead = this.createHeadInstance(this, true);
            this.mEndHead = this.createHeadInstance(this, false);
        }

        protected SGDrawingElementSymbol createHeadInstance(SGDrawingElementArrow sGDrawingElementArrow, boolean bl) {
            return new ErrorBarHeadInGroup(this, bl);
        }

        public boolean setHeadType(int n) {
            this.setEndHeadType(n);
            return true;
        }

        public float getLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        public int getLineType() {
            return 1;
        }

        public float getHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        public int getStartHeadType() {
            return -1;
        }

        public int getEndHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getHeadCloseAngle() {
            return 0.0f;
        }

        public float getHeadOpenAngle() {
            return 0.0f;
        }

        public SGStroke getStroke() {
            return this.getErrorBarGroup().getStroke();
        }

        public Color getColor() {
            return this.getErrorBarGroup().getColor();
        }

        public SGTuple2f getEnd() {
            return this.mEndPoint;
        }

        public SGTuple2f getStart() {
            return this.getErrorBarGroup().getStartLocation(this.mIndex);
        }

        protected Shape getStartHeadShape() {
            return this.getErrorBarGroup().getStartHeadShape();
        }

        protected Shape getEndHeadShape() {
            return this.getErrorBarGroup().getEndHeadShape();
        }
    }

    protected static class ErrorBarInGroup
    extends SGDrawingElementErrorBar2D {
        protected SGElementGroupErrorBar mGroup = null;

        public ErrorBarInGroup(SGElementGroupErrorBar sGElementGroupErrorBar, int n) {
            this.mGroup = sGElementGroupErrorBar;
            this.mLowerArrowElement = this.createArrowInstance(n);
            this.mUpperArrowElement = this.createArrowInstance(n);
            this.mLowerArrowElement.setStartHeadType(-1);
            this.mUpperArrowElement.setStartHeadType(-1);
        }

        public void dispose() {
            super.dispose();
            this.mGroup = null;
        }

        public float getLineWidth() {
            return this.mGroup.getLineWidth();
        }

        public float getHeadSize() {
            return this.mGroup.getHeadSize();
        }

        public int getHeadType() {
            return this.mGroup.getHeadType();
        }

        public int getErrorBarStyle() {
            return this.mGroup.getErrorBarStyle();
        }

        public boolean setLineWidth(float f) {
            return true;
        }

        public boolean setHeadSize(float f) {
            return true;
        }

        public boolean setHeadType(int n) {
            return true;
        }

        public boolean setErrorBarStyle(int n) {
            return true;
        }

        protected SGDrawingElementArrow createArrowInstance(int n) {
            ErrorBarArrowInGroup errorBarArrowInGroup = new ErrorBarArrowInGroup(this.mGroup, n);
            ((SGDrawingElementArrow)errorBarArrowInGroup).setLineType(1);
            return errorBarArrowInGroup;
        }

        public float getMagnification() {
            return this.mGroup.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }

        public Color getColor() {
            return this.mGroup.getColor();
        }

        public boolean setColor(Color color) {
            return true;
        }
    }

    public static class ErrorBarProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementErrorBar.ErrorBarProperties mErrorBarProperties = new SGDrawingElementErrorBar.ErrorBarProperties();
        private boolean mPositionOnLine = true;

        public Object copy() {
            Object object = super.copy();
            ErrorBarProperties errorBarProperties = (ErrorBarProperties)object;
            errorBarProperties.mErrorBarProperties = (SGDrawingElementErrorBar.ErrorBarProperties)this.mErrorBarProperties.copy();
            errorBarProperties.mPositionOnLine = this.mPositionOnLine;
            return errorBarProperties;
        }

        public void dispose() {
            super.dispose();
            this.mErrorBarProperties.dispose();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ErrorBarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ErrorBarProperties errorBarProperties = (ErrorBarProperties)object;
            if (!this.mErrorBarProperties.equals(errorBarProperties.mErrorBarProperties)) {
                return false;
            }
            return this.mPositionOnLine == errorBarProperties.mPositionOnLine;
        }

        public Float getLineWidth() {
            return this.mErrorBarProperties.getLineWidth();
        }

        public Float getHeadSize() {
            return this.mErrorBarProperties.getHeadSize();
        }

        public Integer getHeadType() {
            return this.mErrorBarProperties.getHeadType();
        }

        public Color getColor() {
            return this.mErrorBarProperties.getColor();
        }

        public Boolean isVertical() {
            return this.mErrorBarProperties.isVertical();
        }

        public boolean setColor(Color color) {
            return this.mErrorBarProperties.setColor(color);
        }

        public void setLineWidth(float f) {
            this.mErrorBarProperties.setLineWidth(f);
        }

        public void setHeadSize(float f) {
            this.mErrorBarProperties.setHeadSize(f);
        }

        public void setHeadType(int n) {
            this.mErrorBarProperties.setHeadType(n);
        }

        public Integer getErrorBarStyle() {
            return this.mErrorBarProperties.getErrorBarStyle();
        }

        public void setErrorBarStyle(int n) {
            this.mErrorBarProperties.setErrorBarStyle(n);
        }

        public void setVertical(boolean bl) {
            this.mErrorBarProperties.setVertical(bl);
        }
    }
}

