/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGColorBarModel;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGFillPaint;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIColorMapConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupRectangle;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInGraph;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupGridSXY;
import org.w3c.dom.Element;

public abstract class SGElementGroupColorMap
extends SGElementGroupRectangle
implements SGIColorMapConstants,
SGIElementGroupGridSXY {
    protected double mWidthValue;
    protected double mHeightValue;
    protected SGColorBarModel mColorBarModel = null;
    protected float[] mXCoordinateArray = null;
    protected float[] mYCoordinateArray = null;
    protected float[] mWidthArray = null;
    protected float[] mHeightArray = null;
    protected double[] mZValuesArray = null;
    protected Rectangle2D mBounds = new Rectangle2D.Float();
    protected boolean mGridMode = false;
    protected static final float SINGLE_VALUE_MARGIN = 10.0f;
    private boolean mFocusedFlag = false;
    private SGElementGroupSetInGraph mGroupSet = null;

    public void dispose() {
        super.dispose();
        this.mColorBarModel = null;
        this.mXCoordinateArray = null;
        this.mYCoordinateArray = null;
        this.mZValuesArray = null;
        this.mBounds = null;
    }

    public void setColorBarModel(SGColorBarModel sGColorBarModel) {
        if (sGColorBarModel == null) {
            throw new IllegalArgumentException("model == null");
        }
        this.mColorBarModel = sGColorBarModel;
    }

    public SGColorBarModel getColorBarModel() {
        return this.mColorBarModel;
    }

    public double getWidthValue() {
        return this.mWidthValue;
    }

    public boolean setWidthValue(double d) {
        if (d < 0.0) {
            return false;
        }
        this.mWidthValue = d;
        return true;
    }

    public double getHeightValue() {
        return this.mHeightValue;
    }

    public boolean setHeightValue(double d) {
        if (d < 0.0) {
            return false;
        }
        this.mHeightValue = d;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            this.initDrawingElement(sGTuple2fArray);
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            ColorMapRectangle colorMapRectangle = (ColorMapRectangle)sGDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            colorMapRectangle.setVisible(bl);
            if (!bl) continue;
            colorMapRectangle.setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setLocation(float[] fArray, float[] fArray2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        if (fArray == null || fArray2 == null) {
            throw new IllegalArgumentException("xCoordinateArray == null || yCoordinateArray == null");
        }
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n == 1) {
            f7 = f8 = fArray[0];
            f6 = 10.0f;
            f5 = 10.0f;
        } else if (fArray[0] < fArray[n - 1]) {
            f8 = fArray[0];
            f7 = fArray[n - 1];
            f6 = Math.abs(fArray[1] - fArray[0]) / 2.0f;
            f5 = Math.abs(fArray[n - 1] - fArray[n - 2]) / 2.0f;
        } else {
            f8 = fArray[n - 1];
            f7 = fArray[0];
            f6 = Math.abs(fArray[n - 1] - fArray[n - 2]) / 2.0f;
            f5 = Math.abs(fArray[1] - fArray[0]) / 2.0f;
        }
        if (n2 == 1) {
            f3 = f4 = fArray2[0];
            f2 = 10.0f;
            f = 10.0f;
        } else if (fArray2[0] < fArray2[n2 - 1]) {
            f4 = fArray2[0];
            f3 = fArray2[n2 - 1];
            f2 = Math.abs(fArray2[1] - fArray2[0]) / 2.0f;
            f = Math.abs(fArray2[n2 - 1] - fArray2[n2 - 2]) / 2.0f;
        } else {
            f4 = fArray2[n2 - 1];
            f3 = fArray2[0];
            f2 = Math.abs(fArray2[n2 - 1] - fArray2[n2 - 2]) / 2.0f;
            f = Math.abs(fArray2[1] - fArray2[0]) / 2.0f;
        }
        float f9 = (f7 += f5) - (f8 -= f6);
        float f10 = (f3 += f) - (f4 -= f2);
        this.mBounds = new Rectangle2D.Float(f8, f4, f9, f10);
        float[] fArray3 = new float[n];
        for (int i = 0; i < n; ++i) {
            float f11 = i == 0 ? Math.abs(fArray[1] - fArray[0]) : (i == n - 1 ? Math.abs(fArray[n - 1] - fArray[n - 2]) : Math.abs(fArray[i + 1] - fArray[i - 1]) / 2.0f);
            fArray3[i] = f11;
        }
        float[] fArray4 = new float[n2];
        for (int i = 0; i < n2; ++i) {
            float f12 = i == 0 ? Math.abs(fArray2[1] - fArray2[0]) : (i == n2 - 1 ? Math.abs(fArray2[n2 - 1] - fArray2[n2 - 2]) : Math.abs(fArray2[i + 1] - fArray2[i - 1]) / 2.0f);
            fArray4[i] = f12;
        }
        this.mXCoordinateArray = fArray;
        this.mYCoordinateArray = fArray2;
        this.mWidthArray = fArray3;
        this.mHeightArray = fArray4;
        return true;
    }

    public String getTagName() {
        return "ColorMap";
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        block6: {
            block5: {
                if (!this.mGridMode) break block5;
                Area area = null;
                if (rectangle2D != null) {
                    area = new Area(rectangle2D);
                }
                int n = this.mXCoordinateArray.length;
                int n2 = this.mYCoordinateArray.length;
                for (int i = 0; i < n2; ++i) {
                    float f = this.mYCoordinateArray[i] - this.mHeightArray[i] / 2.0f;
                    for (int j = 0; j < n; ++j) {
                        int n3 = n * i + j;
                        double d = this.mZValuesArray[n3];
                        if (Double.isNaN(d) || Double.isInfinite(d)) continue;
                        float f2 = this.mXCoordinateArray[j] - this.mWidthArray[j] / 2.0f;
                        Rectangle2D.Double double_ = new Rectangle2D.Double(f2, f, this.mWidthArray[j], this.mHeightArray[i]);
                        Color color = this.mColorBarModel.evaluate(d);
                        graphics2D.setPaint(color);
                        if (area != null) {
                            Area area2 = new Area(double_);
                            area2.intersect(area);
                            graphics2D.fill(area2);
                            continue;
                        }
                        graphics2D.fill(double_);
                    }
                }
                break block6;
            }
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (sGDrawingElementArray == null) break block6;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                ColorMapRectangle colorMapRectangle = (ColorMapRectangle)sGDrawingElementArray[i];
                colorMapRectangle.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        return super.initDrawingElement(sGTuple2fArray);
    }

    public boolean initDrawingElement(float[] fArray, float[] fArray2) {
        return true;
    }

    protected SGDrawingElement createDrawingElementInstance(int n) {
        return new ColorMapRectangle(this, n);
    }

    public boolean readProperty(Element element) {
        if (!this.mGridMode) {
            String string = null;
            Double d = null;
            string = element.getAttribute("WidthValue");
            if (string.length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                this.setWidthValue(d);
            }
            if ((string = element.getAttribute("HeightValue")).length() != 0) {
                d = SGUtilityText.getDouble(string);
                if (d == null) {
                    return false;
                }
                this.setHeightValue(d);
            }
        }
        return true;
    }

    public boolean writeProperty(Element element) {
        if (!this.mGridMode) {
            element.setAttribute("WidthValue", Double.toString(this.mWidthValue));
            element.setAttribute("HeightValue", Double.toString(this.mHeightValue));
        }
        return true;
    }

    public void setFocused(boolean bl) {
        this.mFocusedFlag = bl;
    }

    public boolean isFocused() {
        return this.mFocusedFlag;
    }

    public boolean setElementGroupSet(SGElementGroupSetInGraph sGElementGroupSetInGraph) {
        this.mGroupSet = sGElementGroupSetInGraph;
        return true;
    }

    public void setColors(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("values == null");
        }
        if (dArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException("Illegal array length: " + dArray.length + " != " + this.mDrawingElementArray.length);
        }
        for (int i = 0; i < dArray.length; ++i) {
            ColorMapRectangle colorMapRectangle = (ColorMapRectangle)this.mDrawingElementArray[i];
            colorMapRectangle.setZValue(dArray[i]);
            if (Double.isNaN(dArray[i]) || Double.isInfinite(dArray[i])) {
                colorMapRectangle.setVisible(false);
                continue;
            }
            colorMapRectangle.setVisible(true);
            Color color = this.mColorBarModel.evaluate(dArray[i]);
            colorMapRectangle.setInnerPaint(new SGFillPaint(color));
        }
    }

    public void setValueRange(double d, double d2) {
        this.mColorBarModel.setValueRange(d, d2);
    }

    public SGProperties getProperties() {
        ColorMapProperties colorMapProperties = new ColorMapProperties();
        if (!this.getProperties(colorMapProperties)) {
            return null;
        }
        return colorMapProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ColorMapProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ColorMapProperties colorMapProperties = (ColorMapProperties)sGProperties;
        colorMapProperties.widthValue = this.mWidthValue;
        colorMapProperties.heightValue = this.mHeightValue;
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ColorMapProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ColorMapProperties colorMapProperties = (ColorMapProperties)sGProperties;
        this.mWidthValue = colorMapProperties.widthValue;
        this.mHeightValue = colorMapProperties.heightValue;
        return true;
    }

    protected boolean setZValues(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("zValues == null");
        }
        if (this.mGridMode) {
            this.mZValuesArray = dArray;
        } else {
            if (dArray.length != this.mDrawingElementArray.length) {
                throw new IllegalArgumentException("The number of z values is different from that of the rectangles: " + this.mDrawingElementArray.length + " != " + dArray.length);
            }
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                ColorMapRectangle colorMapRectangle = (ColorMapRectangle)this.mDrawingElementArray[i];
                colorMapRectangle.setZValue(dArray[i]);
            }
        }
        return true;
    }

    public boolean setEdgeLineWidth(float f, String string) {
        return true;
    }

    public boolean isGridMode() {
        return this.mGridMode;
    }

    public boolean setGridMode(boolean bl) {
        this.mGridMode = bl;
        return true;
    }

    public float getX(int n) {
        return this.mXCoordinateArray[n];
    }

    public float getY(int n) {
        return this.mYCoordinateArray[n];
    }

    public static class ColorMapProperties
    extends SGElementGroup.ElementGroupProperties {
        double widthValue;
        double heightValue;

        ColorMapProperties() {
        }

        public Object copy() {
            Object object = super.copy();
            ColorMapProperties colorMapProperties = (ColorMapProperties)object;
            colorMapProperties.widthValue = this.widthValue;
            colorMapProperties.heightValue = this.heightValue;
            return colorMapProperties;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ColorMapProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ColorMapProperties colorMapProperties = (ColorMapProperties)object;
            if (this.widthValue != colorMapProperties.widthValue) {
                return false;
            }
            return this.heightValue == colorMapProperties.heightValue;
        }
    }

    protected static class ColorMapRectangle
    extends SGElementGroupRectangle.RectInGroup
    implements SGIDrawingElementJava2D {
        private double mZValue;

        public ColorMapRectangle(SGElementGroupColorMap sGElementGroupColorMap, int n) {
            super(sGElementGroupColorMap, n);
        }

        public void setZValue(double d) {
            this.mZValue = d;
        }

        public double getZValue() {
            return this.mZValue;
        }

        public void paint(Graphics2D graphics2D) {
            if (!this.isVisible()) {
                return;
            }
            Rectangle2D rectangle2D = this.getElementBounds();
            Color color = this.getColor();
            graphics2D.setPaint(color);
            graphics2D.fill(rectangle2D);
        }

        public boolean contains(int n, int n2) {
            return this.getElementBounds().contains(n, n2);
        }

        public Rectangle2D getElementBounds() {
            float f = this.getX();
            float f2 = this.getY();
            float f3 = this.getWidth();
            float f4 = this.getHeight();
            float f5 = Math.abs(f3);
            float f6 = Math.abs(f4);
            float f7 = f - 0.5f * f5;
            float f8 = f2 - 0.5f * f6;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f7, f8, f5, f6);
            return float_;
        }

        public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            if (rectangle2D == null) {
                this.paint(graphics2D);
            } else {
                Rectangle2D rectangle2D2 = this.getElementBounds();
                Area area = new Area(rectangle2D);
                Area area2 = new Area(rectangle2D2);
                area2.intersect(area);
                graphics2D.setPaint(this.getColor());
                graphics2D.fill(area2);
            }
        }

        public Color getColor() {
            SGColorBarModel sGColorBarModel = ((SGElementGroupColorMap)this.mGroup).getColorBarModel();
            return sGColorBarModel.evaluate(this.mZValue);
        }
    }
}

