/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPaint;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGSelectablePaint;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIBarConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGPaintUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGStroke;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupRectangle;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupBar
extends SGElementGroupRectangle
implements SGIBarConstants,
SGIElementGroupConstants {
    protected double mBaselineValue;
    protected double mWidthValue;
    protected float mWidth;
    protected boolean mVerticalFlag;
    protected double mShiftX;
    protected double mShiftY;
    protected double mInterval;

    public abstract float getX(int var1);

    public abstract float getY(int var1);

    public double getBaselineValue() {
        return this.mBaselineValue;
    }

    public boolean setBaselineValue(double d) {
        this.mBaselineValue = d;
        return true;
    }

    public double getWidthValue() {
        return this.mWidthValue;
    }

    public boolean setWidthValue(double d) {
        if (d < 0.0) {
            return false;
        }
        this.mWidthValue = d;
        return true;
    }

    public boolean isVertical() {
        return this.mVerticalFlag;
    }

    public double getShiftX() {
        return this.mShiftX;
    }

    public double getShiftY() {
        return this.mShiftY;
    }

    public boolean setShiftX(double d) {
        this.mShiftX = d;
        return true;
    }

    public boolean setShiftY(double d) {
        this.mShiftY = d;
        return true;
    }

    public double getInterval() {
        return this.mInterval;
    }

    public boolean setInterval(double d) {
        this.mInterval = d;
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                sGDrawingElementBar2D.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    public String getTagName() {
        return "Bar";
    }

    public boolean writeProperty(Element element) {
        float f = (float)SGUtilityNumber.roundOffNumber(this.getEdgeLineWidth(), -3);
        element.setAttribute("WidthValue", Double.toString(this.mWidthValue));
        element.setAttribute("EdgeLineWidth", Float.toString(f) + "pt");
        element.setAttribute("BaselineValue", Double.toString(this.mBaselineValue));
        element.setAttribute("EdgeLineColor", SGUtilityText.getColorString(this.mEdgeLineColor));
        element.setAttribute("EdgeLineVisible", Boolean.toString(this.isEdgeLineVisible()));
        if (!SGPaintUtility.writeProperty(element, this.mInnerPaint)) {
            return false;
        }
        element.setAttribute("Vertical", Boolean.toString(this.mVerticalFlag));
        element.setAttribute("Interval", Double.toString(this.mInterval));
        element.setAttribute("ShiftX", Double.toString(this.mShiftX));
        element.setAttribute("ShiftY", Double.toString(this.mShiftY));
        return true;
    }

    public boolean readProperty(Element element) {
        Object object;
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        string = element.getAttribute("WidthValue");
        if (string.length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            if (!this.setWidthValue(number.doubleValue())) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineWidth")).length() != 0) {
            object = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)object);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setEdgeLineWidth(f, ((StringBuffer)object).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("BaselineValue")).length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.setBaselineValue(d)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineColor")).length() != 0) {
            color = SGUtilityText.parseColor(string);
            if (color == null) {
                return false;
            }
            object = color;
            if (!this.setEdgeLineColor((Color)object)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineVisible")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            if (!this.setEdgeLineVisible(bl)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            object = SGUtilityText.getColorList(string);
            if (object == null) {
                return false;
            }
            if (object.size() < 1) {
                return false;
            }
            color = (Color)object.get(0);
            SGSelectablePaint sGSelectablePaint = new SGSelectablePaint();
            sGSelectablePaint.setSelectedPaintStyle(0);
            sGSelectablePaint.setFillColor(color);
            if (!this.setInnerPaint(sGSelectablePaint)) {
                return false;
            }
            string = element.getAttribute("Transparent");
            if (string.length() != 0 && (bl = SGUtilityText.getBoolean(string)) != null && (bl == false ? !this.setTransparent(1.0f) : !this.setTransparent(0.0f))) {
                return false;
            }
        } else {
            object = SGPaintUtility.readProperty(element);
            if (null != object) {
                this.setInnerPaint((SGIPaint)object);
            } else {
                return false;
            }
        }
        string = element.getAttribute("Vertical");
        if (string.length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            object = bl;
            if (!this.setVertical((Boolean)object)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Interval")).length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.setInterval(d)) {
                return false;
            }
        }
        if ((string = element.getAttribute("ShiftX")).length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.setShiftX(d)) {
                return false;
            }
        }
        if ((string = element.getAttribute("ShiftY")).length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.setShiftY(d)) {
                return false;
            }
        }
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            this.initDrawingElement(sGTuple2fArray);
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            sGDrawingElementBar2D.setVisible(bl);
        }
        return true;
    }

    public boolean setVertical(boolean bl) {
        this.mVerticalFlag = bl;
        return true;
    }

    public SGProperties getProperties() {
        BarProperties barProperties = new BarProperties();
        if (!this.getProperties(barProperties)) {
            return null;
        }
        return barProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        BarProperties barProperties = (BarProperties)sGProperties;
        barProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        barProperties.setInnerPaint(this.getInnerPaint());
        barProperties.setEdgeLineColor(this.getEdgeLineColor());
        barProperties.setBaselineValue(this.getBaselineValue());
        barProperties.setWidthValue(this.getWidthValue());
        barProperties.setVerticalFlag(this.isVertical());
        barProperties.setEdgeLineVisible(this.isEdgeLineVisible());
        barProperties.setInterval(this.getInterval());
        barProperties.setShiftX(this.getShiftX());
        barProperties.setShiftY(this.getShiftY());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        BarProperties barProperties = (BarProperties)sGProperties;
        Float f = barProperties.getBarWidth();
        if (f == null) {
            return false;
        }
        this.setRectangleWidth(f.floatValue());
        Float f2 = barProperties.getEdgeLineWidth();
        if (f2 == null) {
            return false;
        }
        this.setEdgeLineWidth(f2.floatValue());
        Color color = barProperties.getEdgeLineColor();
        if (color == null) {
            return false;
        }
        this.setEdgeLineColor(color);
        Boolean bl = barProperties.isEdgeLineVisible();
        if (bl == null) {
            return false;
        }
        this.setEdgeLineVisible(bl);
        SGIPaint sGIPaint = barProperties.getInnerPaint();
        if (sGIPaint == null) {
            return false;
        }
        this.setInnerPaint(sGIPaint);
        Double d = barProperties.getBaselineValue();
        if (d == null) {
            return false;
        }
        this.setBaselineValue(d);
        Double d2 = barProperties.getWidthValue();
        if (d2 == null) {
            return false;
        }
        this.setWidthValue(d2);
        Boolean bl2 = barProperties.isVertical();
        if (bl2 == null) {
            return false;
        }
        this.setVertical(bl2);
        Double d3 = barProperties.getInterval();
        if (d3 == null) {
            return false;
        }
        this.setInterval(d3);
        this.setShiftX(barProperties.mShiftX);
        this.setShiftY(barProperties.mShiftY);
        return true;
    }

    public static class BarProperties
    extends SGElementGroup.ElementGroupProperties {
        protected SGDrawingElementBar.BarProperties mBarProperties = new SGDrawingElementBar.BarProperties();
        private double mShiftX;
        private double mShiftY;

        public Object copy() {
            Object object = super.copy();
            BarProperties barProperties = (BarProperties)object;
            barProperties.mBarProperties = (SGDrawingElementBar.BarProperties)this.mBarProperties.copy();
            barProperties.mShiftX = this.mShiftX;
            barProperties.mShiftY = this.mShiftY;
            return barProperties;
        }

        public void dispose() {
            super.dispose();
            this.mBarProperties.dispose();
        }

        public boolean equals(Object object) {
            if (!(object instanceof BarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            BarProperties barProperties = (BarProperties)object;
            if (!this.mBarProperties.equals(barProperties.mBarProperties)) {
                return false;
            }
            if (this.mShiftX != barProperties.mShiftX) {
                return false;
            }
            return this.mShiftY == barProperties.mShiftY;
        }

        public Float getBarWidth() {
            return this.mBarProperties.getWidth();
        }

        public Float getEdgeLineWidth() {
            return this.mBarProperties.getEdgeLineWidth();
        }

        public Color getEdgeLineColor() {
            return this.mBarProperties.getEdgeLineColor();
        }

        public Boolean isEdgeLineVisible() {
            return this.mBarProperties.isEdgeLineVisible();
        }

        public SGIPaint getInnerPaint() {
            return this.mBarProperties.getInnerPaint();
        }

        public Double getBaselineValue() {
            return this.mBarProperties.getBaselineValue();
        }

        public Double getWidthValue() {
            return this.mBarProperties.getWidthValue();
        }

        public Boolean isVertical() {
            return this.mBarProperties.isVertical();
        }

        public Double getInterval() {
            return this.mBarProperties.getInterval();
        }

        public Double getShiftX() {
            return this.mShiftX;
        }

        public Double getShiftY() {
            return this.mShiftY;
        }

        public boolean setBarWidth(float f) {
            return this.mBarProperties.setWidth(f);
        }

        public boolean setBaselineValue(double d) {
            return this.mBarProperties.setBaselineValue(d);
        }

        public boolean setWidthValue(double d) {
            return this.mBarProperties.setWidthValue(d);
        }

        public boolean setEdgeLineWidth(float f) {
            return this.mBarProperties.setEdgeLineWidth(f);
        }

        public boolean setEdgeLineColor(Color color) {
            return this.mBarProperties.setEdgeLineColor(color);
        }

        public boolean setEdgeLineVisible(boolean bl) {
            return this.mBarProperties.setEdgeLineVisible(bl);
        }

        public boolean setInnerPaint(SGIPaint sGIPaint) {
            return this.mBarProperties.setInnerPaint(sGIPaint);
        }

        public boolean setVerticalFlag(boolean bl) {
            return this.mBarProperties.setVertical(bl);
        }

        public boolean setInterval(double d) {
            return this.mBarProperties.setInterval(d);
        }

        public boolean setShiftX(double d) {
            this.mShiftX = d;
            return true;
        }

        public boolean setShiftY(double d) {
            this.mShiftY = d;
            return true;
        }
    }

    protected static abstract class BarInGroup
    extends SGDrawingElementBar2D {
        protected SGElementGroupBar mGroup = null;
        protected float mWidth;
        protected float mHeight;
        protected int mIndex = -1;

        public BarInGroup(SGElementGroupBar sGElementGroupBar, int n) {
            this.mGroup = sGElementGroupBar;
            this.mIndex = n;
        }

        public Color getEdgeLineColor() {
            return this.mGroup.getEdgeLineColor();
        }

        public int getEdgeLineType() {
            return this.mGroup.getEdgeLineType();
        }

        public float getEdgeLineWidth() {
            return this.mGroup.getEdgeLineWidth();
        }

        public boolean isEdgeLineVisible() {
            return this.mGroup.isEdgeLineVisible();
        }

        protected SGStroke getStroke() {
            return this.mGroup.getStroke();
        }

        public float getTransparency() {
            return this.mGroup.getTransparency();
        }

        public boolean setEdgeLineColor(Color color) {
            return true;
        }

        public boolean setEdgeLineType(int n) {
            return true;
        }

        public boolean setEdgeLineWidth(float f) {
            return true;
        }

        public boolean setEdgeLineVisible(boolean bl) {
            return true;
        }

        public boolean setTransparent(float f) {
            return true;
        }

        public double getBaselineValue() {
            return this.mGroup.getBaselineValue();
        }

        public double getWidthValue() {
            return this.mGroup.getWidthValue();
        }

        public boolean isVertical() {
            return this.mGroup.isVertical();
        }

        public double getInterval() {
            return this.mGroup.getInterval();
        }

        public boolean setBaselineValue(double d) {
            return true;
        }

        public boolean setVertical(boolean bl) {
            return true;
        }

        public boolean setWidthValue(double d) {
            return true;
        }

        public boolean setInterval(double d) {
            return true;
        }

        public float getMagnification() {
            return this.mGroup.getMagnification();
        }

        public boolean setMagnification(float f) {
            return true;
        }

        public SGIPaint getInnerPaint() {
            return this.mGroup.getInnerPaint();
        }

        public boolean setInnerPaint(SGIPaint sGIPaint) {
            return true;
        }

        public float getX() {
            return this.mGroup.getX(this.mIndex);
        }

        public float getY() {
            return this.mGroup.getY(this.mIndex);
        }

        public boolean setX(float f) {
            return true;
        }

        public boolean setY(float f) {
            return true;
        }
    }
}

