/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGDrawingElementString2D
extends SGDrawingElementString
implements SGIDrawingElementJava2D {
    protected Rectangle2D mStringRect = null;
    protected Rectangle2D mElementBounds = null;
    protected float mAscent = 0.0f;
    protected float mDescent = 0.0f;
    protected float mLeading = 0.0f;
    protected float mStrikethroughOffset = 0.0f;
    protected float mAdvance = 0.0f;

    public SGDrawingElementString2D() {
        this.updateMetrics();
    }

    public SGDrawingElementString2D(String string) {
        super(string);
        this.updateMetrics();
        this.updateElementBounds();
    }

    public SGDrawingElementString2D(SGDrawingElementString sGDrawingElementString) {
        super(sGDrawingElementString);
        this.updateMetrics();
        this.updateElementBounds();
    }

    public SGDrawingElementString2D(String string, String string2, int n, float f, Color color, float f2, float f3) {
        super(string, string2, n, f, color, f2, f3);
        this.updateMetrics();
        this.updateElementBounds();
    }

    public void dispose() {
        super.dispose();
        this.mStringRect = null;
        this.mElementBounds = null;
    }

    public boolean setString(String string) {
        if (!super.setString(string)) {
            return false;
        }
        this.updateMetrics();
        this.updateElementBounds();
        return true;
    }

    public boolean setMagnification(float f) {
        if (!super.setMagnification(f)) {
            return false;
        }
        this.updateMetrics();
        this.updateElementBounds();
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        super.setFont(string, n, f);
        this.updateMetrics();
        this.updateElementBounds();
        return true;
    }

    public boolean setX(float f) {
        super.setX(f);
        this.updateElementBounds();
        return true;
    }

    public boolean setY(float f) {
        super.setY(f);
        this.updateElementBounds();
        return true;
    }

    public boolean setAngle(float f) {
        if (!super.setAngle(f)) {
            return false;
        }
        this.updateElementBounds();
        return true;
    }

    public final boolean contains(int n, int n2) {
        Rectangle2D rectangle2D = this.getElementBounds();
        return rectangle2D.contains(n, n2);
    }

    private void updateMetrics() {
        Font font = this.getFont();
        String string = this.getString();
        if (string.length() == 0) {
            this.mStringRect = new Rectangle2D.Float();
            this.mAscent = 0.0f;
            this.mDescent = 0.0f;
            this.mLeading = 0.0f;
            this.mStrikethroughOffset = 0.0f;
            this.mAdvance = 0.0f;
            return;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        this.mStringRect = textLayout.getOutline(new AffineTransform()).getBounds2D();
        if (this.mStringRect.isEmpty()) {
            this.mStringRect.setRect(0.0, 0.0, 0.0, 0.0);
        }
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        this.mAscent = (float)(-this.mStringRect.getY());
        this.mDescent = (float)(this.mStringRect.getHeight() + this.mStringRect.getY());
        this.mLeading = lineMetrics.getLeading();
        this.mStrikethroughOffset = lineMetrics.getStrikethroughOffset();
        this.mAdvance = textLayout.getAdvance();
    }

    private void updateElementBounds() {
        String string = this.getString();
        if (string.length() == 0) {
            this.mElementBounds = new Rectangle2D.Float();
            return;
        }
        float f = this.getAngle() * ((float)Math.PI / 180);
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = (float)(this.mStringRect.getHeight() + this.mStringRect.getY());
        float f5 = super.getX() + 0.0f * f2 + f4 * f3;
        float f6 = super.getY() - 0.0f * f3 + f4 * f2;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f5, f6);
        affineTransform.rotate(-f);
        Rectangle2D rectangle2D = (Rectangle2D)this.mStringRect.clone();
        rectangle2D.setRect(0.0, 0.0, this.mAdvance, this.mStringRect.getHeight());
        Shape shape = affineTransform.createTransformedShape(rectangle2D);
        this.mElementBounds = shape.getBounds2D();
    }

    public Rectangle2D getElementBounds() {
        return (Rectangle2D)this.mElementBounds.clone();
    }

    public Rectangle2D getStringRect() {
        return (Rectangle2D)this.mStringRect.clone();
    }

    protected float getAscent() {
        return this.mAscent;
    }

    protected float getDescent() {
        return this.mDescent;
    }

    protected float getLeading() {
        return this.mLeading;
    }

    protected float getStrikethroughOffset() {
        return this.mStrikethroughOffset;
    }

    protected float getAdvance() {
        return this.mAdvance;
    }

    public void paint(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        String string = this.getString();
        graphics2D.setPaint(this.getColor());
        graphics2D.setFont(this.getFont());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(super.getX(), super.getY());
        affineTransform.rotate(-this.getAngle() * ((float)Math.PI / 180));
        AffineTransform affineTransform2 = graphics2D.getTransform();
        graphics2D.transform(affineTransform);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawString(string, 0.0f, (float)this.mStringRect.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setTransform(affineTransform2);
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.paint(graphics2D);
    }
}

