/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;

public abstract class SGDrawingElementLine2D
extends SGDrawingElementLine
implements SGIDrawingElementJava2D {
    public static final float MINIMUM_LINE_WIDTH = 2.0f;

    public SGDrawingElementLine2D() {
    }

    public SGDrawingElementLine2D(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        super(sGTuple2f, sGTuple2f2);
    }

    public SGDrawingElementLine2D(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    public boolean contains(int n, int n2) {
        float f = this.getLineWidth() * this.getMagnification();
        if (f < 2.0f) {
            f = 2.0f;
        }
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        double d = Line2D.ptSegDistSq(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y, n, n2);
        return d < (double)(f * f);
    }

    public void paint(Graphics2D graphics2D) {
        if (!this.isVisible()) {
            return;
        }
        graphics2D.setPaint(this.getColor());
        Stroke stroke = this.getBasicStroke();
        graphics2D.setStroke(stroke);
        graphics2D.draw(this.getLineShape());
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            this.paint(graphics2D);
        } else {
            if (!this.isVisible()) {
                return;
            }
            Area area = new Area(rectangle2D);
            Shape shape = this.getLineShape();
            if (shape == null) {
                return;
            }
            Shape shape2 = this.getBasicStroke().createStrokedShape(shape);
            Area area2 = new Area(shape2);
            area2.intersect(area);
            graphics2D.setPaint(this.getColor());
            graphics2D.fill(area2);
        }
    }

    public Rectangle2D getElementBounds() {
        Shape shape = this.getBasicStroke().createStrokedShape(this.getLineShape());
        return shape.getBounds2D();
    }

    private Stroke getBasicStroke() {
        return this.getStroke().getBasicStroke();
    }

    public Shape getLineShape() {
        Line2D.Float float_ = new Line2D.Float(this.getStart().x, this.getStart().y, this.getEnd().x, this.getEnd().y);
        return float_;
    }

    public static Line2D getLine(SGDrawingElementLine sGDrawingElementLine) {
        SGTuple2f sGTuple2f = sGDrawingElementLine.getStart();
        SGTuple2f sGTuple2f2 = sGDrawingElementLine.getEnd();
        Line2D.Float float_ = new Line2D.Float(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
        return float_;
    }

    public float getGradient() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        return SGUtilityJava2D.getGradient(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
    }
}

